/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.indexview;

import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.resources.FileStorage;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMName;
import org.eclipse.cdt.internal.ui.indexview.IndexAction;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class OpenDefinitionAction
extends IndexAction {
    public OpenDefinitionAction(TreeViewer viewer) {
        super(viewer, CUIPlugin.getResourceString("IndexView.openDefinition.name"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        ISelection selection = this.viewer.getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        Object[] objs = ((IStructuredSelection)selection).toArray();
        int i = 0;
        while (true) {
            block20: {
                if (i >= objs.length) {
                    return;
                }
                if (objs[i] instanceof PDOMBinding) {
                    Object var17_19;
                    PDOM pdom;
                    block19: {
                        block18: {
                            PDOMBinding binding = (PDOMBinding)objs[i];
                            pdom = binding.getPDOM();
                            try {
                                try {
                                    IEditorPart editor;
                                    pdom.acquireReadLock();
                                    PDOMName name = binding.getFirstDefinition();
                                    if (name == null) {
                                        name = binding.getFirstDeclaration();
                                    }
                                    if (name == null) {
                                        var17_19 = null;
                                        break block18;
                                    }
                                    IASTFileLocation location = name.getFileLocation();
                                    Path path = new Path(location.getFileName());
                                    IFile input = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
                                    if (input == null) {
                                        input = new FileStorage((IPath)path);
                                    }
                                    if ((editor = EditorUtility.openInEditor(input)) != null && editor instanceof ITextEditor) {
                                        int length;
                                        int offset;
                                        ITextEditor textEditor = (ITextEditor)editor;
                                        int nodeOffset = location.getNodeOffset();
                                        int nodeLength = location.getNodeLength();
                                        if (nodeLength == -1) {
                                            try {
                                                IDocument document = textEditor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
                                                offset = document.getLineOffset(nodeOffset);
                                                length = document.getLineLength(nodeOffset);
                                            }
                                            catch (BadLocationException e) {
                                                CUIPlugin.getDefault().log(e);
                                                var17_19 = null;
                                                pdom.releaseReadLock();
                                                return;
                                            }
                                        } else {
                                            offset = nodeOffset;
                                            length = nodeLength;
                                        }
                                        textEditor.selectAndReveal(offset, length);
                                    }
                                    break block19;
                                }
                                catch (InterruptedException interruptedException) {
                                }
                                catch (CoreException e) {
                                    CUIPlugin.getDefault().log(e);
                                }
                                break block19;
                            }
                            catch (Throwable throwable) {
                                var17_19 = null;
                                pdom.releaseReadLock();
                                throw throwable;
                            }
                        }
                        pdom.releaseReadLock();
                        break block20;
                    }
                    var17_19 = null;
                    pdom.releaseReadLock();
                }
            }
            ++i;
        }
    }

    public boolean valid() {
        ISelection selection = this.viewer.getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return false;
        }
        Object[] objs = ((IStructuredSelection)selection).toArray();
        int i = 0;
        while (i < objs.length) {
            if (objs[i] instanceof PDOMBinding) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

