/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search;

import java.util.HashMap;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IPDOMManager;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMName;
import org.eclipse.cdt.internal.ui.search.CSearchMessages;
import org.eclipse.cdt.internal.ui.search.PDOMSearchMatch;
import org.eclipse.cdt.internal.ui.search.PDOMSearchResult;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;

public abstract class PDOMSearchQuery
implements ISearchQuery {
    public static final int FIND_DECLARATIONS = 1;
    public static final int FIND_DEFINITIONS = 2;
    public static final int FIND_REFERENCES = 4;
    public static final int FIND_DECLARATIONS_DEFINITIONS = 3;
    public static final int FIND_ALL_OCCURANCES = 7;
    protected PDOMSearchResult result = new PDOMSearchResult(this);
    protected int flags;
    protected ICElement[] scope;
    protected ICProject[] projects;

    protected PDOMSearchQuery(ICElement[] scope, int flags) {
        this.flags = flags;
        this.scope = scope;
        try {
            if (scope == null) {
                this.projects = CoreModel.getDefault().getCModel().getCProjects();
            } else {
                HashMap<String, ICProject> projectMap = new HashMap<String, ICProject>();
                int i = 0;
                while (i < scope.length) {
                    ICProject project = scope[i].getCProject();
                    if (project != null) {
                        projectMap.put(project.getElementName(), project);
                    }
                    ++i;
                }
                this.projects = projectMap.values().toArray(new ICProject[projectMap.size()]);
            }
        }
        catch (CoreException e) {
            CUIPlugin.getDefault().log(e);
        }
    }

    public String getLabel() {
        String type = (this.flags & 4) != 0 ? CSearchMessages.getString("PDOMSearch.query.refs.label") : ((this.flags & 1) != 0 ? CSearchMessages.getString("PDOMSearch.query.decls.label") : CSearchMessages.getString("PDOMSearch.query.defs.label"));
        return type;
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public ISearchResult getSearchResult() {
        return this.result;
    }

    protected boolean filterName(PDOMName name) {
        return false;
    }

    private void collectNames(PDOMName name) throws CoreException {
        while (name != null) {
            if (this.filterName(name)) continue;
            IASTFileLocation loc = name.getFileLocation();
            this.result.addMatch(new PDOMSearchMatch(name, loc.getNodeOffset(), loc.getNodeLength()));
            name = name.getNextInBinding();
        }
    }

    protected void createMatches(ILanguage language, IBinding binding) throws CoreException {
        IPDOMManager manager = CCorePlugin.getPDOMManager();
        int i = 0;
        while (i < this.projects.length) {
            PDOM pdom = (PDOM)manager.getPDOM(this.projects[i]);
            PDOMBinding pdomBinding = pdom.getLinkage(language).adaptBinding(binding);
            if (pdomBinding != null) {
                if ((this.flags & 1) != 0) {
                    this.collectNames(pdomBinding.getFirstDeclaration());
                }
                if ((this.flags & 2) != 0) {
                    this.collectNames(pdomBinding.getFirstDefinition());
                }
                if ((this.flags & 4) != 0) {
                    this.collectNames(pdomBinding.getFirstReference());
                }
            }
            ++i;
        }
    }
}

