/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text;

import java.util.HashMap;
import java.util.LinkedList;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.text.formatter.ContextBasedFormattingStrategy;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;

public class CFormattingStrategy
extends ContextBasedFormattingStrategy {
    private final LinkedList fDocuments = new LinkedList();
    private final LinkedList fPartitions = new LinkedList();

    public void format() {
        super.format();
        IDocument document = (IDocument)this.fDocuments.removeFirst();
        TypedPosition partition = (TypedPosition)this.fPartitions.removeFirst();
        if (document != null && partition != null) {
            this.getPreferences();
            try {
                TextEdit edit = CodeFormatterUtil.format(8, document.get(), partition.getOffset(), partition.getLength(), 0, TextUtilities.getDefaultLineDelimiter((IDocument)document), this.getPreferences());
                if (edit != null) {
                    edit.apply(document);
                }
            }
            catch (MalformedTreeException exception) {
                CUIPlugin.getDefault().log(exception);
            }
            catch (BadLocationException exception) {
                CUIPlugin.getDefault().log(exception);
            }
        }
    }

    public void formatterStarts(IFormattingContext context) {
        this.prepareFormattingContext(context);
        super.formatterStarts(context);
        this.fPartitions.addLast(context.getProperty((Object)"formatting.context.partition"));
        this.fDocuments.addLast(context.getProperty((Object)"formatting.context.medium"));
    }

    public void formatterStops() {
        super.formatterStops();
        this.fPartitions.clear();
        this.fDocuments.clear();
    }

    private IFile getActiveFile() {
        IFile file = null;
        IEditorPart editor = CUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        IEditorInput input = editor.getEditorInput();
        if (input instanceof IFileEditorInput) {
            file = ((IFileEditorInput)input).getFile();
        }
        return file;
    }

    private void prepareFormattingContext(IFormattingContext context) {
        HashMap<String, Object> preferences;
        ParserLanguage language = ParserLanguage.CPP;
        IFile activeFile = this.getActiveFile();
        if (activeFile != null) {
            IProject currentProject = activeFile.getProject();
            Assert.isNotNull((Object)currentProject);
            String filename = activeFile.getFullPath().lastSegment();
            language = CoreModel.isValidCXXHeaderUnitName((IProject)currentProject, (String)filename) || CoreModel.isValidCXXSourceUnitName((IProject)currentProject, (String)filename) ? ParserLanguage.CPP : ParserLanguage.C;
            preferences = new HashMap(CoreModel.getDefault().create(activeFile.getProject()).getOptions(true));
        } else {
            preferences = new HashMap<String, Object>(CCorePlugin.getOptions());
        }
        preferences.put("org.eclipse.cdt.core.formatter.language", language);
        preferences.put("org.eclipse.cdt.core.formatter.current_file", activeFile);
        context.storeToMap(CUIPlugin.getDefault().getPreferenceStore(), preferences, false);
        context.setProperty((Object)"formatting.context.preferences", preferences);
    }
}

