/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.c.hover;

import java.io.IOException;
import java.util.Set;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.core.parser.KeywordSetKey;
import org.eclipse.cdt.core.parser.ParserFactory;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.internal.ui.codemanipulation.StubUtility;
import org.eclipse.cdt.internal.ui.text.CCodeReader;
import org.eclipse.cdt.internal.ui.text.c.hover.AbstractCEditorTextHover;
import org.eclipse.cdt.internal.ui.text.c.hover.SourceViewerInformationControl;
import org.eclipse.cdt.internal.ui.util.Strings;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.IWorkingCopyManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;

public class CSourceHover
extends AbstractCEditorTextHover
implements ITextHoverExtension,
IInformationProviderExtension2 {
    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        IEditorPart editor = this.getEditor();
        if (editor != null) {
            ICElement curr;
            String source;
            block12: {
                String expression;
                IWorkingCopy copy;
                block11: {
                    IEditorInput input = editor.getEditorInput();
                    IWorkingCopyManager manager = CUIPlugin.getDefault().getWorkingCopyManager();
                    copy = manager.getWorkingCopy(input);
                    if (copy == null) {
                        return null;
                    }
                    expression = textViewer.getDocument().get(hoverRegion.getOffset(), hoverRegion.getLength());
                    expression = expression.trim();
                    if (expression.length() != 0) break block11;
                    return null;
                }
                source = null;
                curr = copy.getElement(expression);
                source = curr == null ? this.findMatches(expression, textViewer) : ((ISourceReference)curr).getSource();
                if (source != null && source.trim().length() != 0) break block12;
                return null;
            }
            try {
                source = this.removeLeadingComments(source);
                String delim = null;
                try {
                    delim = StubUtility.getLineDelimiterUsed(curr);
                }
                catch (CModelException cModelException) {
                    delim = System.getProperty("line.separator", "\n");
                }
                String[] sourceLines = Strings.convertIntoLines(source);
                String firstLine = sourceLines[0];
                if (!Character.isWhitespace(firstLine.charAt(0))) {
                    sourceLines[0] = "";
                }
                Strings.trimIndentation(sourceLines, CSourceHover.getTabWidth());
                if (!Character.isWhitespace(firstLine.charAt(0))) {
                    sourceLines[0] = firstLine;
                }
                source = Strings.concatenate(sourceLines, delim);
                return source;
            }
            catch (BadLocationException badLocationException) {
            }
            catch (CModelException cModelException) {}
        }
        return null;
    }

    private static int getTabWidth() {
        return 4;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String removeLeadingComments(String source) {
        block11: {
            reader = new CCodeReader();
            document = new Document(source);
            try {
                try {
                    reader.configureForwardReader((IDocument)document, 0, document.getLength(), true, false);
                    c = reader.read();
                    while (true) {
                        if (c == -1 || c != 13 && c != 10) {
                            i = reader.getOffset();
                            reader.close();
                        }
                        c = reader.read();
                    }
                }
                catch (IOException v0) {
                    i = 0;
                }
            }
            catch (Throwable var7_6) {
                var6_7 = null;
                try {
                    if (reader == null) throw var7_6;
                    reader.close();
                    throw var7_6;
                }
                catch (IOException ex) {
                    CUIPlugin.getDefault().log(ex);
                }
                throw var7_6;
            }
            {
                var6_8 = null;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 96->107)] { 
lbl29:
            // 1 sources

            if (reader != null) {
                reader.close();
            }
            break block11;
lbl32:
            // 1 sources

            catch (IOException ex) {
                CUIPlugin.getDefault().log(ex);
            }
        }
        if (i >= 0) return source.substring(i);
        return source;
    }

    private String findMatches(String name, ITextViewer textViewer) {
        IEditorPart editor = this.getEditor();
        if (editor != null) {
            IEditorInput input = editor.getEditorInput();
            IWorkingCopyManager manager = CUIPlugin.getDefault().getWorkingCopyManager();
            IWorkingCopy copy = manager.getWorkingCopy(input);
            if (this.selectionIsKeyword(name)) {
                return null;
            }
        }
        return null;
    }

    private boolean selectionIsKeyword(String name) {
        Set keywords = ParserFactory.getKeywordSet((KeywordSetKey)KeywordSetKey.KEYWORDS, (ParserLanguage)ParserLanguage.CPP);
        return keywords.contains(name);
    }

    public IInformationControlCreator getHoverControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new SourceViewerInformationControl(parent, CSourceHover.this.getTooltipAffordanceString());
            }
        };
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                int shellStyle = 16;
                int style = 768;
                return new SourceViewerInformationControl(parent, shellStyle, style);
            }
        };
    }
}

