/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.contentassist;

import java.util.List;
import org.eclipse.cdt.core.dom.ast.ASTCompletionNode;
import org.eclipse.cdt.core.dom.ast.IASTFieldReference;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.ui.CHelpProviderManager;
import org.eclipse.cdt.internal.ui.text.contentassist.CCompletionProposal;
import org.eclipse.cdt.internal.ui.viewsupport.CElementImageProvider;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.IFunctionSummary;
import org.eclipse.cdt.ui.text.ICHelpInvocationContext;
import org.eclipse.cdt.ui.text.contentassist.ICompletionContributor;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;

public class HelpCompletionContributor
implements ICompletionContributor {
    public void contributeCompletionProposals(ITextViewer viewer, int offset, IWorkingCopy workingCopy, ASTCompletionNode completionNode, String prefix, List proposals) {
        final IWorkingCopy fWorkingCopy = workingCopy;
        if (completionNode != null) {
            ICHelpInvocationContext context = new ICHelpInvocationContext(){

                public IProject getProject() {
                    return fWorkingCopy.getCProject().getProject();
                }

                public ITranslationUnit getTranslationUnit() {
                    return fWorkingCopy.getTranslationUnit();
                }
            };
            IASTName[] names = completionNode.getNames();
            int i = 0;
            while (i < names.length) {
                IFunctionSummary[] summaries;
                IASTName name = names[i];
                if (name.getTranslationUnit() != null && !(name.getParent() instanceof IASTFieldReference) && (summaries = CHelpProviderManager.getDefault().getMatchingFunctions(context, prefix)) != null) {
                    int repOffset = offset - prefix.length();
                    int repLength = prefix.length();
                    Image image = CUIPlugin.getImageDescriptorRegistry().get(CElementImageProvider.getFunctionImageDescriptor());
                    int j = 0;
                    while (j < summaries.length) {
                        IFunctionSummary summary = summaries[j];
                        String fname = String.valueOf(summary.getName()) + "()";
                        String fdesc = summary.getDescription();
                        IFunctionSummary.IFunctionPrototypeSummary fproto = summary.getPrototype();
                        String fargs = fproto.getArguments();
                        CCompletionProposal proposal = new CCompletionProposal(fname, repOffset, repLength, image, fproto.getPrototypeString(true), 2, viewer);
                        if (fdesc != null) {
                            proposal.setAdditionalProposalInfo(fdesc);
                        }
                        if (fargs != null && fargs.length() > 0) {
                            proposal.setContextInformation((IContextInformation)new ContextInformation(fname, fargs));
                            proposal.setCursorPosition(fname.length() - 1);
                        }
                        proposals.add(proposal);
                        ++j;
                    }
                }
                ++i;
            }
        }
    }
}

