/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.wizards.dialogfields;

import java.io.File;
import org.eclipse.cdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class LinkToFileGroup
extends StringButtonDialogField {
    private String fText;
    protected Listener listener;
    private String initialLinkTarget;
    private int type;
    protected boolean createLink = false;
    protected Text linkTargetField;
    protected Button linkButton;
    protected Button browseButton;
    private Label resolvedPathLabelText;
    private Label resolvedPathLabelData;
    boolean preventDialogFieldChanged = false;

    public LinkToFileGroup(IStringButtonAdapter adapter, Listener listener) {
        super(adapter);
        this.listener = listener;
        this.type = 1;
    }

    public Control[] doFillIntoGrid(Composite parent, int nColumns) {
        this.assertEnoughColumns(nColumns);
        Label label = this.getLabelControl(parent);
        label.setLayoutData((Object)LinkToFileGroup.gridDataForLabel(1));
        this.getLinkCheckButtonControl(parent);
        Text text = this.getTextControl(parent);
        text.setLayoutData((Object)LinkToFileGroup.gridDataForText(2));
        Button browseButton = this.getBrowseButtonControl(parent);
        browseButton.setLayoutData((Object)LinkToFileGroup.gridDataForButton(browseButton, 1));
        DialogField.createEmptySpace(parent);
        this.resolvedPathLabelText = new Label(parent, 4);
        this.resolvedPathLabelText.setText(NewWizardMessages.getString("CreateLinkedResourceGroup.resolvedPathLabel"));
        this.resolvedPathLabelText.setVisible(true);
        this.resolvedPathLabelData = new Label(parent, 4);
        GridData data = new GridData(768);
        data.horizontalSpan = 3;
        this.resolvedPathLabelData.setLayoutData((Object)data);
        this.resolvedPathLabelData.setVisible(true);
        return null;
    }

    public int getNumberOfControls() {
        return 4;
    }

    public Button getLinkCheckButtonControl(Composite parent) {
        if (this.linkButton == null) {
            this.linkButton = new Button(parent, 32);
            this.linkButton.setText(NewWizardMessages.getString("NewClassWizardPage.files.linkFileButton"));
            this.linkButton.setSelection(this.createLink);
            this.linkButton.setFont(parent.getFont());
            SelectionAdapter selectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    LinkToFileGroup.this.createLink = LinkToFileGroup.this.linkButton.getSelection();
                    LinkToFileGroup.this.browseButton.setEnabled(LinkToFileGroup.this.createLink);
                    LinkToFileGroup.this.linkTargetField.setEnabled(LinkToFileGroup.this.createLink);
                    LinkToFileGroup.this.resolveVariable();
                    if (LinkToFileGroup.this.listener != null) {
                        LinkToFileGroup.this.listener.handleEvent(new Event());
                    }
                    if (!LinkToFileGroup.this.preventDialogFieldChanged) {
                        LinkToFileGroup.this.dialogFieldChanged();
                    }
                }
            };
            this.linkButton.addSelectionListener((SelectionListener)selectionListener);
        }
        return this.linkButton;
    }

    public String getText() {
        return this.linkTargetField.getText();
    }

    public void setText(String text) {
        this.fText = text;
        if (this.isOkToUse((Control)this.linkTargetField)) {
            this.preventDialogFieldChanged = true;
            this.linkTargetField.setText(text);
            this.preventDialogFieldChanged = false;
        }
    }

    public Text getTextControl(Composite parent) {
        if (this.linkTargetField == null) {
            this.assertCompositeNotNull(parent);
            this.linkTargetField = new Text(parent, 2048);
            this.linkTargetField.setFont(parent.getFont());
            this.linkTargetField.setEnabled(this.createLink);
            this.linkTargetField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    LinkToFileGroup.this.resolveVariable();
                    if (LinkToFileGroup.this.listener != null) {
                        LinkToFileGroup.this.listener.handleEvent(new Event());
                    }
                    if (!LinkToFileGroup.this.preventDialogFieldChanged) {
                        LinkToFileGroup.this.dialogFieldChanged();
                    }
                }
            });
            if (this.initialLinkTarget != null) {
                this.linkTargetField.setText(this.initialLinkTarget);
            }
        }
        return this.linkTargetField;
    }

    public static GridData gridDataForText(int span) {
        GridData data = new GridData();
        data.widthHint = 200;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = false;
        data.horizontalSpan = span;
        return data;
    }

    public Button getBrowseButtonControl(Composite parent) {
        if (this.browseButton == null) {
            this.assertCompositeNotNull(parent);
            this.browseButton = new Button(parent, 8);
            this.browseButton.setFont(parent.getFont());
            this.browseButton.setText(NewWizardMessages.getString("CreateLinkedResourceGroup.browseButton"));
            this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    LinkToFileGroup.this.handleLinkTargetBrowseButtonPressed();
                }
            });
            this.browseButton.setEnabled(this.createLink);
        }
        return this.browseButton;
    }

    private IStatus createStatus(int severity, String message) {
        return new Status(severity, CUIPlugin.getPluginId(), severity, message, null);
    }

    public String getLinkTarget() {
        if (this.createLink && this.linkTargetField != null && !this.linkTargetField.isDisposed()) {
            return this.linkTargetField.getText();
        }
        return null;
    }

    public String getResolvedPath() {
        if (this.createLink && this.resolvedPathLabelData != null && !this.resolvedPathLabelData.isDisposed()) {
            return this.resolvedPathLabelData.getText();
        }
        return null;
    }

    protected void handleLinkTargetBrowseButtonPressed() {
        String linkTargetName = this.linkTargetField.getText();
        File file = null;
        String selection = null;
        if (!"".equals(linkTargetName) && !(file = new File(linkTargetName)).exists()) {
            file = null;
        }
        if (this.type == 1) {
            FileDialog dialog = new FileDialog(this.linkTargetField.getShell());
            dialog.setText(NewWizardMessages.getString("CreateLinkedResourceGroup.open"));
            if (file != null) {
                if (file.isFile()) {
                    dialog.setFileName(linkTargetName);
                } else {
                    dialog.setFilterPath(linkTargetName);
                }
            }
            selection = dialog.open();
        } else {
            DirectoryDialog dialog = new DirectoryDialog(this.linkTargetField.getShell());
            dialog.setText(NewWizardMessages.getString("CreateLinkedResourceGroup.open"));
            if (file != null) {
                if (file.isFile()) {
                    linkTargetName = file.getParent();
                }
                if (linkTargetName != null) {
                    dialog.setFilterPath(linkTargetName);
                }
            }
            dialog.setMessage(NewWizardMessages.getString("CreateLinkedResourceGroup.targetSelectionLabel"));
            selection = dialog.open();
        }
        if (selection != null) {
            this.linkTargetField.setText(selection);
            if (!this.preventDialogFieldChanged) {
                this.dialogFieldChanged();
            }
        }
    }

    protected void resolveVariable() {
        if (!this.linkTargetField.isEnabled()) {
            this.resolvedPathLabelData.setText("");
            return;
        }
        IPathVariableManager pathVariableManager = ResourcesPlugin.getWorkspace().getPathVariableManager();
        Path path = new Path(this.linkTargetField.getText());
        IPath resolvedPath = pathVariableManager.resolvePath((IPath)path);
        this.resolvedPathLabelData.setText(resolvedPath.toOSString());
    }

    public void setLinkTarget(String target) {
        this.initialLinkTarget = target;
        if (this.linkTargetField != null && !this.linkTargetField.isDisposed()) {
            this.linkTargetField.setText(target);
            if (!this.preventDialogFieldChanged) {
                this.dialogFieldChanged();
            }
        }
    }

    private IStatus validateFileType(File linkTargetFile) {
        if (this.type == 1 && !linkTargetFile.isFile()) {
            return this.createStatus(4, NewWizardMessages.getString("CreateLinkedResourceGroup.linkTargetNotFile"));
        }
        if (this.type == 2 && !linkTargetFile.isDirectory()) {
            return this.createStatus(4, NewWizardMessages.getString("CreateLinkedResourceGroup.linkTargetNotFolder"));
        }
        return this.createStatus(0, "");
    }

    public IStatus validateLinkLocation(IResource linkHandle) {
        if (this.linkTargetField == null || this.linkTargetField.isDisposed()) {
            return this.createStatus(0, "");
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        String linkTargetName = this.linkTargetField.getText();
        Path path = new Path(linkTargetName);
        if (!this.createLink) {
            return this.createStatus(0, "");
        }
        IStatus locationStatus = workspace.validateLinkLocation(linkHandle, (IPath)path);
        if (locationStatus.getSeverity() == 4) {
            return locationStatus;
        }
        linkTargetName = this.resolvedPathLabelData.getText();
        path = new Path(linkTargetName);
        File linkTargetFile = new Path(linkTargetName).toFile();
        if (linkTargetFile.exists()) {
            IStatus fileTypeStatus = this.validateFileType(linkTargetFile);
            if (!fileTypeStatus.isOK()) {
                return fileTypeStatus;
            }
        } else if (locationStatus.getSeverity() == 0) {
            return this.createStatus(2, NewWizardMessages.getString("CreateLinkedResourceGroup.linkTargetNonExistent"));
        }
        return locationStatus;
    }

    public boolean linkCreated() {
        return this.createLink;
    }
}

