/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.dialogs;

import java.util.ArrayList;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.internal.ui.CUIMessages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.dialogs.AbstractCOptionPage;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ReferenceBlock
extends AbstractCOptionPage {
    private static final String PREFIX = "ReferenceBlock";
    private static final String LABEL = "ReferenceBlock.label";
    private static final String DESC = "ReferenceBlock.desc";
    private CheckboxTableViewer referenceProjectsViewer;
    private static final int PROJECT_LIST_MULTIPLIER = 10;

    public ReferenceBlock() {
        super(CUIPlugin.getResourceString(LABEL));
        this.setDescription(CUIPlugin.getResourceString(DESC));
    }

    public Image getImage() {
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT");
    }

    protected IStructuredContentProvider getContentProvider() {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object element) {
                if (!(element instanceof IWorkspace)) {
                    return new Object[0];
                }
                ArrayList<IProject> aList = new ArrayList<IProject>(15);
                IProject[] projects = ((IWorkspace)element).getRoot().getProjects();
                int i = 0;
                while (i < projects.length) {
                    if (CoreModel.hasCNature((IProject)projects[i]) && (ReferenceBlock.this.getContainer().getProject() == null || !ReferenceBlock.this.getContainer().getProject().equals((Object)projects[i]))) {
                        aList.add(projects[i]);
                    }
                    ++i;
                }
                return aList.toArray();
            }
        };
    }

    protected void initializeValues() {
        if (this.getContainer().getProject() != null) {
            try {
                Object[] referenced = this.getContainer().getProject().getReferencedProjects();
                this.referenceProjectsViewer.setCheckedElements(referenced);
            }
            catch (CoreException coreException) {}
        }
    }

    public IProject[] getReferencedProjects() {
        Object[] elements = this.referenceProjectsViewer.getCheckedElements();
        IProject[] projects = new IProject[elements.length];
        System.arraycopy(elements, 0, projects, 0, elements.length);
        return projects;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(768));
        Label label = new Label(composite, 16384);
        label.setText(CUIPlugin.getResourceString(DESC));
        GridData lbldata = new GridData(768);
        lbldata.horizontalSpan = 1;
        label.setLayoutData((Object)lbldata);
        this.referenceProjectsViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2176);
        GridData data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        data.heightHint = ReferenceBlock.getDefaultFontHeight((Control)this.referenceProjectsViewer.getTable(), 10);
        this.referenceProjectsViewer.getTable().setLayoutData((Object)data);
        this.referenceProjectsViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.referenceProjectsViewer.setContentProvider((IContentProvider)this.getContentProvider());
        this.referenceProjectsViewer.setInput((Object)ResourcesPlugin.getWorkspace());
        this.initializeValues();
        this.setControl((Control)composite);
    }

    private static int getDefaultFontHeight(Control control, int lines) {
        FontData[] viewerFontData = control.getFont().getFontData();
        int fontHeight = 10;
        if (viewerFontData.length > 0) {
            fontHeight = viewerFontData[0].getHeight();
        }
        return lines * fontHeight;
    }

    public void performApply(IProgressMonitor monitor) throws CoreException {
        IProject[] refProjects = this.getReferencedProjects();
        if (refProjects != null) {
            IProject project = this.getContainer().getProject();
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            monitor.beginTask(CUIMessages.getString("ReferenceBlock.task.ReferenceProjects"), 1);
            try {
                IProjectDescription description = project.getDescription();
                description.setReferencedProjects(refProjects);
                project.setDescription(description, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            catch (CoreException coreException) {}
        }
    }

    public void performDefaults() {
        this.initializeValues();
    }
}

