/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build;

import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPlatformRunnable;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.pde.internal.build.BundleHelper;

public class BuildApplication
implements IPlatformRunnable {
    public Object run(Object args) throws Exception {
        Platform.endSplash();
        IPlatformRunnable antRunner = this.getAntRunner();
        args = this.updateArgs((String[])args);
        return antRunner.run(args);
    }

    private Object updateArgs(String[] args) throws IOException {
        for (int i = 0; i < args.length; ++i) {
            String string = args[i];
            if (!string.equals("-f") && !string.equals("-buildfile")) continue;
            return args;
        }
        int length = args.length;
        String[] result = new String[length + 2];
        System.arraycopy(args, 0, result, 0, length);
        result[length] = "-f";
        URL buildURL = BundleHelper.getDefault().find((IPath)new Path("/scripts/build.xml"));
        result[length + 1] = Platform.asLocalURL((URL)buildURL).getFile();
        return result;
    }

    private IPlatformRunnable getAntRunner() throws CoreException {
        IExtension ext = Platform.getExtensionRegistry().getExtension("org.eclipse.ant.core.antRunner");
        if (ext == null) {
            return null;
        }
        IConfigurationElement element = ext.getConfigurationElements()[0];
        return (IPlatformRunnable)element.createExecutableExtension("run");
    }
}

