/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.build.AbstractScriptGenerator;
import org.eclipse.pde.internal.build.AssembleScriptGenerator;
import org.eclipse.pde.internal.build.AssemblyInformation;
import org.eclipse.pde.internal.build.Config;
import org.eclipse.pde.internal.build.Messages;
import org.eclipse.pde.internal.build.SourceFeatureInformation;
import org.eclipse.pde.internal.build.Utils;
import org.eclipse.pde.internal.build.builder.AbstractBuildScriptGenerator;
import org.eclipse.pde.internal.build.builder.DevClassPathHelper;
import org.eclipse.pde.internal.build.builder.FeatureBuildScriptGenerator;
import org.eclipse.pde.internal.build.builder.ModelBuildScriptGenerator;
import org.eclipse.pde.internal.build.packager.PackageScriptGenerator;
import org.eclipse.pde.internal.build.site.BuildTimeSiteFactory;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.VersionedIdentifier;
import org.osgi.framework.Version;

public class BuildScriptGenerator
extends AbstractScriptGenerator {
    protected boolean generateArchive = true;
    protected boolean children = true;
    protected boolean groupConfigs = false;
    protected String[] elements;
    protected DevClassPathHelper devEntries;
    protected boolean recursiveGeneration = true;
    protected boolean generateBuildScript = true;
    protected boolean includePlatformIndependent = true;
    protected boolean signJars = false;
    protected boolean generateJnlp = false;
    protected boolean generateFeatureVersionSuffix = false;
    private String product;
    private HashMap archivesFormat;
    private boolean generateAssembleScript = true;
    private boolean ignoreMissingPropertiesFile = true;
    private boolean generateVersionsList = false;
    private static final String PROPERTY_ARCHIVESFORMAT = "archivesFormat";

    public void generate() throws CoreException {
        ArrayList plugins = new ArrayList(5);
        ArrayList features = new ArrayList(5);
        this.sortElements(features, plugins);
        this.generateModels(plugins);
        this.generateFeatures(features);
        this.flushState();
    }

    protected void sortElements(List features, List plugins) {
        for (int i = 0; i < this.elements.length; ++i) {
            int index = this.elements[i].indexOf(64);
            String type = this.elements[i].substring(0, index);
            String element = this.elements[i].substring(index + 1);
            if (type.equals("plugin") || type.equals("fragment")) {
                plugins.add(element);
                continue;
            }
            if (!type.equals("feature")) continue;
            features.add(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateModels(List models) throws CoreException {
        AbstractScriptGenerator generator = null;
        try {
            Iterator iterator = models.iterator();
            while (iterator.hasNext()) {
                generator = new ModelBuildScriptGenerator();
                ((AbstractBuildScriptGenerator)generator).setReportResolutionErrors(this.reportResolutionErrors);
                ((AbstractBuildScriptGenerator)generator).setIgnoreMissingPropertiesFile(this.ignoreMissingPropertiesFile);
                String model = (String)iterator.next();
                generator.setBuildSiteFactory(null);
                ((ModelBuildScriptGenerator)generator).setModelId(model);
                generator.setPluginPath(this.pluginPath);
                ((AbstractBuildScriptGenerator)generator).setDevEntries(this.devEntries);
                ((AbstractBuildScriptGenerator)generator).setCompiledElements(((AbstractBuildScriptGenerator)generator).getCompiledElements());
                generator.setBuildingOSGi(BuildScriptGenerator.isBuildingOSGi());
                ((ModelBuildScriptGenerator)generator).setSignJars(this.signJars);
                ((ModelBuildScriptGenerator)generator).generate();
            }
        }
        finally {
            if (generator != null) {
                generator.getSite(false).getRegistry().cleanupOriginalState();
            }
        }
    }

    private String[] getNameAndVersion(String id) {
        int versionPosition = id.indexOf(":");
        String[] result = new String[2];
        if (versionPosition != -1) {
            result[1] = id.substring(versionPosition + 1);
            result[0] = id.substring(0, versionPosition);
        } else {
            result[0] = id;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateFeatures(List features) throws CoreException {
        AssemblyInformation assemblageInformation = null;
        assemblageInformation = new AssemblyInformation();
        AbstractScriptGenerator generator = null;
        try {
            Iterator i = features.iterator();
            while (i.hasNext()) {
                String[] featureInfo = this.getNameAndVersion((String)i.next());
                generator = new FeatureBuildScriptGenerator(featureInfo[0], featureInfo[1], assemblageInformation);
                ((FeatureBuildScriptGenerator)generator).setGenerateIncludedFeatures(this.recursiveGeneration);
                ((FeatureBuildScriptGenerator)generator).setAnalyseChildren(this.children);
                ((FeatureBuildScriptGenerator)generator).setSourceFeatureGeneration(false);
                ((FeatureBuildScriptGenerator)generator).setBinaryFeatureGeneration(true);
                ((FeatureBuildScriptGenerator)generator).setScriptGeneration(this.generateBuildScript);
                generator.setPluginPath(this.pluginPath);
                generator.setBuildSiteFactory(null);
                ((AbstractBuildScriptGenerator)generator).setDevEntries(this.devEntries);
                ((FeatureBuildScriptGenerator)generator).setSourceToGather(new SourceFeatureInformation());
                ((AbstractBuildScriptGenerator)generator).setCompiledElements(((AbstractBuildScriptGenerator)generator).getCompiledElements());
                generator.setBuildingOSGi(BuildScriptGenerator.isBuildingOSGi());
                ((AbstractBuildScriptGenerator)generator).includePlatformIndependent(this.includePlatformIndependent);
                ((AbstractBuildScriptGenerator)generator).setReportResolutionErrors(this.reportResolutionErrors);
                ((AbstractBuildScriptGenerator)generator).setIgnoreMissingPropertiesFile(this.ignoreMissingPropertiesFile);
                ((FeatureBuildScriptGenerator)generator).setSignJars(this.signJars);
                ((FeatureBuildScriptGenerator)generator).setGenerateJnlp(this.generateJnlp);
                ((FeatureBuildScriptGenerator)generator).setGenerateVersionSuffix(this.generateFeatureVersionSuffix);
                ((FeatureBuildScriptGenerator)generator).setProduct(this.product);
                ((FeatureBuildScriptGenerator)generator).generate();
            }
            if (generator != null && this.generateAssembleScript) {
                String[] featureInfo = null;
                featureInfo = features.size() == 1 ? this.getNameAndVersion((String)features.get(0)) : new String[]{"all"};
                this.generateAssembleScripts(assemblageInformation, featureInfo, ((FeatureBuildScriptGenerator)generator).siteFactory);
                featureInfo = features.size() == 1 ? this.getNameAndVersion((String)features.get(0)) : new String[]{""};
                this.generatePackageScripts(assemblageInformation, featureInfo, ((FeatureBuildScriptGenerator)generator).siteFactory);
            }
            if (this.generateVersionsList) {
                this.generateVersionsLists(assemblageInformation);
            }
        }
        finally {
            if (generator != null) {
                generator.getSite(false).getRegistry().cleanupOriginalState();
            }
        }
    }

    protected void generateVersionsLists(AssemblyInformation assemblageInformation) throws CoreException {
        if (assemblageInformation == null) {
            return;
        }
        List configs = BuildScriptGenerator.getConfigInfos();
        HashSet features = new HashSet();
        HashSet plugins = new HashSet();
        Properties versions = new Properties();
        Iterator iter = configs.iterator();
        while (iter.hasNext()) {
            Config config = (Config)iter.next();
            String configString = config.toStringReplacingAny("_", "ANY");
            Collection list = assemblageInformation.getFeatures(config);
            versions.clear();
            features.addAll(list);
            String featureFile = "finalFeaturesVersions." + configString + ".properties";
            this.readVersions(versions, featureFile);
            Iterator i = list.iterator();
            while (i.hasNext()) {
                IFeature feature = (IFeature)i.next();
                VersionedIdentifier id = feature.getVersionedIdentifier();
                this.recordVersion(id.getIdentifier(), new Version(id.getVersion().toString()), versions);
            }
            this.saveVersions(versions, featureFile);
            list = assemblageInformation.getPlugins(config);
            versions.clear();
            plugins.addAll(list);
            String pluginFile = "finalPluginsVersions." + configString + ".properties";
            this.readVersions(versions, pluginFile);
            Iterator i2 = list.iterator();
            while (i2.hasNext()) {
                BundleDescription bundle = (BundleDescription)i2.next();
                this.recordVersion(bundle.getSymbolicName(), bundle.getVersion(), versions);
            }
            this.saveVersions(versions, pluginFile);
        }
        versions.clear();
        String featureFile = "finalFeaturesVersions.properties";
        this.readVersions(versions, featureFile);
        Iterator i = features.iterator();
        while (i.hasNext()) {
            IFeature feature = (IFeature)i.next();
            VersionedIdentifier id = feature.getVersionedIdentifier();
            this.recordVersion(id.getIdentifier(), new Version(id.getVersion().toString()), versions);
        }
        this.saveVersions(versions, featureFile);
        versions.clear();
        String pluginVersion = "finalPluginsVersions.properties";
        this.readVersions(versions, pluginVersion);
        Iterator i3 = plugins.iterator();
        while (i3.hasNext()) {
            BundleDescription bundle = (BundleDescription)i3.next();
            this.recordVersion(bundle.getSymbolicName(), bundle.getVersion(), versions);
        }
        this.saveVersions(versions, pluginVersion);
    }

    protected void recordVersion(String name, Version version, Properties properties) {
        String versionString = version.toString();
        if (properties.containsKey(name)) {
            Version existing = new Version((String)properties.get(name));
            if (version.compareTo((Object)existing) >= 0) {
                properties.put(name, versionString);
            }
        } else {
            properties.put(name, versionString);
        }
        String suffix = '_' + String.valueOf(version.getMajor()) + '.' + String.valueOf(version.getMinor()) + '.' + String.valueOf(version.getMicro());
        properties.put(name + suffix, versionString);
    }

    private String getFilePath(String fileName) {
        return workingDirectory + '/' + fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readVersions(Properties properties, String fileName) {
        String location = this.getFilePath(fileName);
        try {
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(location));
            try {
                properties.load(is);
            }
            finally {
                ((InputStream)is).close();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveVersions(Properties properties, String fileName) throws CoreException {
        String location = this.getFilePath(fileName);
        try {
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(location));
            try {
                properties.store(os, null);
            }
            finally {
                ((OutputStream)os).close();
            }
        }
        catch (IOException e) {
            String message = NLS.bind((String)Messages.exception_writingFile, (Object)location);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 12, message, null));
        }
    }

    protected void generatePackageScripts(AssemblyInformation assemblageInformation, String[] featureInfo, BuildTimeSiteFactory factory) throws CoreException {
        PackageScriptGenerator assembler = null;
        assembler = new PackageScriptGenerator(workingDirectory, assemblageInformation, featureInfo[0]);
        assembler.setSignJars(this.signJars);
        assembler.setGenerateJnlp(this.generateJnlp);
        assembler.setArchivesFormat(this.getArchivesFormat());
        assembler.setProduct(this.product);
        assembler.setBuildSiteFactory(factory);
        assembler.setGroupConfigs(this.groupConfigs);
        assembler.generate();
    }

    private void generateAssembleScripts(AssemblyInformation assemblageInformation, String[] featureInfo, BuildTimeSiteFactory factory) throws CoreException {
        AssembleScriptGenerator assembler = new AssembleScriptGenerator(workingDirectory, assemblageInformation, featureInfo[0]);
        assembler.setSignJars(this.signJars);
        assembler.setGenerateJnlp(this.generateJnlp);
        assembler.setArchivesFormat(this.getArchivesFormat());
        assembler.setProduct(this.product);
        assembler.setBuildSiteFactory(factory);
        assembler.setGroupConfigs(this.groupConfigs);
        assembler.generate();
    }

    public void setGenerateArchive(boolean generateArchive) {
        this.generateArchive = generateArchive;
    }

    public void setChildren(boolean children) {
        this.children = children;
    }

    public void setDevEntries(String devEntries) {
        if (devEntries != null) {
            this.devEntries = new DevClassPathHelper(devEntries);
        }
    }

    public void setElements(String[] elements) {
        this.elements = elements;
    }

    public void setRecursiveGeneration(boolean recursiveGeneration) {
        this.recursiveGeneration = recursiveGeneration;
    }

    public void setGenerateAssembleScript(boolean generateAssembleScript) {
        this.generateAssembleScript = generateAssembleScript;
    }

    public void setGenerateVersionsList(boolean generateVersionsList) {
        this.generateVersionsList = generateVersionsList;
    }

    public void setReportResolutionErrors(boolean value) {
        this.reportResolutionErrors = value;
    }

    public void setIgnoreMissingPropertiesFile(boolean value) {
        this.ignoreMissingPropertiesFile = value;
    }

    public void setProduct(String value) {
        this.product = value;
    }

    public void setSignJars(boolean value) {
        this.signJars = value;
    }

    public void setGenerateJnlp(boolean value) {
        this.generateJnlp = value;
    }

    public void setGenerateFeatureVersionSuffix(boolean value) {
        this.generateFeatureVersionSuffix = value;
    }

    public void setArchivesFormat(String archivesFormatAsString) throws CoreException {
        if (Utils.getPropertyFormat(PROPERTY_ARCHIVESFORMAT).equalsIgnoreCase(archivesFormatAsString)) {
            this.archivesFormat = new ArchiveTable(0);
            return;
        }
        this.archivesFormat = new ArchiveTable(BuildScriptGenerator.getConfigInfos().size());
        String[] configs = Utils.getArrayFromStringWithBlank(archivesFormatAsString, "&");
        for (int i = 0; i < configs.length; ++i) {
            String[] configElements = Utils.getArrayFromStringWithBlank(configs[i], ",");
            if (configElements.length != 3) {
                Status error = new Status(4, "org.eclipse.pde.build", 22, NLS.bind((String)Messages.error_configWrongFormat, (Object)configs[i]), null);
                throw new CoreException((IStatus)error);
            }
            String[] archAndFormat = Utils.getArrayFromStringWithBlank(configElements[2], "-");
            Config aConfig = new Config(configElements[0], configElements[1], archAndFormat[0]);
            if (!BuildScriptGenerator.getConfigInfos().contains(aConfig)) continue;
            this.archivesFormat.put(aConfig, archAndFormat[1]);
        }
    }

    protected HashMap getArchivesFormat() {
        if (this.archivesFormat == null) {
            try {
                this.setArchivesFormat(Utils.getPropertyFormat(PROPERTY_ARCHIVESFORMAT));
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return this.archivesFormat;
    }

    public void includePlatformIndependent(boolean b) {
        this.includePlatformIndependent = b;
    }

    public void setGroupConfigs(boolean value) {
        this.groupConfigs = value;
    }

    private class ArchiveTable
    extends HashMap {
        private static final long serialVersionUID = -3063402400461435816L;

        public ArchiveTable(int size) {
            super(size);
        }

        public Object get(Object arg0) {
            Object result = super.get(arg0);
            if (result == null) {
                result = "antZip";
            }
            return result;
        }
    }
}

