/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.pde.build.IFetchFactory;
import org.eclipse.pde.internal.build.BundleHelper;
import org.eclipse.pde.internal.build.IPDEBuildConstants;

public class FetchTaskFactoriesRegistry
implements IPDEBuildConstants {
    private Map factories = new HashMap();

    public FetchTaskFactoriesRegistry() {
        this.initializeRegistry();
    }

    public IFetchFactory getFactory(String id) {
        Object result = this.factories.get(id);
        if (result instanceof IFetchFactory) {
            return (IFetchFactory)result;
        }
        IConfigurationElement extension = (IConfigurationElement)this.factories.get(id);
        if (null != extension) {
            try {
                IFetchFactory toCache = (IFetchFactory)extension.createExecutableExtension("class");
                this.factories.put(id, toCache);
                return toCache;
            }
            catch (CoreException e) {
                BundleHelper.getDefault().getLog().log(e.getStatus());
            }
        }
        return null;
    }

    public Collection getFactoryIds() {
        return this.factories.keySet();
    }

    private void initializeRegistry() {
        IConfigurationElement[] extensions = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.pde.build.fetchFactories");
        for (int i = 0; i < extensions.length; ++i) {
            String id;
            IConfigurationElement extension = extensions[i];
            if (!"factory".equals(extension.getName()) || null == (id = extension.getAttribute("id")) || id.trim().length() <= 0) continue;
            this.factories.put(id, extension);
        }
    }
}

