/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.build.Config;
import org.eclipse.pde.internal.build.IBuildPropertiesConstants;
import org.eclipse.pde.internal.build.IPDEBuildConstants;
import org.eclipse.pde.internal.build.IXMLConstants;
import org.eclipse.pde.internal.build.Messages;
import org.eclipse.pde.internal.build.ant.AntScript;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IPluginEntry;

public final class Utils
implements IPDEBuildConstants,
IBuildPropertiesConstants,
IXMLConstants {
    public static String[] getArrayFromString(String list, String separator) {
        if (list == null || list.trim().equals("")) {
            return new String[0];
        }
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer tokens = new StringTokenizer(list, separator);
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (token.equals("")) continue;
            result.add(token);
        }
        return result.toArray(new String[result.size()]);
    }

    public static String[] getArrayFromStringWithBlank(String list, String separator) {
        if (list == null || list.trim().length() == 0) {
            return new String[0];
        }
        ArrayList<String> result = new ArrayList<String>();
        boolean previousWasSeparator = true;
        StringTokenizer tokens = new StringTokenizer(list, separator, true);
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (token.equals(separator)) {
                if (previousWasSeparator) {
                    result.add("");
                }
                previousWasSeparator = true;
                continue;
            }
            result.add(token);
            previousWasSeparator = false;
        }
        return result.toArray(new String[result.size()]);
    }

    public static String[] getArrayFromString(String list) {
        return Utils.getArrayFromString(list, ",");
    }

    public static URL[] asURL(String[] target) throws CoreException {
        if (target == null) {
            return null;
        }
        try {
            URL[] result = new URL[target.length];
            for (int i = 0; i < target.length; ++i) {
                result[i] = new URL(target[i]);
            }
            return result;
        }
        catch (MalformedURLException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 3, e.getMessage(), (Throwable)e));
        }
    }

    public static URL[] asURL(Collection target) throws CoreException {
        if (target == null) {
            return null;
        }
        try {
            URL[] result = new URL[target.size()];
            int i = 0;
            Iterator iter = target.iterator();
            while (iter.hasNext()) {
                result[i++] = ((File)iter.next()).toURL();
            }
            return result;
        }
        catch (MalformedURLException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 3, e.getMessage(), (Throwable)e));
        }
    }

    public static String getStringFromCollection(Collection collection, String separator) {
        StringBuffer result = new StringBuffer();
        boolean first = true;
        Iterator i = collection.iterator();
        while (i.hasNext()) {
            if (first) {
                first = false;
            } else {
                result.append(separator);
            }
            result.append(i.next());
        }
        return result.toString();
    }

    public static String getStringFromArray(String[] values, String separator) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) continue;
            if (i > 0) {
                result.append(separator);
            }
            result.append(values[i]);
        }
        return result.toString();
    }

    public static IPath makeRelative(IPath location, IPath base) {
        if (location.getDevice() != null && !location.getDevice().equalsIgnoreCase(base.getDevice())) {
            return location;
        }
        int baseCount = base.segmentCount();
        int count = base.matchingFirstSegments(location);
        String temp = "";
        for (int j = 0; j < baseCount - count; ++j) {
            temp = temp + "../";
        }
        return new Path(temp).append(location.removeFirstSegments(count));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void transferStreams(InputStream source, OutputStream destination) throws IOException {
        source = new BufferedInputStream(source);
        destination = new BufferedOutputStream(destination);
        try {
            byte[] buffer = new byte[8192];
            while (true) {
                int bytesRead = -1;
                bytesRead = source.read(buffer);
                if (bytesRead == -1) {
                    break;
                }
                destination.write(buffer, 0, bytesRead);
            }
        }
        finally {
            try {
                source.close();
            }
            catch (IOException e) {}
            try {
                destination.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static IPluginEntry[] getPluginEntry(IFeature feature, String pluginId, boolean raw) {
        IPluginEntry[] plugins = raw ? feature.getRawPluginEntries() : feature.getPluginEntries();
        ArrayList<IPluginEntry> foundEntries = new ArrayList<IPluginEntry>(5);
        for (int i = 0; i < plugins.length; ++i) {
            if (!plugins[i].getVersionedIdentifier().getIdentifier().equals(pluginId)) continue;
            foundEntries.add(plugins[i]);
        }
        return foundEntries.toArray(new IPluginEntry[foundEntries.size()]);
    }

    public static Collection findFiles(String from, String foldername, final String filename) {
        File root = new File(from);
        if (root.isFile() && root.getName().equals(filename)) {
            ArrayList<File> coll = new ArrayList<File>(1);
            coll.add(root);
            return coll;
        }
        String featureDirectory = from + '/' + foldername;
        ArrayList<File> collectedElements = new ArrayList<File>(10);
        File[] featureDirectoryContent = new File(featureDirectory).listFiles();
        if (featureDirectoryContent == null) {
            return null;
        }
        for (int i = 0; i < featureDirectoryContent.length; ++i) {
            File[] featureFiles;
            if (!featureDirectoryContent[i].isDirectory() || (featureFiles = featureDirectoryContent[i].listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.equals(filename);
                }
            })).length == 0) continue;
            collectedElements.add(featureFiles[0]);
        }
        return collectedElements;
    }

    public static boolean isIn(IPluginEntry[] array, IPluginEntry element) {
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].getVersionedIdentifier().equals((Object)element.getVersionedIdentifier())) continue;
            return true;
        }
        return false;
    }

    public static Collection copyFiles(String fromDir, String toDir) throws CoreException {
        File[] files;
        File templateLocation = new File(fromDir);
        ArrayList<String> copiedFiles = new ArrayList<String>();
        if (templateLocation.exists() && (files = templateLocation.listFiles()) != null) {
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    File subDir = new File(toDir, files[i].getName());
                    if (!subDir.exists()) {
                        subDir.mkdirs();
                    }
                    Collection subFiles = Utils.copyFiles(fromDir + '/' + files[i].getName(), toDir + '/' + files[i].getName());
                    Iterator iter = subFiles.iterator();
                    while (iter.hasNext()) {
                        String sub = (String)iter.next();
                        copiedFiles.add(files[i].getName() + '/' + sub);
                    }
                    continue;
                }
                FileInputStream inputStream = null;
                FileOutputStream outputStream = null;
                try {
                    inputStream = new FileInputStream(files[i]);
                }
                catch (FileNotFoundException e) {
                    String message = NLS.bind((String)Messages.exception_missingFile, (Object)files[i].getAbsolutePath());
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 10, message, (Throwable)e));
                }
                String fileToCopy = toDir + '/' + files[i].getName();
                try {
                    outputStream = new FileOutputStream(fileToCopy);
                }
                catch (FileNotFoundException e) {
                    String message = NLS.bind((String)Messages.exception_missingFile, (Object)fileToCopy);
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 10, message, (Throwable)e));
                }
                try {
                    Utils.transferStreams(inputStream, outputStream);
                    copiedFiles.add(files[i].getName());
                    continue;
                }
                catch (IOException e) {
                    String message = NLS.bind((String)Messages.exception_writingFile, (Object)fileToCopy);
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 12, message, (Throwable)e));
                }
            }
        }
        return copiedFiles;
    }

    public static List extractPlugins(List initialList, List toExtract) {
        if (initialList.size() == toExtract.size()) {
            return initialList;
        }
        ArrayList result = new ArrayList(toExtract.size());
        Iterator iter = initialList.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (!toExtract.contains(element)) continue;
            result.add(element);
            if (result.size() != toExtract.size()) continue;
            break;
        }
        return result;
    }

    public static int isStringIn(String[] searched, String toSearch) {
        if (searched == null || toSearch == null) {
            return -1;
        }
        for (int i = 0; i < searched.length; ++i) {
            if (!toSearch.startsWith(searched[i])) continue;
            return i;
        }
        return -1;
    }

    public static void generatePermissions(Properties featureProperties, Config aConfig, String targetRootProperty, AntScript script) {
        String configInfix = aConfig.toString(".");
        String configPath = aConfig.toStringReplacingAny(".", "ANY");
        String prefixPermissions = "root." + configInfix + '.' + "permissions" + '.';
        String prefixLinks = "root." + configInfix + '.' + "link";
        String commonPermissions = "root.permissions.";
        String commonLinks = "root.link";
        Iterator<Map.Entry<Object, Object>> iter = featureProperties.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Object, Object> permission = iter.next();
            String instruction = (String)permission.getKey();
            String parameters = Utils.removeEndingSlashes((String)permission.getValue());
            if (instruction.startsWith(prefixPermissions)) {
                Utils.generateChmodInstruction(script, Utils.getPropertyFormat(targetRootProperty) + '/' + configPath + '/' + Utils.getPropertyFormat("collectingFolder"), instruction.substring(prefixPermissions.length()), parameters);
                continue;
            }
            if (instruction.startsWith(prefixLinks)) {
                Utils.generateLinkInstruction(script, Utils.getPropertyFormat(targetRootProperty) + '/' + configPath + '/' + Utils.getPropertyFormat("collectingFolder"), parameters);
                continue;
            }
            if (instruction.startsWith(commonPermissions)) {
                Utils.generateChmodInstruction(script, Utils.getPropertyFormat(targetRootProperty) + '/' + configPath + '/' + Utils.getPropertyFormat("collectingFolder"), instruction.substring(commonPermissions.length()), parameters);
                continue;
            }
            if (!instruction.startsWith(commonLinks)) continue;
            Utils.generateLinkInstruction(script, Utils.getPropertyFormat(targetRootProperty) + '/' + configPath + '/' + Utils.getPropertyFormat("collectingFolder"), parameters);
        }
    }

    public static String removeEndingSlashes(String value) {
        String[] params = Utils.getArrayFromString(value, ",");
        for (int i = 0; i < params.length; ++i) {
            if (!params[i].endsWith("/")) continue;
            params[i] = params[i].substring(0, params[i].length() - 1);
        }
        return Utils.getStringFromArray(params, ",");
    }

    private static void generateChmodInstruction(AntScript script, String dir, String rights, String files) {
        if (rights.equals("executable")) {
            rights = "755";
        }
        script.printChmod(dir, rights, files);
    }

    private static void generateLinkInstruction(AntScript script, String dir, String files) {
        String[] links = Utils.getArrayFromString(files, ",");
        ArrayList<String> arguments = new ArrayList<String>(2);
        for (int i = 0; i < links.length; i += 2) {
            arguments.add("-sf");
            arguments.add(links[i]);
            arguments.add(links[i + 1]);
            script.printExecTask("ln", dir, arguments, "Linux");
            arguments.clear();
        }
    }

    public static String getPropertyFormat(String propertyName) {
        StringBuffer sb = new StringBuffer();
        sb.append("${");
        sb.append(propertyName);
        sb.append("}");
        return sb.toString();
    }

    public static boolean isBinary(BundleDescription bundle) {
        Properties bundleProperties = (Properties)bundle.getUserObject();
        if (bundleProperties == null || bundleProperties.get("isCompiler") == null) {
            File props = new File(bundle.getLocation(), "build.properties");
            return !props.exists() || !props.isFile();
        }
        return Boolean.FALSE == bundleProperties.get("isCompiler");
    }
}

