/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build.builder;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.build.AbstractScriptGenerator;
import org.eclipse.pde.internal.build.AssemblyInformation;
import org.eclipse.pde.internal.build.BundleHelper;
import org.eclipse.pde.internal.build.Config;
import org.eclipse.pde.internal.build.Messages;
import org.eclipse.pde.internal.build.ProductGenerator;
import org.eclipse.pde.internal.build.SourceFeatureInformation;
import org.eclipse.pde.internal.build.SourceFeatureWriter;
import org.eclipse.pde.internal.build.Utils;
import org.eclipse.pde.internal.build.ant.FileSet;
import org.eclipse.pde.internal.build.builder.AbstractBuildScriptGenerator;
import org.eclipse.pde.internal.build.builder.ModelBuildScriptGenerator;
import org.eclipse.pde.internal.build.site.BuildTimeFeature;
import org.eclipse.pde.internal.build.site.PDEState;
import org.eclipse.update.core.Feature;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IIncludedFeatureReference;
import org.eclipse.update.core.IPlatformEnvironment;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.IncludedFeatureReference;
import org.eclipse.update.core.PluginEntry;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.core.model.IncludedFeatureReferenceModel;
import org.eclipse.update.core.model.PluginEntryModel;
import org.eclipse.update.core.model.URLEntryModel;

public class FeatureBuildScriptGenerator
extends AbstractBuildScriptGenerator {
    private static final String COMMENT_START_TAG = "<!--";
    private static final String COMMENT_END_TAG = "-->";
    private static final String FEATURE_START_TAG = "<feature";
    private static final String PLUGIN_START_TAG = "<plugin";
    private static final String FRAGMENT_START_TAG = "<fragment";
    private static final String VERSION = "version";
    private static final String PLUGIN_VERSION = "plugin-version";
    protected boolean analyseIncludedFeatures = false;
    protected boolean analysePlugins = true;
    protected boolean sourceFeatureGeneration = false;
    protected boolean binaryFeature = true;
    private boolean scriptGeneration = true;
    protected String featureIdentifier;
    protected String searchedVersion;
    protected IFeature feature;
    protected String featureFullName;
    protected String featureFolderName;
    protected String featureRootLocation;
    protected String featureTempFolder;
    protected Feature sourceFeature;
    protected PluginEntry sourcePlugin;
    protected String sourceFeatureFullName;
    protected String sourceFeatureFullNameVersionned;
    protected SourceFeatureInformation sourceToGather;
    protected boolean sourcePluginOnly = false;
    private String[] extraPlugins = new String[0];
    private boolean generateJnlp = false;
    private boolean signJars = false;
    private boolean generateVersionSuffix = false;
    private List computedElements = null;
    private String customFeatureCallbacks = null;
    private String product = null;
    private static final String TEMPLATE = "data";

    public FeatureBuildScriptGenerator() {
    }

    public FeatureBuildScriptGenerator(String featureId, String versionId, AssemblyInformation informationGathering) throws CoreException {
        if (featureId == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 1, Messages.error_missingFeatureId, null));
        }
        this.featureIdentifier = featureId;
        this.searchedVersion = versionId;
        this.assemblyData = informationGathering;
    }

    protected List computeElements() throws CoreException {
        if (this.computedElements != null) {
            return this.computedElements;
        }
        this.computedElements = new ArrayList(5);
        IPluginEntry[] pluginList = this.feature.getPluginEntries();
        for (int i = 0; i < pluginList.length; ++i) {
            IPluginEntry entry = pluginList[i];
            VersionedIdentifier identifier = entry.getVersionedIdentifier();
            if (this.selectConfigs((IPlatformEnvironment)entry).size() == 0) continue;
            String versionRequested = identifier.getVersion().toString();
            BundleDescription model = this.getSite(false).getRegistry().getResolvedBundle(identifier.getIdentifier(), versionRequested);
            if ((model == null || Utils.isBinary(model)) && this.getBuildProperties().containsKey("generate.plugin@" + identifier.getIdentifier())) {
                this.generateEmbeddedSource(identifier.getIdentifier());
                model = this.getSite(false).getRegistry().getResolvedBundle(identifier.getIdentifier(), versionRequested);
            }
            if (model == null) {
                String message = NLS.bind((String)Messages.exception_missingPlugin, (Object)entry.getVersionedIdentifier());
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 5, message, null));
            }
            this.associateModelAndEntry(model, entry);
            this.computedElements.add(model);
            this.collectElementToAssemble(pluginList[i]);
            this.collectSourcePlugins(pluginList[i], model);
        }
        return this.computedElements;
    }

    private void associateModelAndEntry(BundleDescription model, IPluginEntry entry) {
        HashSet<IPluginEntry> entries;
        Properties bundleProperties = (Properties)model.getUserObject();
        if (bundleProperties == null) {
            bundleProperties = new Properties();
            model.setUserObject((Object)bundleProperties);
        }
        if ((entries = (HashSet<IPluginEntry>)bundleProperties.get("pluginEntry")) == null) {
            entries = new HashSet<IPluginEntry>();
            bundleProperties.put("pluginEntry", entries);
        }
        entries.add(entry);
    }

    private void generateEmbeddedSource(String pluginId) throws CoreException {
        if (this.sourceFeatureGeneration) {
            return;
        }
        FeatureBuildScriptGenerator featureGenerator = new FeatureBuildScriptGenerator(Utils.getArrayFromString(this.getBuildProperties().getProperty("generate.plugin@" + pluginId))[0], null, this.assemblyData);
        featureGenerator.setGenerateIncludedFeatures(false);
        featureGenerator.setAnalyseChildren(this.analysePlugins);
        featureGenerator.setSourceFeatureId(pluginId);
        featureGenerator.setSourceFeatureGeneration(true);
        featureGenerator.setExtraPlugins(Utils.getArrayFromString(this.getBuildProperties().getProperty("generate.plugin@" + pluginId)));
        featureGenerator.setBinaryFeatureGeneration(false);
        featureGenerator.setScriptGeneration(false);
        featureGenerator.setPluginPath(this.pluginPath);
        featureGenerator.setBuildSiteFactory(this.siteFactory);
        featureGenerator.setDevEntries(this.devEntries);
        featureGenerator.setCompiledElements(this.getCompiledElements());
        featureGenerator.setSourceToGather(this.sourceToGather);
        featureGenerator.setSourcePluginOnly(true);
        featureGenerator.setBuildingOSGi(FeatureBuildScriptGenerator.isBuildingOSGi());
        featureGenerator.includePlatformIndependent(this.isPlatformIndependentIncluded());
        featureGenerator.setIgnoreMissingPropertiesFile(this.isIgnoreMissingPropertiesFile());
        featureGenerator.setGenerateVersionSuffix(this.generateVersionSuffix);
        featureGenerator.generate();
    }

    public void setSourcePluginOnly(boolean b) {
        this.sourcePluginOnly = b;
    }

    private void collectSourcePlugins(IPluginEntry pluginEntry, BundleDescription model) {
        if (!this.sourceFeatureGeneration) {
            return;
        }
        if (!this.assemblyData.getAllCompiledPlugins().contains(model)) {
            return;
        }
        if (pluginEntry.getOS() == null && pluginEntry.getWS() == null && pluginEntry.getOSArch() == null) {
            this.sourceToGather.addElementEntry(Config.genericConfig(), model);
            return;
        }
        List correctConfigs = this.selectConfigs((IPlatformEnvironment)pluginEntry);
        Iterator iter = correctConfigs.iterator();
        while (iter.hasNext()) {
            this.sourceToGather.addElementEntry((Config)iter.next(), model);
        }
    }

    public void setAnalyseChildren(boolean generate) {
        this.analysePlugins = generate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate() throws CoreException {
        if (workingDirectory == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 2, Messages.error_missingInstallLocation, null));
        }
        this.initializeVariables();
        String custom = (String)this.getBuildProperties().get("custom");
        if ("true".equalsIgnoreCase(custom)) {
            File buildFile = new File(this.featureRootLocation, "build.xml");
            if (!buildFile.exists()) {
                String message = NLS.bind((String)Messages.error_missingCustomBuildFile, (Object)buildFile);
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 7, message, null));
            }
            try {
                this.updateVersion(buildFile, "feature.version.suffix", this.feature.getVersionedIdentifier().getVersion().toString());
            }
            catch (IOException e) {
                String message = NLS.bind((String)Messages.exception_writeScript, (Object)buildFile);
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 7, message, (Throwable)e));
            }
            List configs = FeatureBuildScriptGenerator.getConfigInfos();
            Iterator iter = configs.iterator();
            while (iter.hasNext()) {
                this.assemblyData.addRootFileProvider((Config)iter.next(), this.feature);
            }
            return;
        }
        if (this.analyseIncludedFeatures) {
            this.generateIncludedFeatureBuildFile();
        }
        if (this.sourceFeatureGeneration) {
            this.generateSourceFeature();
        }
        if (this.analysePlugins) {
            this.generateChildrenScripts();
        }
        if (this.sourceFeatureGeneration) {
            this.addSourceFragmentsToFeature();
            this.writeSourceFeature();
        }
        if (!this.sourcePluginOnly) {
            this.collectElementToAssemble(this.feature);
        }
        if (this.sourceFeatureGeneration) {
            this.generateSourceFeatureScripts();
        }
        if (this.scriptGeneration) {
            this.openScript(this.featureRootLocation, "build.xml");
            try {
                this.generateBuildScript();
            }
            finally {
                this.closeScript();
            }
        }
    }

    protected void generateIncludedFeatureBuildFile() throws CoreException {
        IIncludedFeatureReference[] referencedFeatures = this.feature.getIncludedFeatureReferences();
        for (int i = 0; i < referencedFeatures.length; ++i) {
            String featureId = ((IncludedFeatureReferenceModel)referencedFeatures[i]).getFeatureIdentifier();
            String featureVersion = ((IncludedFeatureReferenceModel)referencedFeatures[i]).getFeatureVersion();
            boolean doSourceFeatureGeneration = this.getBuildProperties().containsKey("generate.feature@" + featureId);
            FeatureBuildScriptGenerator generator = new FeatureBuildScriptGenerator(doSourceFeatureGeneration ? Utils.getArrayFromString(this.getBuildProperties().getProperty("generate.feature@" + featureId))[0] : featureId, featureVersion, this.assemblyData);
            generator.setGenerateIncludedFeatures(!doSourceFeatureGeneration);
            generator.setAnalyseChildren(this.analysePlugins);
            generator.setSourceFeatureGeneration(doSourceFeatureGeneration);
            generator.setBinaryFeatureGeneration(!doSourceFeatureGeneration);
            generator.setScriptGeneration(!doSourceFeatureGeneration);
            if (doSourceFeatureGeneration) {
                generator.setSourceFeatureId(featureId);
                generator.setExtraPlugins(Utils.getArrayFromString(this.getBuildProperties().getProperty("generate.feature@" + featureId)));
            }
            generator.setPluginPath(this.pluginPath);
            generator.setBuildSiteFactory(this.siteFactory);
            generator.setDevEntries(this.devEntries);
            generator.setCompiledElements(this.getCompiledElements());
            generator.setSourceToGather(new SourceFeatureInformation());
            generator.setBuildingOSGi(FeatureBuildScriptGenerator.isBuildingOSGi());
            generator.includePlatformIndependent(this.isPlatformIndependentIncluded());
            generator.setIgnoreMissingPropertiesFile(this.isIgnoreMissingPropertiesFile());
            generator.setGenerateVersionSuffix(this.generateVersionSuffix);
            try {
                generator.generate();
                continue;
            }
            catch (CoreException exception) {
                this.absorbExceptionIfOptionalFeature(referencedFeatures[i], exception);
            }
        }
    }

    private void absorbExceptionIfOptionalFeature(IIncludedFeatureReference feature, CoreException toAbsorb) throws CoreException {
        if (toAbsorb.getStatus().getCode() != 1 || toAbsorb.getStatus().getCode() == 1 && !feature.isOptional()) {
            throw toAbsorb;
        }
    }

    protected void setExtraPlugins(String[] plugins) {
        this.extraPlugins = plugins;
    }

    private void generateBuildScript() throws CoreException {
        if (BundleHelper.getDefault().isDebugging()) {
            System.out.println("Generating feature " + this.featureFullName);
        }
        this.generatePrologue();
        this.generateAllPluginsTarget();
        this.generateAllFeaturesTarget();
        this.generateUpdateFeatureFile();
        this.generateAllChildrenTarget();
        this.generateChildrenTarget();
        this.generateBuildJarsTarget();
        this.generateBuildZipsTarget();
        this.generateBuildUpdateJarTarget();
        this.generateGatherBinPartsTarget();
        this.generateZipDistributionWholeTarget();
        this.generateZipSourcesTarget();
        this.generateZipLogsTarget();
        this.generateCleanTarget();
        this.generateRefreshTarget();
        this.generateGatherSourcesTarget();
        this.generateGatherLogsTarget();
        this.generateEpilogue();
    }

    private void generateGatherSourcesTarget() {
        this.script.printTargetDeclaration("gather.sources", null, null, null, null);
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("destination.temp.folder", Utils.getPropertyFormat("feature.temp.folder") + '/' + "plugins" + '/' + this.sourceFeatureFullNameVersionned + '/' + "src");
        params.put("target", "gather.sources");
        this.script.printAntCallTask("children", true, params);
        this.script.printTargetEnd();
    }

    private void generateGatherLogsTarget() {
        this.script.println();
        this.script.printTargetDeclaration("gather.logs", "init", null, null, null);
        this.script.printMkdirTask(this.featureTempFolder);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("target", "gather.logs");
        params.put("destination.temp.folder", new Path(this.featureTempFolder).append("plugins").toString());
        this.script.printAntCallTask("all.children", false, params);
        this.script.printTargetEnd();
    }

    private void generateUpdateFeatureFile() {
        this.script.printTargetDeclaration("update.feature", "init", null, null, null);
        this.script.printTargetEnd();
    }

    private void generateBuildZipsTarget() throws CoreException {
        StringBuffer zips = new StringBuffer();
        Properties props = this.getBuildProperties();
        Iterator<Map.Entry<Object, Object>> iterator = props.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            String key = (String)entry.getKey();
            if (!key.startsWith("source.") || !key.endsWith(".zip")) continue;
            String zipName = key.substring("source.".length());
            zips.append(',');
            zips.append(zipName);
            this.generateZipIndividualTarget(zipName, (String)entry.getValue());
        }
        this.script.println();
        this.script.printTargetDeclaration("build.zips", "init" + zips.toString(), null, null, null);
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("target", "build.zips");
        this.script.printAntCallTask("all.children", true, params);
        this.script.printTargetEnd();
    }

    private void generateZipIndividualTarget(String zipName, String source) {
        this.script.println();
        this.script.printTargetDeclaration(zipName, "init", null, null, null);
        this.script.printZipTask(Utils.getPropertyFormat("basedir") + '/' + zipName, Utils.getPropertyFormat("basedir") + '/' + source, false, false, null);
        this.script.printTargetEnd();
    }

    private void generateCleanTarget() {
        this.script.println();
        this.script.printTargetDeclaration("clean", "init", null, null, NLS.bind((String)Messages.build_feature_clean, (Object)this.featureIdentifier));
        this.script.printDeleteTask(null, Utils.getPropertyFormat("feature.destination") + '/' + this.featureFullName + ".jar", null);
        this.script.printDeleteTask(null, Utils.getPropertyFormat("feature.destination") + '/' + this.featureFullName + ".bin.dist.zip", null);
        this.script.printDeleteTask(null, Utils.getPropertyFormat("feature.destination") + '/' + this.featureFullName + ".log.zip", null);
        this.script.printDeleteTask(null, Utils.getPropertyFormat("feature.destination") + '/' + this.featureFullName + ".src.zip", null);
        this.script.printDeleteTask(this.featureTempFolder, null, null);
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("target", "clean");
        this.script.printAntCallTask("all.children", true, params);
        this.script.printTargetEnd();
    }

    private void generateZipLogsTarget() {
        this.script.println();
        this.script.printTargetDeclaration("zip.logs", "init", null, null, null);
        this.script.printDeleteTask(this.featureTempFolder, null, null);
        this.script.printMkdirTask(this.featureTempFolder);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("include.children", "true");
        params.put("target", "gather.logs");
        params.put("destination.temp.folder", new Path(this.featureTempFolder).append("plugins").toString());
        this.script.printAntCallTask("all.children", false, params);
        IPath destination = new Path(Utils.getPropertyFormat("feature.destination")).append(this.featureFullName + ".log.zip");
        this.script.printZipTask(destination.toString(), this.featureTempFolder, true, false, null);
        this.script.printDeleteTask(this.featureTempFolder, null, null);
        this.script.printTargetEnd();
    }

    protected void generateZipSourcesTarget() {
        this.script.println();
        this.script.printTargetDeclaration("zip.sources", "init", null, null, null);
        this.script.printDeleteTask(this.featureTempFolder, null, null);
        this.script.printMkdirTask(this.featureTempFolder);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("include.children", "true");
        params.put("target", "gather.sources");
        params.put("destination.temp.folder", this.featureTempFolder + '/' + "plugins" + '/' + this.sourceFeatureFullNameVersionned + '/' + "src");
        this.script.printAntCallTask("all.children", true, params);
        this.script.printZipTask(Utils.getPropertyFormat("feature.destination") + '/' + this.featureFullName + ".src.zip", this.featureTempFolder, true, false, null);
        this.script.printDeleteTask(this.featureTempFolder, null, null);
        this.script.printTargetEnd();
    }

    private void generateGatherBinPartsTarget() throws CoreException {
        String include = (String)this.getBuildProperties().get("bin.includes");
        String exclude = (String)this.getBuildProperties().get("bin.excludes");
        String root = Utils.getPropertyFormat("feature.base") + '/' + this.featureFolderName;
        this.script.println();
        this.script.printTargetDeclaration("gather.bin.parts", "init", "feature.base", null, null);
        if (include != null) {
            this.script.printMkdirTask(root);
        }
        HashMap<String, String> callbackParams = null;
        if (this.customFeatureCallbacks != null) {
            callbackParams = new HashMap<String, String>(1);
            callbackParams.put("destination.temp.folder", new Path(Utils.getPropertyFormat("feature.base")).append("plugins").toString());
            callbackParams.put("feature.directory", root);
            this.script.printSubantTask(Utils.getPropertyFormat("customBuildCallbacks"), "pre.gather.bin.parts", ".", "false", callbackParams, null);
        }
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("target", "gather.bin.parts");
        params.put("destination.temp.folder", new Path(Utils.getPropertyFormat("feature.base")).append("plugins").toString());
        this.script.printAntCallTask("children", true, params);
        if (include != null) {
            if (include != null || exclude != null) {
                FileSet fileSet = new FileSet(Utils.getPropertyFormat("basedir"), null, include, null, exclude, null, null);
                this.script.printCopyTask(null, root, new FileSet[]{fileSet}, true, false);
            }
            String featureVersionInfo = "";
            IIncludedFeatureReference[] includedFeatures = this.feature.getRawIncludedFeatureReferences();
            for (int i = 0; i < includedFeatures.length; ++i) {
                String versionId = includedFeatures[i].getVersionedIdentifier().getVersion().toString();
                IFeature includedFeature = null;
                try {
                    includedFeature = this.getSite(false).findFeature(includedFeatures[i].getVersionedIdentifier().getIdentifier(), versionId, true);
                }
                catch (CoreException e) {
                    this.absorbExceptionIfOptionalFeature(includedFeatures[i], e);
                    continue;
                }
                VersionedIdentifier includedFeatureVersionId = includedFeature.getVersionedIdentifier();
                featureVersionInfo = featureVersionInfo + includedFeatureVersionId.getIdentifier() + ',' + includedFeatureVersionId.getVersion().toString() + ',';
            }
            String pluginVersionInfo = "";
            IPluginEntry[] pluginsIncluded = this.feature.getRawPluginEntries();
            for (int i = 0; i < pluginsIncluded.length; ++i) {
                VersionedIdentifier identifier = pluginsIncluded[i].getVersionedIdentifier();
                String versionRequested = identifier.getVersion().toString();
                String entryIdentifier = identifier.getIdentifier();
                BundleDescription model = this.getSite(false).getRegistry().getResolvedBundle(entryIdentifier, versionRequested);
                if (model == null) continue;
                pluginVersionInfo = pluginVersionInfo + entryIdentifier + ',' + model.getVersion() + ',';
            }
            this.script.println("<eclipse.idReplacer featureFilePath=\"" + root + '/' + "feature.xml" + "\"  selfVersion=\"" + this.feature.getVersionedIdentifier().getVersion() + "\" featureIds=\"" + featureVersionInfo + "\" pluginIds=\"" + pluginVersionInfo + "\"/>");
        }
        this.generateRootFilesAndPermissionsCalls();
        if (this.customFeatureCallbacks != null) {
            this.script.printSubantTask(Utils.getPropertyFormat("customBuildCallbacks"), "post.gather.bin.parts", ".", "false", callbackParams, null);
        }
        this.script.printTargetEnd();
        this.generateRootFilesAndPermissions();
    }

    private void generateRootFilesAndPermissionsCalls() {
        this.script.printAntCallTask("rootFiles" + Utils.getPropertyFormat("os") + '_' + Utils.getPropertyFormat("ws") + '_' + Utils.getPropertyFormat("arch"), true, null);
    }

    private void generateRootFilesAndPermissions() throws CoreException {
        Config aConfig;
        if (this.product != null && !this.havePDEUIState()) {
            ProductGenerator generator = new ProductGenerator();
            generator.setProduct(this.product);
            generator.setBuildSiteFactory(this.siteFactory);
            generator.setBuildProperties(this.getBuildProperties());
            generator.setRoot(this.featureRootLocation);
            generator.setWorkingDirectory(FeatureBuildScriptGenerator.getWorkingDirectory());
            try {
                generator.generate();
            }
            catch (CoreException e) {
                // empty catch block
            }
        }
        Iterator iter = FeatureBuildScriptGenerator.getConfigInfos().iterator();
        while (iter.hasNext()) {
            aConfig = (Config)iter.next();
            this.script.printTargetDeclaration("rootFiles" + aConfig.toString("_"), null, null, null, null);
            this.generateCopyRootFiles(aConfig);
            Utils.generatePermissions(this.getBuildProperties(), aConfig, "feature.base", this.script);
            this.script.printTargetEnd();
        }
        this.script.printTargetDeclaration("rootFilesgroup_group_group", null, null, null, null);
        iter = FeatureBuildScriptGenerator.getConfigInfos().iterator();
        while (iter.hasNext()) {
            aConfig = (Config)iter.next();
            this.script.printAntCallTask("rootFiles" + aConfig.toString("_"), true, null);
        }
        this.script.printTargetEnd();
    }

    private void generateCopyRootFiles(Config aConfig) throws CoreException {
        String baseList = this.getBuildProperties().getProperty("root", "");
        String fileList = this.getBuildProperties().getProperty("root." + aConfig.toString("."), "");
        if ((fileList = (fileList.length() == 0 ? "" : fileList + ',') + baseList).equals("")) {
            return;
        }
        this.assemblyData.addRootFileProvider(aConfig, this.feature);
        String configName = aConfig.toStringReplacingAny(".", "ANY");
        this.script.printMkdirTask(Utils.getPropertyFormat("feature.base") + '/' + configName + '/' + Utils.getPropertyFormat("collectingFolder"));
        String[] files = Utils.getArrayFromString(fileList, ",");
        FileSet[] fileSet = new FileSet[files.length];
        for (int i = 0; i < files.length; ++i) {
            String fromDir = Utils.getPropertyFormat("basedir") + '/';
            String file = files[i];
            if (file.startsWith("absolute:")) {
                file = file.substring(9);
                fromDir = "";
            }
            if (file.startsWith("file:")) {
                Path target = new Path(file.substring(5));
                fileSet[i] = new FileSet(fromDir + target.removeLastSegments(1), null, target.lastSegment(), null, null, null, null);
                continue;
            }
            fileSet[i] = new FileSet(fromDir + file, null, "**", null, null, null, null);
        }
        String shouldOverwrite = this.getBuildProperties().getProperty("overwriteRootFiles", "true");
        this.script.printCopyTask(null, Utils.getPropertyFormat("feature.base") + '/' + configName + '/' + Utils.getPropertyFormat("collectingFolder"), fileSet, true, Boolean.valueOf(shouldOverwrite));
    }

    private void generateBuildUpdateJarTarget() {
        this.script.println();
        this.script.printTargetDeclaration("build.update.jar", "init", null, null, NLS.bind((String)Messages.build_feature_buildUpdateJar, (Object)this.featureIdentifier));
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("target", "build.update.jar");
        this.script.printAntCallTask("all.children", true, params);
        this.script.printProperty("feature.base", this.featureTempFolder);
        this.script.printDeleteTask(this.featureTempFolder, null, null);
        this.script.printMkdirTask(this.featureTempFolder);
        params.clear();
        params.put("feature.base", this.featureTempFolder);
        params.put("os", this.feature.getOS() == null ? Config.ANY : this.feature.getOS());
        params.put("ws", this.feature.getWS() == null ? Config.ANY : this.feature.getWS());
        params.put("arch", this.feature.getOSArch() == null ? Config.ANY : this.feature.getOSArch());
        params.put("nl", this.feature.getNL() == null ? Config.ANY : this.feature.getNL());
        this.script.printAntCallTask("gather.bin.parts", false, params);
        String jar = Utils.getPropertyFormat("feature.destination") + '/' + this.featureFullName + ".jar";
        this.script.printJarTask(jar, this.featureTempFolder + '/' + this.featureFolderName, null);
        this.script.printDeleteTask(this.featureTempFolder, null, null);
        if (this.generateJnlp) {
            this.script.println("<eclipse.jnlpGenerator feature=\"" + jar + "\"  codebase=\"" + Utils.getPropertyFormat("jnlp.codebase") + "\" j2se=\"" + Utils.getPropertyFormat("jnlp.j2se") + "\"/>");
        }
        if (this.signJars) {
            this.script.println("<signjar jar=\"" + jar + "\" alias=\"" + Utils.getPropertyFormat("sign.alias") + "\" keystore=\"" + Utils.getPropertyFormat("sign.keystore") + "\" storepass=\"" + Utils.getPropertyFormat("sign.storepass") + "\"/>");
        }
        this.script.printTargetEnd();
    }

    protected void generateZipDistributionWholeTarget() {
        this.script.println();
        this.script.printTargetDeclaration("zip.distribution", "init", null, null, NLS.bind((String)Messages.build_feature_zips, (Object)this.featureIdentifier));
        this.script.printDeleteTask(this.featureTempFolder, null, null);
        this.script.printMkdirTask(this.featureTempFolder);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("feature.base", this.featureTempFolder);
        params.put("include.children", "true");
        params.put("os", this.feature.getOS() == null ? Config.ANY : this.feature.getOS());
        params.put("ws", this.feature.getWS() == null ? Config.ANY : this.feature.getWS());
        params.put("arch", this.feature.getOSArch() == null ? Config.ANY : this.feature.getOSArch());
        params.put("nl", this.feature.getNL() == null ? Config.ANY : this.feature.getNL());
        this.script.printAntCallTask("gather.bin.parts", true, params);
        this.script.printZipTask(Utils.getPropertyFormat("feature.destination") + '/' + this.featureFullName + ".bin.dist.zip", this.featureTempFolder, false, false, null);
        this.script.printDeleteTask(this.featureTempFolder, null, null);
        this.script.printTargetEnd();
    }

    private void generateAllChildrenTarget() {
        StringBuffer depends = new StringBuffer();
        depends.append("init");
        depends.append(',');
        depends.append("all.features");
        depends.append(',');
        depends.append("all.plugins");
        depends.append(',');
        depends.append("update.feature");
        this.script.println();
        this.script.printTargetDeclaration("all.children", depends.toString(), null, null, null);
        this.script.printTargetEnd();
    }

    protected void generateAllPluginsTarget() throws CoreException {
        List plugins = this.computeElements();
        plugins = Utils.extractPlugins(this.getSite(false).getRegistry().getSortedBundles(), plugins);
        this.script.println();
        this.script.printTargetDeclaration("all.plugins", "init", null, null, null);
        HashSet<BundleDescription> writtenCalls = new HashSet<BundleDescription>(plugins.size());
        Iterator iter = plugins.iterator();
        while (iter.hasNext()) {
            BundleDescription current = (BundleDescription)iter.next();
            Properties bundleProperties = (Properties)current.getUserObject();
            if (bundleProperties == null || bundleProperties.get("isCompiler") == null || bundleProperties.get("isCompiler") == Boolean.FALSE || writtenCalls.contains(current)) continue;
            writtenCalls.add(current);
            IPluginEntry[] entries = Utils.getPluginEntry(this.feature, current.getSymbolicName(), false);
            for (int j = 0; j < entries.length; ++j) {
                List list = this.selectConfigs((IPlatformEnvironment)entries[j]);
                if (list.size() == 0) continue;
                HashMap<String, String> params = null;
                Config aMatchingConfig = (Config)list.get(0);
                params = new HashMap<String, String>(3);
                if (!aMatchingConfig.getOs().equals(Config.ANY)) {
                    params.put("os", aMatchingConfig.getOs());
                }
                if (!aMatchingConfig.getWs().equals(Config.ANY)) {
                    params.put("ws", aMatchingConfig.getWs());
                }
                if (!aMatchingConfig.getArch().equals(Config.ANY)) {
                    params.put("arch", aMatchingConfig.getArch());
                }
                IPath location = Utils.makeRelative((IPath)new Path(this.getLocation(current)), (IPath)new Path(this.featureRootLocation));
                this.script.printAntTask("build.xml", location.toString(), Utils.getPropertyFormat("target"), null, null, params);
            }
        }
        this.script.printTargetEnd();
    }

    private void generateAllFeaturesTarget() throws CoreException {
        this.script.printTargetDeclaration("all.features", "init", null, null, null);
        if (this.analyseIncludedFeatures) {
            IIncludedFeatureReference[] features = this.feature.getIncludedFeatureReferences();
            for (int i = 0; i < features.length; ++i) {
                String featureId = features[i].getVersionedIdentifier().getIdentifier();
                String versionId = features[i].getVersionedIdentifier().getVersion().toString();
                IFeature includedFeature = this.getSite(false).findFeature(featureId, versionId, false);
                if (includedFeature == null) {
                    if (features[i].isOptional()) continue;
                    String message = NLS.bind((String)Messages.exception_missingFeature, (Object)(featureId + ' ' + versionId));
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 1, message, null));
                }
                if (includedFeature instanceof BuildTimeFeature && ((BuildTimeFeature)includedFeature).isBinary()) continue;
                String includedFeatureDirectory = includedFeature.getURL().getPath();
                int j = includedFeatureDirectory.lastIndexOf("feature.xml");
                if (j != -1) {
                    includedFeatureDirectory = includedFeatureDirectory.substring(0, j);
                }
                IPath location = Utils.makeRelative((IPath)new Path(includedFeatureDirectory), (IPath)new Path(this.featureRootLocation));
                this.script.printAntTask("build.xml", location.toString(), Utils.getPropertyFormat("target"), null, null, null);
            }
        }
        this.script.printTargetEnd();
    }

    private void generateEpilogue() {
        this.script.println();
        this.script.printProjectEnd();
    }

    private void generatePrologue() {
        this.script.printProjectDeclaration(this.feature.getVersionedIdentifier().getIdentifier(), "build.update.jar", ".");
        this.script.println();
        this.script.printTargetDeclaration("init", null, null, null, null);
        this.script.printProperty("feature.temp.folder", Utils.getPropertyFormat("basedir") + '/' + "feature.temp.folder");
        this.script.printProperty("feature.destination", Utils.getPropertyFormat("basedir"));
        if (this.customFeatureCallbacks != null) {
            this.script.printAvailableTask("customBuildCallbacks", this.customFeatureCallbacks, this.customFeatureCallbacks);
        }
        this.script.printTargetEnd();
    }

    private void generateChildrenScripts() throws CoreException {
        List plugins = this.computeElements();
        String suffix = this.generateFeatureVersionSuffix((BuildTimeFeature)this.feature, plugins);
        if (suffix != null) {
            PluginVersionIdentifier versionId = this.feature.getVersionedIdentifier().getVersion();
            String qualifier = versionId.getQualifierComponent();
            qualifier = qualifier.substring(0, ((BuildTimeFeature)this.feature).getContextQualifierLength());
            qualifier = qualifier + '-' + suffix;
            versionId = new PluginVersionIdentifier(versionId.getMajorComponent(), versionId.getMinorComponent(), versionId.getServiceComponent(), qualifier);
            String newVersion = versionId.toString();
            ((BuildTimeFeature)this.feature).setFeatureVersion(newVersion);
            this.initializeFeatureNames();
        }
        this.generateModels(Utils.extractPlugins(this.getSite(false).getRegistry().getSortedBundles(), plugins));
    }

    private String generateFeatureVersionSuffix(BuildTimeFeature buildFeature, List plugins) throws CoreException {
        String qualifier;
        if (!this.generateVersionSuffix || buildFeature.getContextQualifierLength() == -1) {
            return null;
        }
        Properties properties = this.getBuildProperties();
        String significantDigits = (String)properties.get("significantVersionDigits");
        int maxDigits = 15;
        if (significantDigits != null) {
            try {
                maxDigits = Integer.parseInt(significantDigits);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        String generatedLength = (String)properties.get("generatedVersionLength");
        int finalLength = 15;
        if (generatedLength != null) {
            try {
                finalLength = Integer.parseInt(generatedLength);
                if (finalLength < maxDigits) {
                    finalLength = maxDigits;
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        IIncludedFeatureReference[] referencedFeatures = buildFeature.getIncludedFeatureReferences();
        int numElements = plugins.size() + referencedFeatures.length;
        char[][] versions = new char[numElements][];
        int idx = -1;
        int longestArray = 0;
        int shift = 45;
        if (referencedFeatures != null) {
            for (int i = 0; i < referencedFeatures.length; ++i) {
                BuildTimeFeature refFeature = (BuildTimeFeature)this.getSite(false).findFeature(referencedFeatures[i].getVersionedIdentifier().getIdentifier(), null, false);
                if (refFeature == null) continue;
                int contextLength = refFeature.getContextQualifierLength();
                qualifier = refFeature.getVersionedIdentifier().getVersion().getQualifierComponent();
                if (qualifier.length() <= ++contextLength) continue;
                char[] chars = qualifier.toCharArray();
                versions[++idx] = new char[chars.length - contextLength];
                System.arraycopy(chars, contextLength, versions[idx], 0, chars.length - contextLength);
                if (versions[idx].length <= longestArray) continue;
                longestArray = versions[idx].length;
            }
        }
        Iterator iterator = plugins.iterator();
        while (iterator.hasNext()) {
            BundleDescription model = (BundleDescription)iterator.next();
            qualifier = model.getVersion().getQualifier();
            if (qualifier.length() <= 0) continue;
            versions[++idx] = qualifier.toCharArray();
            if (versions[idx].length <= longestArray) continue;
            longestArray = versions[idx].length;
        }
        if (idx == -1) {
            return null;
        }
        if (longestArray > maxDigits) {
            longestArray = maxDigits;
        }
        int[] sums = new int[longestArray];
        for (int i = 0; i <= idx; ++i) {
            for (int j = 0; j < longestArray; ++j) {
                if (versions[i].length <= j) continue;
                int n = j;
                sums[n] = sums[n] + (versions[i][j] - shift);
            }
        }
        char[] result = new char[finalLength];
        int x = 0;
        int val = 0;
        int carry = 0;
        int c = 0;
        int i = -1;
        while ((++i < longestArray || carry != 0) && i < finalLength) {
            x = carry + (i < longestArray ? sums[longestArray - i - 1] : 0);
            val = x % 64;
            carry = x >> 6;
            if (val == 0) {
                c = 45;
            } else if (val > 0 && val <= 10) {
                c = (char)(48 + val - 1);
            } else if (val == 11) {
                c = 95;
            } else if (val > 11 && val <= 37) {
                c = (char)(65 + val - 12);
            } else if (val > 37 && val <= 63) {
                c = (char)(97 + val - 38);
            }
            result[finalLength - i - 1] = c;
        }
        while (i < finalLength) {
            result[finalLength - i - 1] = 45;
            ++i;
        }
        return String.valueOf(result);
    }

    private void generateModels(List models) throws CoreException {
        if (!this.scriptGeneration) {
            return;
        }
        if (!this.binaryFeature || models.isEmpty()) {
            return;
        }
        HashSet<BundleDescription> generatedScripts = new HashSet<BundleDescription>(models.size());
        Iterator iterator = models.iterator();
        while (iterator.hasNext()) {
            BundleDescription model = (BundleDescription)iterator.next();
            if (generatedScripts.contains(model)) continue;
            generatedScripts.add(model);
            Set matchingEntries = (Set)((Properties)model.getUserObject()).get("pluginEntry");
            if (matchingEntries.isEmpty()) {
                return;
            }
            Iterator entryIter = matchingEntries.iterator();
            IPluginEntry correspondingEntry = (IPluginEntry)entryIter.next();
            List list = this.selectConfigs((IPlatformEnvironment)correspondingEntry);
            if (list.size() == 0) continue;
            ModelBuildScriptGenerator generator = new ModelBuildScriptGenerator();
            generator.setBuildSiteFactory(this.siteFactory);
            generator.setCompiledElements(this.getCompiledElements());
            generator.setIgnoreMissingPropertiesFile(this.isIgnoreMissingPropertiesFile());
            generator.setModel(model);
            generator.setFeatureGenerator(this);
            generator.setPluginPath(this.getPluginPath());
            generator.setBuildingOSGi(FeatureBuildScriptGenerator.isBuildingOSGi());
            generator.setDevEntries(this.devEntries);
            generator.includePlatformIndependent(this.isPlatformIndependentIncluded());
            generator.setSignJars(this.signJars);
            generator.setAssociatedEntry(correspondingEntry);
            generator.generate();
        }
    }

    public void setFeature(String featureID) throws CoreException {
        if (featureID == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 1, Messages.error_missingFeatureId, null));
        }
        this.featureIdentifier = featureID;
    }

    public static String getNormalizedName(IFeature feature) {
        return feature.getVersionedIdentifier().toString();
    }

    private void initializeVariables() throws CoreException {
        this.feature = this.getSite(false).findFeature(this.featureIdentifier, this.searchedVersion, true);
        if (this.featureRootLocation == null) {
            this.featureRootLocation = this.feature.getURL().getPath();
            int i = this.featureRootLocation.lastIndexOf("feature.xml");
            if (i != -1) {
                this.featureRootLocation = this.featureRootLocation.substring(0, i);
            }
        }
        this.initializeFeatureNames();
        if (this.feature instanceof BuildTimeFeature && this.getBuildProperties() == AbstractScriptGenerator.MissingProperties.getInstance()) {
            BuildTimeFeature buildFeature = (BuildTimeFeature)this.feature;
            this.scriptGeneration = false;
            buildFeature.setBinary(true);
        }
        this.customFeatureCallbacks = this.getBuildProperties().getProperty("customBuildCallbacks");
        if ("true".equalsIgnoreCase(this.customFeatureCallbacks)) {
            this.customFeatureCallbacks = "customBuildCallbacks.xml";
        } else if ("false".equalsIgnoreCase(this.customFeatureCallbacks)) {
            this.customFeatureCallbacks = null;
        }
    }

    private void initializeFeatureNames() throws CoreException {
        this.featureFullName = FeatureBuildScriptGenerator.getNormalizedName(this.feature);
        this.featureFolderName = "features/" + this.featureFullName;
        this.sourceFeatureFullName = this.computeSourceFeatureName(this.feature, false);
        this.sourceFeatureFullNameVersionned = this.computeSourceFeatureName(this.feature, true);
        this.featureTempFolder = Utils.getPropertyFormat("feature.temp.folder");
    }

    public void setSourceFeatureId(String id) {
        this.sourceFeatureFullName = id;
    }

    private String computeSourceFeatureName(IFeature featureForName, boolean withNumber) throws CoreException {
        String sourceFeatureName = this.getBuildProperties().getProperty("sourceFeature.name");
        if (sourceFeatureName == null) {
            sourceFeatureName = this.sourceFeatureFullName;
        }
        if (sourceFeatureName == null) {
            sourceFeatureName = featureForName.getVersionedIdentifier().getIdentifier() + ".source";
        }
        return sourceFeatureName + (withNumber ? "_" + featureForName.getVersionedIdentifier().getVersion().toString() : "");
    }

    protected Properties getBuildProperties() throws CoreException {
        if (this.buildProperties == null) {
            this.buildProperties = FeatureBuildScriptGenerator.readProperties(this.featureRootLocation, "build.properties", this.isIgnoreMissingPropertiesFile() ? 0 : 2);
        }
        return this.buildProperties;
    }

    private void generateChildrenTarget() {
        this.script.println();
        this.script.printTargetDeclaration("children", null, "include.children", null, null);
        this.script.printAntCallTask("all.children", true, null);
        this.script.printTargetEnd();
    }

    private void generateBuildJarsTarget() {
        this.script.println();
        this.script.printTargetDeclaration("build.jars", "init", null, null, NLS.bind((String)Messages.build_feature_buildJars, (Object)this.featureIdentifier));
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("target", "build.jars");
        this.script.printAntCallTask("all.children", true, params);
        this.script.printTargetEnd();
        this.script.println();
        this.script.printTargetDeclaration("build.sources", "init", null, null, null);
        params.clear();
        params.put("target", "build.sources");
        this.script.printAntCallTask("all.children", true, params);
        this.script.printTargetEnd();
    }

    private void generateRefreshTarget() {
        this.script.println();
        this.script.printTargetDeclaration("refresh", "init", "eclipse.running", null, NLS.bind((String)Messages.build_feature_refresh, (Object)this.featureIdentifier));
        this.script.printConvertPathTask(new Path(this.featureRootLocation).removeLastSegments(0).toOSString().replace('\\', '/'), "resourcePath", false);
        this.script.printRefreshLocalTask(Utils.getPropertyFormat("resourcePath"), "infinite");
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("target", "refresh");
        this.script.printAntCallTask("all.children", true, params);
        this.script.printTargetEnd();
    }

    public void setGenerateIncludedFeatures(boolean recursiveGeneration) {
        this.analyseIncludedFeatures = recursiveGeneration;
    }

    protected void collectElementToAssemble(IFeature featureToCollect) throws CoreException {
        if (this.scriptGeneration && (this.assemblyData == null || this.getBuildProperties().get("bin.includes") == null)) {
            return;
        }
        List correctConfigs = this.selectConfigs((IPlatformEnvironment)featureToCollect);
        Iterator iter = correctConfigs.iterator();
        while (iter.hasNext()) {
            Config config = (Config)iter.next();
            this.assemblyData.addFeature(config, this.feature);
        }
    }

    private void generateSourceFeature() throws CoreException {
        Feature featureExample = (Feature)this.feature;
        this.sourceFeature = this.createSourceFeature(featureExample);
        this.associateExtraPluginsAndFeatures();
        this.sourcePlugin = FeatureBuildScriptGenerator.isBuildingOSGi() ? this.create30SourcePlugin() : this.createSourcePlugin();
        this.generateSourceFragment();
    }

    private void generateSourceFragment() throws CoreException {
        Map fragments = this.sourceToGather.getElementEntries();
        Iterator iter = fragments.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry fragmentInfo = iter.next();
            Config configInfo = (Config)fragmentInfo.getKey();
            if (configInfo.equals(Config.genericConfig())) continue;
            PluginEntry sourceFragment = new PluginEntry();
            String sourceFragmentId = this.sourceFeature.getFeatureIdentifier() + "." + configInfo.toString(".");
            sourceFragment.setPluginIdentifier(sourceFragmentId);
            sourceFragment.setPluginVersion(this.sourceFeature.getFeatureVersion());
            sourceFragment.setOS(configInfo.getOs());
            sourceFragment.setWS(configInfo.getWs());
            sourceFragment.setArch(configInfo.getArch());
            sourceFragment.isFragment(true);
            if (FeatureBuildScriptGenerator.isBuildingOSGi()) {
                this.create30SourceFragment(sourceFragment, this.sourcePlugin);
                continue;
            }
            this.createSourceFragment(sourceFragment, this.sourcePlugin);
        }
    }

    private void addSourceFragmentsToFeature() {
        Map fragments = this.sourceToGather.getElementEntries();
        Iterator iter = fragments.entrySet().iterator();
        while (iter.hasNext()) {
            Set sourceList;
            Map.Entry fragmentInfo = iter.next();
            Config configInfo = (Config)fragmentInfo.getKey();
            if (configInfo.equals(Config.genericConfig()) || (sourceList = (Set)fragmentInfo.getValue()).size() == 0) continue;
            PluginEntry sourceFragment = new PluginEntry();
            String sourceFragmentId = this.sourceFeature.getFeatureIdentifier() + "." + configInfo.toString(".");
            sourceFragment.setPluginIdentifier(sourceFragmentId);
            sourceFragment.setPluginVersion(this.sourceFeature.getFeatureVersion());
            sourceFragment.setOS(configInfo.getOs());
            sourceFragment.setWS(configInfo.getWs());
            sourceFragment.setArch(configInfo.getArch());
            sourceFragment.isFragment(true);
            this.sourceFeature.addPluginEntryModel((PluginEntryModel)sourceFragment);
        }
    }

    private void generateSourceFeatureScripts() throws CoreException {
        FeatureBuildScriptGenerator sourceScriptGenerator = new FeatureBuildScriptGenerator(this.sourceFeatureFullName, this.sourceFeature.getFeatureVersion(), this.assemblyData);
        sourceScriptGenerator.setGenerateIncludedFeatures(true);
        sourceScriptGenerator.setAnalyseChildren(true);
        sourceScriptGenerator.setSourceToGather(this.sourceToGather);
        sourceScriptGenerator.setBinaryFeatureGeneration(true);
        sourceScriptGenerator.setSourceFeatureGeneration(false);
        sourceScriptGenerator.setScriptGeneration(true);
        sourceScriptGenerator.setPluginPath(this.pluginPath);
        sourceScriptGenerator.setBuildSiteFactory(this.siteFactory);
        sourceScriptGenerator.setDevEntries(this.devEntries);
        sourceScriptGenerator.setCompiledElements(this.getCompiledElements());
        sourceScriptGenerator.setSourcePluginOnly(this.sourcePluginOnly);
        sourceScriptGenerator.setBuildingOSGi(FeatureBuildScriptGenerator.isBuildingOSGi());
        sourceScriptGenerator.includePlatformIndependent(this.isPlatformIndependentIncluded());
        sourceScriptGenerator.setIgnoreMissingPropertiesFile(this.isIgnoreMissingPropertiesFile());
        sourceScriptGenerator.setGenerateVersionSuffix(this.generateVersionSuffix);
        sourceScriptGenerator.generate();
    }

    private void associateExtraPluginsAndFeatures() throws CoreException {
        for (int i = 1; i < this.extraPlugins.length; ++i) {
            BundleDescription model;
            if (this.extraPlugins[i].startsWith("feature@")) {
                String id = this.extraPlugins[i].substring(8);
                IncludedFeatureReference include = new IncludedFeatureReference();
                include.setFeatureIdentifier(id);
                include.setFeatureVersion("0.0.0");
                this.sourceFeature.addIncludedFeatureReferenceModel((IncludedFeatureReferenceModel)include);
                continue;
            }
            StringTokenizer tokenizer = new StringTokenizer(this.extraPlugins[i].startsWith("plugin@") ? this.extraPlugins[i].substring(7) : this.extraPlugins[i].substring(8), ";");
            String bundleId = tokenizer.nextToken();
            boolean unpack = true;
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (!token.startsWith("unpack")) continue;
                unpack = token.toLowerCase().indexOf("true") > -1;
                break;
            }
            if ((model = this.getSite(false).getRegistry().getResolvedBundle(bundleId)) == null) {
                String message = NLS.bind((String)Messages.exception_missingPlugin, (Object)this.extraPlugins[i]);
                BundleHelper.getDefault().getLog().log((IStatus)new Status(2, this.extraPlugins[i], 5, message, null));
                continue;
            }
            PluginEntry entry = new PluginEntry();
            entry.setPluginIdentifier(model.getSymbolicName());
            entry.setPluginVersion(model.getVersion().toString());
            entry.setUnpack(unpack);
            this.sourceFeature.addPluginEntryModel((PluginEntryModel)entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PluginEntry create30SourcePlugin() throws CoreException {
        PDEState state;
        BundleDescription oldBundle;
        File buildProperty;
        StringBuffer buffer;
        PluginEntry result = new PluginEntry();
        String sourcePluginId = this.sourceFeature.getFeatureIdentifier();
        result.setPluginIdentifier(sourcePluginId);
        result.setPluginVersion(this.sourceFeature.getFeatureVersion());
        this.sourceFeature.addPluginEntryModel((PluginEntryModel)result);
        Path sourcePluginDirURL = new Path(workingDirectory + '/' + "plugins" + '/' + this.getSourcePluginName(result, false));
        File sourcePluginDir = sourcePluginDirURL.toFile();
        new File(sourcePluginDir, "META-INF").mkdirs();
        Path templateManifest = new Path("data/30/plugin/META-INF/MANIFEST.MF");
        URL templateManifestURL = BundleHelper.getDefault().find((IPath)templateManifest);
        if (templateManifestURL == null) {
            Status status = new Status(2, "org.eclipse.pde.build", 10, NLS.bind((String)Messages.error_readingDirectory, (Object)templateManifest), null);
            BundleHelper.getDefault().getLog().log((IStatus)status);
            return null;
        }
        try {
            buffer = this.readFile(templateManifestURL.openStream());
        }
        catch (IOException e1) {
            String message = NLS.bind((String)Messages.exception_readingFile, (Object)templateManifestURL.toExternalForm());
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 10, message, (Throwable)e1));
        }
        int beginId = this.scan(buffer, 0, "PLUGIN_ID");
        buffer.replace(beginId, beginId + "PLUGIN_ID".length(), result.getPluginIdentifier());
        beginId = this.scan(buffer, beginId, "PLUGIN_VERSION");
        buffer.replace(beginId, beginId + "PLUGIN_VERSION".length(), result.getPluginVersion());
        try {
            Utils.transferStreams(new ByteArrayInputStream(buffer.toString().getBytes()), new FileOutputStream(sourcePluginDirURL.append("META-INF/MANIFEST.MF").toOSString()));
        }
        catch (IOException e1) {
            String message = NLS.bind((String)Messages.exception_writingFile, (Object)templateManifestURL.toExternalForm());
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 10, message, (Throwable)e1));
        }
        try {
            InputStream pluginXML = BundleHelper.getDefault().getBundle().getEntry("data/30/plugin/plugin.xml").openStream();
            Utils.transferStreams(pluginXML, new FileOutputStream(sourcePluginDirURL.append("plugin.xml").toOSString()));
        }
        catch (IOException e1) {
            String message = NLS.bind((String)Messages.exception_readingFile, (Object)"data/30/plugin/plugin.xml");
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 12, message, (Throwable)e1));
        }
        Collection copiedFiles = Utils.copyFiles(this.featureRootLocation + '/' + "sourceTemplatePlugin", sourcePluginDir.getAbsolutePath());
        if (copiedFiles.contains("META-INF/MANIFEST.MF")) {
            this.replaceManifestValue(sourcePluginDirURL.append("META-INF/MANIFEST.MF").toOSString(), "Bundle-Version", result.getPluginVersion());
        }
        if (!(buildProperty = sourcePluginDirURL.append("build.properties").toFile()).exists()) {
            copiedFiles.add("plugin.xml");
            copiedFiles.add("src/**/*.zip");
            copiedFiles.add("META-INF/MANIFEST.MF");
            Properties sourceBuildProperties = new Properties();
            sourceBuildProperties.put("bin.includes", Utils.getStringFromCollection(copiedFiles, ","));
            sourceBuildProperties.put("sourcePlugin", "true");
            try {
                BufferedOutputStream buildFile = new BufferedOutputStream(new FileOutputStream(buildProperty));
                try {
                    sourceBuildProperties.store(buildFile, null);
                }
                finally {
                    ((OutputStream)buildFile).close();
                }
            }
            catch (FileNotFoundException e) {
                String message = NLS.bind((String)Messages.exception_writingFile, (Object)buildProperty.getAbsolutePath());
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 12, message, (Throwable)e));
            }
            catch (IOException e) {
                String message = NLS.bind((String)Messages.exception_writingFile, (Object)buildProperty.getAbsolutePath());
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 12, message, (Throwable)e));
            }
        }
        if ((oldBundle = (state = this.getSite(false).getRegistry()).getResolvedBundle(result.getPluginIdentifier())) != null) {
            state.getState().removeBundle(oldBundle);
        }
        state.addBundle(sourcePluginDir);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PluginEntry createSourcePlugin() throws CoreException {
        PDEState state;
        BundleDescription oldBundle;
        File buildProperty;
        StringBuffer buffer;
        PluginEntry result = new PluginEntry();
        String sourcePluginId = this.sourceFeature.getFeatureIdentifier();
        result.setPluginIdentifier(sourcePluginId);
        result.setPluginVersion(this.sourceFeature.getFeatureVersion());
        this.sourceFeature.addPluginEntryModel((PluginEntryModel)result);
        Path sourcePluginDirURL = new Path(workingDirectory + '/' + "plugins" + '/' + this.getSourcePluginName(result, false));
        File sourcePluginDir = sourcePluginDirURL.toFile();
        sourcePluginDir.mkdirs();
        Path templatePluginXML = new Path("data/21/plugin/plugin.xml");
        URL templatePluginURL = BundleHelper.getDefault().find((IPath)templatePluginXML);
        if (templatePluginURL == null) {
            Status status = new Status(2, "org.eclipse.pde.build", 10, NLS.bind((String)Messages.error_readingDirectory, (Object)templatePluginXML), null);
            BundleHelper.getDefault().getLog().log((IStatus)status);
            return null;
        }
        try {
            buffer = this.readFile(templatePluginURL.openStream());
        }
        catch (IOException e1) {
            String message = NLS.bind((String)Messages.exception_readingFile, (Object)templatePluginURL.toExternalForm());
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 10, message, (Throwable)e1));
        }
        int beginId = this.scan(buffer, 0, "PLUGIN_ID");
        buffer.replace(beginId, beginId + "PLUGIN_ID".length(), result.getPluginIdentifier());
        beginId = this.scan(buffer, beginId, "PLUGIN_VERSION");
        buffer.replace(beginId, beginId + "PLUGIN_VERSION".length(), result.getPluginVersion());
        try {
            Utils.transferStreams(new ByteArrayInputStream(buffer.toString().getBytes()), new FileOutputStream(sourcePluginDirURL.append("plugin.xml").toOSString()));
        }
        catch (IOException e1) {
            String message = NLS.bind((String)Messages.exception_writingFile, (Object)templatePluginURL.toExternalForm());
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 10, message, (Throwable)e1));
        }
        Collection copiedFiles = Utils.copyFiles(this.featureRootLocation + '/' + "sourceTemplatePlugin", sourcePluginDir.getAbsolutePath());
        if (copiedFiles.contains("plugin.xml")) {
            this.replaceXMLAttribute(sourcePluginDirURL.append("plugin.xml").toOSString(), PLUGIN_START_TAG, VERSION, result.getPluginVersion());
        }
        if (!(buildProperty = sourcePluginDirURL.append("build.properties").toFile()).exists()) {
            copiedFiles.add("plugin.xml");
            copiedFiles.add("src/**/*.zip");
            Properties sourceBuildProperties = new Properties();
            sourceBuildProperties.put("bin.includes", Utils.getStringFromCollection(copiedFiles, ","));
            sourceBuildProperties.put("sourcePlugin", "true");
            try {
                BufferedOutputStream buildFile = new BufferedOutputStream(new FileOutputStream(buildProperty));
                try {
                    sourceBuildProperties.store(buildFile, null);
                }
                finally {
                    ((OutputStream)buildFile).close();
                }
            }
            catch (FileNotFoundException e) {
                String message = NLS.bind((String)Messages.exception_writingFile, (Object)buildProperty.getAbsolutePath());
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 12, message, (Throwable)e));
            }
            catch (IOException e) {
                String message = NLS.bind((String)Messages.exception_writingFile, (Object)buildProperty.getAbsolutePath());
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 12, message, (Throwable)e));
            }
        }
        if ((oldBundle = (state = this.getSite(false).getRegistry()).getResolvedBundle(result.getPluginIdentifier())) != null) {
            state.getState().removeBundle(oldBundle);
        }
        state.addBundle(sourcePluginDir);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void create30SourceFragment(PluginEntry fragment, PluginEntry plugin) throws CoreException {
        File sourceFragmentDir;
        block13: {
            Path sourceFragmentDirURL = new Path(workingDirectory + '/' + "plugins" + '/' + this.getSourcePluginName(fragment, false));
            sourceFragmentDir = new File(sourceFragmentDirURL.toOSString());
            new File(sourceFragmentDir, "META-INF").mkdirs();
            try {
                File buildProperty;
                Path fragmentPath = new Path("data/30/fragment/META-INF/MANIFEST.MF");
                URL templateLocation = BundleHelper.getDefault().find((IPath)fragmentPath);
                if (templateLocation == null) {
                    Status status = new Status(2, "org.eclipse.pde.build", 10, NLS.bind((String)Messages.error_readingDirectory, (Object)fragmentPath), null);
                    BundleHelper.getDefault().getLog().log((IStatus)status);
                    return;
                }
                try {
                    InputStream fragmentXML = BundleHelper.getDefault().getBundle().getEntry("data/30/fragment/fragment.xml").openStream();
                    Utils.transferStreams(fragmentXML, new FileOutputStream(sourceFragmentDirURL.append("fragment.xml").toOSString()));
                }
                catch (IOException e1) {
                    String message = NLS.bind((String)Messages.exception_readingFile, (Object)"data/30/fragment/fragment.xml");
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 12, message, (Throwable)e1));
                }
                StringBuffer buffer = this.readFile(templateLocation.openStream());
                int beginId = this.scan(buffer, 0, "FRAGMENT_ID");
                buffer.replace(beginId, beginId + "FRAGMENT_ID".length(), fragment.getPluginIdentifier());
                beginId = this.scan(buffer, beginId, "FRAGMENT_VERSION");
                buffer.replace(beginId, beginId + "FRAGMENT_VERSION".length(), fragment.getPluginVersion());
                beginId = this.scan(buffer, beginId, "PLUGIN_ID");
                buffer.replace(beginId, beginId + "PLUGIN_ID".length(), plugin.getPluginIdentifier());
                BundleDescription effectivePlugin = this.getSite(false).getRegistry().getResolvedBundle(plugin.getVersionedIdentifier().getIdentifier(), plugin.getPluginVersion());
                beginId = this.scan(buffer, beginId, "PLUGIN_VERSION");
                buffer.replace(beginId, beginId + "PLUGIN_VERSION".length(), effectivePlugin.getVersion().toString());
                Utils.transferStreams(new ByteArrayInputStream(buffer.toString().getBytes()), new FileOutputStream(sourceFragmentDirURL.append("META-INF/MANIFEST.MF").toOSString()));
                Collection copiedFiles = Utils.copyFiles(this.featureRootLocation + '/' + "sourceTemplateFragment", sourceFragmentDir.getAbsolutePath());
                if (copiedFiles.contains("META-INF/MANIFEST.MF")) {
                    this.replaceManifestValue(sourceFragmentDirURL.append("META-INF/MANIFEST.MF").toOSString(), "Bundle-Version", fragment.getPluginVersion());
                    String host = plugin.getPluginIdentifier() + ';' + "Bundle-Version" + '=' + effectivePlugin.getVersion().toString();
                    this.replaceManifestValue(sourceFragmentDirURL.append("META-INF/MANIFEST.MF").toOSString(), "Fragment-Host", host);
                }
                if ((buildProperty = sourceFragmentDirURL.append("build.properties").toFile()).exists()) break block13;
                copiedFiles.add("fragment.xml");
                copiedFiles.add("src/**");
                copiedFiles.add("META-INF/MANIFEST.MF");
                Properties sourceBuildProperties = new Properties();
                sourceBuildProperties.put("bin.includes", Utils.getStringFromCollection(copiedFiles, ","));
                sourceBuildProperties.put("sourcePlugin", "true");
                try {
                    BufferedOutputStream buildFile = new BufferedOutputStream(new FileOutputStream(buildProperty));
                    try {
                        sourceBuildProperties.store(buildFile, null);
                    }
                    finally {
                        ((OutputStream)buildFile).close();
                    }
                }
                catch (FileNotFoundException e) {
                    String message = NLS.bind((String)Messages.exception_writingFile, (Object)buildProperty.getAbsolutePath());
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 12, message, (Throwable)e));
                }
                catch (IOException e) {
                    String message = NLS.bind((String)Messages.exception_writingFile, (Object)buildProperty.getAbsolutePath());
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 12, message, (Throwable)e));
                }
            }
            catch (IOException e) {
                String message = NLS.bind((String)Messages.exception_writingFile, (Object)sourceFragmentDir.getName());
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 12, message, null));
            }
        }
        PDEState state = this.getSite(false).getRegistry();
        BundleDescription oldBundle = state.getResolvedBundle(fragment.getPluginIdentifier());
        if (oldBundle != null) {
            state.getState().removeBundle(oldBundle);
        }
        state.addBundle(sourceFragmentDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSourceFragment(PluginEntry fragment, PluginEntry plugin) throws CoreException {
        File sourceFragmentDir;
        block11: {
            Path sourceFragmentDirURL = new Path(workingDirectory + '/' + "plugins" + '/' + this.getSourcePluginName(fragment, false));
            sourceFragmentDir = new File(sourceFragmentDirURL.toOSString());
            sourceFragmentDir.mkdirs();
            try {
                File buildProperty;
                Path fragmentPath = new Path("data/21/fragment/fragment.xml");
                URL templateLocation = BundleHelper.getDefault().find((IPath)fragmentPath);
                if (templateLocation == null) {
                    Status status = new Status(2, "org.eclipse.pde.build", 10, NLS.bind((String)Messages.error_readingDirectory, (Object)fragmentPath), null);
                    BundleHelper.getDefault().getLog().log((IStatus)status);
                    return;
                }
                StringBuffer buffer = this.readFile(templateLocation.openStream());
                int beginId = this.scan(buffer, 0, "FRAGMENT_ID");
                buffer.replace(beginId, beginId + "FRAGMENT_ID".length(), fragment.getPluginIdentifier());
                beginId = this.scan(buffer, beginId, "FRAGMENT_VERSION");
                buffer.replace(beginId, beginId + "FRAGMENT_VERSION".length(), fragment.getPluginVersion());
                beginId = this.scan(buffer, beginId, "PLUGIN_ID");
                buffer.replace(beginId, beginId + "PLUGIN_ID".length(), plugin.getPluginIdentifier());
                beginId = this.scan(buffer, beginId, "PLUGIN_VERSION");
                buffer.replace(beginId, beginId + "PLUGIN_VERSION".length(), plugin.getPluginVersion());
                Utils.transferStreams(new ByteArrayInputStream(buffer.toString().getBytes()), new FileOutputStream(sourceFragmentDirURL.append("fragment.xml").toOSString()));
                Collection copiedFiles = Utils.copyFiles(this.featureRootLocation + '/' + "sourceTemplateFragment", sourceFragmentDir.getAbsolutePath());
                if (copiedFiles.contains("fragment.xml")) {
                    this.replaceXMLAttribute(sourceFragmentDirURL.append("fragment.xml").toOSString(), FRAGMENT_START_TAG, VERSION, fragment.getPluginVersion());
                    this.replaceXMLAttribute(sourceFragmentDirURL.append("fragment.xml").toOSString(), FRAGMENT_START_TAG, PLUGIN_VERSION, plugin.getPluginVersion());
                }
                if ((buildProperty = sourceFragmentDirURL.append("build.properties").toFile()).exists()) break block11;
                copiedFiles.add("fragment.xml");
                copiedFiles.add("src/**");
                Properties sourceBuildProperties = new Properties();
                sourceBuildProperties.put("bin.includes", Utils.getStringFromCollection(copiedFiles, ","));
                sourceBuildProperties.put("sourcePlugin", "true");
                try {
                    BufferedOutputStream buildFile = new BufferedOutputStream(new FileOutputStream(buildProperty));
                    try {
                        sourceBuildProperties.store(buildFile, null);
                    }
                    finally {
                        ((OutputStream)buildFile).close();
                    }
                }
                catch (FileNotFoundException e) {
                    String message = NLS.bind((String)Messages.exception_writingFile, (Object)buildProperty.getAbsolutePath());
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 12, message, (Throwable)e));
                }
                catch (IOException e) {
                    String message = NLS.bind((String)Messages.exception_writingFile, (Object)buildProperty.getAbsolutePath());
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 12, message, (Throwable)e));
                }
            }
            catch (IOException e) {
                String message = NLS.bind((String)Messages.exception_writingFile, (Object)sourceFragmentDir.getName());
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 12, message, null));
            }
        }
        PDEState state = this.getSite(false).getRegistry();
        BundleDescription oldBundle = state.getResolvedBundle(fragment.getPluginIdentifier());
        if (oldBundle != null) {
            state.getState().removeBundle(oldBundle);
        }
        state.addBundle(sourceFragmentDir);
    }

    public String getSourcePluginName(PluginEntry plugin, boolean versionSuffix) {
        return plugin.getPluginIdentifier() + (versionSuffix ? "_" + plugin.getPluginVersion() : "");
    }

    public void setFeatureRootLocation(String featureLocation) {
        this.featureRootLocation = featureLocation;
    }

    public void setSourceToGather(SourceFeatureInformation sourceToGather) {
        this.sourceToGather = sourceToGather;
    }

    public void setSourceFeatureGeneration(boolean sourceFeatureGeneration) {
        this.sourceFeatureGeneration = sourceFeatureGeneration;
    }

    public void setBinaryFeatureGeneration(boolean binaryFeatureGeneration) {
        this.binaryFeature = binaryFeatureGeneration;
    }

    public void setScriptGeneration(boolean scriptGeneration) {
        this.scriptGeneration = scriptGeneration;
    }

    public boolean isSourceFeatureGeneration() {
        return this.sourceFeatureGeneration;
    }

    public void setGenerateJnlp(boolean value) {
        this.generateJnlp = value;
    }

    public void setSignJars(boolean value) {
        this.signJars = value;
    }

    public void setGenerateVersionSuffix(boolean value) {
        this.generateVersionSuffix = value;
    }

    public void setProduct(String product) {
        this.product = product;
    }

    protected void collectElementToAssemble(IPluginEntry entryToCollect) throws CoreException {
        if (this.assemblyData == null) {
            return;
        }
        List correctConfigs = this.selectConfigs((IPlatformEnvironment)entryToCollect);
        String versionRequested = entryToCollect.getVersionedIdentifier().getVersion().toString();
        BundleDescription effectivePlugin = null;
        effectivePlugin = this.getSite(false).getRegistry().getResolvedBundle(entryToCollect.getVersionedIdentifier().getIdentifier(), versionRequested);
        Iterator iter = correctConfigs.iterator();
        while (iter.hasNext()) {
            this.assemblyData.addPlugin((Config)iter.next(), effectivePlugin);
        }
    }

    private Feature createSourceFeature(Feature featureExample) throws CoreException {
        BuildTimeFeature result = new BuildTimeFeature();
        result.setFeatureIdentifier(this.computeSourceFeatureName((IFeature)featureExample, false));
        result.setFeatureVersion(featureExample.getVersionedIdentifier().getVersion().toString());
        result.setLabel(featureExample.getLabelNonLocalized());
        result.setProvider(featureExample.getProviderNonLocalized());
        result.setImageURLString(featureExample.getImageURLString());
        result.setInstallHandlerModel(featureExample.getInstallHandlerModel());
        result.setDescriptionModel(featureExample.getDescriptionModel());
        result.setCopyrightModel(featureExample.getCopyrightModel());
        result.setLicenseModel(featureExample.getLicenseModel());
        result.setUpdateSiteEntryModel(featureExample.getUpdateSiteEntryModel());
        URLEntryModel[] siteEntries = featureExample.getDiscoverySiteEntryModels();
        result.setDiscoverySiteEntryModels(siteEntries == null || siteEntries.length == 0 ? null : siteEntries);
        result.setOS(featureExample.getOS());
        result.setArch(featureExample.getOSArch());
        result.setWS(featureExample.getWS());
        int contextLength = featureExample instanceof BuildTimeFeature ? ((BuildTimeFeature)featureExample).getContextQualifierLength() : -1;
        result.setContextQualifierLength(contextLength);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSourceFeature() throws CoreException {
        File buildProperty;
        String sourceFeatureDir = workingDirectory + '/' + "features" + '/' + this.sourceFeatureFullName;
        File sourceDir = new File(sourceFeatureDir);
        sourceDir.mkdirs();
        File file = new File(sourceFeatureDir + '/' + "feature.xml");
        try {
            SourceFeatureWriter writer = new SourceFeatureWriter((OutputStream)new FileOutputStream(file), this.sourceFeature, this);
            try {
                writer.printFeature();
            }
            finally {
                writer.close();
            }
        }
        catch (IOException e) {
            String message = NLS.bind((String)Messages.error_creatingFeature, (Object)this.sourceFeature.getFeatureIdentifier());
            throw new CoreException((IStatus)new Status(0, "org.eclipse.pde.build", 12, message, (Throwable)e));
        }
        Collection copiedFiles = Utils.copyFiles(this.featureRootLocation + '/' + "sourceTemplateFeature", sourceFeatureDir);
        if (copiedFiles.contains("feature.xml")) {
            this.replaceXMLAttribute(sourceFeatureDir + '/' + "feature.xml", FEATURE_START_TAG, VERSION, this.sourceFeature.getFeatureVersion());
        }
        if ((buildProperty = new File(sourceFeatureDir + '/' + "build.properties")).exists()) {
            this.getSite(false).addFeatureReferenceModel(sourceDir);
            return;
        }
        copiedFiles.add("feature.xml");
        Properties sourceBuildProperties = new Properties();
        sourceBuildProperties.put("bin.includes", Utils.getStringFromCollection(copiedFiles, ","));
        FileOutputStream output = null;
        try {
            output = new FileOutputStream(buildProperty);
            try {
                sourceBuildProperties.store(output, null);
            }
            finally {
                ((OutputStream)output).close();
            }
        }
        catch (FileNotFoundException e) {
            String message = NLS.bind((String)Messages.exception_writingFile, (Object)buildProperty.getAbsolutePath());
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 12, message, (Throwable)e));
        }
        catch (IOException e) {
            String message = NLS.bind((String)Messages.exception_writingFile, (Object)buildProperty.getAbsolutePath());
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 12, message, (Throwable)e));
        }
        this.getSite(false).addFeatureReferenceModel(sourceDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceManifestValue(String location, String attribute, String newVersion) {
        Manifest manifest = null;
        try {
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(location));
            try {
                manifest = new Manifest(is);
            }
            finally {
                ((InputStream)is).close();
            }
        }
        catch (IOException e) {
            return;
        }
        manifest.getMainAttributes().put(new Attributes.Name(attribute), newVersion);
        BufferedOutputStream os = null;
        try {
            os = new BufferedOutputStream(new FileOutputStream(location));
            try {
                manifest.write(os);
            }
            finally {
                ((OutputStream)os).close();
            }
        }
        catch (IOException e1) {
            // empty catch block
        }
    }

    private void replaceXMLAttribute(String location, String tag, String attr, String newValue) {
        File featureFile = new File(location);
        if (!featureFile.exists()) {
            return;
        }
        StringBuffer buffer = null;
        try {
            buffer = this.readFile(featureFile);
        }
        catch (IOException e) {
            return;
        }
        int startComment = this.scan(buffer, 0, COMMENT_START_TAG);
        int endComment = startComment > -1 ? this.scan(buffer, startComment, COMMENT_END_TAG) : -1;
        int startTag = this.scan(buffer, 0, tag);
        while (startComment != -1 && startTag > startComment && startTag < endComment) {
            startTag = this.scan(buffer, endComment, tag);
            startComment = this.scan(buffer, endComment, COMMENT_START_TAG);
            endComment = startComment > -1 ? this.scan(buffer, startComment, COMMENT_END_TAG) : -1;
        }
        if (startTag == -1) {
            return;
        }
        int endTag = this.scan(buffer, startTag, ">");
        boolean attrFound = false;
        while (!attrFound) {
            int endAttributeWord;
            int startAttributeWord = this.scan(buffer, startTag, attr);
            if (startAttributeWord == -1 || startAttributeWord > endTag) {
                return;
            }
            if (!Character.isWhitespace(buffer.charAt(startAttributeWord - 1))) {
                startTag = startAttributeWord + attr.length();
                continue;
            }
            for (endAttributeWord = startAttributeWord + attr.length(); Character.isWhitespace(buffer.charAt(endAttributeWord)) && endAttributeWord < endTag; ++endAttributeWord) {
            }
            if (endAttributeWord > endTag) {
                return;
            }
            if (buffer.charAt(endAttributeWord) != '=') {
                startTag = endAttributeWord;
                continue;
            }
            int startVersionId = this.scan(buffer, startAttributeWord + 1, "\"");
            int endVersionId = this.scan(buffer, startVersionId + 1, "\"");
            buffer.replace(startVersionId + 1, endVersionId, newValue);
            attrFound = true;
        }
        if (attrFound) {
            try {
                Utils.transferStreams(new ByteArrayInputStream(buffer.toString().getBytes()), new FileOutputStream(featureFile));
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }
}

