/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build.packager;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.build.AssembleConfigScriptGenerator;
import org.eclipse.pde.internal.build.Config;
import org.eclipse.pde.internal.build.Messages;
import org.eclipse.pde.internal.build.Utils;
import org.eclipse.pde.internal.build.ant.FileSet;
import org.eclipse.pde.internal.build.builder.FeatureBuildScriptGenerator;
import org.eclipse.pde.internal.build.builder.ModelBuildScriptGenerator;
import org.eclipse.pde.internal.build.site.BuildTimeSiteContentProvider;

public class PackageConfigScriptGenerator
extends AssembleConfigScriptGenerator {
    private Properties packagingProperties;

    protected void generateGatherBinPartsCalls() {
        String location;
        int i;
        String excludedFiles = "build.properties, .project, .classpath";
        Path baseLocation = null;
        try {
            String url = ((BuildTimeSiteContentProvider)this.getSite(false).getSiteContentProvider()).getInstalledBaseURL();
            if (url != null) {
                baseLocation = new Path(url);
            }
        }
        catch (CoreException e) {
            // empty catch block
        }
        for (i = 0; i < this.plugins.length; ++i) {
            Path pluginLocation = new Path(this.plugins[i].getLocation());
            location = pluginLocation.toOSString();
            boolean isFolder = this.isFolder(pluginLocation);
            if (baseLocation != null && baseLocation.isPrefixOf((IPath)pluginLocation)) {
                IPath relative = pluginLocation.removeFirstSegments(baseLocation.segmentCount());
                location = new Path(Utils.getPropertyFormat("baseLocation")).append(relative).toOSString();
            }
            if (isFolder) {
                this.script.printCopyTask(null, Utils.getPropertyFormat("assemblyTempDir") + '/' + Utils.getPropertyFormat("pluginArchivePrefix") + '/' + ModelBuildScriptGenerator.getNormalizedName(this.plugins[i]), new FileSet[]{new FileSet(location, null, null, null, excludedFiles, null, null)}, false, false);
                continue;
            }
            this.script.printCopyFileTask(location, Utils.getPropertyFormat("assemblyTempDir") + '/' + Utils.getPropertyFormat("pluginArchivePrefix") + '/' + pluginLocation.lastSegment(), false);
        }
        for (i = 0; i < this.features.length; ++i) {
            Path featureLocation = new Path(this.features[i].getURL().getPath());
            featureLocation = featureLocation.removeLastSegments(1);
            location = featureLocation.toOSString();
            if (baseLocation != null && baseLocation.isPrefixOf((IPath)featureLocation)) {
                IPath relative = featureLocation.removeFirstSegments(baseLocation.segmentCount());
                location = new Path(Utils.getPropertyFormat("baseLocation")).append(relative).toOSString();
            }
            this.script.printCopyTask(null, Utils.getPropertyFormat("assemblyTempDir") + '/' + Utils.getPropertyFormat("featureArchivePrefix") + '/' + FeatureBuildScriptGenerator.getNormalizedName(this.features[i]), new FileSet[]{new FileSet(location, null, null, null, null, null, null)}, false, false);
        }
        if (this.packagingProperties.size() != 0) {
            String tmp;
            String filesToPackage = null;
            filesToPackage = this.packagingProperties.getProperty("root", null);
            if (filesToPackage != null) {
                filesToPackage = filesToPackage + ',';
            }
            if ((tmp = this.packagingProperties.getProperty("root." + this.configInfo.toString("."), null)) != null) {
                filesToPackage = filesToPackage + tmp;
            }
            if (filesToPackage == null) {
                filesToPackage = "**/**";
            }
            FileSet rootFiles = new FileSet(Utils.getPropertyFormat("tempDirectory") + '/' + this.configInfo.toStringReplacingAny(".", "ANY") + "/eclipse", null, filesToPackage, null, null, null, null);
            String target = Utils.getPropertyFormat("eclipse.base") + '/' + this.configInfo.toStringReplacingAny(".", "ANY") + '/' + Utils.getPropertyFormat("collectingFolder");
            this.script.printCopyTask(null, target, new FileSet[]{rootFiles}, false, false);
            Utils.generatePermissions(this.packagingProperties, this.configInfo, "eclipse.base", this.script);
            this.rootFileProviders = new ArrayList(1);
            this.rootFileProviders.add("elt");
        }
    }

    public String getTargetName() {
        return "package" + (this.featureId.equals("") ? "" : '.' + this.featureId) + (this.configInfo.equals(Config.genericConfig()) ? "" : '.' + this.configInfo.toStringReplacingAny(".", "ANY"));
    }

    private boolean isFolder(Path pluginLocation) {
        return pluginLocation.toFile().isDirectory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPackagingPropertiesLocation(String packagingPropertiesLocation) throws CoreException {
        this.packagingProperties = new Properties();
        if (packagingPropertiesLocation == null || packagingPropertiesLocation.equals("")) {
            return;
        }
        BufferedInputStream propertyStream = null;
        try {
            propertyStream = new BufferedInputStream(new FileInputStream(packagingPropertiesLocation));
            try {
                this.packagingProperties.load(new BufferedInputStream(propertyStream));
            }
            finally {
                ((InputStream)propertyStream).close();
            }
        }
        catch (FileNotFoundException e) {
            String message = NLS.bind((String)Messages.exception_readingFile, (Object)packagingPropertiesLocation);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 10, message, (Throwable)e));
        }
        catch (IOException e) {
            String message = NLS.bind((String)Messages.exception_readingFile, (Object)packagingPropertiesLocation);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 10, message, (Throwable)e));
        }
    }

    protected void generateGatherSourceCalls() {
    }

    protected FileSet[] generatePermissions(boolean zip) {
        return new FileSet[0];
    }

    protected void generateGZipTarget(boolean assembling) {
        super.generateGZipTarget(false);
    }

    public void generateTarGZTasks(boolean assembling) {
        super.generateTarGZTasks(false);
    }
}

