/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build.site;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.build.AbstractScriptGenerator;
import org.eclipse.pde.internal.build.BundleHelper;
import org.eclipse.pde.internal.build.IBuildPropertiesConstants;
import org.eclipse.pde.internal.build.IPDEBuildConstants;
import org.eclipse.pde.internal.build.Messages;
import org.eclipse.pde.internal.build.site.BuildTimeFeature;
import org.eclipse.pde.internal.build.site.BuildTimeSite;
import org.eclipse.pde.internal.build.site.QualifierReplacer;
import org.eclipse.update.core.BaseFeatureFactory;
import org.eclipse.update.core.Feature;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureContentProvider;
import org.eclipse.update.core.IFeatureFactory;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.model.FeatureModel;
import org.eclipse.update.internal.core.FeatureExecutableContentProvider;
import org.eclipse.update.internal.core.URLEncoder;

public class BuildTimeFeatureFactory
extends BaseFeatureFactory
implements IFeatureFactory,
IPDEBuildConstants,
IBuildPropertiesConstants {
    public static final String BUILDTIME_FEATURE_FACTORY_ID = "org.eclipse.pde.build.BuildTimeFeatureFactory";

    public IFeature createFeature(URL url, ISite site, IProgressMonitor p) throws CoreException {
        Feature feature = null;
        InputStream featureStream = null;
        if (url == null) {
            return this.createFeature(site);
        }
        try {
            FeatureExecutableContentProvider contentProvider = new FeatureExecutableContentProvider(url);
            URL nonResolvedURL = contentProvider.getFeatureManifestReference(null).asURL();
            URL resolvedURL = URLEncoder.encode((URL)nonResolvedURL);
            featureStream = resolvedURL.openStream();
            feature = (Feature)this.parseFeature(featureStream);
            String qualifier = AbstractScriptGenerator.readProperties(new Path(url.getFile()).removeLastSegments(1).toOSString(), "build.properties", 0).getProperty("qualifier");
            String newVersion = QualifierReplacer.replaceQualifierInVersion(feature.getFeatureVersion(), feature.getFeatureIdentifier(), qualifier, ((BuildTimeSite)site).getFeatureVersions());
            if (newVersion != null) {
                if (feature.getFeatureVersion().endsWith(".qualifier") && (qualifier == null || qualifier.equalsIgnoreCase("context"))) {
                    int idx = feature.getFeatureVersion().lastIndexOf(".qualifier");
                    ((BuildTimeFeature)feature).setContextQualifierLength(newVersion.length() - idx - 1);
                }
                ((BuildTimeFeature)feature).setFeatureVersion(newVersion);
            }
            feature.setSite(site);
            feature.setFeatureContentProvider((IFeatureContentProvider)contentProvider);
            feature.resolve(url, url);
        }
        catch (CoreException e) {
            String message = NLS.bind((String)Messages.error_creatingFeature, (Object)url);
            BundleHelper.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.pde.build", 17, message, (Throwable)e));
            throw e;
        }
        catch (Exception e) {
            String message = NLS.bind((String)Messages.exception_readingFile, (Object)url);
            Status status = new Status(4, "org.eclipse.pde.build", 1, message, (Throwable)e);
            BundleHelper.getDefault().getLog().log((IStatus)status);
            throw new CoreException((IStatus)status);
        }
        finally {
            try {
                if (featureStream != null) {
                    featureStream.close();
                }
            }
            catch (IOException e) {}
        }
        return feature;
    }

    private IFeature createFeature(ISite site) throws CoreException {
        Feature feature = null;
        FeatureExecutableContentProvider contentProvider = new FeatureExecutableContentProvider(null);
        feature = (Feature)this.createFeatureModel();
        feature.setSite(site);
        feature.setFeatureContentProvider((IFeatureContentProvider)contentProvider);
        return feature;
    }

    public FeatureModel createFeatureModel() {
        return new BuildTimeFeature();
    }
}

