/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build.site;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.ResolverError;
import org.eclipse.osgi.service.resolver.StateHelper;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.build.AbstractScriptGenerator;
import org.eclipse.pde.internal.build.BundleHelper;
import org.eclipse.pde.internal.build.Config;
import org.eclipse.pde.internal.build.IPDEBuildConstants;
import org.eclipse.pde.internal.build.IXMLConstants;
import org.eclipse.pde.internal.build.Messages;
import org.eclipse.pde.internal.build.site.BuildTimeSiteContentProvider;
import org.eclipse.pde.internal.build.site.PDEState;
import org.eclipse.pde.internal.build.site.PluginRegistryConverter;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.ISiteFeatureReference;
import org.eclipse.update.core.Site;
import org.eclipse.update.core.SiteFeatureReference;
import org.eclipse.update.core.SiteFeatureReferenceModel;
import org.eclipse.update.core.model.SiteModel;
import org.osgi.framework.Version;

public class BuildTimeSite
extends Site
implements ISite,
IPDEBuildConstants,
IXMLConstants {
    private PDEState state;
    private Properties repositoryVersions;
    private boolean reportResolutionErrors;

    public void setReportResolutionErrors(boolean value) {
        this.reportResolutionErrors = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getFeatureVersions() {
        if (this.repositoryVersions == null) {
            this.repositoryVersions = new Properties();
            try {
                BufferedInputStream input = new BufferedInputStream(new FileInputStream(AbstractScriptGenerator.getWorkingDirectory() + '/' + "featureVersions.properties"));
                try {
                    this.repositoryVersions.load(input);
                }
                finally {
                    ((InputStream)input).close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.repositoryVersions;
    }

    public PDEState getRegistry() throws CoreException {
        if (this.state == null) {
            BuildTimeSiteContentProvider contentProvider = (BuildTimeSiteContentProvider)this.getSiteContentProvider();
            if (contentProvider.getInitialState() != null) {
                this.state = new PDEState(contentProvider.getInitialState());
                return this.state;
            }
            this.state = AbstractScriptGenerator.isBuildingOSGi() ? new PDEState() : new PluginRegistryConverter();
            this.state.addBundles(contentProvider.getPluginPaths());
            this.state.resolveState();
            BundleDescription[] allBundles = this.state.getState().getBundles();
            BundleDescription[] resolvedBundles = this.state.getState().getResolvedBundles();
            if (allBundles.length == resolvedBundles.length) {
                return this.state;
            }
            if (this.reportResolutionErrors) {
                MultiStatus errors = new MultiStatus("org.eclipse.pde.build", 1, Messages.exception_registryResolution, null);
                BundleDescription[] all = this.state.getState().getBundles();
                StateHelper helper = Platform.getPlatformAdmin().getStateHelper();
                for (int i = 0; i < all.length; ++i) {
                    if (all[i].isResolved()) continue;
                    ResolverError[] resolutionErrors = this.state.getState().getResolverErrors(all[i]);
                    VersionConstraint[] versionErrors = helper.getUnsatisfiedConstraints(all[i]);
                    if (this.isConfigError(all[i], resolutionErrors, AbstractScriptGenerator.getConfigInfos())) continue;
                    String errorMessage = "Bundle " + all[i].getSymbolicName() + ":\n" + this.getResolutionErrorMessage(resolutionErrors);
                    for (int j = 0; j < versionErrors.length; ++j) {
                        errorMessage = errorMessage + '\t' + this.getResolutionFailureMessage(versionErrors[j]) + '\n';
                    }
                    errors.add((IStatus)new Status(2, "org.eclipse.pde.build", 2, errorMessage, null));
                }
                BundleHelper.getDefault().getLog().log((IStatus)errors);
            }
        }
        if (!this.state.getState().isResolved()) {
            this.state.state.resolve(true);
        }
        return this.state;
    }

    private boolean isConfigError(BundleDescription bundle, ResolverError[] errors, List configs) {
        Hashtable<String, String> environment = new Hashtable<String, String>(3);
        String filterSpec = bundle.getPlatformFilter();
        if (this.hasPlatformFilterError(errors) != null) {
            Iterator iter = configs.iterator();
            while (iter.hasNext()) {
                Config aConfig = (Config)iter.next();
                ((Dictionary)environment).put("osgi.os", aConfig.getOs());
                ((Dictionary)environment).put("osgi.ws", aConfig.getWs());
                ((Dictionary)environment).put("osgi.arch", aConfig.getArch());
                if (!BundleHelper.getDefault().createFilter(filterSpec).match(environment)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private ResolverError hasPlatformFilterError(ResolverError[] errors) {
        for (int i = 0; i < errors.length; ++i) {
            if ((errors[i].getType() & 0x2000) == 0) continue;
            return errors[i];
        }
        return null;
    }

    private String getResolutionErrorMessage(ResolverError[] errors) {
        String errorMessage = "";
        for (int i = 0; i < errors.length; ++i) {
            if ((errors[i].getType() & 0x4078) == 0) continue;
            errorMessage = errorMessage + '\t' + errors[i].toString() + '\n';
        }
        return errorMessage;
    }

    public String getResolutionFailureMessage(VersionConstraint unsatisfied) {
        if (unsatisfied.isResolved()) {
            throw new IllegalArgumentException();
        }
        if (unsatisfied instanceof ImportPackageSpecification) {
            return NLS.bind((String)Messages.unsatisfied_import, (Object)this.displayVersionConstraint(unsatisfied));
        }
        if (unsatisfied instanceof BundleSpecification) {
            if (((BundleSpecification)unsatisfied).isOptional()) {
                return NLS.bind((String)Messages.unsatisfied_optionalBundle, (Object)this.displayVersionConstraint(unsatisfied));
            }
            return NLS.bind((String)Messages.unsatisfied_required, (Object)this.displayVersionConstraint(unsatisfied));
        }
        return NLS.bind((String)Messages.unsatisfied_host, (Object)this.displayVersionConstraint(unsatisfied));
    }

    private String displayVersionConstraint(VersionConstraint constraint) {
        VersionRange versionSpec = constraint.getVersionRange();
        if (versionSpec == null) {
            return constraint.getName();
        }
        return constraint.getName() + '_' + versionSpec;
    }

    public IFeature findFeature(String featureId, String versionId, boolean throwsException) throws CoreException {
        ISiteFeatureReference[] features = this.getFeatureReferences();
        if ("0.0.0".equals(versionId)) {
            versionId = null;
        }
        for (int i = 0; i < features.length; ++i) {
            IFeature verifiedFeature;
            try {
                verifiedFeature = features[i].getFeature(null);
            }
            catch (CoreException e) {
                String message = NLS.bind((String)Messages.exception_featureParse, (Object)features[i].getURL());
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 1, message, null));
            }
            if (!verifiedFeature.getVersionedIdentifier().getIdentifier().equals(featureId) || versionId != null && !features[i].getVersionedIdentifier().getVersion().equals((Object)new PluginVersionIdentifier(versionId))) continue;
            return features[i].getFeature(null);
        }
        int qualifierIdx = -1;
        if (versionId != null && (qualifierIdx = versionId.indexOf(".qualifier")) != -1) {
            Version versionToMatch = Version.parseVersion((String)versionId.substring(0, qualifierIdx));
            for (int i = 0; i < features.length; ++i) {
                Version featureVersion = Version.parseVersion((String)features[i].getVersionedIdentifier().getVersion().toString());
                if (!features[i].getVersionedIdentifier().getIdentifier().equals(featureId) || featureVersion.getMajor() != versionToMatch.getMajor() || featureVersion.getMinor() != versionToMatch.getMinor() || featureVersion.getMicro() < versionToMatch.getMicro() || featureVersion.getQualifier().compareTo(versionToMatch.getQualifier()) < 0) continue;
                return features[i].getFeature(null);
            }
        }
        if (throwsException) {
            String message = NLS.bind((String)Messages.exception_missingFeature, (Object)featureId);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 1, message, null));
        }
        return null;
    }

    public void addFeatureReferenceModel(File featureXML) {
        if (featureXML.exists()) {
            try {
                URL featureURL = new URL("file:" + featureXML.getAbsolutePath() + '/');
                SiteFeatureReference featureRef = new SiteFeatureReference();
                featureRef.setSiteModel((SiteModel)this);
                featureRef.setURLString(featureURL.toExternalForm());
                featureRef.setType("org.eclipse.pde.build.BuildTimeFeatureFactory");
                this.addFeatureReferenceModel((SiteFeatureReferenceModel)featureRef);
            }
            catch (MalformedURLException e) {
                BundleHelper.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.pde.build", 20, NLS.bind((String)Messages.warning_cannotLocateSource, (Object)featureXML.getAbsolutePath()), (Throwable)e));
            }
        }
    }
}

