/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build.site;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.pde.internal.build.IPDEBuildConstants;
import org.eclipse.pde.internal.build.PDEUIStateWrapper;
import org.eclipse.pde.internal.build.site.PluginPathFinder;
import org.eclipse.update.core.ISiteContentProvider;
import org.eclipse.update.core.SiteContentProvider;

public class BuildTimeSiteContentProvider
extends SiteContentProvider
implements ISiteContentProvider,
IPDEBuildConstants {
    private String installedBaseURL;
    private String[] urls;
    private PDEUIStateWrapper pdeUIState;

    public BuildTimeSiteContentProvider(String[] urls, String installedBaseURL, PDEUIStateWrapper initialState) {
        super(null);
        this.installedBaseURL = installedBaseURL;
        this.urls = urls;
        this.pdeUIState = initialState;
    }

    public String getInstalledBaseURL() {
        return this.installedBaseURL;
    }

    public Collection getPluginPaths() {
        Collection pluginsToCompile = this.findPluginXML(this.urls);
        if (this.installedBaseURL != null) {
            pluginsToCompile.addAll(this.findPluginXML(PluginPathFinder.getPluginPaths(this.installedBaseURL)));
            pluginsToCompile.addAll(this.findPluginXML(new String[]{this.installedBaseURL}));
        }
        return pluginsToCompile;
    }

    public URL getURL() {
        throw new RuntimeException();
    }

    private Collection findPluginXML(String[] location) {
        ArrayList<File> collectedElements = new ArrayList<File>(10);
        for (int i = 0; i < location.length; ++i) {
            File f = new File(location[i], "plugins");
            if (f.exists()) {
                collectedElements.addAll(Arrays.asList(f.listFiles()));
                continue;
            }
            collectedElements.add(new File(location[i]));
        }
        return collectedElements;
    }

    public PDEUIStateWrapper getInitialState() {
        return this.pdeUIState;
    }
}

