/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build.site;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.pluginconversion.PluginConversionException;
import org.eclipse.osgi.service.pluginconversion.PluginConverter;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.build.AbstractScriptGenerator;
import org.eclipse.pde.internal.build.BundleHelper;
import org.eclipse.pde.internal.build.CatchAllValue;
import org.eclipse.pde.internal.build.Config;
import org.eclipse.pde.internal.build.IBuildPropertiesConstants;
import org.eclipse.pde.internal.build.IPDEBuildConstants;
import org.eclipse.pde.internal.build.Messages;
import org.eclipse.pde.internal.build.PDEUIStateWrapper;
import org.eclipse.pde.internal.build.site.QualifierReplacer;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

public class PDEState
implements IPDEBuildConstants,
IBuildPropertiesConstants {
    private static final String PROFILE_EXTENSION = ".profile";
    private static final String SYSTEM_PACKAGES = "org.osgi.framework.system.packages";
    private StateObjectFactory factory = Platform.getPlatformAdmin().getFactory();
    protected State state = this.factory.createState();
    private long id;
    private Properties repositoryVersions;
    private HashMap bundleClasspaths;
    private Map patchBundles;
    private List addedBundle;
    private List unqualifiedBundles;
    private String javaProfile;
    private String[] javaProfiles;
    static /* synthetic */ Class class$org$eclipse$osgi$service$pluginconversion$PluginConverter;

    protected long getNextId() {
        return ++this.id;
    }

    public PDEState(PDEUIStateWrapper initialState) {
        this();
        this.state = initialState.getState();
        this.factory = this.state.getFactory();
        this.id = initialState.getNextId();
        this.bundleClasspaths = initialState.getClasspaths();
        this.patchBundles = initialState.getPatchData();
        this.addedBundle = new ArrayList();
        this.unqualifiedBundles = new ArrayList();
        this.forceQualifiers();
    }

    public PDEState() {
        this.state.setResolver(Platform.getPlatformAdmin().getResolver());
        this.id = 0L;
        this.bundleClasspaths = new HashMap();
        this.patchBundles = new HashMap();
        this.loadPluginTagFile();
    }

    public StateObjectFactory getFactory() {
        return this.factory;
    }

    public void addBundleDescription(BundleDescription toAdd) {
        this.state.addBundle(toAdd);
    }

    private PluginConverter acquirePluginConverter() throws Exception {
        return (PluginConverter)BundleHelper.getDefault().acquireService((class$org$eclipse$osgi$service$pluginconversion$PluginConverter == null ? (class$org$eclipse$osgi$service$pluginconversion$PluginConverter = PDEState.class$("org.eclipse.osgi.service.pluginconversion.PluginConverter")) : class$org$eclipse$osgi$service$pluginconversion$PluginConverter).getName());
    }

    public boolean addBundle(Dictionary enhancedManifest, File bundleLocation) {
        this.updateVersionNumber(enhancedManifest);
        try {
            BundleDescription descriptor = this.factory.createBundleDescription(this.state, enhancedManifest, bundleLocation.getAbsolutePath(), this.getNextId());
            this.bundleClasspaths.put(new Long(descriptor.getBundleId()), this.getClasspath(enhancedManifest));
            String patchValue = this.fillPatchData(enhancedManifest);
            if (patchValue != null) {
                this.patchBundles.put(new Long(descriptor.getBundleId()), patchValue);
            }
            this.rememberQualifierTagPresence(descriptor);
            if (this.state.addBundle(descriptor) && this.addedBundle != null) {
                this.addedBundle.add(descriptor);
            }
        }
        catch (BundleException e) {
            Status status = new Status(2, "org.eclipse.pde.build", 15, NLS.bind((String)Messages.exception_stateAddition, enhancedManifest.get("Bundle-Name")), (Throwable)e);
            BundleHelper.getDefault().getLog().log((IStatus)status);
            return false;
        }
        return true;
    }

    private void rememberQualifierTagPresence(BundleDescription descriptor) {
        Properties bundleProperties = null;
        bundleProperties = (Properties)descriptor.getUserObject();
        if (bundleProperties == null) {
            bundleProperties = new Properties();
            descriptor.setUserObject((Object)bundleProperties);
        }
        bundleProperties.setProperty("qualifier", "marker");
    }

    private String[] getClasspath(Dictionary manifest) {
        String fullClasspath = (String)manifest.get("Bundle-ClassPath");
        String[] result = new String[]{};
        try {
            if (fullClasspath != null) {
                ManifestElement[] classpathEntries = ManifestElement.parseHeader((String)"Bundle-ClassPath", (String)fullClasspath);
                result = new String[classpathEntries.length];
                for (int i = 0; i < classpathEntries.length; ++i) {
                    result[i] = classpathEntries[i].getValue();
                }
            }
        }
        catch (BundleException e) {
            // empty catch block
        }
        return result;
    }

    private String fillPatchData(Dictionary manifest) {
        if (manifest.get("Eclipse-ExtensibleAPI") != null) {
            return "Eclipse-ExtensibleAPI: true";
        }
        if (manifest.get("Eclipse-PatchFragment") != null) {
            return "Eclipse-PatchFragment: true";
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPluginTagFile() {
        this.repositoryVersions = new Properties();
        try {
            BufferedInputStream input = new BufferedInputStream(new FileInputStream(AbstractScriptGenerator.getWorkingDirectory() + '/' + "pluginVersions.properties"));
            try {
                this.repositoryVersions.load(input);
            }
            finally {
                ((InputStream)input).close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean addBundle(File bundleLocation) {
        Dictionary manifest = this.loadManifest(bundleLocation);
        if (manifest == null) {
            return false;
        }
        try {
            this.hasQualifier(bundleLocation, manifest);
        }
        catch (BundleException bundleException) {
            // empty catch block
        }
        return this.addBundle(manifest, bundleLocation);
    }

    private void updateVersionNumber(Dictionary manifest) {
        String newVersion = null;
        try {
            String symbolicName = (String)manifest.get("Bundle-SymbolicName");
            if (symbolicName == null) {
                return;
            }
            symbolicName = ManifestElement.parseHeader((String)"Bundle-SymbolicName", (String)symbolicName)[0].getValue();
            newVersion = QualifierReplacer.replaceQualifierInVersion((String)manifest.get("Bundle-Version"), symbolicName, (String)manifest.get("qualifier"), this.repositoryVersions);
        }
        catch (BundleException bundleException) {
            // empty catch block
        }
        if (newVersion != null) {
            manifest.put("Bundle-Version", newVersion);
        }
    }

    private void hasQualifier(File bundleLocation, Dictionary manifest) throws BundleException {
        ManifestElement[] versionInfo = ManifestElement.parseHeader((String)"Bundle-Version", (String)((String)manifest.get("Bundle-Version")));
        if (versionInfo != null && versionInfo[0].getValue().endsWith("qualifier")) {
            manifest.put("qualifier", this.getQualifierPropery(bundleLocation.getAbsolutePath()));
        }
    }

    private String getQualifierPropery(String bundleLocation) {
        String qualifierInfo = null;
        try {
            qualifierInfo = AbstractScriptGenerator.readProperties(bundleLocation, "build.properties", 1).getProperty("qualifier");
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        if (qualifierInfo == null) {
            qualifierInfo = "context";
        }
        return qualifierInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dictionary basicLoadManifest(File bundleLocation) {
        InputStream manifestStream = null;
        ZipFile jarFile = null;
        try {
            if ("jar".equalsIgnoreCase(new Path(bundleLocation.getName()).getFileExtension()) && bundleLocation.isFile()) {
                jarFile = new ZipFile(bundleLocation, 1);
                ZipEntry manifestEntry = jarFile.getEntry("META-INF/MANIFEST.MF");
                if (manifestEntry != null) {
                    manifestStream = jarFile.getInputStream(manifestEntry);
                }
            } else {
                manifestStream = new FileInputStream(new File(bundleLocation, "META-INF/MANIFEST.MF"));
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        Dictionary manifest = null;
        if (manifestStream == null && (manifest = this.convertPluginManifest(bundleLocation, true)) == null) {
            return null;
        }
        if (manifestStream != null) {
            try {
                Manifest m = new Manifest(manifestStream);
                manifest = this.manifestToProperties(m.getMainAttributes());
            }
            catch (IOException ioe) {
                Dictionary dictionary = null;
                return dictionary;
            }
            finally {
                try {
                    manifestStream.close();
                }
                catch (IOException e1) {}
                try {
                    if (jarFile != null) {
                        jarFile.close();
                    }
                }
                catch (IOException e2) {}
            }
        }
        return manifest;
    }

    private void enforceSymbolicName(File bundleLocation, Dictionary initialManifest) {
        if (initialManifest.get("Bundle-SymbolicName") != null) {
            return;
        }
        Dictionary generatedManifest = this.convertPluginManifest(bundleLocation, false);
        if (generatedManifest == null) {
            return;
        }
        Enumeration enumeration = generatedManifest.keys();
        while (enumeration.hasMoreElements()) {
            Object key = enumeration.nextElement();
            if (initialManifest.get(key) != null) continue;
            initialManifest.put(key, generatedManifest.get(key));
        }
    }

    private void enforceClasspath(Dictionary manifest) {
        String classpath = (String)manifest.get("Bundle-ClassPath");
        if (classpath == null) {
            manifest.put("Bundle-ClassPath", ".");
        }
    }

    private Dictionary loadManifest(File bundleLocation) {
        Dictionary manifest = this.basicLoadManifest(bundleLocation);
        if (manifest == null) {
            return null;
        }
        this.enforceSymbolicName(bundleLocation, manifest);
        this.enforceClasspath(manifest);
        return manifest;
    }

    private Dictionary convertPluginManifest(File bundleLocation, boolean logConversionException) {
        try {
            PluginConverter converter = this.acquirePluginConverter();
            return converter.convertManifest(bundleLocation, false, AbstractScriptGenerator.isBuildingOSGi() ? null : "2.1", false, null);
        }
        catch (PluginConversionException convertException) {
            if (bundleLocation.getName().equals("feature.xml")) {
                return null;
            }
            if (logConversionException) {
                Status status = new Status(2, "org.eclipse.pde.build", 0, NLS.bind((String)Messages.exception_errorConverting, (Object)bundleLocation.getAbsolutePath()), (Throwable)convertException);
                BundleHelper.getDefault().getLog().log((IStatus)status);
            }
            return null;
        }
        catch (Exception serviceException) {
            Status status = new Status(2, "org.eclipse.pde.build", 0, NLS.bind((String)Messages.exception_cannotAcquireService, (Object)"Plugin converter"), (Throwable)serviceException);
            BundleHelper.getDefault().getLog().log((IStatus)status);
            return null;
        }
    }

    private Properties manifestToProperties(Attributes d) {
        Iterator<Object> iter = d.keySet().iterator();
        Properties result = new Properties();
        while (iter.hasNext()) {
            Attributes.Name key = (Attributes.Name)iter.next();
            result.put(key.toString(), d.get(key));
        }
        return result;
    }

    public void addBundles(Collection bundles) {
        Iterator iter = bundles.iterator();
        while (iter.hasNext()) {
            File bundle = (File)iter.next();
            this.addBundle(bundle);
        }
    }

    public void resolveState() {
        Properties profileProps;
        List configs = AbstractScriptGenerator.getConfigInfos();
        String[] os = new String[configs.size()];
        String[] ws = new String[configs.size()];
        String[] archs = new String[configs.size()];
        int i = 0;
        Iterator iter = configs.iterator();
        while (iter.hasNext()) {
            Config aConfig = (Config)iter.next();
            os[i] = aConfig.getOs();
            ws[i] = aConfig.getWs();
            archs[i] = aConfig.getArch();
            ++i;
        }
        Hashtable<String, Object> properties = new Hashtable<String, Object>(3);
        if (ws.length == 1 && Config.ANY.equalsIgnoreCase(ws[0])) {
            properties.put("osgi.ws", CatchAllValue.singleton);
        } else {
            properties.put("osgi.ws", ws);
        }
        if (os.length == 1 && Config.ANY.equalsIgnoreCase(os[0])) {
            properties.put("osgi.os", CatchAllValue.singleton);
        } else {
            properties.put("osgi.os", os);
        }
        if (archs.length == 1 && Config.ANY.equalsIgnoreCase(archs[0])) {
            properties.put("osgi.arch", CatchAllValue.singleton);
        } else {
            properties.put("osgi.arch", archs);
        }
        if (this.javaProfile == null) {
            this.javaProfile = this.getDefaultJavaProfile();
        }
        if ((profileProps = this.getJavaProfileProperties()) != null) {
            String ee;
            String systemPackages = profileProps.getProperty(SYSTEM_PACKAGES);
            if (systemPackages != null) {
                properties.put(SYSTEM_PACKAGES, systemPackages);
            }
            if ((ee = profileProps.getProperty("org.osgi.framework.executionenvironment")) != null) {
                properties.put("org.osgi.framework.executionenvironment", ee);
            }
        }
        this.state.setPlatformProperties(properties);
        this.state.resolve(false);
    }

    private String getDefaultJavaProfile() {
        if (this.javaProfiles == null) {
            this.setJavaProfiles(this.getOSGiLocation());
        }
        if (this.javaProfiles != null && this.javaProfiles.length > 0) {
            return this.javaProfiles[0];
        }
        return null;
    }

    public State getState() {
        return this.state;
    }

    public BundleDescription[] getDependentBundles(String bundleId, Version version) {
        BundleDescription root = this.state.getBundle(bundleId, version);
        return PDEState.getDependentBundles(root);
    }

    public static BundleDescription[] getImportedBundles(BundleDescription root) {
        if (root == null) {
            return new BundleDescription[0];
        }
        ExportPackageDescription[] packages = root.getResolvedImports();
        ArrayList<BundleDescription> resolvedImports = new ArrayList<BundleDescription>(packages.length);
        for (int i = 0; i < packages.length; ++i) {
            if (root.getLocation().equals(packages[i].getExporter().getLocation()) || resolvedImports.contains(packages[i].getExporter())) continue;
            resolvedImports.add(packages[i].getExporter());
        }
        return resolvedImports.toArray(new BundleDescription[resolvedImports.size()]);
    }

    public static BundleDescription[] getRequiredBundles(BundleDescription root) {
        if (root == null) {
            return new BundleDescription[0];
        }
        return root.getResolvedRequires();
    }

    public BundleDescription getResolvedBundle(String bundleId, String version) {
        if ("0.0.0".equals(version) || version == null) {
            return this.getResolvedBundle(bundleId);
        }
        BundleDescription description = this.getState().getBundle(bundleId, Version.parseVersion((String)version));
        if (description != null && description.isResolved()) {
            return description;
        }
        int qualifierIdx = -1;
        qualifierIdx = version.indexOf(".qualifier");
        if (qualifierIdx != -1) {
            BundleDescription[] bundles = this.getState().getBundles(bundleId);
            Version versionToMatch = Version.parseVersion((String)version.substring(0, qualifierIdx));
            for (int i = 0; i < bundles.length; ++i) {
                Version bundleVersion = bundles[i].getVersion();
                if (bundleVersion.getMajor() != versionToMatch.getMajor() || bundleVersion.getMinor() != versionToMatch.getMinor() || bundleVersion.getMicro() < versionToMatch.getMicro() || bundleVersion.getQualifier().compareTo(versionToMatch.getQualifier()) < 0) continue;
                return bundles[i];
            }
        }
        return null;
    }

    public BundleDescription getResolvedBundle(String bundleId) {
        BundleDescription[] description = this.getState().getBundles(bundleId);
        if (description == null) {
            return null;
        }
        for (int i = 0; i < description.length; ++i) {
            if (!description[i].isResolved()) continue;
            return description[i];
        }
        return null;
    }

    public static BundleDescription[] getDependentBundles(BundleDescription root) {
        BundleDescription[] imported = PDEState.getImportedBundles(root);
        BundleDescription[] required = PDEState.getRequiredBundles(root);
        BundleDescription[] dependents = new BundleDescription[imported.length + required.length];
        System.arraycopy(imported, 0, dependents, 0, imported.length);
        System.arraycopy(required, 0, dependents, imported.length, required.length);
        return dependents;
    }

    public static BundleDescription[] getDependentBundlesWithFragments(BundleDescription root) {
        BundleDescription[] imported = PDEState.getImportedBundles(root);
        BundleDescription[] importedByFragments = PDEState.getImportedByFragments(root);
        BundleDescription[] required = PDEState.getRequiredBundles(root);
        BundleDescription[] requiredByFragments = PDEState.getRequiredByFragments(root);
        BundleDescription[] dependents = new BundleDescription[imported.length + importedByFragments.length + required.length + requiredByFragments.length];
        System.arraycopy(imported, 0, dependents, 0, imported.length);
        System.arraycopy(importedByFragments, 0, dependents, imported.length, importedByFragments.length);
        System.arraycopy(required, 0, dependents, imported.length + importedByFragments.length, required.length);
        System.arraycopy(requiredByFragments, 0, dependents, imported.length + importedByFragments.length + required.length, requiredByFragments.length);
        return dependents;
    }

    public static BundleDescription[] getImportedByFragments(BundleDescription root) {
        BundleDescription[] fragments = root.getFragments();
        ArrayList importedByFragments = new ArrayList();
        for (int i = 0; i < fragments.length; ++i) {
            if (!fragments[i].isResolved()) continue;
            PDEState.merge(importedByFragments, PDEState.getImportedBundles(fragments[i]));
        }
        BundleDescription[] result = new BundleDescription[importedByFragments.size()];
        return importedByFragments.toArray(result);
    }

    public static BundleDescription[] getRequiredByFragments(BundleDescription root) {
        BundleDescription[] fragments = root.getFragments();
        ArrayList importedByFragments = new ArrayList();
        for (int i = 0; i < fragments.length; ++i) {
            if (!fragments[i].isResolved()) continue;
            PDEState.merge(importedByFragments, PDEState.getRequiredBundles(fragments[i]));
        }
        BundleDescription[] result = new BundleDescription[importedByFragments.size()];
        return importedByFragments.toArray(result);
    }

    public static void merge(List source, BundleDescription[] toAdd) {
        for (int i = 0; i < toAdd.length; ++i) {
            if (source.contains(toAdd[i])) continue;
            source.add(toAdd[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties loadPropertyFileIn(Map toMerge, File location) {
        Properties result = new Properties();
        result.putAll((Map<?, ?>)toMerge);
        try {
            BufferedInputStream propertyStream = new BufferedInputStream(new FileInputStream(new File(location, "build.properties")));
            try {
                result.load(propertyStream);
            }
            finally {
                ((InputStream)propertyStream).close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return result;
    }

    public HashMap getExtraData() {
        return this.bundleClasspaths;
    }

    public Map getPatchData() {
        return this.patchBundles;
    }

    public List getSortedBundles() {
        BundleDescription[] toSort = this.getState().getResolvedBundles();
        Platform.getPlatformAdmin().getStateHelper().sortBundles(toSort);
        return Arrays.asList(toSort);
    }

    public void cleanupOriginalState() {
        if (this.addedBundle == null && this.unqualifiedBundles == null) {
            return;
        }
        Iterator iter = this.addedBundle.iterator();
        while (iter.hasNext()) {
            BundleDescription added = (BundleDescription)iter.next();
            this.state.removeBundle(added);
        }
        iter = this.unqualifiedBundles.iterator();
        while (iter.hasNext()) {
            BundleDescription toAddBack = (BundleDescription)iter.next();
            this.state.removeBundle(toAddBack.getBundleId());
            this.state.addBundle(toAddBack);
        }
        BundleDescription[] allBundles = this.state.getBundles();
        for (int i = 0; i < allBundles.length; ++i) {
            allBundles[i].setUserObject(null);
        }
        this.state.resolve();
    }

    private File getOSGiLocation() {
        BundleDescription osgiBundle = this.state.getBundle("org.eclipse.osgi", null);
        if (osgiBundle == null) {
            return null;
        }
        return new File(osgiBundle.getLocation());
    }

    private void setJavaProfiles(File bundleLocation) {
        if (bundleLocation == null) {
            return;
        }
        this.javaProfiles = bundleLocation.isDirectory() ? this.getDirJavaProfiles(bundleLocation) : this.getJarJavaProfiles(bundleLocation);
    }

    private String[] getDirJavaProfiles(File bundleLocation) {
        File profileList = new File(bundleLocation, "profile.list");
        if (profileList.exists()) {
            try {
                return this.getJavaProfiles(new FileInputStream(profileList));
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        String[] profiles = bundleLocation.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(PDEState.PROFILE_EXTENSION);
            }
        });
        return this.sortProfiles(profiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private String[] getJarJavaProfiles(File bundleLocation) {
        block19: {
            block18: {
                zipFile = null;
                results = new ArrayList<String>(6);
                zipFile = new ZipFile(bundleLocation, 1);
                profileList = zipFile.getEntry("profile.list");
                if (profileList == null) ** GOTO lbl-1000
                var5_8 = this.getJavaProfiles(zipFile.getInputStream(profileList));
                if (zipFile == null) break block18;
                try {
                    zipFile.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            return var5_8;
            {
                catch (IOException e) {
                    try lbl-1000:
                    // 2 sources

                    {
                        entries = zipFile.entries();
                        while (entries.hasMoreElements()) {
                            entryName = entries.nextElement().getName();
                            if (entryName.indexOf(47) >= 0 || !entryName.endsWith(".profile")) continue;
                            results.add(entryName);
                        }
                    }
                    catch (IOException e) {
                        break block19;
                        catch (Throwable var7_13) {
                            throw var7_13;
                        }
                    }
                    finally {
                        if (zipFile != null) {
                            try {
                                zipFile.close();
                            }
                            catch (IOException e) {}
                        }
                    }
                }
            }
        }
        return this.sortProfiles(results.toArray(new String[results.size()]));
    }

    private String[] getJavaProfiles(InputStream is) throws IOException {
        Properties props = new Properties();
        props.load(is);
        return ManifestElement.getArrayFromList((String)props.getProperty("java.profiles"), (String)",");
    }

    private String[] sortProfiles(String[] profiles) {
        Arrays.sort(profiles, new Comparator(){

            public int compare(Object profile1, Object profile2) {
                String p1 = (String)profile1;
                String p2 = (String)profile2;
                if (p1.startsWith("J2SE") && !p2.startsWith("J2SE")) {
                    return -1;
                }
                if (!p1.startsWith("J2SE") && p2.startsWith("J2SE")) {
                    return 1;
                }
                return -p1.compareTo(p2);
            }
        });
        return profiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getJavaProfileProperties() {
        if (this.javaProfile == null) {
            return null;
        }
        File location = this.getOSGiLocation();
        InputStream is = null;
        ZipFile zipFile = null;
        try {
            if (location.isDirectory()) {
                is = new FileInputStream(new File(location, this.javaProfile));
            } else {
                zipFile = null;
                try {
                    zipFile = new ZipFile(location, 1);
                    ZipEntry entry = zipFile.getEntry(this.javaProfile);
                    if (entry != null) {
                        is = zipFile.getInputStream(entry);
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            Properties profile = new Properties();
            profile.load(is);
            Properties properties = profile;
            return properties;
        }
        catch (IOException e) {
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException e) {}
            }
        }
        return null;
    }

    private void forceQualifiers() {
        BundleDescription[] resolvedBundles = this.state.getResolvedBundles();
        for (int i = 0; i < resolvedBundles.length; ++i) {
            if (!resolvedBundles[i].getVersion().getQualifier().equals("qualifier")) continue;
            BundleDescription b = resolvedBundles[i];
            this.unqualifiedBundles.add(this.state.removeBundle(b.getBundleId()));
            String newVersion = QualifierReplacer.replaceQualifierInVersion(b.getVersion().toString(), b.getSymbolicName(), this.getQualifierPropery(b.getLocation()), null);
            String[] envs = b.getExecutionEnvironments();
            StringBuffer buffer = new StringBuffer();
            for (int j = 0; j < envs.length; ++j) {
                if (j > 0) {
                    buffer.append(",");
                }
                buffer.append(envs[j]);
            }
            String ee = buffer.toString();
            BundleDescription newBundle = this.state.getFactory().createBundleDescription(b.getBundleId(), b.getSymbolicName(), new Version(newVersion), b.getLocation(), b.getRequiredBundles(), b.getHost(), b.getImportPackages(), b.getExportPackages(), null, b.isSingleton(), b.attachFragments(), b.dynamicFragments(), b.getPlatformFilter(), ee, b.getGenericRequires(), b.getGenericCapabilities());
            this.state.addBundle(newBundle);
            this.rememberQualifierTagPresence(newBundle);
        }
        this.state.resolve();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

