/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.preferences.ImportOrganizeInputDialog;
import org.eclipse.jdt.internal.ui.preferences.OptionsConfigurationBlock;
import org.eclipse.jdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.jdt.internal.ui.util.PixelConverter;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.jdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class ImportOrganizeConfigurationBlock
extends OptionsConfigurationBlock {
    private static final OptionsConfigurationBlock.Key PREF_IMPORTORDER = ImportOrganizeConfigurationBlock.getJDTUIKey("org.eclipse.jdt.ui.importorder");
    private static final OptionsConfigurationBlock.Key PREF_ONDEMANDTHRESHOLD = ImportOrganizeConfigurationBlock.getJDTUIKey("org.eclipse.jdt.ui.ondemandthreshold");
    private static final OptionsConfigurationBlock.Key PREF_IGNORELOWERCASE = ImportOrganizeConfigurationBlock.getJDTUIKey("org.eclipse.jdt.ui.ignorelowercasenames");
    private static final OptionsConfigurationBlock.Key PREF_STATICONDEMANDTHRESHOLD = ImportOrganizeConfigurationBlock.getJDTUIKey("org.eclipse.jdt.ui.staticondemandthreshold");
    private static final String DIALOGSETTING_LASTLOADPATH = "org.eclipse.jdt.ui.importorder.loadpath";
    private static final String DIALOGSETTING_LASTSAVEPATH = "org.eclipse.jdt.ui.importorder.savepath";
    private static final int IDX_ADD = 0;
    private static final int IDX_ADD_STATIC = 1;
    private static final int IDX_EDIT = 2;
    private static final int IDX_REMOVE = 3;
    private static final int IDX_UP = 5;
    private static final int IDX_DOWN = 6;
    private static final int IDX_LOAD = 8;
    private static final int IDX_SAVE = 9;
    private ListDialogField fOrderListField;
    private StringDialogField fThresholdField;
    private StringDialogField fStaticThresholdField;
    private SelectionButtonDialogField fIgnoreLowerCaseTypesField;
    private PixelConverter fPixelConverter;

    private static OptionsConfigurationBlock.Key[] getAllKeys() {
        return new OptionsConfigurationBlock.Key[]{PREF_IMPORTORDER, PREF_ONDEMANDTHRESHOLD, PREF_STATICONDEMANDTHRESHOLD, PREF_IGNORELOWERCASE};
    }

    public ImportOrganizeConfigurationBlock(IStatusChangeListener context, IProject project, IWorkbenchPreferenceContainer container) {
        super(context, project, ImportOrganizeConfigurationBlock.getAllKeys(), container);
        String[] stringArray = new String[10];
        stringArray[0] = PreferencesMessages.ImportOrganizeConfigurationBlock_order_add_button;
        stringArray[1] = PreferencesMessages.ImportOrganizeConfigurationBlock_order_add_static_button;
        stringArray[2] = PreferencesMessages.ImportOrganizeConfigurationBlock_order_edit_button;
        stringArray[3] = PreferencesMessages.ImportOrganizeConfigurationBlock_order_remove_button;
        stringArray[5] = PreferencesMessages.ImportOrganizeConfigurationBlock_order_up_button;
        stringArray[6] = PreferencesMessages.ImportOrganizeConfigurationBlock_order_down_button;
        stringArray[8] = PreferencesMessages.ImportOrganizeConfigurationBlock_order_load_button;
        stringArray[9] = PreferencesMessages.ImportOrganizeConfigurationBlock_order_save_button;
        String[] buttonLabels = stringArray;
        ImportOrganizeAdapter adapter = new ImportOrganizeAdapter();
        this.fOrderListField = new ListDialogField(adapter, buttonLabels, (ILabelProvider)new ImportOrganizeLabelProvider());
        this.fOrderListField.setDialogFieldListener(adapter);
        this.fOrderListField.setLabelText(PreferencesMessages.ImportOrganizeConfigurationBlock_order_label);
        this.fOrderListField.setUpButtonIndex(5);
        this.fOrderListField.setDownButtonIndex(6);
        this.fOrderListField.setRemoveButtonIndex(3);
        this.fOrderListField.enableButton(2, false);
        this.fThresholdField = new StringDialogField();
        this.fThresholdField.setDialogFieldListener(adapter);
        this.fThresholdField.setLabelText(PreferencesMessages.ImportOrganizeConfigurationBlock_threshold_label);
        this.fStaticThresholdField = new StringDialogField();
        this.fStaticThresholdField.setDialogFieldListener(adapter);
        this.fStaticThresholdField.setLabelText(PreferencesMessages.ImportOrganizeConfigurationBlock_staticthreshold_label);
        this.fIgnoreLowerCaseTypesField = new SelectionButtonDialogField(32);
        this.fIgnoreLowerCaseTypesField.setDialogFieldListener(adapter);
        this.fIgnoreLowerCaseTypesField.setLabelText(PreferencesMessages.ImportOrganizeConfigurationBlock_ignoreLowerCase_label);
        this.updateControls();
    }

    protected Control createContents(Composite parent) {
        this.setShell(parent.getShell());
        this.fPixelConverter = new PixelConverter((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        this.fOrderListField.doFillIntoGrid(composite, 3);
        LayoutUtil.setHorizontalSpan((Control)this.fOrderListField.getLabelControl(null), 2);
        LayoutUtil.setWidthHint((Control)this.fOrderListField.getLabelControl(null), this.fPixelConverter.convertWidthInCharsToPixels(60));
        LayoutUtil.setHorizontalGrabbing(this.fOrderListField.getListControl(null));
        this.fThresholdField.doFillIntoGrid(composite, 2);
        ((GridData)this.fThresholdField.getTextControl(null).getLayoutData()).grabExcessHorizontalSpace = false;
        this.fStaticThresholdField.doFillIntoGrid(composite, 2);
        this.fIgnoreLowerCaseTypesField.doFillIntoGrid(composite, 2);
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void doThresholdChanged(String thresholdString) {
        StatusInfo status = new StatusInfo();
        try {
            int threshold = Integer.parseInt(thresholdString);
            if (threshold < 0) {
                status.setError(PreferencesMessages.ImportOrganizeConfigurationBlock_error_invalidthreshold);
            }
        }
        catch (NumberFormatException numberFormatException) {
            status.setError(PreferencesMessages.ImportOrganizeConfigurationBlock_error_invalidthreshold);
        }
        this.updateStatus(status);
    }

    private void doButtonPressed(int index) {
        if (index == 0 || index == 1) {
            List existing = this.fOrderListField.getElements();
            ImportOrganizeInputDialog dialog = new ImportOrganizeInputDialog(this.getShell(), existing, index == 1);
            if (dialog.open() == 0) {
                List selectedElements = this.fOrderListField.getSelectedElements();
                if (selectedElements.size() == 1) {
                    int insertionIndex = this.fOrderListField.getIndexOfElement(selectedElements.get(0)) + 1;
                    this.fOrderListField.addElement(dialog.getResult(), insertionIndex);
                } else {
                    this.fOrderListField.addElement(dialog.getResult());
                }
            }
        } else if (index == 2) {
            List selected = this.fOrderListField.getSelectedElements();
            if (selected.isEmpty()) {
                return;
            }
            ImportOrderEntry editedEntry = (ImportOrderEntry)selected.get(0);
            List existing = this.fOrderListField.getElements();
            existing.remove(editedEntry);
            ImportOrganizeInputDialog dialog = new ImportOrganizeInputDialog(this.getShell(), existing, editedEntry.isStatic);
            dialog.setInitialSelection(editedEntry);
            if (dialog.open() == 0) {
                this.fOrderListField.replaceElement(editedEntry, dialog.getResult());
            }
        } else if (index == 8) {
            List order = this.loadImportOrder();
            if (order != null) {
                this.fOrderListField.setElements(order);
            }
        } else if (index == 9) {
            this.saveImportOrder(this.fOrderListField.getElements());
        }
    }

    private List loadFromProperties(Properties properties) {
        ArrayList<ImportOrderEntry> res = new ArrayList<ImportOrderEntry>();
        int nEntries = properties.size();
        int i = 0;
        while (i < nEntries) {
            ImportOrderEntry entry;
            String curr = properties.getProperty(String.valueOf(i));
            if (curr != null) {
                entry = ImportOrderEntry.fromSerialized(curr);
                if (JavaConventions.validatePackageName((String)entry.name).matches(4)) {
                    return null;
                }
            } else {
                return res;
            }
            res.add(entry);
            ++i;
        }
        return res;
    }

    /*
     * Exception decompiling
     */
    private List loadImportOrder() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [4 : 182->185)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private void saveImportOrder(List elements) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 242->246)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void updateStatus(IStatus status) {
        this.fContext.statusChanged(status);
    }

    protected void validateSettings(OptionsConfigurationBlock.Key changedKey, String oldValue, String newValue) {
    }

    protected void updateControls() {
        ImportOrderEntry[] importOrder = this.getImportOrderPreference();
        int threshold = this.getImportNumberThreshold(PREF_ONDEMANDTHRESHOLD);
        int staticThreshold = this.getImportNumberThreshold(PREF_STATICONDEMANDTHRESHOLD);
        boolean ignoreLowerCase = Boolean.valueOf(this.getValue(PREF_IGNORELOWERCASE));
        this.fOrderListField.removeAllElements();
        int i = 0;
        while (i < importOrder.length) {
            this.fOrderListField.addElement(importOrder[i]);
            ++i;
        }
        this.fThresholdField.setText(String.valueOf(threshold));
        this.fStaticThresholdField.setText(String.valueOf(staticThreshold));
        this.fIgnoreLowerCaseTypesField.setSelection(ignoreLowerCase);
    }

    protected final void updateModel(DialogField field) {
        if (field == this.fOrderListField) {
            this.setValue(PREF_IMPORTORDER, ImportOrganizeConfigurationBlock.packOrderList(this.fOrderListField.getElements()));
        } else if (field == this.fThresholdField) {
            this.setValue(PREF_ONDEMANDTHRESHOLD, this.fThresholdField.getText());
            this.doThresholdChanged(this.fThresholdField.getText());
        } else if (field == this.fStaticThresholdField) {
            this.setValue(PREF_STATICONDEMANDTHRESHOLD, this.fStaticThresholdField.getText());
            this.doThresholdChanged(this.fStaticThresholdField.getText());
        } else if (field == this.fIgnoreLowerCaseTypesField) {
            this.setValue(PREF_IGNORELOWERCASE, this.fIgnoreLowerCaseTypesField.isSelected());
        }
    }

    protected String[] getFullBuildDialogStrings(boolean workspaceSettings) {
        return null;
    }

    private static ImportOrderEntry[] unpackOrderList(String str) {
        int end;
        ArrayList<ImportOrderEntry> res = new ArrayList<ImportOrderEntry>();
        int start = 0;
        do {
            if ((end = str.indexOf(59, start)) == -1) {
                end = str.length();
            }
            res.add(ImportOrderEntry.fromSerialized(str.substring(start, end)));
        } while ((start = end + 1) < str.length());
        return res.toArray(new ImportOrderEntry[res.size()]);
    }

    private static String packOrderList(List orderList) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < orderList.size()) {
            ImportOrderEntry entry = (ImportOrderEntry)orderList.get(i);
            buf.append(entry.serialize());
            buf.append(';');
            ++i;
        }
        return buf.toString();
    }

    private ImportOrderEntry[] getImportOrderPreference() {
        String str = this.getValue(PREF_IMPORTORDER);
        if (str != null) {
            return ImportOrganizeConfigurationBlock.unpackOrderList(str);
        }
        return new ImportOrderEntry[0];
    }

    private int getImportNumberThreshold(OptionsConfigurationBlock.Key key) {
        String thresholdStr = this.getValue(key);
        try {
            int threshold = Integer.parseInt(thresholdStr);
            if (threshold < 0) {
                threshold = Integer.MAX_VALUE;
            }
            return threshold;
        }
        catch (NumberFormatException numberFormatException) {
            return Integer.MAX_VALUE;
        }
    }

    public static class ImportOrderEntry {
        public final String name;
        public final boolean isStatic;

        public ImportOrderEntry(String name, boolean isStatic) {
            this.name = name;
            this.isStatic = isStatic;
        }

        public String serialize() {
            return this.isStatic ? String.valueOf('#') + this.name : this.name;
        }

        public static ImportOrderEntry fromSerialized(String str) {
            if (str.length() > 0 && str.charAt(0) == '#') {
                return new ImportOrderEntry(str.substring(1), true);
            }
            return new ImportOrderEntry(str, false);
        }
    }

    private static class ImportOrganizeLabelProvider
    extends LabelProvider {
        private final Image PCK_ICON = JavaPluginImages.get("org.eclipse.jdt.ui.package_obj.gif");
        private final Image STATIC_CLASS_ICON = JavaElementImageProvider.getDecoratedImage(JavaPluginImages.DESC_MISC_PUBLIC, 8, JavaElementImageProvider.SMALL_SIZE);

        public Image getImage(Object element) {
            return ((ImportOrderEntry)element).isStatic ? this.STATIC_CLASS_ICON : this.PCK_ICON;
        }

        public String getText(Object element) {
            ImportOrderEntry entry = (ImportOrderEntry)element;
            String name = entry.name;
            if (name.length() > 0) {
                return name;
            }
            if (entry.isStatic) {
                return PreferencesMessages.ImportOrganizeConfigurationBlock_other_static;
            }
            return PreferencesMessages.ImportOrganizeConfigurationBlock_other_normal;
        }
    }

    private class ImportOrganizeAdapter
    implements IListAdapter,
    IDialogFieldListener {
        private ImportOrganizeAdapter() {
        }

        private boolean canEdit(ListDialogField field) {
            List selected = field.getSelectedElements();
            return selected.size() == 1;
        }

        public void customButtonPressed(ListDialogField field, int index) {
            ImportOrganizeConfigurationBlock.this.doButtonPressed(index);
        }

        public void selectionChanged(ListDialogField field) {
            ImportOrganizeConfigurationBlock.this.fOrderListField.enableButton(2, this.canEdit(field));
        }

        public void dialogFieldChanged(DialogField field) {
            ImportOrganizeConfigurationBlock.this.updateModel(field);
        }

        public void doubleClicked(ListDialogField field) {
            if (this.canEdit(field)) {
                ImportOrganizeConfigurationBlock.this.doButtonPressed(2);
            }
        }
    }
}

