/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.propertiesfileeditor;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.text.StringCharacterIterator;
import java.util.Properties;
import org.eclipse.jdt.internal.ui.propertiesfileeditor.PropertyKeyHyperlink;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;

public class PropertyKeyHyperlinkDetector
implements IHyperlinkDetector {
    private ITextEditor fTextEditor;

    public PropertyKeyHyperlinkDetector(ITextEditor editor) {
        Assert.isNotNull((Object)editor);
        this.fTextEditor = editor;
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        int delta;
        String realKey;
        ITypedRegion partition;
        block13: {
            IDocument document;
            block12: {
                int offset;
                block11: {
                    if (region == null || this.fTextEditor == null || canShowMultipleHyperlinks) {
                        return null;
                    }
                    IEditorSite site = this.fTextEditor.getEditorSite();
                    if (site == null) {
                        return null;
                    }
                    if (!this.checkEnabled(region)) {
                        return null;
                    }
                    offset = region.getOffset();
                    partition = null;
                    IStorageEditorInput storageEditorInput = (IStorageEditorInput)this.fTextEditor.getEditorInput();
                    document = this.fTextEditor.getDocumentProvider().getDocument((Object)storageEditorInput);
                    if (document instanceof IDocumentExtension3) {
                        partition = ((IDocumentExtension3)document).getPartition("___pf_partitioning", offset, false);
                    }
                    if (partition != null && "__dftl_partition_content_type".equals(partition.getType())) break block11;
                    return null;
                }
                if (offset + region.getLength() <= partition.getOffset() + partition.getLength()) break block12;
                return null;
            }
            String key = document.get(partition.getOffset(), partition.getLength());
            realKey = key.trim();
            delta = key.indexOf(realKey);
            String unicodeKey = this.getUnicodeString(realKey);
            Properties properties = new Properties();
            properties.load(new ByteArrayInputStream(document.get().getBytes()));
            if (properties.getProperty(unicodeKey) != null) break block13;
            return null;
        }
        try {
            return new PropertyKeyHyperlink[]{new PropertyKeyHyperlink((IRegion)new Region(partition.getOffset() + delta, realKey.length()), realKey, this.fTextEditor)};
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        catch (BadPartitioningException badPartitioningException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private String getUnicodeString(String key) {
        StringCharacterIterator iter = new StringCharacterIterator(key);
        StringBuffer result = new StringBuffer();
        while (iter.getIndex() < iter.getEndIndex()) {
            char c = iter.current();
            if (c == '\\') {
                iter.next();
                c = iter.current();
                if (c == 'u') {
                    StringBuffer unicode = new StringBuffer();
                    unicode.append(iter.next());
                    unicode.append(iter.next());
                    unicode.append(iter.next());
                    unicode.append(iter.next());
                    c = (char)Integer.parseInt(unicode.toString(), 16);
                }
            }
            result.append(c);
            iter.next();
        }
        return result.toString();
    }

    private boolean checkEnabled(IRegion region) {
        if (region == null || region.getOffset() < 0) {
            return false;
        }
        return this.fTextEditor.getEditorInput() instanceof IFileEditorInput;
    }
}

