/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.search;

import java.io.File;
import java.io.FileInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.help.internal.base.HelpBaseResources;
import org.eclipse.help.internal.search.AnalyzerDescriptor;
import org.eclipse.help.internal.search.PluginVersionInfo;
import org.eclipse.help.internal.search.SearchIndex;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HelpIndexBuilder {
    private static final String POINT_TOC = "org.eclipse.help.toc";
    private static final String EL_TOC = "toc";
    private static final String EL_INDEX = "index";
    private File manifest;
    private String indexPath;
    private File destination;
    private ArrayList tocFiles = new ArrayList();
    private ArrayList localeDirs = new ArrayList();
    private static final DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    private DocumentBuilder parser;
    private static Locale[] legalLocales = Locale.getAvailableLocales();
    private static HashSet legalLanguages = null;
    private static HashSet legalCountries = null;

    public File getManifest() {
        return this.manifest;
    }

    public void setManifest(File manifest) {
        File project;
        File parent;
        if (manifest.getName().equalsIgnoreCase("MANIFEST.MF") && (parent = manifest.getParentFile()).getName().equalsIgnoreCase("META-INF") && !(manifest = new File(project = parent.getParentFile(), "plugin.xml")).exists()) {
            manifest = null;
        }
        this.manifest = manifest;
    }

    public File getDestination() {
        return this.destination;
    }

    public void setDestination(File destination) {
        this.destination = destination;
    }

    public void execute(IProgressMonitor monitor) throws CoreException {
        this.reset();
        if (this.manifest == null || this.destination == null) {
            return;
        }
        Document doc = this.readXMLFile(this.manifest);
        if (doc == null) {
            return;
        }
        PluginIdentifier pid = this.getPluginID(this.manifest.getParentFile(), doc);
        PluginIdentifier fid = null;
        if (!this.manifest.getParentFile().equals(this.destination)) {
            File fragmentFile = new File(this.destination, "fragment.xml");
            Document fdoc = null;
            if (fragmentFile.exists()) {
                fdoc = this.readXMLFile(fragmentFile);
            }
            fid = this.getPluginID(this.destination, fdoc);
            fdoc = null;
        }
        Element[] extensions = this.getTocExtensions(doc);
        int i = 0;
        while (i < extensions.length) {
            this.processExtension(extensions[i]);
            ++i;
        }
        if (this.indexPath == null) {
            this.throwCoreException(HelpBaseResources.HelpIndexBuilder_noDestinationPath, null);
        }
        doc = null;
        this.computeLocaleDirs(fid != null);
        monitor.beginTask(HelpBaseResources.HelpIndexBuilder_buildingIndex, this.localeDirs.size());
        MultiStatus multiStatus = null;
        int i2 = 0;
        while (i2 < this.localeDirs.size()) {
            LocaleDir localeDir = (LocaleDir)this.localeDirs.get(i2);
            MultiStatus localeStatus = this.processLocaleDir(pid, fid, localeDir, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 4));
            if (localeStatus != null) {
                if (multiStatus == null) {
                    multiStatus = localeStatus;
                } else {
                    multiStatus.addAll((IStatus)localeStatus);
                }
            }
            ++i2;
        }
        monitor.done();
        if (multiStatus != null) {
            throw new CoreException(multiStatus);
        }
    }

    private void processExtension(Element extensionNode) {
        NodeList children = extensionNode.getElementsByTagName(EL_TOC);
        int i = 0;
        while (i < children.getLength()) {
            Node node = children.item(i);
            String file = this.getAttribute(node, "file");
            String primary = this.getAttribute(node, "primary");
            String extradir = this.getAttribute(node, "extradir");
            this.addTocFile(file, primary, extradir);
            ++i;
        }
        children = extensionNode.getElementsByTagName(EL_INDEX);
        if (children.getLength() == 1) {
            Node node = children.item(0);
            this.indexPath = this.getAttribute(node, "path");
        }
    }

    private void addTocFile(String file, String primary, String extradir) {
        boolean isPrimary = primary != null && primary.equalsIgnoreCase("true");
        this.tocFiles.add(new TocFile(file, isPrimary, extradir));
    }

    private void computeLocaleDirs(boolean fragment) {
        if (!fragment) {
            LocaleDir dir = new LocaleDir(null, "/");
            dir.addDirectory(this.destination);
            this.localeDirs.add(dir);
        }
        File ws = new File(this.destination, "ws");
        this.computeSystem(ws, Platform.knownWSValues());
        File os = new File(this.destination, "os");
        this.computeSystem(os, Platform.knownOSValues());
        File nl = new File(this.destination, "nl");
        if (!nl.exists() || !nl.isDirectory()) {
            return;
        }
        File[] languages = nl.listFiles();
        HashSet<String> locales = new HashSet<String>();
        int i = 0;
        while (i < languages.length) {
            File language = languages[i];
            if (language.isDirectory() && this.isValidLanguage(language.getName())) {
                File[] countries = language.listFiles();
                int j = 0;
                while (j < countries.length) {
                    String locale;
                    File country = countries[j];
                    boolean hasCountry = false;
                    if (country.isDirectory() && this.isValidCountry(country.getName())) {
                        hasCountry = true;
                    }
                    if (this.isValidLocale(locale = hasCountry ? String.valueOf(language.getName()) + "_" + country.getName() : language.getName()) && !locales.contains(locale)) {
                        String relativePath = hasCountry ? "/nl/" + language.getName() + "/" + country.getName() : "/nl/" + language.getName();
                        LocaleDir dir = new LocaleDir(locale, relativePath);
                        if (hasCountry) {
                            dir.addDirectory(country);
                        }
                        dir.addDirectory(language);
                        dir.addDirectory(this.destination);
                        this.localeDirs.add(dir);
                        locales.add(locale);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private void computeSystem(File systemRoot, String[] values) {
        if (systemRoot.exists() && systemRoot.isDirectory()) {
            File[] files = systemRoot.listFiles();
            int i = 0;
            while (i < files.length) {
                File sdir = files[i];
                if (sdir.isDirectory()) {
                    String sname = sdir.getName();
                    int j = 0;
                    while (j < values.length) {
                        if (values[j].equals(sname)) {
                            String relativePath = "/" + systemRoot.getName() + "/" + sname;
                            LocaleDir dir = new LocaleDir(sname, relativePath);
                            dir.addDirectory(sdir);
                            dir.addDirectory(this.destination);
                            this.localeDirs.add(dir);
                            break;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    private boolean isValidLocale(String locale) {
        int i = 0;
        while (i < legalLocales.length) {
            Locale legalLocale = legalLocales[i];
            if (legalLocale.toString().equals(locale)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isValidLanguage(String language) {
        if (legalLanguages == null) {
            legalLanguages = new HashSet();
            String[] choices = Locale.getISOLanguages();
            int i = 0;
            while (i < choices.length) {
                legalLanguages.add(choices[i]);
                ++i;
            }
        }
        return legalLanguages.contains(language);
    }

    private boolean isValidCountry(String country) {
        if (legalCountries == null) {
            legalCountries = new HashSet();
            String[] choices = Locale.getISOCountries();
            int i = 0;
            while (i < choices.length) {
                legalCountries.add(choices[i]);
                ++i;
            }
        }
        return legalCountries.contains(country);
    }

    private MultiStatus processLocaleDir(PluginIdentifier id, PluginIdentifier fid, LocaleDir localeDir, IProgressMonitor monitor) throws CoreException {
        String message = NLS.bind((String)HelpBaseResources.HelpIndexBuilder_indexFor, (Object)((File)localeDir.dirs.get(0)).getName());
        monitor.beginTask(message, 5);
        File directory = (File)localeDir.dirs.get(0);
        File indexDirectory = new File(directory, this.indexPath);
        this.prepareDirectory(indexDirectory);
        Collection docs = this.collectDocs(localeDir);
        MultiStatus status = null;
        if (docs.size() > 0) {
            String locale = localeDir.locale != null ? localeDir.locale : Platform.getNL();
            SearchIndex index = new SearchIndex(indexDirectory, locale, new AnalyzerDescriptor(locale), null, localeDir.relativePath);
            IndexerPluginVersionInfo docPlugins = new IndexerPluginVersionInfo(id, fid, indexDirectory);
            index.setDocPlugins(docPlugins);
            status = this.createIndex(id.id, fid != null, localeDir, index, docs, (IProgressMonitor)new SubProgressMonitor(monitor, 5, 4));
            index.deleteLockFile();
        }
        monitor.setTaskName("");
        monitor.done();
        return status;
    }

    private Collection collectDocs(LocaleDir localeDir) throws CoreException {
        HashSet docs = new HashSet();
        int i = 0;
        while (i < this.tocFiles.size()) {
            TocFile tocFile = (TocFile)this.tocFiles.get(i);
            this.collectDocs(docs, this.getTocFile(localeDir, tocFile.href));
            String cfr_ignored_0 = tocFile.extraDir;
            ++i;
        }
        return docs;
    }

    private File getTocFile(LocaleDir localeDir, String href) {
        File file = localeDir.findFile(href);
        if (file != null) {
            return file;
        }
        File pdir = this.manifest.getParentFile();
        return new File(pdir, href);
    }

    private void collectDocs(Set docs, File tocFile) throws CoreException {
        if (!tocFile.exists()) {
            return;
        }
        Document doc = this.readXMLFile(tocFile);
        this.add(doc.getDocumentElement(), docs);
    }

    private void add(Element topic, Set hrefs) {
        String href = this.getAttribute(topic, "href");
        if (topic.getTagName().equals(EL_TOC)) {
            href = this.getAttribute(topic, "topic");
        }
        if (!(href == null || href.equals("") || href.startsWith("http://") || href.startsWith("https://") || (href = SearchIndex.getIndexableHref(href)) == null)) {
            hrefs.add(href);
        }
        NodeList subtopics = topic.getElementsByTagName("topic");
        int i = 0;
        while (i < subtopics.getLength()) {
            this.add((Element)subtopics.item(i), hrefs);
            ++i;
        }
    }

    private MultiStatus createIndex(String pluginId, boolean fragment, LocaleDir localeDir, SearchIndex index, Collection addedDocs, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(HelpBaseResources.UpdatingIndex, addedDocs.size());
        if (!index.beginAddBatch(true)) {
            this.throwCoreException(HelpBaseResources.HelpIndexBuilder_error, null);
        }
        this.checkCancelled(monitor);
        MultiStatus multiStatus = null;
        Iterator it = addedDocs.iterator();
        while (it.hasNext()) {
            String href = (String)it.next();
            URL url = localeDir.findURL(href);
            if (url != null) {
                IStatus status = index.addDocument(this.getName(pluginId, href), url);
                if (status.getCode() != 0) {
                    if (multiStatus == null) {
                        multiStatus = this.createMultiStatus();
                    }
                    multiStatus.add(status);
                }
            } else {
                String locale = localeDir.locale != null ? localeDir.locale : Platform.getNL();
                String message = NLS.bind((String)HelpBaseResources.HelpIndexBuilder_cannotFindDoc, (Object)locale, (Object)href);
                Status status = new Status(2, pluginId, 0, message, null);
                if (multiStatus == null) {
                    multiStatus = this.createMultiStatus();
                }
                multiStatus.add((IStatus)status);
            }
            this.checkCancelled(monitor);
            monitor.worked(1);
        }
        monitor.subTask(HelpBaseResources.Writing_index);
        if (!index.endAddBatch(true, true)) {
            Status status = new Status(4, "org.eclipse.help.base", 0, HelpBaseResources.HelpIndexBuilder_errorWriting, null);
            if (multiStatus == null) {
                multiStatus = this.createMultiStatus();
            }
            multiStatus.add((IStatus)status);
        }
        monitor.done();
        return multiStatus;
    }

    private MultiStatus createMultiStatus() {
        return new MultiStatus("org.eclipse.help.base", 0, HelpBaseResources.HelpIndexBuilder_incompleteIndex, null);
    }

    private void checkCancelled(IProgressMonitor pm) throws OperationCanceledException {
        if (pm.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    private String getName(String pluginId, String href) {
        int i = href.indexOf(63);
        if (i != -1) {
            href = href.substring(0, i);
        }
        return "/" + pluginId + "/" + href;
    }

    private void prepareDirectory(File indexDirectory) throws CoreException {
        if (indexDirectory.exists()) {
            File[] files = indexDirectory.listFiles();
            int i = 0;
            while (i < files.length) {
                File file = files[i];
                boolean result = file.delete();
                if (!result) {
                    this.throwCoreException(HelpBaseResources.HelpIndexBuilder_cannotScrub, null);
                }
                ++i;
            }
        } else {
            boolean result = indexDirectory.mkdirs();
            if (!result) {
                this.throwCoreException(HelpBaseResources.HelpIndexBuilder_cannotCreateDest, null);
            }
        }
    }

    private void reset() {
        this.localeDirs.clear();
        this.tocFiles.clear();
        this.indexPath = null;
    }

    private PluginIdentifier getPluginID(File dir, Document doc) throws CoreException {
        File OSGiFile;
        String id = null;
        String version = null;
        if (doc != null) {
            Element root = doc.getDocumentElement();
            id = this.getAttribute(root, "id");
            version = this.getAttribute(root, "version");
            if (id != null && version != null) {
                return new PluginIdentifier(id, version);
            }
        }
        if ((OSGiFile = new File(dir, "META-INF/MANIFEST.MF")).exists()) {
            ManifestElement[] elements;
            String value;
            block11: {
                Properties headers;
                block10: {
                    Manifest OSGiManifest = new Manifest(new FileInputStream(OSGiFile));
                    headers = this.manifestToProperties(OSGiManifest.getMainAttributes());
                    value = ((Dictionary)headers).get("Bundle-SymbolicName").toString();
                    if (value != null) break block10;
                    return null;
                }
                elements = ManifestElement.parseHeader((String)"Bundle-SymbolicName", (String)value);
                if (elements.length > 0) {
                    id = elements[0].getValue();
                }
                if ((value = ((Dictionary)headers).get("Bundle-Version").toString()) != null) break block11;
                return null;
            }
            try {
                elements = ManifestElement.parseHeader((String)"Bundle-Version", (String)value);
                if (elements.length > 0) {
                    version = elements[0].getValue();
                }
                if (id != null && version != null) {
                    return new PluginIdentifier(id, version);
                }
            }
            catch (Exception e1) {
                this.throwCoreException(HelpBaseResources.HelpIndexBuilder_errorExtractingId, e1);
            }
        }
        return null;
    }

    private String getAttribute(Node node, String name) {
        Node att;
        NamedNodeMap atts = node.getAttributes();
        if (atts != null && (att = atts.getNamedItem(name)) != null) {
            return att.getNodeValue();
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private Document readXMLFile(File file) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 130->133)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Element[] getTocExtensions(Document doc) {
        ArrayList<Node> list = new ArrayList<Node>();
        NodeList children = doc.getElementsByTagName("extension");
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            String point = this.getAttribute(child, "point");
            if (point.equals(POINT_TOC)) {
                list.add(child);
            }
            ++i;
        }
        return list.toArray(new Element[list.size()]);
    }

    private Properties manifestToProperties(Attributes d) {
        Iterator<Object> iter = d.keySet().iterator();
        Properties result = new Properties();
        while (iter.hasNext()) {
            Attributes.Name key = (Attributes.Name)iter.next();
            result.put(key.toString(), d.get(key));
        }
        return result;
    }

    private void throwCoreException(String message, Throwable t) throws CoreException {
        Status status = new Status(4, "org.eclipse.help.base", 0, message, t);
        throw new CoreException((IStatus)status);
    }

    class PluginIdentifier {
        String id;
        PluginVersionIdentifier version;

        public PluginIdentifier(String id, String version) {
            this.id = id;
            this.version = new PluginVersionIdentifier(version);
        }
    }

    class LocaleDir {
        String locale;
        String relativePath;
        ArrayList dirs = new ArrayList();

        public LocaleDir(String locale, String relativePath) {
            this.locale = locale;
            this.relativePath = relativePath;
        }

        public File findFile(String file) {
            int i = 0;
            while (i < this.dirs.size()) {
                File dir = (File)this.dirs.get(i);
                File absoluteFile = new File(dir, file);
                if (absoluteFile.exists()) {
                    return absoluteFile;
                }
                ++i;
            }
            return null;
        }

        public URL findURL(String href) {
            File file = this.findFile(href);
            if (file != null) {
                try {
                    return file.toURL();
                }
                catch (MalformedURLException malformedURLException) {}
            }
            return null;
        }

        public void addDirectory(File directory) {
            this.dirs.add(directory);
        }
    }

    class IndexerPluginVersionInfo
    extends PluginVersionInfo {
        private static final long serialVersionUID = 1L;

        public IndexerPluginVersionInfo(PluginIdentifier id, PluginIdentifier fid, File dir) {
            super("indexed_contributions", null, dir, false);
            this.createInfo(id, fid);
        }

        protected void createTable(Collection docBundleIds) {
        }

        protected void createInfo(PluginIdentifier id, PluginIdentifier fid) {
            StringBuffer buffer = new StringBuffer();
            this.appendBundleInformation(buffer, id.id, id.version.toString());
            if (fid != null) {
                this.appendBundleInformation(buffer, fid.id, fid.version.toString());
            }
            this.put(id.id, buffer.toString());
        }
    }

    class TocFile {
        String href;
        boolean primary;
        String extraDir;

        public TocFile(String href, boolean primary, String extraDir) {
            this.href = href;
            this.primary = primary;
            this.extraDir = extraDir;
        }
    }
}

