/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions.expressions;

import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IExpressionManager;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.core.model.IWatchExpression;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.actions.IWatchExpressionFactoryAdapter;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;

public class WatchAction
implements IObjectActionDelegate {
    private IStructuredSelection fSelection;
    static /* synthetic */ Class class$0;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        if (this.fSelection == null) {
            return;
        }
        Iterator iter = this.fSelection.iterator();
        while (iter.hasNext()) {
            IVariable variable = (IVariable)iter.next();
            this.createExpression(variable);
        }
    }

    private void showExpressionsView() {
        IWorkbenchPage page = DebugUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IViewPart part = page.findView("org.eclipse.debug.ui.ExpressionView");
        if (part == null) {
            try {
                page.showView("org.eclipse.debug.ui.ExpressionView");
            }
            catch (PartInitException partInitException) {}
        } else {
            page.bringToTop((IWorkbenchPart)part);
        }
    }

    private void createExpression(IVariable variable) {
        IWatchExpression expression;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.debug.ui.actions.IWatchExpressionFactoryAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IWatchExpressionFactoryAdapter factory = (IWatchExpressionFactoryAdapter)variable.getAdapter((Class)clazz);
        try {
            String exp = variable.getName();
            if (factory != null) {
                exp = factory.createWatchExpression(variable);
            }
            expression = DebugPlugin.getDefault().getExpressionManager().newWatchExpression(exp);
        }
        catch (CoreException e) {
            DebugUIPlugin.errorDialog(DebugUIPlugin.getShell(), ActionMessages.WatchAction_0, ActionMessages.WatchAction_1, e);
            return;
        }
        DebugPlugin.getDefault().getExpressionManager().addExpression((IExpression)expression);
        IAdaptable object = DebugUITools.getDebugContext();
        IDebugElement context = null;
        if (object instanceof IDebugElement) {
            context = (IDebugElement)object;
        } else if (object instanceof ILaunch) {
            context = ((ILaunch)object).getDebugTarget();
        }
        expression.setExpressionContext(context);
        this.showExpressionsView();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fSelection = null;
        int enabled = 0;
        int size = -1;
        if (selection instanceof IStructuredSelection) {
            this.fSelection = (IStructuredSelection)selection;
            size = this.fSelection.size();
            IExpressionManager manager = DebugPlugin.getDefault().getExpressionManager();
            Iterator iterator = this.fSelection.iterator();
            while (iterator.hasNext()) {
                IVariable variable = (IVariable)iterator.next();
                if (!manager.hasWatchExpressionDelegate(variable.getModelIdentifier())) break;
                ++enabled;
            }
        }
        action.setEnabled(enabled == size);
    }
}

