/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui;

import com.ibm.icu.text.MessageFormat;
import com.sun.jdi.InvocationException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.debug.core.IEvaluationRunnable;
import org.eclipse.jdt.debug.core.IJavaArray;
import org.eclipse.jdt.debug.core.IJavaArrayType;
import org.eclipse.jdt.debug.core.IJavaClassType;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaInterfaceType;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaPrimitiveValue;
import org.eclipse.jdt.debug.core.IJavaReferenceType;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.debug.eval.IAstEvaluationEngine;
import org.eclipse.jdt.debug.eval.ICompiledExpression;
import org.eclipse.jdt.debug.eval.IEvaluationListener;
import org.eclipse.jdt.debug.eval.IEvaluationResult;
import org.eclipse.jdt.internal.debug.core.JDIDebugPlugin;
import org.eclipse.jdt.internal.debug.core.JavaDebugUtils;
import org.eclipse.jdt.internal.debug.ui.DebugUIMessages;
import org.eclipse.jdt.internal.debug.ui.DetailFormatter;
import org.eclipse.jdt.internal.debug.ui.IJDIPreferencesConstants;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.JavaDebugOptionsManager;
import org.eclipse.jdt.internal.debug.ui.JavaDetailFormattersManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class JavaDetailFormattersManager
implements IPropertyChangeListener,
IDebugEventSetListener,
ILaunchesListener {
    private static JavaDetailFormattersManager fgDefault;
    private HashMap fDetailFormattersMap;
    private HashMap fCacheMap;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public static JavaDetailFormattersManager getDefault() {
        if (fgDefault == null) {
            fgDefault = new JavaDetailFormattersManager();
        }
        return fgDefault;
    }

    private JavaDetailFormattersManager() {
        this.populateDetailFormattersMap();
        JDIDebugUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)this);
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        DebugUITools.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.fCacheMap = new HashMap();
    }

    private void populateDetailFormattersMap() {
        String[] detailFormattersList = JavaDebugOptionsManager.parseList(JDIDebugUIPlugin.getDefault().getPreferenceStore().getString(IJDIPreferencesConstants.PREF_DETAIL_FORMATTERS_LIST));
        this.fDetailFormattersMap = new HashMap(detailFormattersList.length / 3);
        int i = 0;
        int length = detailFormattersList.length;
        while (i < length) {
            String typeName = detailFormattersList[i++];
            String snippet = detailFormattersList[i++].replace('\u0000', ',');
            boolean enabled = !"0".equals(detailFormattersList[i++]);
            this.fDetailFormattersMap.put(typeName, new DetailFormatter(typeName, snippet, enabled));
        }
    }

    public void computeValueDetail(final IJavaValue objectValue, final IJavaThread thread, final IValueDetailListener listener) {
        Runnable postEventDispatch = new Runnable(){

            public void run() {
                Runnable postEventProcess = new Runnable(this, thread, listener, objectValue){
                    final /* synthetic */ 2 this$1;
                    private final /* synthetic */ IJavaThread val$thread;
                    private final /* synthetic */ IValueDetailListener val$listener;
                    private final /* synthetic */ IJavaValue val$objectValue;
                    {
                        this.this$1 = var1_1;
                        this.val$thread = iJavaThread;
                        this.val$listener = iValueDetailListener;
                        this.val$objectValue = iJavaValue;
                    }

                    public void run() {
                        if (!this.val$thread.isSuspended() && !this.val$thread.isPerformingEvaluation()) {
                            this.val$listener.detailComputed((IValue)this.val$objectValue, DebugUIMessages.JavaDetailFormattersManager_9);
                        } else {
                            this.val$thread.queueRunnable(new Runnable(this, this.val$objectValue, this.val$thread, this.val$listener){
                                final /* synthetic */ 3 this$2;
                                private final /* synthetic */ IJavaValue val$objectValue;
                                private final /* synthetic */ IJavaThread val$thread;
                                private final /* synthetic */ IValueDetailListener val$listener;
                                {
                                    this.this$2 = var1_1;
                                    this.val$objectValue = iJavaValue;
                                    this.val$thread = iJavaThread;
                                    this.val$listener = iValueDetailListener;
                                }

                                public void run() {
                                    JavaDetailFormattersManager.access$1(2.access$0(3.access$0(this.this$2)), this.val$objectValue, this.val$thread, this.val$listener);
                                }
                            });
                        }
                    }

                    static /* synthetic */ 2 access$0(3 var0) {
                        return var0.this$1;
                    }
                };
                JDIDebugUIPlugin.getStandardDisplay().asyncExec(postEventProcess);
            }

            static /* synthetic */ JavaDetailFormattersManager access$0(2 var0) {
                return var0.JavaDetailFormattersManager.this;
            }
        };
        DebugPlugin.getDefault().asyncExec(postEventDispatch);
    }

    private void resolveFormatter(IJavaValue value, IJavaThread thread, IValueDetailListener listener) {
        EvaluationListener evaluationListener = new EvaluationListener(value, thread, listener);
        if (value instanceof IJavaObject) {
            IJavaObject objectValue = (IJavaObject)value;
            try {
                IJavaDebugTarget debugTarget = (IJavaDebugTarget)thread.getDebugTarget();
                Expression expression = this.getCompiledExpression(objectValue, debugTarget, thread);
                if (expression != null) {
                    expression.getEngine().evaluateExpression(expression.getExpression(), objectValue, thread, (IEvaluationListener)evaluationListener, 128, false);
                    return;
                }
            }
            catch (CoreException e) {
                listener.detailComputed((IValue)value, e.toString());
                return;
            }
        }
        try {
            evaluationListener.valueToString(value);
        }
        catch (DebugException e) {
            listener.detailComputed((IValue)value, e.getStatus().getMessage());
        }
    }

    private IJavaProject getJavaProject(IJavaObject javaValue, IJavaThread thread) throws CoreException {
        IJavaProject resourceProject;
        IJavaDebugTarget target;
        IType type = JavaDebugUtils.resolveType((IJavaValue)javaValue);
        if (type != null) {
            return type.getJavaProject();
        }
        IStackFrame stackFrame = null;
        IDebugTarget iDebugTarget = javaValue.getDebugTarget();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.debug.core.IJavaDebugTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((target = (IJavaDebugTarget)iDebugTarget.getAdapter((Class)clazz)) != null && (stackFrame = thread.getTopStackFrame()) != null && !stackFrame.getDebugTarget().equals(target)) {
            stackFrame = null;
        }
        if (stackFrame == null) {
            return null;
        }
        Object sourceElement = JavaDebugUtils.resolveSourceElement((Object)stackFrame, (ILaunch)stackFrame.getLaunch());
        if (!(sourceElement instanceof IJavaElement) && sourceElement instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)sourceElement;
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.jdt.core.IJavaElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            sourceElement = iAdaptable.getAdapter((Class)clazz2);
        }
        IJavaProject project = null;
        if (sourceElement instanceof IJavaElement) {
            project = ((IJavaElement)sourceElement).getJavaProject();
        } else if (sourceElement instanceof IResource && (resourceProject = JavaCore.create((IProject)((IResource)sourceElement).getProject())).exists()) {
            project = resourceProject;
        }
        return project;
    }

    public DetailFormatter getDetailFormatterFromInterface(IJavaClassType type) {
        try {
            IJavaInterfaceType[] inter = type.getAllInterfaces();
            Object formatter = null;
            int i = 0;
            while (i < inter.length) {
                formatter = this.fDetailFormattersMap.get(inter[i].getName());
                if (formatter != null) {
                    return formatter;
                }
                ++i;
            }
            return null;
        }
        catch (DebugException debugException) {
            return null;
        }
    }

    public boolean hasInterfaceDetailFormatter(IJavaType type) {
        if (type instanceof IJavaClassType) {
            return this.getDetailFormatterFromInterface((IJavaClassType)type) != null;
        }
        return false;
    }

    public DetailFormatter getDetailFormatterFromSuperclass(IJavaClassType type) {
        block4: {
            try {
                if (type != null) break block4;
                return null;
            }
            catch (DebugException debugException) {
                return null;
            }
        }
        DetailFormatter formatter = (DetailFormatter)this.fDetailFormattersMap.get(type.getName());
        if (formatter != null && formatter.isEnabled()) {
            return formatter;
        }
        return this.getDetailFormatterFromSuperclass(type.getSuperclass());
    }

    public boolean hasSuperclassDetailFormatter(IJavaType type) {
        if (type instanceof IJavaClassType) {
            return this.getDetailFormatterFromSuperclass((IJavaClassType)type) != null;
        }
        return false;
    }

    public boolean hasAssociatedDetailFormatter(IJavaType type) {
        return this.getAssociatedDetailFormatter(type) != null;
    }

    public DetailFormatter getAssociatedDetailFormatter(IJavaType type) {
        String typeName;
        block5: {
            typeName = "";
            try {
                while (type instanceof IJavaArrayType) {
                    type = ((IJavaArrayType)type).getComponentType();
                }
                if (type instanceof IJavaClassType) {
                    typeName = type.getName();
                    break block5;
                }
                return null;
            }
            catch (DebugException debugException) {
                return null;
            }
        }
        return (DetailFormatter)this.fDetailFormattersMap.get(typeName);
    }

    public void setAssociatedDetailFormatter(DetailFormatter detailFormatter) {
        this.fDetailFormattersMap.put(detailFormatter.getTypeName(), detailFormatter);
        this.savePreference();
    }

    private void savePreference() {
        Collection valuesList = this.fDetailFormattersMap.values();
        String[] values = new String[valuesList.size() * 3];
        int i = 0;
        Iterator iter = valuesList.iterator();
        while (iter.hasNext()) {
            DetailFormatter detailFormatter = (DetailFormatter)iter.next();
            values[i++] = detailFormatter.getTypeName();
            values[i++] = detailFormatter.getSnippet().replace(',', '\u0000');
            String string = values[i++] = detailFormatter.isEnabled() ? "1" : "0";
        }
        String pref = JavaDebugOptionsManager.serializeList(values);
        JDIDebugUIPlugin.getDefault().getPreferenceStore().setValue(IJDIPreferencesConstants.PREF_DETAIL_FORMATTERS_LIST, pref);
        JDIDebugUIPlugin.getDefault().savePluginPreferences();
    }

    private String getDetailFormatter(IJavaClassType type) throws DebugException {
        String snippet = this.getDetailFormatterSuperClass(type);
        if (snippet != null) {
            return snippet;
        }
        IJavaInterfaceType[] allInterfaces = type.getAllInterfaces();
        int i = 0;
        while (i < allInterfaces.length) {
            DetailFormatter detailFormatter = (DetailFormatter)this.fDetailFormattersMap.get(allInterfaces[i].getName());
            if (detailFormatter != null && detailFormatter.isEnabled()) {
                return detailFormatter.getSnippet();
            }
            ++i;
        }
        return null;
    }

    private String getDetailFormatterSuperClass(IJavaClassType type) throws DebugException {
        if (type == null) {
            return null;
        }
        DetailFormatter detailFormatter = (DetailFormatter)this.fDetailFormattersMap.get(type.getName());
        if (detailFormatter != null && detailFormatter.isEnabled()) {
            return detailFormatter.getSnippet();
        }
        return this.getDetailFormatterSuperClass(type.getSuperclass());
    }

    private Expression getCompiledExpression(IJavaObject javaObject, IJavaDebugTarget debugTarget, IJavaThread thread) throws CoreException {
        IJavaType type = javaObject.getJavaType();
        String typeName = type.getName();
        Key key = new Key(typeName, debugTarget);
        if (this.fCacheMap.containsKey(key)) {
            return (Expression)this.fCacheMap.get(key);
        }
        IJavaProject project = this.getJavaProject(javaObject, thread);
        if (project != null) {
            String snippet = null;
            IAstEvaluationEngine evaluationEngine = JDIDebugPlugin.getDefault().getEvaluationEngine(project, debugTarget);
            ICompiledExpression res = null;
            if (type instanceof IJavaClassType) {
                snippet = this.getDetailFormatter((IJavaClassType)type);
            } else if (type instanceof IJavaArrayType) {
                snippet = this.getArraySnippet((IJavaArray)javaObject);
            }
            if (snippet != null) {
                res = evaluationEngine.getCompiledExpression(snippet, javaObject);
            }
            if (res != null) {
                Expression exp = new Expression(res, evaluationEngine);
                this.fCacheMap.put(key, exp);
                return exp;
            }
        }
        return null;
    }

    protected String getArraySnippet(IJavaArray value) throws DebugException {
        if (((IJavaArrayType)value.getJavaType()).getComponentType() instanceof IJavaReferenceType) {
            int maxEntries;
            int length = value.getLength();
            if (length > (maxEntries = JavaDetailFormattersManager.getMaxDetailLength() / 3 + 1)) {
                StringBuffer snippet = new StringBuffer();
                snippet.append("Object[] shorter = new Object[");
                snippet.append(maxEntries);
                snippet.append("]; System.arraycopy(this, 0, shorter, 0, ");
                snippet.append(maxEntries);
                snippet.append("); ");
                snippet.append("return java.util.Arrays.asList(shorter).toString();");
                return snippet.toString();
            }
            return "java.util.Arrays.asList(this).toString()";
        }
        return null;
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (property.equals(IJDIPreferencesConstants.PREF_DETAIL_FORMATTERS_LIST) || property.equals(IJDIPreferencesConstants.PREF_SHOW_DETAILS) || property.equals(IDebugUIConstants.PREF_MAX_DETAIL_LENGTH)) {
            this.populateDetailFormattersMap();
            this.fCacheMap.clear();
            IAdaptable selected = DebugUITools.getDebugContext();
            if (selected != null) {
                IJavaStackFrame frame;
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = class$2 = Class.forName("org.eclipse.jdt.debug.core.IJavaStackFrame");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((frame = (IJavaStackFrame)selected.getAdapter((Class)clazz)) != null) {
                    DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{new DebugEvent((Object)frame, 16)});
                }
            }
        }
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            DebugEvent event = events[i];
            if (event.getSource() instanceof IJavaDebugTarget && event.getKind() == 8) {
                this.deleteCacheForTarget((IJavaDebugTarget)event.getSource());
            }
            ++i;
        }
    }

    public void launchesAdded(ILaunch[] launches) {
    }

    public void launchesChanged(ILaunch[] launches) {
    }

    public void launchesRemoved(ILaunch[] launches) {
        int i = 0;
        while (i < launches.length) {
            ILaunch launch = launches[i];
            IDebugTarget[] debugTargets = launch.getDebugTargets();
            int j = 0;
            while (j < debugTargets.length) {
                if (debugTargets[j] instanceof IJavaDebugTarget) {
                    this.deleteCacheForTarget((IJavaDebugTarget)debugTargets[j]);
                }
                ++j;
            }
            ++i;
        }
    }

    private synchronized void deleteCacheForTarget(IJavaDebugTarget debugTarget) {
        Iterator iter = this.fCacheMap.keySet().iterator();
        while (iter.hasNext()) {
            Key key = (Key)iter.next();
            if (key.fDebugTarget != debugTarget) continue;
            iter.remove();
        }
    }

    public void removeAssociatedDetailFormatter(DetailFormatter detailFormatter) {
        this.fDetailFormattersMap.remove(detailFormatter.getTypeName());
        this.savePreference();
    }

    private static int getMaxDetailLength() {
        return DebugUITools.getPreferenceStore().getInt(IDebugUIConstants.PREF_MAX_DETAIL_LENGTH);
    }

    static /* synthetic */ void access$1(JavaDetailFormattersManager javaDetailFormattersManager, IJavaValue iJavaValue, IJavaThread iJavaThread, IValueDetailListener iValueDetailListener) {
        javaDetailFormattersManager.resolveFormatter(iJavaValue, iJavaThread, iValueDetailListener);
    }

    private static class Key {
        private String fTypeName;
        private IJavaDebugTarget fDebugTarget;

        Key(String typeName, IJavaDebugTarget debugTarget) {
            this.fTypeName = typeName;
            this.fDebugTarget = debugTarget;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Key) {
                Key key = (Key)obj;
                return this.fTypeName != null && this.fDebugTarget != null && this.fTypeName.equals(key.fTypeName) && this.fDebugTarget.equals(key.fDebugTarget);
            }
            return false;
        }

        public int hashCode() {
            return this.fTypeName.hashCode() / 2 + this.fDebugTarget.hashCode() / 2;
        }
    }

    private static class Expression {
        private ICompiledExpression fExpression;
        private IAstEvaluationEngine fEngine;

        Expression(ICompiledExpression expression, IAstEvaluationEngine engine) {
            this.fExpression = expression;
            this.fEngine = engine;
        }

        public ICompiledExpression getExpression() {
            return this.fExpression;
        }

        public IAstEvaluationEngine getEngine() {
            return this.fEngine;
        }
    }

    private static class EvaluationListener
    implements IEvaluationListener {
        private static final String fgToString = "toString";
        private static final String fgToStringSignature = "()Ljava/lang/String;";
        private static final String STRING_SIGNATURE = "Ljava/lang/String;";
        private IJavaValue fValue;
        private IValueDetailListener fListener;
        private IJavaThread fThread;

        public EvaluationListener(IJavaValue value, IJavaThread thread, IValueDetailListener listener) {
            this.fValue = value;
            this.fThread = thread;
            this.fListener = listener;
        }

        public void evaluationComplete(IEvaluationResult result) {
            if (result.hasErrors()) {
                StringBuffer error = new StringBuffer(DebugUIMessages.JavaDetailFormattersManager_Detail_formatter_error___1);
                DebugException exception = result.getException();
                if (exception != null) {
                    Throwable throwable = exception.getStatus().getException();
                    error.append("\n\t\t");
                    if (throwable instanceof InvocationException) {
                        error.append(MessageFormat.format((String)DebugUIMessages.JavaDetailFormattersManager_An_exception_occurred___0__3, (Object[])new String[]{((InvocationException)throwable).exception().referenceType().name()}));
                    } else {
                        error.append(exception.getStatus().getMessage());
                    }
                } else {
                    String[] errors = result.getErrorMessages();
                    int i = 0;
                    int length = errors.length;
                    while (i < length) {
                        error.append("\n\t\t").append(errors[i]);
                        ++i;
                    }
                }
                this.fListener.detailComputed((IValue)this.fValue, error.toString());
            } else {
                try {
                    this.valueToString(result.getValue());
                }
                catch (DebugException e) {
                    this.fListener.detailComputed((IValue)this.fValue, e.getStatus().getMessage());
                }
            }
        }

        public void valueToString(IJavaValue objectValue) throws DebugException {
            String nonEvalResult = null;
            StringBuffer result = null;
            if (objectValue.getSignature() == null) {
                nonEvalResult = DebugUIMessages.JavaDetailFormattersManager_null;
            } else if (objectValue instanceof IJavaPrimitiveValue) {
                result = new StringBuffer();
                this.appendJDIPrimitiveValueString(result, objectValue);
            } else if (this.fThread == null || !this.fThread.isSuspended()) {
                result = new StringBuffer();
                result.append(DebugUIMessages.JavaDetailFormattersManager_no_suspended_threads);
                this.appendJDIValueString(result, objectValue);
            } else if (objectValue instanceof IJavaObject && STRING_SIGNATURE.equals(objectValue.getSignature())) {
                result = new StringBuffer();
                this.appendJDIValueString(result, objectValue);
            }
            if (result != null) {
                nonEvalResult = result.toString();
            }
            if (nonEvalResult != null) {
                this.fListener.detailComputed((IValue)this.fValue, nonEvalResult);
                return;
            }
            IEvaluationRunnable eval = new IEvaluationRunnable(this, objectValue){
                final /* synthetic */ EvaluationListener this$1;
                private final /* synthetic */ IJavaValue val$objectValue;
                {
                    this.this$1 = evaluationListener;
                    this.val$objectValue = iJavaValue;
                }

                public void run(IJavaThread thread, IProgressMonitor monitor) throws DebugException {
                    StringBuffer buf = new StringBuffer();
                    if (this.val$objectValue instanceof IJavaArray) {
                        this.this$1.appendArrayDetail(buf, (IJavaArray)this.val$objectValue);
                    } else if (this.val$objectValue instanceof IJavaObject) {
                        this.this$1.appendObjectDetail(buf, (IJavaObject)this.val$objectValue);
                    } else {
                        this.this$1.appendJDIValueString(buf, this.val$objectValue);
                    }
                    EvaluationListener.access$0(this.this$1).detailComputed((IValue)EvaluationListener.access$1(this.this$1), buf.toString());
                }
            };
            this.fThread.runEvaluation(eval, null, 128, false);
        }

        protected void appendArrayDetail(StringBuffer result, IJavaArray arrayValue) throws DebugException {
            result.append('[');
            boolean partial = false;
            IJavaValue[] arrayValues = null;
            int maxLength = JavaDetailFormattersManager.getMaxDetailLength();
            int maxEntries = maxLength / 3 + 1;
            int length = -1;
            try {
                length = arrayValue.getLength();
                if (length > maxEntries) {
                    partial = true;
                    IVariable[] variables = arrayValue.getVariables(0, maxEntries);
                    arrayValues = new IJavaValue[variables.length];
                    int i = 0;
                    while (i < variables.length) {
                        arrayValues[i] = (IJavaValue)variables[i].getValue();
                        ++i;
                    }
                } else {
                    arrayValues = arrayValue.getValues();
                }
            }
            catch (DebugException de) {
                JDIDebugUIPlugin.log(de);
                result.append(de.getStatus().getMessage());
                return;
            }
            int i = 0;
            while (i < arrayValues.length) {
                IJavaValue value = arrayValues[i];
                if (value instanceof IJavaArray) {
                    this.appendArrayDetail(result, (IJavaArray)value);
                } else if (value instanceof IJavaObject) {
                    this.appendObjectDetail(result, (IJavaObject)value);
                } else {
                    this.appendJDIValueString(result, value);
                }
                if (i < arrayValues.length - 1) {
                    result.append(',');
                    result.append(' ');
                }
                if (partial && result.length() > maxLength) break;
                ++i;
            }
            if (!partial) {
                result.append(']');
            }
        }

        protected void appendJDIPrimitiveValueString(StringBuffer result, IJavaValue value) throws DebugException {
            result.append(value.getValueString());
        }

        protected void appendJDIValueString(StringBuffer result, IJavaValue value) throws DebugException {
            result.append(value.getValueString());
        }

        protected void appendObjectDetail(StringBuffer result, IJavaObject objectValue) throws DebugException {
            if (STRING_SIGNATURE.equals(objectValue.getSignature())) {
                this.appendJDIValueString(result, (IJavaValue)objectValue);
            } else {
                IJavaValue toStringValue = objectValue.sendMessage(fgToString, fgToStringSignature, null, this.fThread, false);
                if (toStringValue == null) {
                    result.append(DebugUIMessages.JavaDetailFormattersManager__unknown_);
                } else {
                    this.appendJDIValueString(result, toStringValue);
                }
            }
        }

        static /* synthetic */ IValueDetailListener access$0(EvaluationListener evaluationListener) {
            return evaluationListener.fListener;
        }

        static /* synthetic */ IJavaValue access$1(EvaluationListener evaluationListener) {
            return evaluationListener.fValue;
        }
    }
}

