/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.views;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.cdt.debug.internal.ui.views.DebugViewDecoratingLabelProvider;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class DebugViewLabelDecorator
extends LabelProvider
implements ILabelDecorator,
IDebugEventSetListener {
    private IDebugModelPresentation fPresentation;
    protected DebugViewDecoratingLabelProvider fLabelProvider;
    protected LabelJob fNextJob = null;

    public DebugViewLabelDecorator(IDebugModelPresentation presentation) {
        this.fPresentation = presentation;
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
    }

    public void setLabelProvider(DebugViewDecoratingLabelProvider labelProvider) {
        this.fLabelProvider = labelProvider;
    }

    public Image decorateImage(Image image, Object element) {
        return image;
    }

    public String decorateText(String text, Object element) {
        this.computeText(element);
        return text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeText(Object element) {
        DebugViewLabelDecorator debugViewLabelDecorator = this;
        synchronized (debugViewLabelDecorator) {
            if (this.fNextJob == null) {
                this.fNextJob = new LabelJob("Debug", this.fPresentation);
            }
            this.fNextJob.computeText(element);
        }
    }

    public void labelsComputed(final Object[] computedElements) {
        CDebugUIPlugin.getStandardDisplay().asyncExec(new Runnable(){

            public void run() {
                DebugViewLabelDecorator.this.fLabelProvider.labelsComputed(computedElements);
            }
        });
    }

    public void handleDebugEvents(DebugEvent[] events) {
    }

    public void dispose() {
        super.dispose();
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
    }

    protected class LabelJob
    extends Job
    implements ISchedulingRule {
        private Vector fElementQueue;
        private IDebugModelPresentation fJobPresentation;

        public LabelJob(String name, IDebugModelPresentation presentation) {
            super(name);
            this.fElementQueue = new Vector();
            this.fJobPresentation = presentation;
            this.setSystem(true);
        }

        public void computeText(Object element) {
            if (!this.fElementQueue.contains(element)) {
                this.fElementQueue.add(element);
            }
            this.schedule();
        }

        public IStatus run(IProgressMonitor monitor) {
            int numElements = this.fElementQueue.size();
            monitor.beginTask(MessageFormat.format("Fetching {0} labels", Integer.toString(numElements)), numElements);
            while (!this.fElementQueue.isEmpty() && !monitor.isCanceled()) {
                StringBuffer message = new StringBuffer(MessageFormat.format("Fetching {0} labels", Integer.toString(this.fElementQueue.size())));
                message.append(MessageFormat.format(" ({0} pending)", Integer.toString(DebugViewLabelDecorator.this.fNextJob.fElementQueue.size())));
                monitor.setTaskName(message.toString());
                int blockSize = 10;
                if (this.fElementQueue.size() < blockSize) {
                    blockSize = this.fElementQueue.size();
                }
                ArrayList computedElements = new ArrayList();
                int i = 0;
                while (i < blockSize) {
                    Object element = this.fElementQueue.remove(0);
                    if (element == null) break;
                    DebugViewLabelDecorator.this.fLabelProvider.textComputed(element, this.fJobPresentation.getText(element));
                    computedElements.add(element);
                    ++i;
                }
                DebugViewLabelDecorator.this.labelsComputed(computedElements.toArray());
                monitor.worked(computedElements.size());
            }
            monitor.done();
            return Status.OK_STATUS;
        }

        public boolean contains(ISchedulingRule rule) {
            return rule instanceof LabelJob && this.fJobPresentation == ((LabelJob)rule).fJobPresentation;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule instanceof LabelJob && this.fJobPresentation == ((LabelJob)rule).fJobPresentation;
        }
    }
}

