/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.browser;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.browser.ITypeSearchScope;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfoProvider;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class TypeSearchScope
implements ITypeSearchScope {
    private Set fPathSet = new HashSet();
    private Set fContainerSet = new HashSet();
    private Set fProjectSet = new HashSet();
    private Set fEnclosingProjectSet = new HashSet();
    private boolean fWorkspaceScope = false;
    private ICProject[] fAllProjects = null;
    private ICProject[] fProjects = null;
    private IPath[] fContainerPaths = null;

    public TypeSearchScope() {
    }

    public TypeSearchScope(boolean workspaceScope) {
        this.fWorkspaceScope = workspaceScope;
    }

    public TypeSearchScope(ITypeSearchScope scope) {
        this.add(scope);
    }

    public TypeSearchScope(ICProject project) {
        this.add(project);
    }

    public Collection pathSet() {
        return this.fPathSet;
    }

    public Collection containerSet() {
        return this.fContainerSet;
    }

    public Collection projectSet() {
        return this.fProjectSet;
    }

    public Collection enclosingProjectSet() {
        return this.fEnclosingProjectSet;
    }

    public boolean encloses(ITypeSearchScope scope) {
        IPath path;
        Iterator i;
        if (this.isWorkspaceScope()) {
            return true;
        }
        if (!scope.pathSet().isEmpty()) {
            i = scope.pathSet().iterator();
            while (i.hasNext()) {
                path = (IPath)i.next();
                if (this.encloses(path)) continue;
                return false;
            }
        }
        if (!scope.containerSet().isEmpty()) {
            i = scope.containerSet().iterator();
            while (i.hasNext()) {
                path = (IPath)i.next();
                if (this.encloses(path)) continue;
                return false;
            }
        }
        if (!scope.projectSet().isEmpty()) {
            i = scope.projectSet().iterator();
            while (i.hasNext()) {
                ICProject project = (ICProject)i.next();
                if (this.encloses(project)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean encloses(ICProject project) {
        if (this.isWorkspaceScope()) {
            return true;
        }
        return this.fProjectSet.contains(project);
    }

    public boolean encloses(IPath path) {
        if (this.isWorkspaceScope()) {
            return true;
        }
        if (this.fPathSet.contains(path)) {
            return true;
        }
        if (this.fContainerSet.contains(path)) {
            return true;
        }
        if (this.fContainerPaths == null) {
            this.fContainerPaths = this.fContainerSet.toArray(new IPath[this.fContainerSet.size()]);
        }
        int i = 0;
        while (i < this.fContainerPaths.length) {
            if (this.fContainerPaths[i].isPrefixOf(path)) {
                return true;
            }
            ++i;
        }
        if (this.fProjectSet.contains(path)) {
            return true;
        }
        if (this.fProjects == null) {
            this.fProjects = this.fProjectSet.toArray(new ICProject[this.fProjectSet.size()]);
        }
        i = 0;
        while (i < this.fProjects.length) {
            if (TypeSearchScope.projectContainsPath(this.fProjects[i], path, false)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean encloses(String path) {
        return this.encloses((IPath)new Path(path));
    }

    public boolean encloses(ICElement element) {
        return this.encloses(element.getPath());
    }

    public boolean encloses(IWorkingCopy workingCopy) {
        return this.encloses(workingCopy.getOriginalElement().getPath());
    }

    public ICProject[] getEnclosingProjects() {
        if (this.isWorkspaceScope()) {
            return TypeSearchScope.getAllProjects();
        }
        return this.fEnclosingProjectSet.toArray(new ICProject[this.fEnclosingProjectSet.size()]);
    }

    private static boolean projectContainsPath(ICProject project, IPath path, boolean checkIncludePaths) {
        IPath[] includePaths;
        IPath projectPath = project.getProject().getFullPath();
        if (projectPath.isPrefixOf(path)) {
            return true;
        }
        if (checkIncludePaths && (includePaths = TypeSearchScope.getIncludePaths(project)) != null) {
            int i = 0;
            while (i < includePaths.length) {
                IPath include = includePaths[i];
                if (include.isPrefixOf(path) || include.equals((Object)path)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private static IPath[] getIncludePaths(ICProject project) {
        String[] includes;
        IScannerInfo info;
        IScannerInfoProvider provider = CCorePlugin.getDefault().getScannerInfoProvider(project.getProject());
        if (provider != null && (info = provider.getScannerInformation((IResource)project.getProject())) != null && (includes = info.getIncludePaths()) != null && includes.length > 0) {
            IPath[] includePaths = new IPath[includes.length];
            int i = 0;
            while (i < includes.length) {
                includePaths[i] = new Path(includes[i]);
                ++i;
            }
            return includePaths;
        }
        return null;
    }

    private static ICProject[] getAllProjects() {
        ICProject[] projects = TypeSearchScope.getCProjects();
        if (projects == null) {
            projects = new ICProject[]{};
        }
        return projects;
    }

    private static ICProject[] getCProjects() {
        try {
            return CoreModel.getDefault().getCModel().getCProjects();
        }
        catch (CModelException e) {
            CCorePlugin.log((Throwable)((Object)e));
            return new ICProject[0];
        }
    }

    public boolean isPathScope() {
        return !this.fPathSet.isEmpty();
    }

    public boolean isProjectScope() {
        return !this.fProjectSet.isEmpty();
    }

    public boolean isWorkspaceScope() {
        return this.fWorkspaceScope;
    }

    public boolean isEmpty() {
        return !this.isWorkspaceScope() && this.fPathSet.isEmpty() && this.fContainerSet.isEmpty() && this.fProjectSet.isEmpty();
    }

    public void add(IWorkingCopy workingCopy) {
        IPath path = workingCopy.getOriginalElement().getPath();
        ICProject cProject = workingCopy.getCProject();
        this.fPathSet.add(path);
        this.addEnclosingProject(cProject);
    }

    public void add(IPath path, boolean addSubfolders, ICProject enclosingProject) {
        if (addSubfolders) {
            this.fContainerSet.add(path);
            this.fContainerPaths = null;
        } else {
            this.fPathSet.add(path);
        }
        if (enclosingProject != null) {
            this.addEnclosingProject(enclosingProject);
        } else {
            if (this.fAllProjects == null) {
                this.fAllProjects = TypeSearchScope.getAllProjects();
            }
            int i = 0;
            while (i < this.fAllProjects.length) {
                if (TypeSearchScope.projectContainsPath(this.fAllProjects[i], path, false)) {
                    this.addEnclosingProject(this.fAllProjects[i]);
                    break;
                }
                ++i;
            }
        }
    }

    public void add(ICProject project) {
        this.fProjectSet.add(project);
        this.fProjects = null;
        this.fAllProjects = null;
        this.addEnclosingProject(project);
    }

    private void addEnclosingProject(ICProject project) {
        this.fEnclosingProjectSet.add(project);
    }

    public void addWorkspace() {
        this.fWorkspaceScope = true;
        this.fProjects = null;
        this.fAllProjects = null;
    }

    public void add(ICElement elem) {
        if (elem == null) {
            return;
        }
        switch (elem.getElementType()) {
            case 10: {
                this.addWorkspace();
                break;
            }
            case 11: {
                ICProject project = (ICProject)elem;
                this.add(project);
                break;
            }
            case 12: {
                ICProject project = elem.getCProject();
                this.add(elem.getPath(), true, project);
                break;
            }
            case 60: {
                ICProject project = elem.getCProject();
                this.add(elem.getPath(), false, project);
                break;
            }
            case 61: 
            case 63: 
            case 65: 
            case 67: 
            case 69: 
            case 75: 
            case 80: 
            case 83: {
                ICProject project = elem.getCProject();
                this.add(elem.getPath(), false, project);
            }
        }
    }

    public void add(ITypeSearchScope scope) {
        this.fPathSet.addAll(scope.pathSet());
        this.fContainerSet.addAll(scope.containerSet());
        this.fProjectSet.addAll(scope.projectSet());
        this.fEnclosingProjectSet.addAll(scope.enclosingProjectSet());
        this.fProjects = null;
        this.fAllProjects = null;
        this.fContainerPaths = null;
        this.fWorkspaceScope |= scope.isWorkspaceScope();
    }

    public void clear() {
        this.fPathSet.clear();
        this.fContainerSet.clear();
        this.fProjectSet.clear();
        this.fEnclosingProjectSet.clear();
        this.fWorkspaceScope = false;
        this.fProjects = null;
        this.fAllProjects = null;
        this.fContainerPaths = null;
    }
}

