/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNameOwner;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTNode;
import org.eclipse.cdt.internal.core.dom.parser.c.CVisitor;

public class CASTName
extends CASTNode
implements IASTName {
    private final char[] name;
    private static final char[] EMPTY_CHAR_ARRAY = new char[0];
    private static final String EMPTY_STRING = "";
    private IBinding binding = null;

    public CASTName(char[] name) {
        this.name = name;
    }

    public CASTName() {
        this.name = EMPTY_CHAR_ARRAY;
    }

    public IBinding resolveBinding() {
        if (this.binding == null) {
            CVisitor.createBinding(this);
        }
        return this.binding;
    }

    public IBinding getBinding() {
        return this.binding;
    }

    public IBinding[] resolvePrefix() {
        return CVisitor.prefixLookup(this);
    }

    public void setBinding(IBinding binding) {
        this.binding = binding;
    }

    public String toString() {
        if (this.name == EMPTY_CHAR_ARRAY) {
            return EMPTY_STRING;
        }
        return new String(this.name);
    }

    public char[] toCharArray() {
        return this.name;
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitNames) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (action.shouldVisitNames) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    public boolean isDeclaration() {
        IASTNode parent = this.getParent();
        if (parent instanceof IASTNameOwner) {
            int role = ((IASTNameOwner)((Object)parent)).getRoleForName(this);
            switch (role) {
                case 1: 
                case 3: {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public boolean isReference() {
        IASTNode parent = this.getParent();
        if (parent instanceof IASTNameOwner) {
            int role = ((IASTNameOwner)((Object)parent)).getRoleForName(this);
            switch (role) {
                case 1: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public boolean isDefinition() {
        IASTNode parent = this.getParent();
        if (parent instanceof IASTNameOwner) {
            int role = ((IASTNameOwner)((Object)parent)).getRoleForName(this);
            switch (role) {
                case 2: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }
}

