/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IBuffer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IContributedModelBuilder;
import org.eclipse.cdt.core.model.IInclude;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.INamespace;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.IProblemRequestor;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IUsing;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.core.model.LanguageManager;
import org.eclipse.cdt.internal.core.model.BufferManager;
import org.eclipse.cdt.internal.core.model.CElement;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.cdt.internal.core.model.CModelBuilder;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.CreateIncludeOperation;
import org.eclipse.cdt.internal.core.model.CreateNamespaceOperation;
import org.eclipse.cdt.internal.core.model.CreateWorkingCopyOperation;
import org.eclipse.cdt.internal.core.model.IBufferFactory;
import org.eclipse.cdt.internal.core.model.IDebugLogConstants;
import org.eclipse.cdt.internal.core.model.Openable;
import org.eclipse.cdt.internal.core.model.OpenableInfo;
import org.eclipse.cdt.internal.core.model.SourceManipulationInfo;
import org.eclipse.cdt.internal.core.model.TranslationUnitInfo;
import org.eclipse.cdt.internal.core.model.Util;
import org.eclipse.cdt.internal.core.model.WorkingCopy;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;

public class TranslationUnit
extends Openable
implements ITranslationUnit {
    IPath location = null;
    String contentTypeId;
    ILanguage language;
    protected IProblemRequestor problemRequestor;
    SourceManipulationInfo sourceManipulationInfo = null;

    public TranslationUnit(ICElement parent, IFile file, String idType) {
        super(parent, (IResource)file, 60);
        this.setContentTypeID(idType);
    }

    public TranslationUnit(ICElement parent, IPath path, String idType) {
        super(parent, path, 60);
        this.setContentTypeID(idType);
    }

    public TranslationUnit(ICElement parent, IResource res, String name, String idType) {
        super(parent, res, name, 60);
        this.setContentTypeID(idType);
    }

    public ITranslationUnit getTranslationUnit() {
        return this;
    }

    public IInclude createInclude(String includeName, boolean isStd, ICElement sibling, IProgressMonitor monitor) throws CModelException {
        CreateIncludeOperation op = new CreateIncludeOperation(includeName, isStd, this);
        if (sibling != null) {
            op.createBefore(sibling);
        }
        op.runOperation(monitor);
        return this.getInclude(includeName);
    }

    public IUsing createUsing(String usingName, boolean isDirective, ICElement sibling, IProgressMonitor monitor) throws CModelException {
        CreateIncludeOperation op = new CreateIncludeOperation(usingName, isDirective, this);
        if (sibling != null) {
            op.createBefore(sibling);
        }
        op.runOperation(monitor);
        return this.getUsing(usingName);
    }

    public INamespace createNamespace(String namespace, ICElement sibling, IProgressMonitor monitor) throws CModelException {
        CreateNamespaceOperation op = new CreateNamespaceOperation(namespace, this);
        if (sibling != null) {
            op.createBefore(sibling);
        }
        op.runOperation(monitor);
        return this.getNamespace(namespace);
    }

    public ICElement getElementAtLine(int line) throws CModelException {
        ICElement[] celements = this.getChildren();
        int i = 0;
        while (i < celements.length) {
            ISourceRange range = ((ISourceReference)((Object)celements[i])).getSourceRange();
            int startLine = range.getStartLine();
            int endLine = range.getEndLine();
            if (line >= startLine && line <= endLine) {
                return celements[i];
            }
            ++i;
        }
        return null;
    }

    public ICElement getElementAtOffset(int pos) throws CModelException {
        ICElement e = this.getSourceElementAtOffset(pos);
        if (e == this) {
            return null;
        }
        return e;
    }

    public ICElement[] getElementsAtOffset(int pos) throws CModelException {
        ICElement[] e = this.getSourceElementsAtOffset(pos);
        if (e.length == 1 && e[0] == this) {
            return CElement.NO_ELEMENTS;
        }
        return e;
    }

    public ICElement getElement(String name) {
        if (name == null || name.length() == 0) {
            return null;
        }
        try {
            ICElement[] celements = this.getChildren();
            int i = 0;
            while (i < celements.length) {
                if (name.equals(celements[i].getElementName())) {
                    return celements[i];
                }
                ++i;
            }
        }
        catch (CModelException cModelException) {}
        String[] names = name.split("::");
        ICElement current = this;
        int j = 0;
        while (j < names.length) {
            if (current instanceof IParent) {
                try {
                    ICElement[] celements = ((IParent)((Object)current)).getChildren();
                    current = null;
                    int i = 0;
                    while (i < celements.length) {
                        if (names[j].equals(celements[i].getElementName())) {
                            current = celements[i];
                            break;
                        }
                        ++i;
                    }
                }
                catch (CModelException cModelException) {
                    current = null;
                }
            } else {
                current = null;
            }
            ++j;
        }
        return current;
    }

    public IInclude getInclude(String name) {
        try {
            ICElement[] celements = this.getChildren();
            int i = 0;
            while (i < celements.length) {
                if (celements[i].getElementType() == 75 && name.equals(celements[i].getElementName())) {
                    return (IInclude)celements[i];
                }
                ++i;
            }
        }
        catch (CModelException cModelException) {}
        return null;
    }

    public IInclude[] getIncludes() throws CModelException {
        ICElement[] celements = this.getChildren();
        ArrayList<ICElement> aList = new ArrayList<ICElement>();
        int i = 0;
        while (i < celements.length) {
            if (celements[i].getElementType() == 75) {
                aList.add(celements[i]);
            }
            ++i;
        }
        return aList.toArray(new IInclude[0]);
    }

    public IUsing getUsing(String name) {
        try {
            ICElement[] celements = this.getChildren();
            int i = 0;
            while (i < celements.length) {
                if (celements[i].getElementType() == 62 && name.equals(celements[i].getElementName())) {
                    return (IUsing)celements[i];
                }
                ++i;
            }
        }
        catch (CModelException cModelException) {}
        return null;
    }

    public IUsing[] getUsings() throws CModelException {
        ICElement[] celements = this.getChildren();
        ArrayList<ICElement> aList = new ArrayList<ICElement>();
        int i = 0;
        while (i < celements.length) {
            if (celements[i].getElementType() == 62) {
                aList.add(celements[i]);
            }
            ++i;
        }
        return aList.toArray(new IUsing[0]);
    }

    public INamespace getNamespace(String name) {
        try {
            String[] names = name.split("::");
            ICElement current = this;
            int j = 0;
            while (j < names.length) {
                if (current instanceof IParent) {
                    ICElement[] celements = ((IParent)((Object)current)).getChildren();
                    current = null;
                    int i = 0;
                    while (i < celements.length) {
                        if (celements[i].getElementType() == 61 && name.equals(celements[i].getElementName())) {
                            current = celements[i];
                            break;
                        }
                        ++i;
                    }
                } else {
                    current = null;
                }
                ++j;
            }
            if (current instanceof INamespace) {
                return (INamespace)current;
            }
        }
        catch (CModelException cModelException) {}
        return null;
    }

    public INamespace[] getNamespaces() throws CModelException {
        ICElement[] celements = this.getChildren();
        ArrayList<ICElement> aList = new ArrayList<ICElement>();
        int i = 0;
        while (i < celements.length) {
            if (celements[i].getElementType() == 61) {
                aList.add(celements[i]);
            }
            ++i;
        }
        return aList.toArray(new INamespace[0]);
    }

    public void setLocation(IPath loc) {
        this.location = loc;
    }

    public IPath getLocation() {
        if (this.location == null) {
            IFile file = this.getFile();
            if (file != null) {
                this.location = file.getLocation();
            } else {
                return this.getPath();
            }
        }
        return this.location;
    }

    public IFile getFile() {
        IResource res = this.getResource();
        if (res instanceof IFile) {
            return (IFile)res;
        }
        return null;
    }

    public void copy(ICElement container, ICElement sibling, String rename, boolean force, IProgressMonitor monitor) throws CModelException {
        this.getSourceManipulationInfo().copy(container, sibling, rename, force, monitor);
    }

    public void delete(boolean force, IProgressMonitor monitor) throws CModelException {
        this.getSourceManipulationInfo().delete(force, monitor);
    }

    public void move(ICElement container, ICElement sibling, String rename, boolean force, IProgressMonitor monitor) throws CModelException {
        this.getSourceManipulationInfo().move(container, sibling, rename, force, monitor);
    }

    public void rename(String name, boolean force, IProgressMonitor monitor) throws CModelException {
        this.getSourceManipulationInfo().rename(name, force, monitor);
    }

    public String getSource() throws CModelException {
        return this.getSourceManipulationInfo().getSource();
    }

    public ISourceRange getSourceRange() throws CModelException {
        return this.getSourceManipulationInfo().getSourceRange();
    }

    protected TranslationUnitInfo getTranslationUnitInfo() throws CModelException {
        return (TranslationUnitInfo)this.getElementInfo();
    }

    protected SourceManipulationInfo getSourceManipulationInfo() {
        if (this.sourceManipulationInfo == null) {
            this.sourceManipulationInfo = new SourceManipulationInfo(this);
        }
        return this.sourceManipulationInfo;
    }

    protected CElementInfo createElementInfo() {
        return new TranslationUnitInfo(this);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ITranslationUnit)) {
            return false;
        }
        return super.equals(o) && !((ITranslationUnit)o).isWorkingCopy();
    }

    public IWorkingCopy findSharedWorkingCopy(IBufferFactory factory) {
        Map sharedWorkingCopies;
        Map perFactoryWorkingCopies;
        if (factory == null) {
            factory = BufferManager.getDefaultBufferManager();
        }
        if ((perFactoryWorkingCopies = (Map)(sharedWorkingCopies = CModelManager.getDefault().sharedWorkingCopies).get(factory)) == null) {
            return null;
        }
        return (WorkingCopy)perFactoryWorkingCopies.get(this);
    }

    private void getNewElements(Map mapping, CElement element) {
        CElementInfo info = null;
        try {
            info = element.getElementInfo();
        }
        catch (CModelException cModelException) {}
        if (info != null && element instanceof IParent) {
            ICElement[] children = info.getChildren();
            int size = children.length;
            int i = 0;
            while (i < size) {
                CElement child = (CElement)children[i];
                this.getNewElements(mapping, child);
                ++i;
            }
        }
        mapping.put(element, info);
    }

    protected boolean buildStructure(OpenableInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws CModelException {
        ITranslationUnit original;
        IResource r;
        TranslationUnitInfo unitInfo = (TranslationUnitInfo)info;
        CModelManager.getDefault().removeChildrenInfo(this);
        this.parse(newElements);
        if (this.isWorkingCopy() && (r = (original = ((IWorkingCopy)((Object)this)).getOriginalElement()).getResource()) != null && r instanceof IFile) {
            unitInfo.fTimestamp = ((IFile)r).getModificationStamp();
        }
        return unitInfo.isStructureKnown();
    }

    public char[] getContents() {
        try {
            IBuffer buffer = this.getBuffer();
            return buffer == null ? null : buffer.getCharacters();
        }
        catch (CModelException cModelException) {
            return new char[0];
        }
    }

    public IWorkingCopy getSharedWorkingCopy(IProgressMonitor monitor, IBufferFactory factory) throws CModelException {
        return this.getSharedWorkingCopy(monitor, factory, null);
    }

    public IWorkingCopy getSharedWorkingCopy(IProgressMonitor monitor, IBufferFactory factory, IProblemRequestor requestor) throws CModelException {
        WorkingCopy workingCopy;
        if (factory == null) {
            factory = BufferManager.getDefaultBufferManager();
        }
        CModelManager manager = CModelManager.getDefault();
        Map sharedWorkingCopies = manager.sharedWorkingCopies;
        HashMap perFactoryWorkingCopies = (HashMap)sharedWorkingCopies.get(factory);
        if (perFactoryWorkingCopies == null) {
            perFactoryWorkingCopies = new HashMap();
            sharedWorkingCopies.put(factory, perFactoryWorkingCopies);
        }
        if ((workingCopy = (WorkingCopy)perFactoryWorkingCopies.get(this)) != null) {
            ++workingCopy.useCount;
            return workingCopy;
        }
        CreateWorkingCopyOperation op = new CreateWorkingCopyOperation(this, perFactoryWorkingCopies, factory, requestor);
        op.runOperation(monitor);
        return (IWorkingCopy)op.getResultElements()[0];
    }

    public IWorkingCopy getWorkingCopy() throws CModelException {
        return this.getWorkingCopy(null, null);
    }

    public IWorkingCopy getWorkingCopy(IProgressMonitor monitor, IBufferFactory factory) throws CModelException {
        WorkingCopy workingCopy = new WorkingCopy(this.getParent(), this.getFile(), this.getContentTypeId(), factory);
        workingCopy.open(monitor);
        return workingCopy;
    }

    protected boolean hasBuffer() {
        return true;
    }

    protected void openParent(Object childInfo, Map newElements, IProgressMonitor pm) throws CModelException {
        block2: {
            try {
                super.openParent(childInfo, newElements, pm);
            }
            catch (CModelException e) {
                if (this.isWorkingCopy()) break block2;
                throw e;
            }
        }
    }

    public boolean isConsistent() throws CModelException {
        return CModelManager.getDefault().getElementsOutOfSynchWithBuffers().get(this) == null;
    }

    protected boolean isSourceElement() {
        return true;
    }

    public boolean isWorkingCopy() {
        return false;
    }

    protected IBuffer openBuffer(IProgressMonitor pm) throws CModelException {
        IResource file;
        BufferManager bufManager = this.getBufferManager();
        IBuffer buffer = this.getBufferFactory().createBuffer(this);
        if (buffer == null) {
            return null;
        }
        if (buffer.getCharacters() == null && (file = this.getResource()) != null && file.getType() == 1) {
            buffer.setContents(Util.getResourceContentsAsCharArray((IFile)file));
        }
        bufManager.addBuffer(buffer);
        buffer.addBufferChangedListener(this);
        return buffer;
    }

    public Map parse() {
        HashMap map = new HashMap();
        try {
            this.getNewElements(map, this);
        }
        catch (Exception exception) {}
        return map;
    }

    private void parse(Map newElements) {
        boolean quickParseMode = !CCorePlugin.getDefault().useStructuralParseMode();
        IContributedModelBuilder mb = LanguageManager.getInstance().getContributedModelBuilderFor(this);
        if (mb == null) {
            this.parseUsingCModelBuilder(newElements, quickParseMode);
        } else {
            this.parseUsingContributedModelBuilder(mb, quickParseMode);
        }
    }

    private void parseUsingCModelBuilder(Map newElements, boolean quickParseMode) {
        try {
            CModelBuilder modelBuilder = new CModelBuilder(this, newElements);
            modelBuilder.parse(quickParseMode);
        }
        catch (Exception exception) {
            Util.debugLog("Exception in CModelBuilder", IDebugLogConstants.MODEL);
        }
    }

    private void parseUsingContributedModelBuilder(IContributedModelBuilder mb, boolean quickParseMode) {
        try {
            mb.parse(quickParseMode);
        }
        catch (Exception exception) {
            Util.debugLog("Exception in contributed model builder", IDebugLogConstants.MODEL);
        }
    }

    public IProblemRequestor getProblemRequestor() {
        return this.problemRequestor;
    }

    public boolean isHeaderUnit() {
        return "org.eclipse.cdt.core.cHeader".equals(this.contentTypeId) || "org.eclipse.cdt.core.cxxHeader".equals(this.contentTypeId);
    }

    public boolean isSourceUnit() {
        if (this.isHeaderUnit()) {
            return false;
        }
        return "org.eclipse.cdt.core.cSource".equals(this.contentTypeId) || "org.eclipse.cdt.core.cxxSource".equals(this.contentTypeId) || "org.eclipse.cdt.core.asmSource".equals(this.contentTypeId) || LanguageManager.getInstance().isContributedContentType(this.contentTypeId);
    }

    public boolean isCLanguage() {
        return "org.eclipse.cdt.core.cSource".equals(this.contentTypeId) || "org.eclipse.cdt.core.cHeader".equals(this.contentTypeId);
    }

    public boolean isCXXLanguage() {
        return "org.eclipse.cdt.core.cxxSource".equals(this.contentTypeId) || "org.eclipse.cdt.core.cxxHeader".equals(this.contentTypeId);
    }

    public boolean isASMLanguage() {
        return "org.eclipse.cdt.core.asmSource".equals(this.contentTypeId);
    }

    public boolean exists() {
        IResource res = this.getResource();
        if (res != null) {
            return res.exists();
        }
        return super.exists();
    }

    public ILanguage getLanguage() throws CoreException {
        if (this.language == null) {
            IContentTypeManager manager = Platform.getContentTypeManager();
            IContentType contentType = manager.getContentType(this.contentTypeId);
            this.language = LanguageManager.getInstance().getLanguage(contentType);
            if (this.language == null && this.isHeaderUnit()) {
                IResource resource = this.getResource();
                contentType = resource != null && CoreModel.hasCCNature(resource.getProject()) ? manager.getContentType("org.eclipse.cdt.core.cxxSource") : manager.getContentType("org.eclipse.cdt.core.cSource");
                this.language = LanguageManager.getInstance().getLanguage(contentType);
            }
        }
        return this.language;
    }

    public String getContentTypeId() {
        return this.contentTypeId;
    }

    protected void setContentTypeID(String id) {
        this.contentTypeId = id;
    }

    protected void closing(Object info) throws CModelException {
        IContentType cType = CCorePlugin.getContentType(this.getCProject().getProject(), this.getElementName());
        if (cType != null) {
            this.setContentTypeID(cType.getId());
        }
        super.closing(info);
    }

    public void setIsStructureKnown(boolean wasSuccessful) {
        try {
            this.getElementInfo().setIsStructureKnown(wasSuccessful);
        }
        catch (CModelException cModelException) {}
    }
}

