/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.complete;

import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.IASTAbstractTypeSpecifierDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTOffsetableNamedElement;
import org.eclipse.cdt.core.parser.ast.IASTTemplate;
import org.eclipse.cdt.core.parser.ast.IASTTypeSpecifier;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTAnonymousDeclaration;
import org.eclipse.cdt.internal.core.parser.pst.IContainerSymbol;

public class ASTAbstractTypeSpecifierDeclaration
extends ASTAnonymousDeclaration
implements IASTAbstractTypeSpecifierDeclaration {
    private final IASTTypeSpecifier typeSpec;
    private final IASTTemplate ownerTemplate;
    private final boolean isFriendDeclaration;
    private int startingLineNumber;
    private int startingOffset;
    private int endingLineNumber;
    private int endingOffset;
    private final char[] fn;

    public ASTAbstractTypeSpecifierDeclaration(IContainerSymbol ownerScope, IASTTypeSpecifier typeSpecifier, IASTTemplate ownerTemplate, int startingOffset, int startingLine, int endingOffset, int endingLine, boolean isFriend, char[] filename) {
        super(ownerScope);
        this.typeSpec = typeSpecifier;
        this.ownerTemplate = ownerTemplate;
        this.isFriendDeclaration = isFriend;
        this.setStartingOffsetAndLineNumber(startingOffset, startingLine);
        this.setEndingOffsetAndLineNumber(endingOffset, endingLine);
        this.fn = filename;
    }

    public void acceptElement(ISourceElementRequestor requestor) {
        try {
            if (this.isFriendDeclaration()) {
                requestor.acceptFriendDeclaration(this);
            } else {
                requestor.acceptAbstractTypeSpecDeclaration(this);
            }
        }
        catch (Exception exception) {}
    }

    public void enterScope(ISourceElementRequestor requestor) {
    }

    public void exitScope(ISourceElementRequestor requestor) {
    }

    public IASTTypeSpecifier getTypeSpecifier() {
        return this.typeSpec;
    }

    public IASTTemplate getOwnerTemplateDeclaration() {
        return this.ownerTemplate;
    }

    public boolean isFriendDeclaration() {
        return this.isFriendDeclaration;
    }

    public final int getStartingLine() {
        return this.startingLineNumber;
    }

    public final int getEndingLine() {
        return this.endingLineNumber;
    }

    public final void setStartingOffsetAndLineNumber(int offset, int lineNumber) {
        this.startingOffset = offset;
        this.startingLineNumber = lineNumber;
    }

    public final void setEndingOffsetAndLineNumber(int offset, int lineNumber) {
        this.endingOffset = offset;
        this.endingLineNumber = lineNumber;
    }

    public final int getStartingOffset() {
        return this.startingOffset;
    }

    public final int getEndingOffset() {
        return this.endingOffset;
    }

    public char[] getFilename() {
        return this.fn;
    }

    public String getName() {
        if (this.typeSpec instanceof IASTOffsetableNamedElement) {
            return ((IASTOffsetableNamedElement)((Object)this.typeSpec)).getName();
        }
        return null;
    }

    public char[] getNameCharArray() {
        if (this.typeSpec instanceof IASTOffsetableNamedElement) {
            return ((IASTOffsetableNamedElement)((Object)this.typeSpec)).getNameCharArray();
        }
        return null;
    }

    public int getNameOffset() {
        if (this.typeSpec instanceof IASTOffsetableNamedElement) {
            return ((IASTOffsetableNamedElement)((Object)this.typeSpec)).getNameOffset();
        }
        return 0;
    }

    public void setNameOffset(int o) {
    }

    public int getNameEndOffset() {
        if (this.typeSpec instanceof IASTOffsetableNamedElement) {
            return ((IASTOffsetableNamedElement)((Object)this.typeSpec)).getNameEndOffset();
        }
        return 0;
    }

    public void setNameEndOffsetAndLineNumber(int offset, int lineNumber) {
    }

    public int getNameLineNumber() {
        if (this.typeSpec instanceof IASTOffsetableNamedElement) {
            return ((IASTOffsetableNamedElement)((Object)this.typeSpec)).getNameLineNumber();
        }
        return 0;
    }
}

