/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.pst;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.core.parser.util.CharArrayObjectMap;
import org.eclipse.cdt.core.parser.util.ObjectMap;
import org.eclipse.cdt.internal.core.parser.pst.ContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IDeferredTemplateInstance;
import org.eclipse.cdt.internal.core.parser.pst.IDerivableContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IParameterizedSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;
import org.eclipse.cdt.internal.core.parser.pst.ITemplateSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ITypeInfo;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTable;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTableException;
import org.eclipse.cdt.internal.core.parser.pst.TemplateEngine;
import org.eclipse.cdt.internal.core.parser.pst.TypeFilter;

public class DerivableContainerSymbol
extends ContainerSymbol
implements IDerivableContainerSymbol {
    private List _constructors = Collections.EMPTY_LIST;
    private List _parentScopes = Collections.EMPTY_LIST;
    private List _friends = Collections.EMPTY_LIST;

    protected DerivableContainerSymbol(ParserSymbolTable table, char[] name) {
        super(table, name);
    }

    protected DerivableContainerSymbol(ParserSymbolTable table, char[] name, ITypeInfo.eType typeInfo) {
        super(table, name, typeInfo);
    }

    public Object clone() {
        DerivableContainerSymbol copy = (DerivableContainerSymbol)super.clone();
        copy._parentScopes = this._parentScopes != Collections.EMPTY_LIST ? (List)((ArrayList)this._parentScopes).clone() : this._parentScopes;
        copy._constructors = this._constructors != Collections.EMPTY_LIST ? (List)((ArrayList)this._constructors).clone() : this._constructors;
        copy._friends = this._friends != Collections.EMPTY_LIST ? (List)((ArrayList)this._friends).clone() : this._friends;
        return copy;
    }

    public ISymbol instantiate(ITemplateSymbol template, ObjectMap argMap) throws ParserSymbolTableException {
        if (!this.isTemplateMember()) {
            return null;
        }
        DerivableContainerSymbol newSymbol = (DerivableContainerSymbol)super.instantiate(template, argMap);
        List parents = this.getParents();
        int size = parents.size();
        newSymbol.getParents().clear();
        ParentWrapper wrapper = null;
        int i = 0;
        while (i < size) {
            wrapper = (ParentWrapper)parents.get(i);
            ISymbol parent = wrapper.getParent();
            if (parent != null) {
                if (parent instanceof IDeferredTemplateInstance) {
                    template.registerDeferredInstatiation(newSymbol, parent, ITemplateSymbol.DeferredKind.PARENT, argMap);
                } else if (parent.isType(ITypeInfo.t_templateParameter) && argMap.containsKey(parent)) {
                    ITypeInfo info = (ITypeInfo)argMap.get(parent);
                    parent = info.getTypeSymbol();
                }
                newSymbol.addParent(parent, wrapper.isVirtual(), wrapper.getAccess(), wrapper.getOffset(), wrapper.getReferences());
            }
            ++i;
        }
        return newSymbol;
    }

    public void instantiateDeferredParent(ISymbol parent, ITemplateSymbol template, ObjectMap argMap) throws ParserSymbolTableException {
        List parents = this.getParents();
        int size = parents.size();
        ParentWrapper w = null;
        int i = 0;
        while (i < size) {
            w = (ParentWrapper)parents.get(i);
            if (w.getParent() == parent) {
                w.setParent(parent.instantiate(template, argMap));
            }
            ++i;
        }
    }

    public void discardDeferredParent(IDeferredTemplateInstance parent, ITemplateSymbol template, ObjectMap map) {
        List parents = this.getParents();
        int size = parents.size();
        ParentWrapper w = null;
        IContainerSymbol originalParent = parent.getTemplate().getTemplatedSymbol();
        int i = 0;
        while (i < size) {
            w = (ParentWrapper)parents.get(i);
            ISymbol instance = w.getParent();
            if (instance.getInstantiatedSymbol() == originalParent) {
                parents.remove(i);
                template.removeInstantiation((IContainerSymbol)instance);
                break;
            }
            ++i;
        }
    }

    protected void collectInstantiatedConstructor(IParameterizedSymbol constructor) {
        if (constructor.isType(ITypeInfo.t_constructor)) {
            this.addToConstructors(constructor);
        }
    }

    public void addSymbol(ISymbol symbol) throws ParserSymbolTableException {
        super.addSymbol(symbol);
        if (symbol instanceof IParameterizedSymbol) {
            this.addThis((IParameterizedSymbol)symbol);
        }
    }

    public void addParent(ISymbol parent) {
        this.addParent(parent, false, ASTAccessVisibility.PUBLIC, -1, null);
    }

    public void addParent(ISymbol parent, boolean virtual, ASTAccessVisibility visibility, int offset, List references) {
        if (this._parentScopes == Collections.EMPTY_LIST) {
            this._parentScopes = new ArrayList(4);
        }
        ParentWrapper wrapper = new ParentWrapper(parent, virtual, visibility, offset, references);
        this._parentScopes.add(wrapper);
    }

    public List getParents() {
        return this._parentScopes;
    }

    public boolean hasParents() {
        return !this._parentScopes.isEmpty();
    }

    public void addConstructor(IParameterizedSymbol constructor) throws ParserSymbolTableException {
        if (!constructor.isType(ITypeInfo.t_constructor)) {
            throw new ParserSymbolTableException(1);
        }
        List constructors = this.getConstructors();
        if (constructors.size() != 0 && !ParserSymbolTable.isValidOverload(constructors, (ISymbol)constructor)) {
            throw new ParserSymbolTableException(3);
        }
        this.addToConstructors(constructor);
        constructor.setContainingSymbol(this);
        constructor.setIsTemplateMember(this.isTemplateMember() || this.getType() == ITypeInfo.t_template);
        this.addThis(constructor);
        this.addToContents(constructor);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addCopyConstructor() throws ParserSymbolTableException {
        block6: {
            ArrayList<ITypeInfo> parameters = new ArrayList<ITypeInfo>(1);
            ISymbol paramType = this;
            if (this.getContainingSymbol() instanceof ITemplateSymbol) {
                paramType = TemplateEngine.instantiateWithinTemplateScope(this, (ITemplateSymbol)this.getContainingSymbol());
            }
            ITypeInfo param = this.getSymbolTable().getTypeInfoProvider().getTypeInfo(ITypeInfo.t_type);
            param.setType(ITypeInfo.t_type);
            param.setBit(true, 1024);
            param.setTypeSymbol(paramType);
            param.addPtrOperator(new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_reference, false, false));
            parameters.add(param);
            IParameterizedSymbol constructor = null;
            try {
                try {
                    constructor = this.lookupConstructor(parameters);
                }
                catch (ParserSymbolTableException parserSymbolTableException) {}
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.getSymbolTable().getTypeInfoProvider().returnTypeInfo(param);
                throw throwable;
            }
            {
                Object var5_7 = null;
                this.getSymbolTable().getTypeInfoProvider().returnTypeInfo(param);
                if (constructor != null) break block6;
                constructor = this.getSymbolTable().newParameterizedSymbol(this.getName(), ITypeInfo.t_constructor);
                constructor.addParameter(this, 1024, new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_reference, false, false), false);
            }
            this.addConstructor(constructor);
        }
    }

    public IParameterizedSymbol lookupConstructor(List parameters) throws ParserSymbolTableException {
        ParserSymbolTable.LookupData data = new ParserSymbolTable.LookupData(ParserSymbolTable.EMPTY_NAME_ARRAY, parameters){
            private final List params;
            {
                this.params = list;
            }

            public List getParameters() {
                return this.params;
            }

            public TypeFilter getFilter() {
                return CONSTRUCTOR_FILTER;
            }
        };
        ArrayList constructors = null;
        if (!this.getConstructors().isEmpty()) {
            constructors = new ArrayList(this.getConstructors());
        }
        if (constructors != null) {
            return this.getSymbolTable().resolveFunction(data, constructors);
        }
        return null;
    }

    public List getConstructors() {
        return this._constructors;
    }

    private void addToConstructors(IParameterizedSymbol constructor) {
        if (this._constructors == Collections.EMPTY_LIST) {
            this._constructors = new ArrayList(4);
        }
        this._constructors.add(constructor);
    }

    private boolean addThis(IParameterizedSymbol obj) {
        ITypeInfo type;
        IContainerSymbol containing;
        if (this.getSymbolTable().getLanguage() != ParserLanguage.CPP) {
            return false;
        }
        if (obj instanceof ITemplateSymbol) {
            IContainerSymbol templated = ((ITemplateSymbol)obj).getTemplatedSymbol();
            if (templated instanceof IParameterizedSymbol) {
                obj = (IParameterizedSymbol)templated;
            } else {
                return false;
            }
        }
        if ((containing = obj.getContainingSymbol()) instanceof ITemplateSymbol) {
            containing = containing.getContainingSymbol();
        }
        if (!(type = obj.getTypeInfo()).isType(ITypeInfo.t_function) && !type.isType(ITypeInfo.t_constructor) || type.checkBit(4)) {
            return false;
        }
        if (containing.isType(ITypeInfo.t_class, ITypeInfo.t_union)) {
            boolean foundThis = false;
            ParserSymbolTable.LookupData data = new ParserSymbolTable.LookupData(ParserSymbolTable.THIS);
            try {
                CharArrayObjectMap map = ParserSymbolTable.lookupInContained(data, obj);
                foundThis = map != null ? map.containsKey(data.name) : false;
            }
            catch (ParserSymbolTableException parserSymbolTableException) {
                return false;
            }
            if (!foundThis) {
                ISymbol thisObj = this.getSymbolTable().newSymbol(ParserSymbolTable.THIS, ITypeInfo.t_type);
                thisObj.setTypeSymbol(obj.getContainingSymbol());
                ITypeInfo.PtrOp ptr = new ITypeInfo.PtrOp();
                ptr.setType(ITypeInfo.PtrOp.t_pointer);
                thisObj.getTypeInfo().setBit(obj.getTypeInfo().checkBit(1024), 1024);
                thisObj.getTypeInfo().setBit(obj.getTypeInfo().checkBit(2048), 2048);
                thisObj.addPtrOperator(ptr);
                try {
                    obj.addSymbol(thisObj);
                }
                catch (ParserSymbolTableException parserSymbolTableException) {
                    return false;
                }
            }
        }
        return true;
    }

    public void addFriend(ISymbol friend) {
        IContainerSymbol containing = friend.getContainingSymbol();
        if (containing == null) {
            IContainerSymbol enclosing = this.getContainingSymbol();
            boolean local = enclosing.isType(ITypeInfo.t_constructor) || enclosing.isType(ITypeInfo.t_function) || enclosing.isType(ITypeInfo.t_block);
            while (enclosing != null && !enclosing.isType(ITypeInfo.t_namespace)) {
                enclosing = enclosing.getContainingSymbol();
            }
            friend.setIsInvisible(local);
            friend.setIsForwardDeclaration(true);
            try {
                enclosing.addSymbol(friend);
            }
            catch (ParserSymbolTableException parserSymbolTableException) {}
        }
        this.addToFriends(friend);
    }

    public ISymbol lookupForFriendship(char[] name) throws ParserSymbolTableException {
        IContainerSymbol enclosing = this.getContainingSymbol();
        if (enclosing != null && enclosing.isType(ITypeInfo.t_namespace, ITypeInfo.t_union)) {
            while (enclosing != null && enclosing.getType() != ITypeInfo.t_namespace) {
                enclosing = enclosing.getContainingSymbol();
            }
        }
        IContainerSymbol finalEnc = enclosing;
        ParserSymbolTable.LookupData data = new ParserSymbolTable.LookupData(name, finalEnc){
            private final ISymbol stopAt;
            {
                this.stopAt = iSymbol;
            }

            public ISymbol getStopAt() {
                return this.stopAt;
            }
        };
        ParserSymbolTable.lookup(data, this);
        return this.getSymbolTable().resolveAmbiguities(data);
    }

    public IParameterizedSymbol lookupFunctionForFriendship(char[] name, List parameters) throws ParserSymbolTableException {
        IContainerSymbol enclosing = this.getContainingSymbol();
        if (enclosing != null && enclosing.isType(ITypeInfo.t_namespace, ITypeInfo.t_union)) {
            while (enclosing != null && enclosing.getType() != ITypeInfo.t_namespace) {
                enclosing = enclosing.getContainingSymbol();
            }
        }
        IContainerSymbol finalEnc = enclosing;
        ParserSymbolTable.LookupData data = new ParserSymbolTable.LookupData(name, parameters, finalEnc){
            private final List params;
            final ISymbol stopAt;
            {
                this.params = list;
                this.stopAt = iSymbol;
            }

            public List getParameters() {
                return this.params;
            }

            public ISymbol getStopAt() {
                return this.stopAt;
            }
        };
        ParserSymbolTable.lookup(data, this);
        return (IParameterizedSymbol)this.getSymbolTable().resolveAmbiguities(data);
    }

    public List getFriends() {
        return this._friends;
    }

    private void addToFriends(ISymbol friend) {
        if (this._friends == Collections.EMPTY_LIST) {
            this._friends = new ArrayList(4);
        }
        this._friends.add(friend);
    }

    public class ParentWrapper
    implements IDerivableContainerSymbol.IParentSymbol {
        private boolean isVirtual = false;
        protected ISymbol parent = null;
        private final ASTAccessVisibility access;
        private final int offset;
        private final List references;

        public ParentWrapper(ISymbol p, boolean v, ASTAccessVisibility s, int offset, List r) {
            this.parent = p;
            this.isVirtual = v;
            this.access = s;
            this.offset = offset;
            this.references = r;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }

        public void setParent(ISymbol parent) {
            this.parent = parent;
        }

        public ISymbol getParent() {
            return this.parent;
        }

        public boolean isVirtual() {
            return this.isVirtual;
        }

        public void setVirtual(boolean virtual) {
            this.isVirtual = virtual;
        }

        public ASTAccessVisibility getAccess() {
            return this.access;
        }

        public int getOffset() {
            return this.offset;
        }

        public List getReferences() {
            return this.references;
        }
    }
}

