/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroDefinition;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.db.IBTreeComparator;
import org.eclipse.cdt.internal.core.pdom.db.IBTreeVisitor;
import org.eclipse.cdt.internal.core.pdom.db.IString;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMInclude;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMMacro;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMName;
import org.eclipse.core.runtime.CoreException;

public class PDOMFile {
    private final PDOM pdom;
    private final int record;
    private static final int FIRST_NAME = 0;
    private static final int FIRST_INCLUDE = 4;
    private static final int FIRST_INCLUDED_BY = 8;
    private static final int FIRST_MACRO = 12;
    private static final int FILE_NAME = 16;
    private static final int RECORD_SIZE = 20;

    public PDOMFile(PDOM pdom, int record) {
        this.pdom = pdom;
        this.record = record;
    }

    public PDOMFile(PDOM pdom, String filename) throws CoreException {
        this.pdom = pdom;
        Database db = pdom.getDB();
        this.record = db.malloc(20);
        db.putInt(this.record + 16, db.newString(filename).getRecord());
        this.setFirstName(null);
        this.setFirstInclude(null);
        this.setFirstIncludedBy(null);
    }

    public int getRecord() {
        return this.record;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof PDOMFile) {
            PDOMFile other = (PDOMFile)obj;
            return this.pdom.equals(other.pdom) && this.record == other.record;
        }
        return false;
    }

    public IString getFileName() throws CoreException {
        Database db = this.pdom.getDB();
        return db.getString(db.getInt(this.record + 16));
    }

    public PDOMName getFirstName() throws CoreException {
        int namerec = this.pdom.getDB().getInt(this.record + 0);
        return namerec != 0 ? new PDOMName(this.pdom, namerec) : null;
    }

    public void setFirstName(PDOMName firstName) throws CoreException {
        int namerec = firstName != null ? firstName.getRecord() : 0;
        this.pdom.getDB().putInt(this.record + 0, namerec);
    }

    public void addName(PDOMName name) throws CoreException {
        PDOMName firstName = this.getFirstName();
        if (firstName != null) {
            name.setNextInFile(firstName);
            firstName.setPrevInFile(name);
        }
        this.setFirstName(name);
    }

    public PDOMInclude getFirstInclude() throws CoreException {
        int increc = this.pdom.getDB().getInt(this.record + 4);
        return increc != 0 ? new PDOMInclude(this.pdom, increc) : null;
    }

    public void setFirstInclude(PDOMInclude include) throws CoreException {
        int rec = include != null ? include.getRecord() : 0;
        this.pdom.getDB().putInt(this.record + 4, rec);
    }

    public PDOMInclude getFirstIncludedBy() throws CoreException {
        int rec = this.pdom.getDB().getInt(this.record + 8);
        return rec != 0 ? new PDOMInclude(this.pdom, rec) : null;
    }

    public void setFirstIncludedBy(PDOMInclude includedBy) throws CoreException {
        int rec = includedBy != null ? includedBy.getRecord() : 0;
        this.pdom.getDB().putInt(this.record + 8, rec);
    }

    public PDOMMacro getFirstMacro() throws CoreException {
        int rec = this.pdom.getDB().getInt(this.record + 12);
        return rec != 0 ? new PDOMMacro(this.pdom, rec) : null;
    }

    public void setFirstMacro(PDOMMacro macro) throws CoreException {
        int rec = macro != null ? macro.getRecord() : 0;
        this.pdom.getDB().putInt(this.record + 12, rec);
    }

    public void addMacro(IASTPreprocessorMacroDefinition macro) throws CoreException {
        PDOMMacro firstMacro = this.getFirstMacro();
        char[] name = macro.getName().toCharArray();
        PDOMMacro pdomMacro = firstMacro;
        while (pdomMacro != null) {
            if (pdomMacro.getName().equals(name)) {
                return;
            }
            pdomMacro = pdomMacro.getNextMacro();
        }
        pdomMacro = new PDOMMacro(this.pdom, macro);
        pdomMacro.setNextMacro(this.getFirstMacro());
        this.setFirstMacro(pdomMacro);
    }

    public void clear() throws CoreException {
        PDOMInclude include = this.getFirstInclude();
        while (include != null) {
            PDOMInclude nextInclude = include.getNextInIncludes();
            include.delete();
            include = nextInclude;
        }
        this.setFirstInclude(include);
        PDOMMacro macro = this.getFirstMacro();
        while (macro != null) {
            PDOMMacro nextMacro = macro.getNextMacro();
            macro.delete();
            macro = nextMacro;
        }
        this.setFirstMacro(null);
        PDOMName name = this.getFirstName();
        while (name != null) {
            PDOMName nextName = name.getNextInFile();
            name.delete();
            name = nextName;
        }
        this.setFirstName(null);
    }

    public PDOMInclude addIncludeTo(PDOMFile file) throws CoreException {
        PDOMInclude include = new PDOMInclude(this.pdom);
        include.setIncludedBy(this);
        include.setIncludes(file);
        PDOMInclude firstInclude = this.getFirstInclude();
        if (firstInclude != null) {
            include.setNextInIncludes(firstInclude);
        }
        this.setFirstInclude(include);
        file.addIncludedBy(include);
        return include;
    }

    public void addIncludedBy(PDOMInclude include) throws CoreException {
        PDOMInclude firstIncludedBy = this.getFirstIncludedBy();
        if (firstIncludedBy != null) {
            include.setNextInIncludedBy(firstIncludedBy);
            firstIncludedBy.setPrevInIncludedBy(include);
        }
        this.setFirstIncludedBy(include);
    }

    public PDOMFile[] getAllIncludedBy() throws CoreException {
        HashMap<IString, PDOMFile> files = new HashMap<IString, PDOMFile>();
        LinkedList<PDOMFile> todo = new LinkedList<PDOMFile>();
        IString myFileName = this.getFileName();
        files.put(myFileName, this);
        todo.addLast(this);
        while (todo.size() > 0) {
            PDOMFile file = (PDOMFile)todo.removeFirst();
            PDOMInclude includedBy = file.getFirstIncludedBy();
            while (includedBy != null) {
                PDOMFile incFile = includedBy.getIncludedBy();
                IString incFileName = incFile.getFileName();
                if (files.get(incFileName) == null) {
                    files.put(incFileName, incFile);
                    todo.addLast(incFile);
                }
                includedBy = includedBy.getNextInIncludedBy();
            }
        }
        files.remove(myFileName);
        Collection values = files.values();
        return values.toArray(new PDOMFile[values.size()]);
    }

    public static class Comparator
    implements IBTreeComparator {
        private Database db;

        public Comparator(Database db) {
            this.db = db;
        }

        public int compare(int record1, int record2) throws CoreException {
            IString name1 = this.db.getString(this.db.getInt(record1 + 16));
            IString name2 = this.db.getString(this.db.getInt(record2 + 16));
            return name1.compare(name2);
        }
    }

    public static class Finder
    implements IBTreeVisitor {
        private final Database db;
        private final String key;
        private int record;

        public Finder(Database db, String key) {
            this.db = db;
            this.key = key;
        }

        public int compare(int record) throws CoreException {
            IString name = this.db.getString(this.db.getInt(record + 16));
            return name.compare(this.key);
        }

        public boolean visit(int record) throws CoreException {
            this.record = record;
            return false;
        }

        public int getRecord() {
            return this.record;
        }
    }
}

