/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom;

import org.eclipse.cdt.core.dom.IPDOMVisitor;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.db.ListItem;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.core.runtime.CoreException;

public abstract class PDOMMemberOwner
extends PDOMBinding {
    private static final int FIRST_MEMBER = 24;
    protected static final int RECORD_SIZE = 28;

    public PDOMMemberOwner(PDOM pdom, PDOMNode parent, IASTName name) throws CoreException {
        super(pdom, parent, name);
    }

    public PDOMMemberOwner(PDOM pdom, int record) {
        super(pdom, record);
    }

    protected int getRecordSize() {
        return 28;
    }

    public void accept(IPDOMVisitor visitor) throws CoreException {
        super.accept(visitor);
        ListItem firstItem = this.getFirstMemberItem();
        if (firstItem == null) {
            return;
        }
        PDOMLinkage linkage = this.getLinkage();
        ListItem item = firstItem;
        do {
            PDOMNode node;
            if (visitor.visit(node = linkage.getNode(item.getItem()))) {
                node.accept(visitor);
            }
            visitor.leave(node);
        } while (!(item = item.getNext()).equals(firstItem));
    }

    private ListItem getFirstMemberItem() throws CoreException {
        Database db = this.pdom.getDB();
        int item = db.getInt(this.record + 24);
        return item != 0 ? new ListItem(db, item) : null;
    }

    public void addMember(PDOMNode member) throws CoreException {
        Database db = this.pdom.getDB();
        ListItem firstMember = this.getFirstMemberItem();
        if (firstMember == null) {
            firstMember = new ListItem(db);
            firstMember.setItem(member.getRecord());
            firstMember.setNext(firstMember);
            firstMember.setPrev(firstMember);
            db.putInt(this.record + 24, firstMember.getRecord());
        } else {
            ListItem newMember = new ListItem(db);
            newMember.setItem(member.getRecord());
            ListItem prevMember = firstMember.getPrev();
            prevMember.setNext(newMember);
            firstMember.setPrev(newMember);
            newMember.setPrev(prevMember);
            newMember.setNext(firstMember);
        }
    }
}

