/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.ASTNodeProperty;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeLocation;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMFile;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNotImplementedError;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMTranslationUnit;
import org.eclipse.core.runtime.CoreException;

public class PDOMName
implements IASTName,
IASTFileLocation {
    private final PDOM pdom;
    private final int record;
    private static final int FILE_REC_OFFSET = 0;
    private static final int FILE_PREV_OFFSET = 4;
    private static final int FILE_NEXT_OFFSET = 8;
    private static final int BINDING_REC_OFFSET = 12;
    private static final int BINDING_PREV_OFFSET = 16;
    private static final int BINDING_NEXT_OFFSET = 20;
    private static final int NODE_OFFSET_OFFSET = 24;
    private static final int NODE_LENGTH_OFFSET = 28;
    private static final int FLAGS = 32;
    private static final int RECORD_SIZE = 33;
    private static final int IS_DECLARATION = 1;
    private static final int IS_DEFINITION = 2;
    private static final int IS_REFERENCE = 3;

    public PDOMName(PDOM pdom, IASTName name, PDOMFile file, PDOMBinding binding) throws CoreException {
        this.pdom = pdom;
        Database db = pdom.getDB();
        this.record = db.malloc(33);
        byte flags = 0;
        flags = name.isDefinition() ? (byte)2 : (name.isDeclaration() ? (byte)1 : 3);
        db.putByte(this.record + 32, flags);
        if (binding != null) {
            switch (flags) {
                case 2: {
                    binding.addDefinition(this);
                    break;
                }
                case 1: {
                    binding.addDeclaration(this);
                    break;
                }
                case 3: {
                    binding.addReference(this);
                }
            }
            db.putInt(this.record + 12, binding.getRecord());
        }
        db.putInt(this.record + 0, file.getRecord());
        file.addName(this);
        IASTFileLocation fileloc = name.getFileLocation();
        db.putInt(this.record + 24, fileloc.getNodeOffset());
        db.putInt(this.record + 28, fileloc.getNodeLength());
    }

    public PDOMName(PDOM pdom, int nameRecord) {
        this.pdom = pdom;
        this.record = nameRecord;
    }

    public int getRecord() {
        return this.record;
    }

    private int getRecField(int offset) throws CoreException {
        return this.pdom.getDB().getInt(this.record + offset);
    }

    private void setRecField(int offset, int fieldrec) throws CoreException {
        this.pdom.getDB().putInt(this.record + offset, fieldrec);
    }

    public PDOMBinding getPDOMBinding() throws CoreException {
        int bindingrec = this.getRecField(12);
        return this.pdom.getBinding(bindingrec);
    }

    public void setBinding(PDOMBinding binding) throws CoreException {
        int bindingrec = binding != null ? binding.getRecord() : 0;
        this.setRecField(12, bindingrec);
    }

    private PDOMName getNameField(int offset) throws CoreException {
        int namerec = this.getRecField(offset);
        return namerec != 0 ? new PDOMName(this.pdom, namerec) : null;
    }

    private void setNameField(int offset, PDOMName name) throws CoreException {
        int namerec = name != null ? name.getRecord() : 0;
        this.setRecField(offset, namerec);
    }

    public PDOMName getPrevInBinding() throws CoreException {
        return this.getNameField(16);
    }

    public void setPrevInBinding(PDOMName name) throws CoreException {
        this.setNameField(16, name);
    }

    public PDOMName getNextInBinding() throws CoreException {
        return this.getNameField(20);
    }

    public void setNextInBinding(PDOMName name) throws CoreException {
        this.setNameField(20, name);
    }

    public PDOMFile getFile() throws CoreException {
        int filerec = this.pdom.getDB().getInt(this.record + 0);
        return filerec != 0 ? new PDOMFile(this.pdom, filerec) : null;
    }

    public PDOMName getNextInFile() throws CoreException {
        return this.getNameField(8);
    }

    public void setNextInFile(PDOMName name) throws CoreException {
        this.setNameField(8, name);
    }

    public PDOMName getPrevInFile() throws CoreException {
        return this.getNameField(4);
    }

    public void setPrevInFile(PDOMName name) throws CoreException {
        this.setNameField(4, name);
    }

    public IBinding resolveBinding() {
        try {
            int bindingRecord = this.pdom.getDB().getInt(this.record + 12);
            return this.pdom.getBinding(bindingRecord);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return null;
        }
    }

    public IBinding getBinding() {
        throw new PDOMNotImplementedError();
    }

    public void setBinding(IBinding binding) {
        throw new PDOMNotImplementedError();
    }

    public IBinding[] resolvePrefix() {
        throw new PDOMNotImplementedError();
    }

    public char[] toCharArray() {
        try {
            Database db = this.pdom.getDB();
            int bindingRec = db.getInt(this.record + 12);
            PDOMBinding binding = this.pdom.getBinding(bindingRec);
            return binding != null ? binding.getNameCharArray() : null;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return null;
        }
    }

    private byte getFlags() throws CoreException {
        return this.pdom.getDB().getByte(this.record + 32);
    }

    public boolean isDeclaration() {
        try {
            byte flags = this.getFlags();
            return flags == 1 || flags == 2;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return false;
        }
    }

    public boolean isReference() {
        try {
            byte flags = this.getFlags();
            return flags == 3;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return false;
        }
    }

    public boolean isDefinition() {
        try {
            byte flags = this.getFlags();
            return flags == 2;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return false;
        }
    }

    public IASTTranslationUnit getTranslationUnit() {
        return new PDOMTranslationUnit();
    }

    public IASTNodeLocation[] getNodeLocations() {
        throw new PDOMNotImplementedError();
    }

    public IASTFileLocation getFileLocation() {
        return this;
    }

    public String getContainingFilename() {
        throw new PDOMNotImplementedError();
    }

    public IASTNode getParent() {
        throw new PDOMNotImplementedError();
    }

    public void setParent(IASTNode node) {
        throw new PDOMNotImplementedError();
    }

    public ASTNodeProperty getPropertyInParent() {
        throw new PDOMNotImplementedError();
    }

    public void setPropertyInParent(ASTNodeProperty property) {
        throw new PDOMNotImplementedError();
    }

    public boolean accept(ASTVisitor visitor) {
        throw new PDOMNotImplementedError();
    }

    public String getRawSignature() {
        throw new PDOMNotImplementedError();
    }

    public int getEndingLineNumber() {
        throw new PDOMNotImplementedError();
    }

    public String getFileName() {
        try {
            PDOMFile file = this.getFile();
            return file != null ? file.getFileName().getString() : null;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return null;
        }
    }

    public int getStartingLineNumber() {
        throw new PDOMNotImplementedError();
    }

    public IASTFileLocation asFileLocation() {
        throw new PDOMNotImplementedError();
    }

    public int getNodeLength() {
        try {
            return this.pdom.getDB().getInt(this.record + 28);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return 0;
        }
    }

    public int getNodeOffset() {
        try {
            return this.pdom.getDB().getInt(this.record + 24);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return 0;
        }
    }

    public void delete() throws CoreException {
        PDOMName prevName = this.getPrevInBinding();
        PDOMName nextName = this.getNextInBinding();
        if (prevName != null) {
            prevName.setNextInBinding(nextName);
        } else {
            switch (this.getFlags()) {
                case 1: {
                    this.getPDOMBinding().setFirstDeclaration(nextName);
                    break;
                }
                case 2: {
                    this.getPDOMBinding().setFirstDefinition(nextName);
                    break;
                }
                case 3: {
                    this.getPDOMBinding().setFirstReference(nextName);
                }
            }
        }
        if (nextName != null) {
            nextName.setPrevInBinding(prevName);
        }
        this.pdom.getDB().free(this.record);
    }
}

