/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPClassType;
import org.eclipse.core.runtime.CoreException;

public class PDOMCPPBase
implements ICPPBase {
    private static final int BASECLASS = 0;
    private static final int NEXTBASE = 4;
    private static final int FLAGS = 8;
    protected static final int RECORD_SIZE = 9;
    protected final PDOM pdom;
    protected final int record;

    public PDOMCPPBase(PDOM pdom, int record) {
        this.pdom = pdom;
        this.record = record;
    }

    public PDOMCPPBase(PDOM pdom, PDOMCPPClassType baseClass, boolean isVirtual, int visibility) throws CoreException {
        this.pdom = pdom;
        Database db = pdom.getDB();
        this.record = db.malloc(9);
        int baserec = baseClass != null ? baseClass.getRecord() : 0;
        db.putInt(this.record + 0, baserec);
        byte flags = (byte)(visibility | (isVirtual ? 4 : 0));
        db.putByte(this.record + 8, flags);
    }

    public int getRecord() {
        return this.record;
    }

    public void setNextBase(PDOMCPPBase nextBase) throws CoreException {
        int rec = nextBase != null ? nextBase.getRecord() : 0;
        this.pdom.getDB().putInt(this.record + 4, rec);
    }

    public PDOMCPPBase getNextBase() throws CoreException {
        int rec = this.pdom.getDB().getInt(this.record + 4);
        return rec != 0 ? new PDOMCPPBase(this.pdom, rec) : null;
    }

    private int getFlags() throws CoreException {
        return this.pdom.getDB().getByte(this.record + 8);
    }

    public IBinding getBaseClass() throws DOMException {
        try {
            int rec = this.pdom.getDB().getInt(this.record + 0);
            return rec != 0 ? new PDOMCPPClassType(this.pdom, rec) : null;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return null;
        }
    }

    public int getVisibility() throws DOMException {
        try {
            return this.getFlags() & 3;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return 0;
        }
    }

    public boolean isVirtual() throws DOMException {
        try {
            return (this.getFlags() & 4) != 0;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return false;
        }
    }
}

