/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.envvar;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.managedbuilder.core.IBuildPathResolver;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IEnvVarBuildPath;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.envvar.IBuildEnvironmentVariable;
import org.eclipse.cdt.managedbuilder.envvar.IEnvironmentBuildPathsChangeListener;
import org.eclipse.cdt.managedbuilder.envvar.IEnvironmentVariableProvider;
import org.eclipse.cdt.managedbuilder.envvar.IEnvironmentVariableSupplier;
import org.eclipse.cdt.managedbuilder.internal.envvar.BuildEnvVar;
import org.eclipse.cdt.managedbuilder.internal.envvar.DefaultContextInfo;
import org.eclipse.cdt.managedbuilder.internal.envvar.EclipseEnvironmentSupplier;
import org.eclipse.cdt.managedbuilder.internal.envvar.EnvVarCollector;
import org.eclipse.cdt.managedbuilder.internal.envvar.EnvVarDescriptor;
import org.eclipse.cdt.managedbuilder.internal.envvar.EnvVarOperationProcessor;
import org.eclipse.cdt.managedbuilder.internal.envvar.ExternalExtensionEnvironmentSupplier;
import org.eclipse.cdt.managedbuilder.internal.envvar.IContextInfo;
import org.eclipse.cdt.managedbuilder.internal.envvar.MbsEnvironmentSupplier;
import org.eclipse.cdt.managedbuilder.internal.envvar.StoredBuildPathEnvironmentContainer;
import org.eclipse.cdt.managedbuilder.internal.envvar.UserDefinedEnvironmentSupplier;
import org.eclipse.cdt.managedbuilder.internal.macros.DefaultMacroContextInfo;
import org.eclipse.cdt.managedbuilder.internal.macros.DefaultMacroSubstitutor;
import org.eclipse.cdt.managedbuilder.internal.macros.EnvironmentMacroSupplier;
import org.eclipse.cdt.managedbuilder.internal.macros.IMacroContextInfo;
import org.eclipse.cdt.managedbuilder.internal.macros.IMacroSubstitutor;
import org.eclipse.cdt.managedbuilder.macros.BuildMacroException;
import org.eclipse.cdt.managedbuilder.macros.IBuildMacro;
import org.eclipse.cdt.managedbuilder.macros.IBuildMacroSupplier;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.QualifiedName;

public class EnvironmentVariableProvider
implements IEnvironmentVariableProvider {
    private static final QualifiedName fBuildPathVarProperty = new QualifiedName(ManagedBuilderCorePlugin.getUniqueIdentifier(), "buildPathVar");
    private static final String DELIMITER_WIN32 = ";";
    private static final String DELIMITER_UNIX = ":";
    private static EnvironmentVariableProvider fInstance = null;
    private List fListeners = null;
    private EnvVarMacroSubstitutor fMacroSubstitutor;
    private StoredBuildPathEnvironmentContainer fIncludeStoredBuildPathVariables;
    private StoredBuildPathEnvironmentContainer fLibraryStoredBuildPathVariables;
    public static final UserDefinedEnvironmentSupplier fUserSupplier = new UserDefinedEnvironmentSupplier();
    public static final ExternalExtensionEnvironmentSupplier fExternalSupplier = new ExternalExtensionEnvironmentSupplier();
    public static final MbsEnvironmentSupplier fMbsSupplier = new MbsEnvironmentSupplier();
    public static final EclipseEnvironmentSupplier fEclipseSupplier = new EclipseEnvironmentSupplier();

    protected EnvironmentVariableProvider() {
    }

    public static EnvironmentVariableProvider getDefault() {
        if (fInstance == null) {
            fInstance = new EnvironmentVariableProvider();
        }
        return fInstance;
    }

    public EnvVarDescriptor getVariable(String variableName, IContextInfo contextInfo, boolean includeParentLevels) {
        if (contextInfo == null) {
            return null;
        }
        if ((variableName = EnvVarOperationProcessor.normalizeName(variableName)) == null) {
            return null;
        }
        IContextInfo[] infos = this.getAllContextInfos(contextInfo);
        if (!includeParentLevels) {
            IEnvironmentVariableSupplier[] suppliers = infos[0].getSuppliers();
            boolean bVarFound = false;
            int i = 0;
            while (i < suppliers.length) {
                if (suppliers[i].getVariable(variableName, infos[0].getContext()) != null) {
                    bVarFound = true;
                    break;
                }
                ++i;
            }
            if (!bVarFound) {
                return null;
            }
        }
        IBuildEnvironmentVariable variable = null;
        IContextInfo varContextInfo = null;
        int varSupplierNum = -1;
        int i = infos.length - 1;
        while (i >= 0) {
            IContextInfo info = infos[i];
            IEnvironmentVariableSupplier[] suppliers = info.getSuppliers();
            int j = suppliers.length - 1;
            while (j >= 0) {
                IEnvironmentVariableSupplier supplier = suppliers[j];
                IBuildEnvironmentVariable var = supplier.getVariable(variableName, info.getContext());
                if (var != null) {
                    varContextInfo = info;
                    varSupplierNum = j;
                    variable = variable == null ? var : EnvVarOperationProcessor.performOperation(variable, var);
                }
                --j;
            }
            --i;
        }
        if (variable != null) {
            if (variable.getOperation() == 2) {
                return null;
            }
            return new EnvVarDescriptor(variable, varContextInfo, varSupplierNum);
        }
        return null;
    }

    public IBuildEnvironmentVariable getVariable(String variableName, Object level, boolean includeParentLevels, boolean resolveMacros) {
        if (variableName == null || "".equals(variableName)) {
            return null;
        }
        IContextInfo info = this.getContextInfo(level);
        EnvVarDescriptor var = this.getVariable(variableName, info, includeParentLevels);
        if (level instanceof IConfiguration && includeParentLevels) {
            this.checkBuildPathVariable((IConfiguration)level, variableName, var);
        }
        return resolveMacros ? this.calculateResolvedVariable(var, info) : var;
    }

    public IContextInfo getContextInfo(Object level) {
        DefaultContextInfo info = new DefaultContextInfo(level);
        if (info.getSuppliers() == null) {
            return null;
        }
        return info;
    }

    public EnvVarCollector getVariables(IContextInfo contextInfo, boolean includeParentLevels) {
        int i;
        if (contextInfo == null) {
            return null;
        }
        IContextInfo[] infos = this.getAllContextInfos(contextInfo);
        HashSet<String> set = null;
        if (!includeParentLevels) {
            IEnvironmentVariableSupplier[] suppliers = infos[0].getSuppliers();
            set = new HashSet<String>();
            i = 0;
            while (i < suppliers.length) {
                IBuildEnvironmentVariable[] vars = suppliers[i].getVariables(infos[0].getContext());
                if (vars != null) {
                    int j = 0;
                    while (j < vars.length) {
                        String name = EnvVarOperationProcessor.normalizeName(vars[j].getName());
                        if (name != null) {
                            set.add(name);
                        }
                        ++j;
                    }
                }
                ++i;
            }
            if (set.size() == 0) {
                return new EnvVarCollector();
            }
        }
        EnvVarCollector envVarSet = new EnvVarCollector();
        i = infos.length - 1;
        while (i >= 0) {
            IContextInfo info = infos[i];
            IEnvironmentVariableSupplier[] suppliers = info.getSuppliers();
            int j = suppliers.length - 1;
            while (j >= 0) {
                IEnvironmentVariableSupplier supplier = suppliers[j];
                IBuildEnvironmentVariable[] vars = null;
                if (set != null) {
                    ArrayList<IBuildEnvironmentVariable> varList = new ArrayList<IBuildEnvironmentVariable>();
                    Iterator iter = set.iterator();
                    while (iter.hasNext()) {
                        IBuildEnvironmentVariable var = supplier.getVariable((String)iter.next(), info.getContext());
                        if (var == null) continue;
                        varList.add(var);
                    }
                    vars = varList.toArray(new IBuildEnvironmentVariable[varList.size()]);
                } else {
                    vars = supplier.getVariables(info.getContext());
                }
                envVarSet.add(vars, info, j);
                --j;
            }
            --i;
        }
        return envVarSet;
    }

    public IBuildEnvironmentVariable[] getVariables(Object level, boolean includeParentLevels, boolean resolveMacros) {
        IBuildEnvironmentVariable[] vars;
        IContextInfo info = this.getContextInfo(level);
        EnvVarCollector varSet = this.getVariables(info, includeParentLevels);
        IBuildEnvironmentVariable[] iBuildEnvironmentVariableArray = vars = varSet != null ? varSet.toArray(false) : null;
        if (level instanceof IConfiguration) {
            if (includeParentLevels) {
                this.checkBuildPathVariables((IConfiguration)level, varSet);
            } else if (vars != null) {
                int i = 0;
                while (i < vars.length) {
                    this.checkBuildPathVariable((IConfiguration)level, ((EnvVarDescriptor)vars[i]).getName(), (EnvVarDescriptor)vars[i]);
                    ++i;
                }
            }
        }
        if (vars != null) {
            if (!resolveMacros) {
                return vars;
            }
            IBuildEnvironmentVariable[] resolved = new IBuildEnvironmentVariable[vars.length];
            int i = 0;
            while (i < vars.length) {
                resolved[i] = this.calculateResolvedVariable((EnvVarDescriptor)vars[i], info);
                ++i;
            }
            return resolved;
        }
        return null;
    }

    private IContextInfo[] getAllContextInfos(IContextInfo contextInfo) {
        if (contextInfo == null) {
            return null;
        }
        ArrayList<IContextInfo> list = new ArrayList<IContextInfo>();
        list.add(contextInfo);
        while ((contextInfo = contextInfo.getNext()) != null) {
            list.add(contextInfo);
        }
        return list.toArray(new IContextInfo[list.size()]);
    }

    private boolean isWin32() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.startsWith("windows ");
    }

    public String getDefaultDelimiter() {
        return this.isWin32() ? DELIMITER_WIN32 : DELIMITER_UNIX;
    }

    public boolean isVariableCaseSensitive() {
        return !this.isWin32();
    }

    public IEnvironmentVariableSupplier[] getSuppliers(Object level) {
        IContextInfo info = this.getContextInfo(level);
        if (info != null) {
            return info.getSuppliers();
        }
        return null;
    }

    public String[] getBuildPaths(IConfiguration configuration, int buildPathType) {
        ITool[] tools = configuration.getFilteredTools();
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < tools.length) {
            IEnvVarBuildPath[] pathDescriptors = tools[i].getEnvVarBuildPaths();
            if (pathDescriptors != null && pathDescriptors.length != 0) {
                int j = 0;
                while (j < pathDescriptors.length) {
                    String[] vars;
                    IEnvVarBuildPath curPathDes = pathDescriptors[j];
                    if (curPathDes.getType() == buildPathType && (vars = curPathDes.getVariableNames()) != null && vars.length != 0) {
                        IBuildPathResolver pathResolver = curPathDes.getBuildPathResolver();
                        if (pathResolver == null) {
                            String delimiter = curPathDes.getPathDelimiter();
                            if (delimiter == null) {
                                delimiter = this.getDefaultDelimiter();
                            }
                            pathResolver = new DefaultBuildPathResolver(delimiter);
                        }
                        int k = 0;
                        while (k < vars.length) {
                            String varValue;
                            String[] paths;
                            String varName = vars[k];
                            EnvVarDescriptor var = this.getVariable(varName, this.getContextInfo(configuration), true);
                            if (var != null && (paths = pathResolver.resolveBuildPaths(buildPathType, varName, varValue = this.calculateResolvedVariable(var, this.getContextInfo(configuration)).getValue(), configuration)) != null && paths.length != 0) {
                                list.addAll(Arrays.asList(paths));
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return list.toArray(new String[list.size()]);
    }

    private List getListeners() {
        if (this.fListeners == null) {
            this.fListeners = new ArrayList();
        }
        return this.fListeners;
    }

    private void notifyListeners(IConfiguration configuration, int buildPathType) {
        List listeners = this.getListeners();
        Iterator iterator = listeners.iterator();
        while (iterator.hasNext()) {
            ((IEnvironmentBuildPathsChangeListener)iterator.next()).buildPathsChanged(configuration, buildPathType);
        }
    }

    public synchronized void subscribe(IEnvironmentBuildPathsChangeListener listener) {
        if (listener == null) {
            return;
        }
        List listeners = this.getListeners();
        if (!listeners.contains(listener)) {
            listeners.add(listener);
        }
    }

    public synchronized void unsubscribe(IEnvironmentBuildPathsChangeListener listener) {
        if (listener == null) {
            return;
        }
        List listeners = this.getListeners();
        listeners.remove(listener);
    }

    public boolean checkParentContextRelation(IContextInfo child, IContextInfo parent) {
        if (child == null || parent == null) {
            return false;
        }
        IContextInfo enumInfo = child;
        do {
            if (parent.getContext() != enumInfo.getContext()) continue;
            return true;
        } while ((enumInfo = enumInfo.getNext()) != null);
        return false;
    }

    public void checkBuildPathVariables(IConfiguration configuration) {
        this.checkBuildPathVariables(configuration, this.getVariables(this.getContextInfo(configuration), true));
    }

    public void checkBuildPathVariables(IConfiguration configuration, int buildPathType) {
        this.checkBuildPathVariables(configuration, buildPathType, this.getVariables(this.getContextInfo(configuration), true));
    }

    protected void checkBuildPathVariables(IConfiguration configuration, EnvVarCollector varSet) {
        this.checkBuildPathVariables(configuration, 1, varSet);
        this.checkBuildPathVariables(configuration, 2, varSet);
    }

    protected void checkBuildPathVariable(IConfiguration configuration, String varName, EnvVarDescriptor var) {
        this.checkBuildPathVariable(configuration, 1, varName, var);
        this.checkBuildPathVariable(configuration, 2, varName, var);
    }

    protected void checkBuildPathVariable(IConfiguration configuration, int buildPathType, String varName, EnvVarDescriptor var) {
        StoredBuildPathEnvironmentContainer buildPathVars = this.getStoredBuildPathVariables(buildPathType);
        if (buildPathVars == null) {
            return;
        }
        if (buildPathVars.isVariableChanged(varName, var, configuration)) {
            buildPathVars.synchronize(this.getVariables(this.getContextInfo(configuration), true), configuration);
            this.notifyListeners(configuration, buildPathType);
        }
    }

    protected void checkBuildPathVariables(IConfiguration configuration, int buildPathType, EnvVarCollector varSet) {
        StoredBuildPathEnvironmentContainer buildPathVars = this.getStoredBuildPathVariables(buildPathType);
        if (buildPathVars == null) {
            return;
        }
        if (buildPathVars.checkBuildPathChange(varSet, configuration)) {
            this.notifyListeners(configuration, buildPathType);
        }
    }

    protected StoredBuildPathEnvironmentContainer getStoredBuildPathVariables(int buildPathType) {
        return buildPathType == 2 ? this.getStoredLibraryBuildPathVariables() : this.getStoredIncludeBuildPathVariables();
    }

    protected StoredBuildPathEnvironmentContainer getStoredIncludeBuildPathVariables() {
        if (this.fIncludeStoredBuildPathVariables == null) {
            this.fIncludeStoredBuildPathVariables = new StoredBuildPathEnvironmentContainer(1);
        }
        return this.fIncludeStoredBuildPathVariables;
    }

    protected StoredBuildPathEnvironmentContainer getStoredLibraryBuildPathVariables() {
        if (this.fLibraryStoredBuildPathVariables == null) {
            this.fLibraryStoredBuildPathVariables = new StoredBuildPathEnvironmentContainer(2);
        }
        return this.fLibraryStoredBuildPathVariables;
    }

    public IBuildEnvironmentVariable calculateResolvedVariable(EnvVarDescriptor des, IContextInfo info) {
        if (des == null || info == null) {
            return null;
        }
        return this.calculateResolvedVariable(des, this.getMacroSubstitutor(this.getMacroContextInfoForContext(info.getContext()), "", " "));
    }

    public IBuildEnvironmentVariable calculateResolvedVariable(EnvVarDescriptor des, IMacroSubstitutor sub) {
        if (des == null) {
            return null;
        }
        IBuildEnvironmentVariable var = des;
        try {
            if (sub instanceof EnvVarMacroSubstitutor) {
                var = ((EnvVarMacroSubstitutor)sub).resolveVariable(des);
            } else if (des.getOperation() != 2) {
                String name = des.getName();
                var = new BuildEnvVar(name, sub.resolveToString(name), des.getOperation(), des.getDelimiter());
            }
        }
        catch (BuildMacroException buildMacroException) {}
        return var;
    }

    protected int getMacroContextTypeFromContext(Object context) {
        if (context instanceof IConfiguration) {
            return 3;
        }
        if (context instanceof IManagedProject) {
            return 4;
        }
        if (context instanceof IWorkspace) {
            return 5;
        }
        if (context == null) {
            return 7;
        }
        return 0;
    }

    public IMacroContextInfo getMacroContextInfoForContext(Object context) {
        return new DefaultMacroContextInfo(this.getMacroContextTypeFromContext(context), context);
    }

    public IMacroSubstitutor getMacroSubstitutor(IMacroContextInfo info, String inexistentMacroValue, String listDelimiter) {
        if (this.fMacroSubstitutor == null) {
            this.fMacroSubstitutor = new EnvVarMacroSubstitutor(info, inexistentMacroValue, listDelimiter);
        } else {
            try {
                this.fMacroSubstitutor.setMacroContextInfo(info);
                this.fMacroSubstitutor.setInexistentMacroValue(inexistentMacroValue);
                this.fMacroSubstitutor.setListDelimiter(listDelimiter);
            }
            catch (BuildMacroException buildMacroException) {
                this.fMacroSubstitutor = new EnvVarMacroSubstitutor(info, inexistentMacroValue, listDelimiter);
            }
        }
        return this.fMacroSubstitutor;
    }

    public static class DefaultBuildPathResolver
    implements IBuildPathResolver {
        private String fDelimiter;

        public DefaultBuildPathResolver(String delimiter) {
            this.fDelimiter = delimiter;
        }

        public String[] resolveBuildPaths(int pathType, String variableName, String variableValue, IConfiguration configuration) {
            if (this.fDelimiter == null || "".equals(this.fDelimiter)) {
                return new String[]{variableValue};
            }
            List list = EnvVarOperationProcessor.convertToList(variableValue, this.fDelimiter);
            return list.toArray(new String[list.size()]);
        }
    }

    public class EnvVarMacroSubstitutor
    extends DefaultMacroSubstitutor {
        private String fDefaultDelimiter;

        public EnvVarMacroSubstitutor(int contextType, Object contextData, String inexistentMacroValue, String listDelimiter) {
            super(contextType, contextData, inexistentMacroValue, listDelimiter);
            this.fDefaultDelimiter = listDelimiter;
        }

        public EnvVarMacroSubstitutor(IMacroContextInfo contextInfo, String inexistentMacroValue, String listDelimiter) {
            super(contextInfo, inexistentMacroValue, listDelimiter, null, inexistentMacroValue);
            this.fDefaultDelimiter = listDelimiter;
        }

        public IBuildEnvironmentVariable resolveVariable(EnvVarDescriptor var) throws BuildMacroException {
            String value;
            if (var == null || (value = var.getValue()) == null || value.length() == 0 || var.getOperation() == 2) {
                return var;
            }
            String listDelimiter = var.getDelimiter();
            if (listDelimiter == null) {
                listDelimiter = this.fDefaultDelimiter;
            }
            this.setListDelimiter(listDelimiter);
            IBuildMacro macro = EnvironmentMacroSupplier.getInstance().createBuildMacro(var);
            IMacroContextInfo varMacroInfo = this.getVarMacroContextInfo(var);
            int varSupplierNum = this.getVarMacroSupplierNum(var, varMacroInfo);
            value = this.resolveToString(new DefaultMacroSubstitutor.MacroDescriptor((DefaultMacroSubstitutor)this, macro, varMacroInfo, varSupplierNum));
            this.removeResolvedMacro(var.getName());
            return new BuildEnvVar(var.getName(), value, var.getOperation(), var.getDelimiter());
        }

        protected IMacroContextInfo getVarMacroContextInfo(EnvVarDescriptor var) {
            IContextInfo info = var.getContextInfo();
            if (info != null) {
                return EnvironmentVariableProvider.this.getMacroContextInfoForContext(info.getContext());
            }
            return null;
        }

        protected int getVarMacroSupplierNum(EnvVarDescriptor var, IMacroContextInfo varMacroInfo) {
            int varSupplierNum = -1;
            IBuildMacroSupplier[] macroSuppliers = varMacroInfo.getSuppliers();
            int i = 0;
            while (i < macroSuppliers.length) {
                if (macroSuppliers[i] instanceof EnvironmentMacroSupplier) {
                    varSupplierNum = i;
                    break;
                }
                ++i;
            }
            return varSupplierNum;
        }
    }
}

