/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.macros;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IInputType;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IOutputType;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.envvar.EnvVarOperationProcessor;
import org.eclipse.cdt.managedbuilder.internal.macros.DefaultMacroSubstitutor;
import org.eclipse.cdt.managedbuilder.internal.macros.EnvironmentMacroSupplier;
import org.eclipse.cdt.managedbuilder.internal.macros.IMacroContextInfo;
import org.eclipse.cdt.managedbuilder.internal.macros.MacroResolver;
import org.eclipse.cdt.managedbuilder.internal.macros.UserDefinedMacroSupplier;
import org.eclipse.cdt.managedbuilder.macros.BuildMacroException;
import org.eclipse.cdt.managedbuilder.macros.IBuildMacro;
import org.eclipse.cdt.managedbuilder.macros.IReservedMacroNameSupplier;
import org.eclipse.core.resources.IResource;

public class BuildfileMacroSubstitutor
extends DefaultMacroSubstitutor {
    private static final String PATTERN_MACRO_NAME = "=";
    private IConfiguration fConfiguration;
    private IBuilder fBuilder;
    private HashSet fCaseInsensitiveReferencedNames;

    public BuildfileMacroSubstitutor(int contextType, Object contextData, String inexistentMacroValue, String listDelimiter) {
        super(contextType, contextData, inexistentMacroValue, listDelimiter);
        this.init();
    }

    public BuildfileMacroSubstitutor(IMacroContextInfo contextInfo, String inexistentMacroValue, String listDelimiter) {
        super(contextInfo, inexistentMacroValue, listDelimiter);
        this.init();
    }

    private void init() {
        IToolChain toolChain;
        IMacroContextInfo contextInfo = this.getMacroContextInfo();
        if (contextInfo == null) {
            return;
        }
        int type = contextInfo.getContextType();
        switch (type) {
            case 1: {
                contextInfo = contextInfo.getNext();
                if (contextInfo == null) break;
            }
            case 2: {
                contextInfo = contextInfo.getNext();
                if (contextInfo == null) break;
            }
            case 3: {
                Object contextData = contextInfo.getContextData();
                if (!(contextData instanceof IConfiguration)) break;
                this.fConfiguration = (IConfiguration)contextData;
                break;
            }
            case 4: {
                IResource rc;
                Object contextData = contextInfo.getContextData();
                if (!(contextData instanceof IManagedProject) || (rc = ((IManagedProject)contextData).getOwner()) == null) break;
                IManagedBuildInfo info = ManagedBuildManager.getBuildInfo(rc);
                this.fConfiguration = info.getDefaultConfiguration();
            }
        }
        if (this.fConfiguration != null && (toolChain = this.fConfiguration.getToolChain()) != null) {
            this.fBuilder = toolChain.getBuilder();
        }
    }

    protected DefaultMacroSubstitutor.ResolvedMacro resolveMacro(IBuildMacro macro) throws BuildMacroException {
        String ref;
        DefaultMacroSubstitutor.ResolvedMacro resolved = null;
        if (this.fConfiguration != null && this.fBuilder != null && !UserDefinedMacroSupplier.getInstance().areMacrosExpanded(this.fConfiguration) && macro instanceof EnvironmentMacroSupplier.EnvVarMacro && !MacroResolver.isStringListMacro(macro.getMacroValueType()) && (ref = this.getMacroReference(macro)) != null) {
            resolved = new DefaultMacroSubstitutor.ResolvedMacro((DefaultMacroSubstitutor)this, macro.getName(), ref);
        }
        if (resolved != null) {
            return resolved;
        }
        return super.resolveMacro(macro);
    }

    public IConfiguration getConfiguration() {
        return this.fConfiguration;
    }

    protected IReservedMacroNameSupplier getReservedMacroNameSupplier() {
        if (this.fBuilder == null) {
            return null;
        }
        IReservedMacroNameSupplier supplier = this.fBuilder.getReservedMacroNameSupplier();
        if (supplier == null) {
            supplier = new DefaultReservedMacroNameSupplier(this.fConfiguration);
        }
        return supplier;
    }

    protected String getMacroReference(IBuildMacro macro) {
        String pattern;
        String macroName = macro.getName();
        String ref = null;
        IReservedMacroNameSupplier supplier = this.getReservedMacroNameSupplier();
        macroName = EnvVarOperationProcessor.normalizeName(macroName);
        if (!(supplier != null && supplier.isReservedName(macroName, this.fConfiguration) || (pattern = this.fBuilder.getBuilderVariablePattern()) == null || pattern.indexOf(PATTERN_MACRO_NAME) == -1 || !this.fBuilder.isVariableCaseSensitive() && !this.getCaseInsensitiveReferencedNames().add(macroName.toUpperCase()))) {
            ref = pattern.replaceAll(PATTERN_MACRO_NAME, macroName);
        }
        return ref;
    }

    protected Set getCaseInsensitiveReferencedNames() {
        if (this.fCaseInsensitiveReferencedNames == null) {
            this.fCaseInsensitiveReferencedNames = new HashSet();
        }
        return this.fCaseInsensitiveReferencedNames;
    }

    public void setMacroContextInfo(IMacroContextInfo info) throws BuildMacroException {
        super.setMacroContextInfo(info);
        this.init();
    }

    public void setMacroContextInfo(int contextType, Object contextData) throws BuildMacroException {
        super.setMacroContextInfo(contextType, contextData);
        this.init();
    }

    private class DefaultReservedMacroNameSupplier
    implements IReservedMacroNameSupplier {
        String[] fReservedNames;

        public DefaultReservedMacroNameSupplier(IConfiguration configuration) {
            IBuilder builder = configuration.getToolChain().getBuilder();
            String[] reservedNames = builder.getReservedMacroNames();
            String[] buildVars = this.getConfigurationReservedNames(configuration);
            if (reservedNames == null || reservedNames.length == 0) {
                this.fReservedNames = buildVars;
            } else if (buildVars == null || buildVars.length == 0) {
                this.fReservedNames = reservedNames;
            } else {
                this.fReservedNames = new String[reservedNames.length + buildVars.length];
                System.arraycopy(reservedNames, 0, this.fReservedNames, 0, reservedNames.length);
                System.arraycopy(buildVars, 0, this.fReservedNames, reservedNames.length, buildVars.length);
            }
        }

        public boolean isReservedName(String macroName, IConfiguration configuration) {
            if (this.fReservedNames != null && this.fReservedNames.length > 0) {
                int i = 0;
                while (i < this.fReservedNames.length) {
                    Pattern p = Pattern.compile(this.fReservedNames[i]);
                    Matcher m = p.matcher(macroName);
                    if (m.matches()) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }

        protected String[] getConfigurationReservedNames(IConfiguration configuration) {
            ITool[] tools = configuration.getFilteredTools();
            if (tools != null) {
                HashSet<String> set = new HashSet<String>();
                int i = 0;
                while (i < tools.length) {
                    IInputType[] its;
                    IOutputType[] ots = tools[i].getOutputTypes();
                    if (ots != null) {
                        int j = 0;
                        while (j < ots.length) {
                            String varName = ots[j].getBuildVariable();
                            if (varName != null) {
                                set.add(varName);
                            }
                            ++j;
                        }
                    }
                    if ((its = tools[i].getInputTypes()) != null) {
                        int j = 0;
                        while (j < its.length) {
                            String varName = its[j].getBuildVariable();
                            if (varName != null) {
                                set.add(varName);
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
                return set.toArray(new String[set.size()]);
            }
            return null;
        }
    }
}

