/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.macros;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.managedbuilder.internal.macros.MacroResolver;
import org.eclipse.cdt.managedbuilder.internal.macros.StorableBuildMacro;
import org.eclipse.cdt.managedbuilder.macros.BuildMacroException;
import org.eclipse.cdt.managedbuilder.macros.IBuildMacro;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StorableMacros {
    public static final String MACROS_ELEMENT_NAME = "macros";
    public static final String EXPAND_ENVIRONMENT_MACROS = "expandEnvironmentMacros";
    public static final String TRUE = "true";
    private Map fMacros;
    private boolean fExpandInMakefile = false;
    private boolean fIsDirty = false;
    private boolean fIsChanged = false;

    private Map getMap() {
        if (this.fMacros == null) {
            this.fMacros = new HashMap();
        }
        return this.fMacros;
    }

    public StorableMacros() {
    }

    public StorableMacros(Element element) {
        this.load(element);
    }

    private void load(Element element) {
        this.fExpandInMakefile = TRUE.equals(element.getAttribute(EXPAND_ENVIRONMENT_MACROS));
        NodeList nodeList = element.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            String name = node.getNodeName();
            if ("stringMacro".equals(name)) {
                this.addMacro(new StorableBuildMacro((Element)node));
            } else if ("stringListMacro".equals(name)) {
                this.addMacro(new StorableBuildMacro((Element)node));
            }
            ++i;
        }
        this.fIsDirty = false;
        this.fIsChanged = false;
    }

    public void serialize(Document doc, Element element) {
        if (this.fExpandInMakefile) {
            element.setAttribute(EXPAND_ENVIRONMENT_MACROS, TRUE);
        }
        if (this.fMacros != null) {
            Iterator iter = this.fMacros.values().iterator();
            while (iter.hasNext()) {
                StorableBuildMacro macro = (StorableBuildMacro)iter.next();
                Element macroEl = MacroResolver.isStringListMacro(macro.getMacroValueType()) ? doc.createElement("stringListMacro") : doc.createElement("stringMacro");
                element.appendChild(macroEl);
                macro.serialize(doc, macroEl);
            }
        }
        this.fIsDirty = false;
    }

    private void addMacro(IBuildMacro macro) {
        String name = macro.getName();
        if (name == null) {
            return;
        }
        this.getMap().put(name, macro);
    }

    public IBuildMacro createMacro(String name, int type, String value) {
        if (name == null || "".equals(name = name.trim()) || MacroResolver.isStringListMacro(type)) {
            return null;
        }
        IBuildMacro macro = this.checkMacro(name, type, value);
        if (macro == null) {
            macro = new StorableBuildMacro(name, type, value);
            this.addMacro(macro);
            this.fIsDirty = true;
            this.fIsChanged = true;
        }
        return macro;
    }

    public IBuildMacro checkMacro(String name, int type, String value) {
        IBuildMacro macro = this.getMacro(name);
        if (macro != null && macro.getName().equals(name) && macro.getMacroValueType() == type) {
            try {
                String val = macro.getStringValue();
                if (val != null && val.equals(value) || val == value) {
                    return macro;
                }
            }
            catch (BuildMacroException buildMacroException) {}
        }
        return null;
    }

    public IBuildMacro checkMacro(String name, int type, String[] value) {
        IBuildMacro macro = this.getMacro(name);
        if (macro != null && macro.getName().equals(name) && macro.getMacroValueType() == type) {
            try {
                String[] val = macro.getStringListValue();
                if (val != null) {
                    if (value != null && value.length == val.length) {
                        int i = 0;
                        while (i < val.length) {
                            if (!value[i].equals(val[i])) break;
                            ++i;
                        }
                        if (i == value.length) {
                            return macro;
                        }
                    }
                } else if (value == val) {
                    return macro;
                }
            }
            catch (BuildMacroException buildMacroException) {}
        }
        return null;
    }

    public void setMacros(IBuildMacro[] macros) {
        if (macros == null || macros.length == 0) {
            this.deleteAll();
        } else {
            if (this.getMap().size() != 0) {
                Iterator iter = this.getMap().values().iterator();
                while (iter.hasNext()) {
                    IBuildMacro m = (IBuildMacro)iter.next();
                    int i = 0;
                    while (i < macros.length) {
                        if (m.getName().equals(macros[i].getName())) break;
                        ++i;
                    }
                    if (i != macros.length) continue;
                    this.deleteMacro(m.getName());
                }
            }
            this.createMacros(macros);
        }
    }

    public void createMacros(IBuildMacro[] macros) {
        int i = 0;
        while (i < macros.length) {
            this.createMacro(macros[i]);
            ++i;
        }
    }

    public IBuildMacro createMacro(IBuildMacro copy) {
        String name = copy.getName();
        if (name == null || "".equals(name = name.trim())) {
            return null;
        }
        int type = copy.getMacroValueType();
        IBuildMacro macro = null;
        try {
            if (MacroResolver.isStringListMacro(type)) {
                String[] value = copy.getStringListValue();
                macro = this.checkMacro(name, type, value);
                if (macro == null) {
                    macro = new StorableBuildMacro(name, type, value);
                    this.addMacro(macro);
                    this.fIsDirty = true;
                    this.fIsChanged = true;
                }
            } else {
                String value = copy.getStringValue();
                macro = this.checkMacro(name, type, value);
                if (macro == null) {
                    macro = new StorableBuildMacro(name, type, value);
                    this.addMacro(macro);
                    this.fIsDirty = true;
                    this.fIsChanged = true;
                }
            }
        }
        catch (BuildMacroException buildMacroException) {}
        return macro;
    }

    public IBuildMacro createMacro(String name, int type, String[] value) {
        if (name == null || "".equals(name = name.trim()) || !MacroResolver.isStringListMacro(type)) {
            return null;
        }
        IBuildMacro macro = this.checkMacro(name, type, value);
        if (macro == null) {
            macro = new StorableBuildMacro(name, type, value);
            this.addMacro(macro);
            this.fIsDirty = true;
            this.fIsChanged = true;
        }
        return macro;
    }

    public boolean isDirty() {
        return this.fIsDirty;
    }

    public void setDirty(boolean dirty) {
        this.fIsDirty = dirty;
    }

    public boolean isChanged() {
        return this.fIsChanged;
    }

    public boolean isExpanded() {
        return this.fExpandInMakefile;
    }

    public void setExpanded(boolean expand) {
        if (this.fExpandInMakefile != expand) {
            this.fExpandInMakefile = expand;
            this.fIsDirty = true;
            this.fIsChanged = true;
        }
    }

    public void setChanged(boolean changed) {
        this.fIsChanged = changed;
    }

    public IBuildMacro getMacro(String name) {
        if (name == null || "".equals(name = name.trim())) {
            return null;
        }
        return (IBuildMacro)this.getMap().get(name);
    }

    public IBuildMacro[] getMacros() {
        Collection macros = this.getMap().values();
        return macros.toArray(new IBuildMacro[macros.size()]);
    }

    public IBuildMacro deleteMacro(String name) {
        if (name == null || "".equals(name = name.trim())) {
            return null;
        }
        IBuildMacro macro = (IBuildMacro)this.getMap().remove(name);
        if (macro != null) {
            this.fIsDirty = true;
            this.fIsChanged = true;
        }
        return macro;
    }

    public boolean deleteAll() {
        Map map = this.getMap();
        if (map.size() > 0) {
            this.fIsDirty = true;
            this.fIsChanged = true;
            map.clear();
            return true;
        }
        return false;
    }
}

