/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.corext.textmanipulation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.IRegion;
import org.eclipse.text.edits.TextEdit;

public class GroupDescription {
    private String fDescription;
    private List fEdits;

    public GroupDescription() {
        this("NO_DESCRIPTION");
    }

    public GroupDescription(String description) {
        Assert.isNotNull((Object)description);
        this.fDescription = description;
        this.fEdits = new ArrayList(3);
    }

    public GroupDescription(String description, TextEdit[] edits) {
        Assert.isNotNull((Object)description);
        Assert.isNotNull((Object)edits);
        this.fDescription = description;
        this.fEdits = new ArrayList<TextEdit>(Arrays.asList(edits));
    }

    public void addTextEdit(TextEdit edit) {
        this.fEdits.add(edit);
    }

    public boolean hasTextEdits() {
        return this.fEdits.isEmpty();
    }

    public TextEdit[] getTextEdits() {
        return this.fEdits.toArray(new TextEdit[this.fEdits.size()]);
    }

    public IRegion getTextRange() {
        int size = this.fEdits.size();
        if (size == 1) {
            return ((TextEdit)this.fEdits.get(0)).getRegion();
        }
        return TextEdit.getCoverage((TextEdit[])this.fEdits.toArray(new TextEdit[this.fEdits.size()]));
    }

    public String getName() {
        return this.fDescription;
    }
}

