/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.buildconsole;

import org.eclipse.cdt.internal.ui.buildconsole.BuildConsolePartition;
import org.eclipse.cdt.internal.ui.buildconsole.BuildConsolePartitioner;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;

public class BuildConsoleViewer
extends TextViewer
implements LineStyleListener {
    protected InternalDocumentListener fInternalDocumentListener = new InternalDocumentListener();
    private boolean fAutoScroll = true;

    public void setAutoScroll(boolean scroll) {
        this.fAutoScroll = scroll;
    }

    public boolean isAutoScroll() {
        return this.fAutoScroll;
    }

    public BuildConsoleViewer(Composite parent) {
        super(parent, BuildConsoleViewer.getSWTStyles());
        this.getTextWidget().setDoubleClickEnabled(true);
        this.getTextWidget().setFont(parent.getFont());
        this.getTextWidget().addLineStyleListener((LineStyleListener)this);
        this.getTextWidget().setEditable(false);
        this.getTextWidget().setWordWrap(true);
    }

    private static int getSWTStyles() {
        int styles = 768;
        return styles;
    }

    protected void revealEndOfDocument() {
        if (this.isAutoScroll()) {
            IDocument doc = this.getDocument();
            int lines = doc.getNumberOfLines();
            try {
                int lineEndOffset;
                int lineStartOffset = doc.getLineOffset(lines - 1);
                StyledText widget = this.getTextWidget();
                if (lineStartOffset > 0) {
                    widget.setCaretOffset(lineStartOffset);
                    widget.showSelection();
                }
                if ((lineEndOffset = lineStartOffset + doc.getLineLength(lines - 1)) > 0) {
                    widget.setCaretOffset(lineEndOffset);
                }
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    public void setDocument(IDocument doc) {
        IDocument oldDoc = this.getDocument();
        IDocument document = doc;
        if (oldDoc == null && document == null) {
            return;
        }
        if (oldDoc != null) {
            oldDoc.removeDocumentListener((IDocumentListener)this.fInternalDocumentListener);
            if (oldDoc.equals(document)) {
                document.addDocumentListener((IDocumentListener)this.fInternalDocumentListener);
                return;
            }
        }
        super.setDocument(document);
        if (document != null) {
            this.revealEndOfDocument();
            document.addDocumentListener((IDocumentListener)this.fInternalDocumentListener);
        }
    }

    public void lineGetStyle(LineStyleEvent event) {
        BuildConsolePartitioner partitioner;
        IDocument document = this.getDocument();
        if (document != null && (partitioner = (BuildConsolePartitioner)document.getDocumentPartitioner()) != null) {
            ITypedRegion[] regions = partitioner.computePartitioning(event.lineOffset, event.lineOffset + event.lineText.length());
            StyleRange[] styles = new StyleRange[regions.length];
            int i = 0;
            while (i < regions.length) {
                BuildConsolePartition partition = (BuildConsolePartition)regions[i];
                Color color = partition.getStream().getColor();
                styles[i] = new StyleRange(partition.getOffset(), partition.getLength(), color, null);
                ++i;
            }
            event.styles = styles;
        }
    }

    class InternalDocumentListener
    implements IDocumentListener {
        InternalDocumentListener() {
        }

        public void documentAboutToBeChanged(DocumentEvent e) {
        }

        public void documentChanged(DocumentEvent e) {
            BuildConsoleViewer.this.revealEndOfDocument();
        }
    }
}

