/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.cview;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.internal.ui.actions.SelectionConverter;
import org.eclipse.cdt.internal.ui.cview.CView;
import org.eclipse.cdt.internal.ui.cview.CViewActionGroup;
import org.eclipse.cdt.internal.ui.cview.CViewMessages;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.OpenFileAction;
import org.eclipse.ui.actions.OpenInNewWindowAction;
import org.eclipse.ui.actions.OpenWithMenu;

public class OpenFileGroup
extends CViewActionGroup {
    private OpenFileAction openFileAction;
    static /* synthetic */ Class class$0;

    public OpenFileGroup(CView cview) {
        super(cview);
    }

    protected void makeActions() {
        this.openFileAction = new OpenFileAction(this.getCView().getSite().getPage());
    }

    public void fillContextMenu(IMenuManager menu) {
        boolean onlyFilesSelected;
        IStructuredSelection celements = (IStructuredSelection)this.getContext().getSelection();
        IStructuredSelection selection = SelectionConverter.convertSelectionToResources((ISelection)celements);
        boolean anyResourceSelected = !selection.isEmpty() && SelectionConverter.allResourcesAreOfType(selection, 7);
        boolean bl = onlyFilesSelected = !selection.isEmpty() && SelectionConverter.allResourcesAreOfType(selection, 1);
        if (onlyFilesSelected) {
            this.openFileAction.selectionChanged(selection);
            menu.add((IAction)this.openFileAction);
            this.fillOpenWithMenu(menu, selection);
        }
        if (anyResourceSelected) {
            this.addNewWindowAction(menu, selection);
        }
    }

    private void fillOpenWithMenu(IMenuManager menu, IStructuredSelection selection) {
        if (selection.size() != 1) {
            return;
        }
        Object element = selection.getFirstElement();
        if (!(element instanceof IFile)) {
            return;
        }
        MenuManager submenu = new MenuManager(CViewMessages.getString("OpenWithMenu.label"));
        submenu.add((IContributionItem)new OpenWithMenu(this.getCView().getSite().getPage(), (IAdaptable)((IFile)element)));
        menu.add((IContributionItem)submenu);
    }

    private void addNewWindowAction(IMenuManager menu, IStructuredSelection selection) {
        if (selection.size() != 1) {
            return;
        }
        Object element = selection.getFirstElement();
        if (!(element instanceof IContainer)) {
            return;
        }
        if (element instanceof IProject && !((IProject)element).isOpen()) {
            return;
        }
        menu.add((IAction)new OpenInNewWindowAction(this.getCView().getSite().getWorkbenchWindow(), (IAdaptable)((IContainer)element)));
    }

    public void fillActionBars(IActionBars actionBars) {
    }

    public void updateActionBars() {
    }

    public void runDefaultAction(IStructuredSelection selection) {
        block10: {
            Object obj = selection.getFirstElement();
            if (obj instanceof ICElement) {
                ICElement celement = (ICElement)obj;
                try {
                    IEditorPart part = EditorUtility.openInEditor(celement);
                    if (part == null) break block10;
                    IWorkbenchPage page = this.getCView().getSite().getPage();
                    page.bringToTop((IWorkbenchPart)part);
                    if (celement instanceof ISourceReference) {
                        EditorUtility.revealInEditor(part, celement);
                    }
                }
                catch (Exception exception) {}
            } else if (obj instanceof IAdaptable) {
                IResource element;
                IAdaptable iAdaptable = (IAdaptable)obj;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((element = (IResource)iAdaptable.getAdapter((Class)clazz)) instanceof IFile) {
                    this.openFileAction.selectionChanged(selection);
                    this.openFileAction.run();
                }
            }
        }
    }
}

