/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.cview;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.cview.CViewMessages;
import org.eclipse.cdt.internal.ui.dnd.CDTViewerDropAdapter;
import org.eclipse.cdt.internal.ui.dnd.TransferDropTargetListener;
import org.eclipse.cdt.internal.ui.util.ExceptionHandler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;

public class SelectionTransferDropAdapter
extends CDTViewerDropAdapter
implements TransferDropTargetListener {
    private List fElements;
    private ICElement[] fMoveData;
    private ICElement[] fCopyData;
    private static final long DROP_TIME_DIFF_TRESHOLD = 150L;

    public SelectionTransferDropAdapter(StructuredViewer viewer) {
        super(viewer, 24);
    }

    public Transfer getTransfer() {
        return LocalSelectionTransfer.getInstance();
    }

    public boolean isEnabled(DropTargetEvent event) {
        Object target;
        Object object = target = event.item != null ? event.item.getData() : null;
        if (target == null) {
            return false;
        }
        return target instanceof ISourceReference;
    }

    public void dragEnter(DropTargetEvent event) {
        this.clear();
        super.dragEnter(event);
    }

    public void dragLeave(DropTargetEvent event) {
        this.clear();
        super.dragLeave(event);
    }

    private void clear() {
        this.fElements = null;
        this.fMoveData = null;
        this.fCopyData = null;
    }

    public void validateDrop(Object target, DropTargetEvent event, int operation) {
        event.detail = 0;
        if (this.tooFast(event)) {
            return;
        }
        this.initializeSelection();
        try {
            switch (operation) {
                case 16: {
                    event.detail = this.handleValidateDefault(target, event);
                    break;
                }
                case 1: {
                    event.detail = this.handleValidateCopy(target, event);
                    break;
                }
                case 2: {
                    event.detail = this.handleValidateMove(target, event);
                    break;
                }
                case 4: {
                    event.detail = this.handleValidateLink(target, event);
                }
            }
        }
        catch (CModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), CViewMessages.getString("SelectionTransferDropAdapter.error.title"), CViewMessages.getString("SelectionTransferDropAdapter.error.message"));
            event.detail = 0;
        }
    }

    protected void initializeSelection() {
        if (this.fElements != null) {
            return;
        }
        ISelection s = LocalSelectionTransfer.getInstance().getSelection();
        if (!(s instanceof IStructuredSelection)) {
            return;
        }
        this.fElements = ((IStructuredSelection)s).toList();
    }

    private boolean tooFast(DropTargetEvent event) {
        return Math.abs(LocalSelectionTransfer.getInstance().getSelectionSetTime() - ((long)event.time & 0xFFFFFFFFL)) < 150L;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void drop(Object target, DropTargetEvent event) {
        try {
            try {
                switch (event.detail) {
                    case 2: {
                        this.handleDropMove(target, event);
                        break;
                    }
                    case 1: {
                        this.handleDropCopy(target, event);
                        break;
                    }
                    case 4: {
                        this.handleDropLink(target, event);
                    }
                }
            }
            catch (CModelException e) {
                ExceptionHandler.handle((CoreException)((Object)e), CViewMessages.getString("SelectionTransferDropAdapter.error.title"), CViewMessages.getString("SelectionTransferDropAdapter.error.message"));
            }
            catch (InvocationTargetException e) {
                ExceptionHandler.handle(e, CViewMessages.getString("SelectionTransferDropAdapter.error.title"), CViewMessages.getString("SelectionTransferDropAdapter.error.exception"));
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            event.detail = 0;
            throw throwable;
        }
        {
            Object var4_7 = null;
            event.detail = 0;
            return;
        }
    }

    private int handleValidateDefault(Object target, DropTargetEvent event) throws CModelException {
        if (target == null) {
            return 0;
        }
        return this.handleValidateMove(target, event);
    }

    private int handleValidateMove(Object target, DropTargetEvent event) throws CModelException {
        ICElement[] cElements;
        if (target == null || this.fElements.contains(target)) {
            return 0;
        }
        if (this.fMoveData == null && (cElements = SelectionTransferDropAdapter.getCElements(this.fElements)) != null && cElements.length > 0) {
            this.fMoveData = cElements;
        }
        if (!this.canMoveElements()) {
            return 0;
        }
        if (target instanceof ISourceReference) {
            return 2;
        }
        return 0;
    }

    private boolean canMoveElements() {
        if (this.fMoveData != null) {
            return this.hasCommonParent(this.fMoveData);
        }
        return false;
    }

    private boolean hasCommonParent(ICElement[] elements) {
        if (elements.length > 1) {
            ICElement parent = elements[0];
            int i = 0;
            while (i < elements.length) {
                ICElement p = elements[i].getParent();
                if (parent == null && p != null) {
                    return false;
                }
                if (!parent.equals(p)) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private void handleDropLink(Object target, DropTargetEvent event) {
    }

    private int handleValidateLink(Object target, DropTargetEvent event) {
        return 0;
    }

    private void handleDropMove(Object target, DropTargetEvent event) throws CModelException, InvocationTargetException, InterruptedException {
        final ICElement[] cElements = SelectionTransferDropAdapter.getCElements(this.fElements);
        if (target instanceof ICElement) {
            ICElement cTarget;
            ICElement parent = cTarget = (ICElement)target;
            boolean isTargetTranslationUnit = cTarget instanceof ITranslationUnit;
            if (!isTargetTranslationUnit) {
                parent = cTarget.getParent();
            }
            final ICElement[] containers = new ICElement[cElements.length];
            int i = 0;
            while (i < containers.length) {
                containers[i] = parent;
                ++i;
            }
            ICElement[] neighbours = null;
            if (!isTargetTranslationUnit) {
                neighbours = new ICElement[cElements.length];
                int i2 = 0;
                while (i2 < neighbours.length) {
                    neighbours[i2] = cTarget;
                    ++i2;
                }
            }
            final ICElement[] siblings = neighbours;
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        CoreModel.getDefault().getCModel().move(cElements, containers, siblings, null, false, monitor);
                    }
                    catch (CModelException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            this.run(runnable);
        }
    }

    private int handleValidateCopy(Object target, DropTargetEvent event) throws CModelException {
        ICElement[] cElements;
        if (target == null) {
            return 0;
        }
        if (this.fCopyData == null && (cElements = SelectionTransferDropAdapter.getCElements(this.fElements)) != null && cElements.length > 0) {
            this.fCopyData = cElements;
        }
        if (!this.canCopyElements()) {
            return 0;
        }
        if (target instanceof ISourceReference) {
            return 1;
        }
        return 0;
    }

    private boolean canCopyElements() {
        if (this.fCopyData != null) {
            return this.hasCommonParent(this.fCopyData);
        }
        return false;
    }

    private void handleDropCopy(Object target, DropTargetEvent event) throws CModelException, InvocationTargetException, InterruptedException {
        final ICElement[] cElements = SelectionTransferDropAdapter.getCElements(this.fElements);
        if (target instanceof ICElement) {
            ICElement cTarget;
            ICElement parent = cTarget = (ICElement)target;
            boolean isTargetTranslationUnit = cTarget instanceof ITranslationUnit;
            if (!isTargetTranslationUnit) {
                parent = cTarget.getParent();
            }
            final ICElement[] containers = new ICElement[cElements.length];
            int i = 0;
            while (i < containers.length) {
                containers[i] = parent;
                ++i;
            }
            ICElement[] neighbours = null;
            if (!isTargetTranslationUnit) {
                neighbours = new ICElement[cElements.length];
                int i2 = 0;
                while (i2 < neighbours.length) {
                    neighbours[i2] = cTarget;
                    ++i2;
                }
            }
            final ICElement[] siblings = neighbours;
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        CoreModel.getDefault().getCModel().copy(cElements, containers, siblings, null, false, monitor);
                    }
                    catch (CModelException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            this.run(runnable);
        }
    }

    private Shell getShell() {
        return this.getViewer().getControl().getShell();
    }

    public void run(IRunnableWithProgress runnable) throws InterruptedException, InvocationTargetException {
        ProgressMonitorDialog context = new ProgressMonitorDialog(this.getShell());
        context.run(true, true, runnable);
    }

    public static ICElement[] getCElements(List elements) {
        ArrayList resources = new ArrayList(elements.size());
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (element instanceof ITranslationUnit || !(element instanceof ICElement)) continue;
            resources.add(element);
        }
        return resources.toArray(new ICElement[resources.size()]);
    }
}

