/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IPDOMManager;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.dialogs.ICOptionContainer;
import org.eclipse.cdt.ui.dialogs.IndexerBlock;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class IndexerPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
ICOptionContainer {
    private IndexerBlock fOptionBlock;
    private Button applyIndexerToAllButton;

    public IndexerPreferencePage() {
        this.setPreferenceStore(CUIPlugin.getDefault().getPreferenceStore());
        this.setDescription(PreferencesMessages.getString("IndexerPrefs.description"));
        this.fOptionBlock = new IndexerBlock();
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        composite.setLayout((Layout)layout);
        this.fOptionBlock.createControl(composite);
        this.applyIndexerToAllButton = new Button(composite, 32);
        this.applyIndexerToAllButton.setText(CUIPlugin.getResourceString("IndexerPreferencePage.applyToAllProjects"));
        return composite;
    }

    public void init(IWorkbench workbench) {
    }

    public void updateContainer() {
    }

    public IProject getProject() {
        return null;
    }

    public Preferences getPreferences() {
        return null;
    }

    public boolean performOk() {
        try {
            this.fOptionBlock.performApply(null);
            if (this.applyIndexerToAllButton.getSelection()) {
                String indexerName = this.fOptionBlock.getSelectedIndexerID();
                String indexerId = this.fOptionBlock.getIndexerPageId(indexerName);
                new ApplyIndexer(indexerId).schedule();
            }
        }
        catch (CoreException coreException) {}
        CUIPlugin.getDefault().savePluginPreferences();
        return true;
    }

    private static class ApplyIndexer
    extends Job {
        private final String indexerId;

        public ApplyIndexer(String indexerId) {
            super("ApplyIndexer");
            this.setSystem(true);
            this.indexerId = indexerId;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                IPDOMManager manager = CCorePlugin.getPDOMManager();
                ICProject[] projects = CoreModel.getDefault().getCModel().getCProjects();
                int i = 0;
                while (i < projects.length) {
                    manager.setIndexerId(projects[i], this.indexerId);
                    ++i;
                }
                return Status.OK_STATUS;
            }
            catch (CoreException e) {
                return e.getStatus();
            }
        }
    }
}

