/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text;

import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.editor.IReconcilingParticipant;
import org.eclipse.cdt.internal.ui.text.CWordFinder;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.IWorkingCopyManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.ui.texteditor.ITextEditor;

public class CReconcilingStrategy
implements IReconcilingStrategy {
    private ITextEditor fEditor;
    private IWorkingCopyManager fManager;
    private IProgressMonitor fProgressMonitor;
    private String txt = null;

    public CReconcilingStrategy(CEditor editor) {
        this.fEditor = editor;
        this.fManager = CUIPlugin.getDefault().getWorkingCopyManager();
    }

    public void setDocument(IDocument document) {
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.fProgressMonitor = monitor;
    }

    public void reconcile(IRegion region) {
        this.reconcile();
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion region) {
        IWorkingCopy tu = this.fManager.getWorkingCopy(this.fEditor.getEditorInput());
        if (tu != null && tu.isWorkingCopy()) {
            try {
                if (tu.isConsistent()) {
                    return;
                }
            }
            catch (CModelException cModelException) {}
        }
        boolean needReconcile = true;
        int dOff = dirtyRegion.getOffset();
        int dLen = dirtyRegion.getLength();
        IDocument doc = this.fEditor.getDocumentProvider().getDocument((Object)this.fEditor.getEditorInput());
        if (doc != null && !CWordFinder.isGlobal(doc, dOff)) {
            String s = "";
            if (dirtyRegion.getType().charAt(2) == 'i') {
                s = dirtyRegion.getText();
                if (!CWordFinder.hasCBraces(s)) {
                    CModelManager.getDefault().fireShift((ICElement)tu, dOff, dLen, CWordFinder.countLFs(s));
                    needReconcile = false;
                }
            } else if (this.txt != null && this.txt.length() == doc.getLength() + dLen && !CWordFinder.hasCBraces(s = this.txt.substring(dOff, dOff + dLen))) {
                CModelManager.getDefault().fireShift((ICElement)tu, dOff, -dLen, -CWordFinder.countLFs(s));
                needReconcile = false;
            }
        }
        if (needReconcile) {
            this.reconcile();
        }
        this.txt = doc.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reconcile() {
        try {
            IWorkingCopy tu = this.fManager.getWorkingCopy(this.fEditor.getEditorInput());
            if (tu != null && tu.isWorkingCopy()) {
                IWorkingCopy workingCopy;
                IWorkingCopy iWorkingCopy = workingCopy = tu;
                synchronized (iWorkingCopy) {
                    workingCopy.reconcile(true, this.fProgressMonitor);
                }
            }
            if (this.fEditor instanceof IReconcilingParticipant) {
                IReconcilingParticipant p = (IReconcilingParticipant)this.fEditor;
                p.reconciled(true);
            }
        }
        catch (CModelException cModelException) {}
    }
}

