/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.wizards.filewizard;

import org.eclipse.cdt.core.CConventions;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.cdt.internal.ui.wizards.filewizard.AbstractFileCreationWizardPage;
import org.eclipse.cdt.internal.ui.wizards.filewizard.NewFileWizardMessages;
import org.eclipse.cdt.internal.ui.wizards.filewizard.NewSourceFileGenerator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class NewHeaderFileCreationWizardPage
extends AbstractFileCreationWizardPage {
    private ITranslationUnit fNewFileTU = null;
    private StringDialogField fNewFileDialogField;

    public NewHeaderFileCreationWizardPage() {
        super(NewFileWizardMessages.getString("NewHeaderFileCreationWizardPage.title"));
        this.setDescription(NewFileWizardMessages.getString("NewHeaderFileCreationWizardPage.description"));
        this.fNewFileDialogField = new StringDialogField();
        this.fNewFileDialogField.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                NewHeaderFileCreationWizardPage.this.handleFieldChanged(2);
            }
        });
        this.fNewFileDialogField.setLabelText(NewFileWizardMessages.getString("NewHeaderFileCreationWizardPage.headerFile.label"));
    }

    protected void setFocus() {
        this.fNewFileDialogField.setFocus();
    }

    protected void createFileControls(Composite parent, int nColumns) {
        this.fNewFileDialogField.doFillIntoGrid(parent, nColumns);
        Text textControl = this.fNewFileDialogField.getTextControl(null);
        LayoutUtil.setWidthHint((Control)textControl, this.getMaxFieldWidth());
        textControl.addFocusListener((FocusListener)new AbstractFileCreationWizardPage.StatusFocusListener(2));
    }

    public IPath getFileFullPath() {
        IPath folderPath;
        String str = this.fNewFileDialogField.getText();
        Path path = null;
        if (str.length() > 0 && !(path = new Path(str)).isAbsolute() && (folderPath = this.getSourceFolderFullPath()) != null) {
            path = folderPath.append((IPath)path);
        }
        return path;
    }

    protected IStatus fileNameChanged() {
        StatusInfo status = new StatusInfo();
        IPath filePath = this.getFileFullPath();
        if (filePath == null) {
            status.setError(NewFileWizardMessages.getString("NewHeaderFileCreationWizardPage.error.EnterFileName"));
            return status;
        }
        IPath sourceFolderPath = this.getSourceFolderFullPath();
        if (sourceFolderPath == null || !sourceFolderPath.isPrefixOf(filePath)) {
            status.setError(NewFileWizardMessages.getString("NewHeaderFileCreationWizardPage.error.FileNotInSourceFolder"));
            return status;
        }
        IResource file = this.getWorkspaceRoot().findMember(filePath);
        if (file != null && file.exists()) {
            if (file.getType() == 1) {
                status.setError(NewFileWizardMessages.getString("NewHeaderFileCreationWizardPage.error.FileExists"));
            } else if (file.getType() == 2) {
                status.setError(NewFileWizardMessages.getString("NewHeaderFileCreationWizardPage.error.MatchingFolderExists"));
            } else {
                status.setError(NewFileWizardMessages.getString("NewHeaderFileCreationWizardPage.error.MatchingResourceExists"));
            }
            return status;
        }
        IPath folderPath = filePath.removeLastSegments(1).makeRelative();
        IResource folder = this.getWorkspaceRoot().findMember(folderPath);
        if (folder == null || !folder.exists() || folder.getType() != 4 && folder.getType() != 2) {
            status.setError(NewFileWizardMessages.getFormattedString("NewHeaderFileCreationWizardPage.error.FolderDoesNotExist", folderPath));
            return status;
        }
        IStatus convStatus = CConventions.validateHeaderFileName((IProject)this.getCurrentProject(), (String)filePath.lastSegment());
        if (convStatus.getSeverity() == 4) {
            status.setError(NewFileWizardMessages.getFormattedString("NewHeaderFileCreationWizardPage.error.InvalidFileName", convStatus.getMessage()));
            return status;
        }
        if (convStatus.getSeverity() == 2) {
            status.setWarning(NewFileWizardMessages.getFormattedString("NewHeaderFileCreationWizardPage.warning.FileNameDiscouraged", convStatus.getMessage()));
        }
        return status;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createFile(IProgressMonitor monitor) throws CoreException {
        IPath filePath = this.getFileFullPath();
        if (filePath == null) return;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            this.fNewFileTU = null;
            IFile newFile = NewSourceFileGenerator.createHeaderFile(filePath, true, monitor);
            if (newFile != null) {
                this.fNewFileTU = (ITranslationUnit)CoreModel.getDefault().create(newFile);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        monitor.done();
    }

    public ITranslationUnit getCreatedFileTU() {
        return this.fNewFileTU;
    }
}

