/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.actions;

import java.util.ArrayList;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.internal.ui.viewsupport.MemberFilter;
import org.eclipse.cdt.internal.ui.viewsupport.MemberFilterAction;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.PreferenceConstants;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.actions.ActionGroup;

public class MemberFilterActionGroup
extends ActionGroup {
    public static final int FILTER_NONPUBLIC = 1;
    public static final int FILTER_STATIC = 2;
    public static final int FILTER_FIELDS = 4;
    public static final int FILTER_LOCALTYPES = 8;
    public static final int ALL_FILTERS = 15;
    private static final String TAG_HIDEFIELDS = "hidefields";
    private static final String TAG_HIDESTATIC = "hidestatic";
    private static final String TAG_HIDENONPUBLIC = "hidenonpublic";
    private MemberFilterAction[] fFilterActions;
    private MemberFilter fFilter;
    StructuredViewer fViewer;
    private String fViewerId;
    private boolean fInViewMenu;

    public MemberFilterActionGroup(StructuredViewer viewer, String viewerId) {
        this(viewer, viewerId, false);
    }

    public MemberFilterActionGroup(StructuredViewer viewer, String viewerId, boolean inViewMenu) {
        this.fViewer = viewer;
        this.fViewerId = viewerId;
        this.fInViewMenu = inViewMenu;
        IPreferenceStore store = CUIPlugin.getDefault().getPreferenceStore();
        boolean doHideFields = store.getBoolean(this.getPreferenceKey(4));
        boolean doHideStatic = store.getBoolean(this.getPreferenceKey(2));
        boolean doHidePublic = store.getBoolean(this.getPreferenceKey(1));
        this.fFilter = new MemberFilter();
        if (doHideFields) {
            this.fFilter.addFilter(4);
        }
        if (doHideStatic) {
            this.fFilter.addFilter(2);
        }
        if (doHidePublic) {
            this.fFilter.addFilter(1);
        }
        String title = ActionMessages.getString("MemberFilterActionGroup.hide_fields.label");
        String helpContext = "org.eclipse.cdt.ui.filter_fields_action";
        MemberFilterAction hideFields = new MemberFilterAction(this, title, 4, helpContext, doHideFields);
        hideFields.setDescription(ActionMessages.getString("MemberFilterActionGroup.hide_fields.description"));
        hideFields.setToolTipText(ActionMessages.getString("MemberFilterActionGroup.hide_fields.tooltip"));
        CPluginImages.setImageDescriptors((IAction)hideFields, "lcl16/", "org.eclipse.cdt.ui.fields_co.gif");
        title = ActionMessages.getString("MemberFilterActionGroup.hide_static.label");
        helpContext = "org.eclipse.cdt.ui.filter_static_action";
        MemberFilterAction hideStatic = new MemberFilterAction(this, title, 2, helpContext, doHideStatic);
        hideStatic.setDescription(ActionMessages.getString("MemberFilterActionGroup.hide_static.description"));
        hideStatic.setToolTipText(ActionMessages.getString("MemberFilterActionGroup.hide_static.tooltip"));
        CPluginImages.setImageDescriptors((IAction)hideStatic, "lcl16/", "org.eclipse.cdt.ui.static_co.gif");
        title = ActionMessages.getString("MemberFilterActionGroup.hide_nonpublic.label");
        helpContext = "org.eclipse.cdt.ui.filter_public_action";
        MemberFilterAction hideNonPublic = new MemberFilterAction(this, title, 1, helpContext, doHidePublic);
        hideNonPublic.setDescription(ActionMessages.getString("MemberFilterActionGroup.hide_nonpublic.description"));
        hideNonPublic.setToolTipText(ActionMessages.getString("MemberFilterActionGroup.hide_nonpublic.tooltip"));
        CPluginImages.setImageDescriptors((IAction)hideNonPublic, "lcl16/", "org.eclipse.cdt.ui.public_co.gif");
        this.fFilterActions = new MemberFilterAction[]{hideFields, hideStatic, hideNonPublic};
        this.fViewer.addFilter((ViewerFilter)this.fFilter);
    }

    public MemberFilterActionGroup(StructuredViewer viewer, String viewerId, boolean inViewMenu, int availableFilters) {
        String helpContext;
        String title;
        boolean filterEnabled;
        this.fViewer = viewer;
        this.fViewerId = viewerId;
        this.fInViewMenu = inViewMenu;
        IPreferenceStore store = PreferenceConstants.getPreferenceStore();
        this.fFilter = new MemberFilter();
        ArrayList<MemberFilterAction> actions = new ArrayList<MemberFilterAction>(4);
        int filterProperty = 4;
        if (this.isSet(filterProperty, availableFilters)) {
            filterEnabled = store.getBoolean(this.getPreferenceKey(filterProperty));
            if (filterEnabled) {
                this.fFilter.addFilter(filterProperty);
            }
            title = ActionMessages.getString("MemberFilterActionGroup.hide_fields.label");
            helpContext = "org.eclipse.cdt.ui.filter_fields_action";
            MemberFilterAction hideFields = new MemberFilterAction(this, title, filterProperty, helpContext, filterEnabled);
            hideFields.setDescription(ActionMessages.getString("MemberFilterActionGroup.hide_fields.description"));
            hideFields.setToolTipText(ActionMessages.getString("MemberFilterActionGroup.hide_fields.tooltip"));
            CPluginImages.setImageDescriptors((IAction)hideFields, "lcl16/", "fields_co.gif");
            actions.add(hideFields);
        }
        if (this.isSet(filterProperty = 2, availableFilters)) {
            filterEnabled = store.getBoolean(this.getPreferenceKey(filterProperty));
            if (filterEnabled) {
                this.fFilter.addFilter(filterProperty);
            }
            title = ActionMessages.getString("MemberFilterActionGroup.hide_static.label");
            helpContext = "org.eclipse.cdt.ui.filter_static_action";
            MemberFilterAction hideStatic = new MemberFilterAction(this, title, 2, helpContext, filterEnabled);
            hideStatic.setDescription(ActionMessages.getString("MemberFilterActionGroup.hide_static.description"));
            hideStatic.setToolTipText(ActionMessages.getString("MemberFilterActionGroup.hide_static.tooltip"));
            CPluginImages.setImageDescriptors((IAction)hideStatic, "lcl16/", "static_co.gif");
            actions.add(hideStatic);
        }
        if (this.isSet(filterProperty = 1, availableFilters)) {
            filterEnabled = store.getBoolean(this.getPreferenceKey(filterProperty));
            if (filterEnabled) {
                this.fFilter.addFilter(filterProperty);
            }
            title = ActionMessages.getString("MemberFilterActionGroup.hide_nonpublic.label");
            helpContext = "org.eclipse.cdt.ui.filter_public_action";
            MemberFilterAction hideNonPublic = new MemberFilterAction(this, title, filterProperty, helpContext, filterEnabled);
            hideNonPublic.setDescription(ActionMessages.getString("MemberFilterActionGroup.hide_nonpublic.description"));
            hideNonPublic.setToolTipText(ActionMessages.getString("MemberFilterActionGroup.hide_nonpublic.tooltip"));
            CPluginImages.setImageDescriptors((IAction)hideNonPublic, "lcl16/", "public_co.gif");
            actions.add(hideNonPublic);
        }
        if (this.isSet(filterProperty = 8, availableFilters)) {
            filterEnabled = store.getBoolean(this.getPreferenceKey(filterProperty));
            if (filterEnabled) {
                this.fFilter.addFilter(filterProperty);
            }
            title = ActionMessages.getString("MemberFilterActionGroup.hide_localtypes.label");
            helpContext = "org.eclipse.cdt.ui.filter_localtypes_action";
            MemberFilterAction hideLocalTypes = new MemberFilterAction(this, title, filterProperty, helpContext, filterEnabled);
            hideLocalTypes.setDescription(ActionMessages.getString("MemberFilterActionGroup.hide_localtypes.description"));
            hideLocalTypes.setToolTipText(ActionMessages.getString("MemberFilterActionGroup.hide_localtypes.tooltip"));
            CPluginImages.setImageDescriptors((IAction)hideLocalTypes, "lcl16/", "localtypes_co.gif");
            actions.add(hideLocalTypes);
        }
        this.fFilterActions = actions.toArray(new MemberFilterAction[actions.size()]);
        this.fViewer.addFilter((ViewerFilter)this.fFilter);
    }

    private boolean isSet(int flag, int set) {
        return (flag & set) != 0;
    }

    private String getPreferenceKey(int filterProperty) {
        return "MemberFilterActionGroup." + this.fViewerId + '.' + String.valueOf(filterProperty);
    }

    public void setMemberFilter(int filterProperty, boolean set) {
        this.setMemberFilters(new int[]{filterProperty}, new boolean[]{set}, true);
    }

    private void setMemberFilters(int[] propertyKeys, boolean[] propertyValues, boolean refresh) {
        if (propertyKeys.length == 0) {
            return;
        }
        Assert.isTrue((propertyKeys.length == propertyValues.length ? 1 : 0) != 0);
        int i = 0;
        while (i < propertyKeys.length) {
            int filterProperty = propertyKeys[i];
            boolean set = propertyValues[i];
            if (set) {
                this.fFilter.addFilter(filterProperty);
            } else {
                this.fFilter.removeFilter(filterProperty);
            }
            IPreferenceStore store = CUIPlugin.getDefault().getPreferenceStore();
            int j = 0;
            while (j < this.fFilterActions.length) {
                int currProperty = this.fFilterActions[j].getFilterProperty();
                if (currProperty == filterProperty) {
                    this.fFilterActions[j].setChecked(set);
                }
                store.setValue(this.getPreferenceKey(currProperty), this.hasMemberFilter(currProperty));
                ++j;
            }
            ++i;
        }
        if (refresh) {
            this.fViewer.getControl().setRedraw(false);
            BusyIndicator.showWhile((Display)this.fViewer.getControl().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    MemberFilterActionGroup.this.fViewer.refresh();
                }
            });
            this.fViewer.getControl().setRedraw(true);
        }
    }

    public boolean hasMemberFilter(int filterProperty) {
        return this.fFilter.hasFilter(filterProperty);
    }

    public void saveState(IMemento memento) {
        memento.putString(TAG_HIDEFIELDS, String.valueOf(this.hasMemberFilter(4)));
        memento.putString(TAG_HIDESTATIC, String.valueOf(this.hasMemberFilter(2)));
        memento.putString(TAG_HIDENONPUBLIC, String.valueOf(this.hasMemberFilter(1)));
    }

    public void restoreState(IMemento memento) {
        this.setMemberFilters(new int[]{4, 2, 1}, new boolean[]{Boolean.valueOf(memento.getString(TAG_HIDEFIELDS)), Boolean.valueOf(memento.getString(TAG_HIDESTATIC)), Boolean.valueOf(memento.getString(TAG_HIDENONPUBLIC))}, false);
    }

    public void fillActionBars(IActionBars actionBars) {
        this.contributeToToolBar(actionBars.getToolBarManager());
    }

    public void contributeToToolBar(IToolBarManager tbm) {
        if (this.fInViewMenu) {
            return;
        }
        tbm.add((IAction)this.fFilterActions[0]);
        tbm.add((IAction)this.fFilterActions[1]);
        tbm.add((IAction)this.fFilterActions[2]);
    }

    public void contributeToViewMenu(IMenuManager menu) {
        if (!this.fInViewMenu) {
            return;
        }
        if (menu.find("filters") != null) {
            menu.prependToGroup("filters", (IAction)this.fFilterActions[0]);
            menu.prependToGroup("filters", (IAction)this.fFilterActions[1]);
            menu.prependToGroup("filters", (IAction)this.fFilterActions[2]);
        } else {
            menu.add((IAction)this.fFilterActions[0]);
            menu.add((IAction)this.fFilterActions[1]);
            menu.add((IAction)this.fFilterActions[2]);
        }
    }

    public void dispose() {
        this.fFilterActions = null;
        this.fFilter = null;
        this.fViewer = null;
        super.dispose();
    }
}

