/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.cdt.internal.ui.CUIMessages;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.CheckedListDialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.dialogs.AbstractCOptionPage;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractErrorParserBlock
extends AbstractCOptionPage {
    private static final String PREFIX = "ErrorParserBlock";
    private static final String LABEL = "ErrorParserBlock.label";
    private static final String DESC = "ErrorParserBlock.desc";
    private static String[] EMPTY = new String[0];
    private Preferences fPrefs;
    protected HashMap mapParsers = new HashMap();
    private CheckedListDialogField fErrorParserList;
    protected boolean listDirty = false;
    private boolean usingDeprecatedContructor = false;

    public AbstractErrorParserBlock(Preferences prefs) {
        this();
        this.usingDeprecatedContructor = true;
        this.fPrefs = prefs;
    }

    public AbstractErrorParserBlock() {
        super(CUIPlugin.getResourceString(LABEL));
        this.setDescription(CUIPlugin.getResourceString(DESC));
    }

    public Image getImage() {
        return null;
    }

    public void updateValues() {
        this.fErrorParserList.removeAllElements();
        this.setValues();
    }

    protected ILabelProvider getLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                String name = (String)AbstractErrorParserBlock.this.mapParsers.get(element.toString());
                return name != null ? name : element.toString();
            }
        };
    }

    protected FieldListenerAdapter getFieldListenerAdapter() {
        return new FieldListenerAdapter();
    }

    protected String[] getErrorParserIDs(boolean defaults) {
        String parserIDs = null;
        if (this.fPrefs != null) {
            parserIDs = defaults ? this.fPrefs.getDefaultString("org.eclipse.cdt.core.errorOutputParser") : this.fPrefs.getString("org.eclipse.cdt.core.errorOutputParser");
        } else {
            return this.getErrorParserIDs();
        }
        String[] empty = new String[]{};
        if (parserIDs != null && parserIDs.length() > 0) {
            StringTokenizer tok = new StringTokenizer(parserIDs, ";");
            ArrayList<String> list = new ArrayList<String>(tok.countTokens());
            while (tok.hasMoreElements()) {
                list.add(tok.nextToken());
            }
            return list.toArray(empty);
        }
        return empty;
    }

    protected abstract String[] getErrorParserIDs(IProject var1);

    protected String[] getErrorParserIDs() {
        return new String[0];
    }

    protected abstract void saveErrorParsers(IProject var1, String[] var2) throws CoreException;

    protected void saveErrorParsers(Preferences prefs, String[] parserIDs) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < parserIDs.length) {
            buf.append(parserIDs[i]).append(';');
            ++i;
        }
        prefs.setValue("org.eclipse.cdt.core.errorOutputParser", buf.toString());
    }

    protected void saveErrorParsers(String[] parserIDs) throws CoreException {
        this.saveErrorParsers(this.fPrefs, parserIDs);
    }

    protected void initMapParsers() {
        this.mapParsers.clear();
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.core", "ErrorParser");
        if (point != null) {
            IExtension[] exts = point.getExtensions();
            int i = 0;
            while (i < exts.length) {
                if (exts[i].getConfigurationElements().length > 0) {
                    this.mapParsers.put(exts[i].getUniqueIdentifier(), exts[i].getLabel());
                }
                ++i;
            }
        }
    }

    protected void initializeValues() {
        this.initMapParsers();
        this.setValues();
    }

    protected void setDefaults() {
        IProject project = this.getContainer().getProject();
        String[] parserIDs = project == null ? this.getErrorParserIDs(true) : this.getErrorParserIDs(false);
        this.updateListControl(parserIDs);
    }

    protected void setValues() {
        IProject project = this.getContainer().getProject();
        String[] parserIDs = project == null ? this.getErrorParserIDs(false) : this.getErrorParserIDs(project);
        this.updateListControl(parserIDs);
    }

    protected void updateListControl(String[] parserIDs) {
        List<String> checkedList = Arrays.asList(parserIDs);
        this.fErrorParserList.setElements(checkedList);
        this.fErrorParserList.setCheckedElements(checkedList);
        if (checkedList.size() > 0) {
            this.fErrorParserList.getTableViewer().setSelection((ISelection)new StructuredSelection((Object)checkedList.get(0)), true);
        }
        Iterator items = this.mapParsers.keySet().iterator();
        while (items.hasNext()) {
            String item = (String)items.next();
            boolean found = false;
            int i = 0;
            while (i < parserIDs.length) {
                if (item.equals(parserIDs[i])) {
                    found = true;
                    break;
                }
                ++i;
            }
            if (found) continue;
            this.fErrorParserList.addElement(item);
        }
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.setControl((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.cdt.ui.newproj_parser_error");
        String[] stringArray = new String[5];
        stringArray[0] = CUIMessages.getString("AbstractErrorParserBlock.label.up");
        stringArray[1] = CUIMessages.getString("AbstractErrorParserBlock.label.down");
        stringArray[3] = CUIMessages.getString("AbstractErrorParserBlock.label.selectAll");
        stringArray[4] = CUIMessages.getString("AbstractErrorParserBlock.label.unselectAll");
        String[] buttonLabels = stringArray;
        this.fErrorParserList = new CheckedListDialogField(null, buttonLabels, (IBaseLabelProvider)this.getLabelProvider());
        this.fErrorParserList.setDialogFieldListener(this.getFieldListenerAdapter());
        this.fErrorParserList.setLabelText(CUIMessages.getString("AbstractErrorParserBlock.label.errorParsers"));
        this.fErrorParserList.setUpButtonIndex(0);
        this.fErrorParserList.setDownButtonIndex(1);
        this.fErrorParserList.setCheckAllButtonIndex(3);
        this.fErrorParserList.setUncheckAllButtonIndex(4);
        LayoutUtil.doDefaultLayout(composite, new DialogField[]{this.fErrorParserList}, true);
        LayoutUtil.setHorizontalGrabbing(this.fErrorParserList.getListControl(null));
        this.initializeValues();
    }

    public void performApply(IProgressMonitor monitor) throws CoreException {
        if (this.listDirty) {
            IProject project = this.getContainer().getProject();
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            monitor.beginTask(CUIMessages.getString("AbstractErrorParserBlock.task.setErrorParser"), 1);
            List elements = this.fErrorParserList.getElements();
            int count = elements.size();
            ArrayList list = new ArrayList(count);
            int i = 0;
            while (i < count) {
                Object obj = elements.get(i);
                if (this.fErrorParserList.isChecked(obj)) {
                    list.add(obj);
                }
                ++i;
            }
            String[] parserIDs = list.toArray(EMPTY);
            if (project == null) {
                this.saveErrorParsers(parserIDs);
            } else {
                this.saveErrorParsers(project, parserIDs);
            }
            monitor.worked(1);
            monitor.done();
        }
    }

    public void performDefaults() {
        this.setDefaults();
    }

    class FieldListenerAdapter
    implements IDialogFieldListener {
        FieldListenerAdapter() {
        }

        public void dialogFieldChanged(DialogField field) {
            AbstractErrorParserBlock.this.listDirty = true;
        }
    }
}

