/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.internal.build.AbstractScriptGenerator;
import org.eclipse.pde.internal.build.Config;
import org.eclipse.pde.internal.build.IPDEBuildConstants;
import org.eclipse.pde.internal.build.Utils;
import org.eclipse.pde.internal.build.site.BuildTimeFeature;
import org.eclipse.update.core.IFeature;

public class AssemblyInformation
implements IPDEBuildConstants {
    private Map assembleInformation = new HashMap(8);

    public AssemblyInformation() {
        Iterator iter = AbstractScriptGenerator.getConfigInfos().iterator();
        while (iter.hasNext()) {
            this.assembleInformation.put(iter.next(), new AssemblyLevelConfigInfo());
        }
    }

    public void addFeature(Config config, IFeature feature) {
        AssemblyLevelConfigInfo entry = (AssemblyLevelConfigInfo)this.assembleInformation.get(config);
        entry.addFeature(feature);
    }

    public void removeFeature(Config config, IFeature feature) {
        AssemblyLevelConfigInfo entry = (AssemblyLevelConfigInfo)this.assembleInformation.get(config);
        entry.removeFeature(feature);
    }

    public void addPlugin(Config config, BundleDescription plugin) {
        AssemblyLevelConfigInfo entry = (AssemblyLevelConfigInfo)this.assembleInformation.get(config);
        entry.addPlugin(plugin);
    }

    public Collection getPlugins(Config config) {
        return ((AssemblyLevelConfigInfo)this.assembleInformation.get(config)).getPlugins();
    }

    public Collection getBinaryPlugins(Config config) {
        Collection allPlugins = this.getPlugins(config);
        HashSet<BundleDescription> result = new HashSet<BundleDescription>(allPlugins.size());
        Iterator iter = allPlugins.iterator();
        while (iter.hasNext()) {
            BundleDescription bundle = (BundleDescription)iter.next();
            Properties bundleProperties = (Properties)bundle.getUserObject();
            if (bundleProperties != null && bundleProperties.get("isCompiler") != null && Boolean.FALSE != bundleProperties.get("isCompiler")) continue;
            result.add(bundle);
        }
        return result;
    }

    public Collection getCompiledPlugins(Config config) {
        Collection allPlugins = this.getPlugins(config);
        HashSet<BundleDescription> result = new HashSet<BundleDescription>(allPlugins.size());
        Iterator iter = allPlugins.iterator();
        while (iter.hasNext()) {
            BundleDescription bundle = (BundleDescription)iter.next();
            Properties bundleProperties = (Properties)bundle.getUserObject();
            if (bundleProperties == null || Boolean.TRUE != bundleProperties.get("isCompiler")) continue;
            result.add(bundle);
        }
        return result;
    }

    public Collection getAllCompiledPlugins() {
        Collection pluginsByConfig = this.assembleInformation.values();
        HashSet<BundleDescription> result = new HashSet<BundleDescription>();
        Iterator iter2 = pluginsByConfig.iterator();
        while (iter2.hasNext()) {
            Collection allPlugins = ((AssemblyLevelConfigInfo)iter2.next()).getPlugins();
            Iterator iter = allPlugins.iterator();
            while (iter.hasNext()) {
                BundleDescription bundle = (BundleDescription)iter.next();
                if (Utils.isBinary(bundle)) continue;
                result.add(bundle);
            }
        }
        return result;
    }

    public Collection getCompiledFeatures(Config config) {
        ArrayList allFeatures = this.getFeatures(config);
        ArrayList result = new ArrayList(allFeatures.size());
        Iterator iter = allFeatures.iterator();
        while (iter.hasNext()) {
            Object tmp = iter.next();
            if (!(tmp instanceof BuildTimeFeature) || ((BuildTimeFeature)((Object)tmp)).isBinary()) continue;
            result.add(tmp);
        }
        return result;
    }

    public Collection getBinaryFeatures(Config config) {
        ArrayList allFeatures = this.getFeatures(config);
        ArrayList result = new ArrayList(allFeatures.size());
        Iterator iter = allFeatures.iterator();
        while (iter.hasNext()) {
            Object tmp = iter.next();
            if (tmp instanceof BuildTimeFeature) {
                if (!((BuildTimeFeature)((Object)tmp)).isBinary()) continue;
                result.add(tmp);
                continue;
            }
            result.add(tmp);
        }
        return result;
    }

    public ArrayList getFeatures(Config config) {
        return ((AssemblyLevelConfigInfo)this.assembleInformation.get(config)).getFeatures();
    }

    public boolean copyRootFile(Config config) {
        return ((AssemblyLevelConfigInfo)this.assembleInformation.get(config)).hasRootFile();
    }

    public Collection getRootFileProviders(Config config) {
        return ((AssemblyLevelConfigInfo)this.assembleInformation.get(config)).getRootFileProvider();
    }

    public void addRootFileProvider(Config config, IFeature feature) {
        ((AssemblyLevelConfigInfo)this.assembleInformation.get(config)).addRootFileProvider(feature);
    }

    private class AssemblyLevelConfigInfo {
        private Collection plugins = new HashSet(20);
        private ArrayList features = new ArrayList(7);
        private LinkedList rootFileProviders = new LinkedList();

        private AssemblyLevelConfigInfo() {
        }

        public void addRootFileProvider(IFeature feature) {
            if (this.rootFileProviders.contains(feature)) {
                return;
            }
            Iterator iter = this.rootFileProviders.iterator();
            while (iter.hasNext()) {
                BuildTimeFeature featureDescriptor = (BuildTimeFeature)((Object)iter.next());
                if (feature == featureDescriptor) {
                    return;
                }
                if (!((BuildTimeFeature)feature).getFeatureIdentifier().equals(featureDescriptor.getFeatureIdentifier()) || !((BuildTimeFeature)feature).getFeatureVersion().equals(featureDescriptor.getFeatureVersion())) continue;
                return;
            }
            this.rootFileProviders.add(feature);
        }

        public Collection getRootFileProvider() {
            return this.rootFileProviders;
        }

        public boolean hasRootFile() {
            return this.rootFileProviders.size() > 0;
        }

        public ArrayList getFeatures() {
            return this.features;
        }

        public Collection getPlugins() {
            return this.plugins;
        }

        public void addFeature(IFeature feature) {
            Iterator iter = this.features.iterator();
            while (iter.hasNext()) {
                BuildTimeFeature featureDescriptor = (BuildTimeFeature)((Object)iter.next());
                if (!((BuildTimeFeature)feature).getFeatureIdentifier().equals(featureDescriptor.getFeatureIdentifier()) || !((BuildTimeFeature)feature).getFeatureVersion().equals(featureDescriptor.getFeatureVersion())) continue;
                return;
            }
            this.features.add(feature);
        }

        public void addPlugin(BundleDescription plugin) {
            this.plugins.add(plugin);
        }

        public void removeFeature(IFeature feature) {
            Iterator iter = this.features.iterator();
            while (iter.hasNext()) {
                BuildTimeFeature featureDescriptor = (BuildTimeFeature)((Object)iter.next());
                if (!((BuildTimeFeature)feature).getFeatureIdentifier().equals(featureDescriptor.getFeatureIdentifier()) || !((BuildTimeFeature)feature).getFeatureVersion().equals(featureDescriptor.getFeatureVersion())) continue;
                this.features.remove((Object)featureDescriptor);
                return;
            }
        }
    }
}

