/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.model;

import java.util.LinkedList;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.internal.core.model.Parent;
import org.eclipse.cdt.internal.core.model.TranslationUnit;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.model.FortranElement;
import org.eclipse.photran.internal.core.model.FortranModelBuilder;
import org.eclipse.photran.internal.core.parser.GenericParseTreeVisitor;
import org.eclipse.photran.internal.core.parser.ParseTreeNode;

public final class FortranParseTreeModelBuildingVisitor
extends GenericParseTreeVisitor {
    private TranslationUnit translationUnit;
    private FortranModelBuilder modelBuilder;
    private LinkedList parentParseTreeNodeStack = new LinkedList();
    private LinkedList parentElementStack = new LinkedList();

    public FortranParseTreeModelBuildingVisitor(TranslationUnit translationUnit, FortranModelBuilder modelBuilder) {
        this.translationUnit = translationUnit;
        this.modelBuilder = modelBuilder;
    }

    private Parent getCurrentParent() {
        if (this.parentElementStack.isEmpty()) {
            return this.translationUnit;
        }
        return (Parent)this.parentElementStack.getLast();
    }

    private boolean isCurrentParent(ParseTreeNode node) {
        if (this.parentParseTreeNodeStack.isEmpty()) {
            return false;
        }
        return node == (ParseTreeNode)this.parentParseTreeNodeStack.getLast();
    }

    private void beginAddingChildrenFor(ParseTreeNode parseTreeNode, FortranElement element) {
        this.parentParseTreeNodeStack.addLast(parseTreeNode);
        this.parentElementStack.addLast(element);
    }

    private void doneAddingChildrenFor(ParseTreeNode node) {
        if (this.isCurrentParent(node)) {
            this.parentParseTreeNodeStack.removeLast();
            this.parentElementStack.removeLast();
        }
    }

    public void preparingToVisitChildrenOf(ParseTreeNode node) {
    }

    public void doneVisitingChildrenOf(ParseTreeNode node) {
        this.doneAddingChildrenFor(node);
    }

    public void visitParseTreeNode(ParseTreeNode node) {
        FortranElement.UnknownNode element = new FortranElement.UnknownNode(this.getCurrentParent(), node.getNonterminal().getDescription());
        try {
            this.modelBuilder.addF90Element(element);
        }
        catch (CModelException cModelException) {}
        this.beginAddingChildrenFor(node, element);
    }

    public void visitToken(Token token) {
        FortranElement.UnknownNode element = new FortranElement.UnknownNode(this.getCurrentParent(), token.getDescription());
        element.setIdentifier(token);
        try {
            this.modelBuilder.addF90Element(element);
        }
        catch (CModelException cModelException) {}
    }
}

