/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.actions;

import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedCProjectNature;
import org.eclipse.cdt.managedbuilder.ui.actions.BuildConfigAction;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class ChangeBuildConfigActionBase {
    protected HashSet fProjects = new HashSet();

    protected void fillMenu(Menu menu) {
        if (menu == null) {
            return;
        }
        MenuItem[] items = menu.getItems();
        int i = 0;
        while (i < items.length) {
            items[i].dispose();
            ++i;
        }
        TreeSet<String> configNames = new TreeSet<String>();
        Iterator projIter = this.fProjects.iterator();
        String sCurrentConfig = null;
        boolean bCurrentConfig = true;
        while (projIter.hasNext()) {
            IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)((IProject)projIter.next()));
            if (info == null || !info.isValid()) continue;
            if (bCurrentConfig) {
                String sNewConfig = info.getDefaultConfiguration().getName();
                if (sCurrentConfig == null) {
                    sCurrentConfig = sNewConfig;
                } else if (!sCurrentConfig.equals(sNewConfig)) {
                    bCurrentConfig = false;
                }
            }
            IConfiguration[] configs = info.getManagedProject().getConfigurations();
            int i2 = 0;
            while (i2 < configs.length) {
                configNames.add(configs[i2].getName());
                ++i2;
            }
        }
        Iterator confIter = configNames.iterator();
        int accel = 0;
        while (confIter.hasNext()) {
            String sName = (String)confIter.next();
            String sDesc = null;
            projIter = this.fProjects.iterator();
            boolean commonName = true;
            boolean commonDesc = true;
            boolean firstProj = true;
            while (projIter.hasNext()) {
                IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)((IProject)projIter.next()));
                if (info == null || !info.isValid()) continue;
                IConfiguration[] configs = info.getManagedProject().getConfigurations();
                int i3 = 0;
                while (i3 < configs.length) {
                    if (configs[i3].getName().equals(sName)) {
                        String sNewDesc = configs[i3].getDescription();
                        if (sNewDesc.equals("")) {
                            sNewDesc = null;
                        }
                        if (!commonDesc) break;
                        if (firstProj) {
                            sDesc = sNewDesc;
                            firstProj = false;
                            break;
                        }
                        if ((sNewDesc != null || sDesc == null) && (sNewDesc == null || sNewDesc.equals(sDesc))) break;
                        commonDesc = false;
                        break;
                    }
                    ++i3;
                }
                if (i3 != configs.length) continue;
                commonName = false;
                break;
            }
            if (!commonName) continue;
            StringBuffer builder = new StringBuffer(sName);
            if (commonDesc) {
                if (sDesc != null) {
                    builder.append(" (");
                    builder.append(sDesc);
                    builder.append(")");
                }
            } else {
                builder.append(" (...)");
            }
            BuildConfigAction action = new BuildConfigAction(this.fProjects, sName, builder.toString(), accel + 1);
            if (bCurrentConfig && sCurrentConfig.equals(sName)) {
                action.setChecked(true);
            }
            ActionContributionItem item = new ActionContributionItem((IAction)action);
            item.fill(menu, -1);
            ++accel;
        }
    }

    protected void onSelectionChanged(IAction action, ISelection selection) {
        this.fProjects.clear();
        if (!action.isEnabled()) {
            return;
        }
        boolean found = false;
        if (selection != null && selection instanceof IStructuredSelection) {
            Iterator iter = ((IStructuredSelection)selection).iterator();
            while (iter.hasNext()) {
                Object selItem = iter.next();
                IProject project = null;
                if (selItem instanceof ICElement) {
                    ICProject cproject = ((ICElement)selItem).getCProject();
                    if (cproject != null) {
                        project = cproject.getProject();
                    }
                } else if (selItem instanceof IResource) {
                    project = ((IResource)selItem).getProject();
                }
                if (project != null) {
                    try {
                        if (project != null && !project.hasNature(ManagedCProjectNature.MNG_NATURE_ID)) {
                            project = null;
                        }
                    }
                    catch (CoreException coreException) {}
                }
                if (project != null) {
                    IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
                    if (info == null || !info.isValid()) continue;
                    this.fProjects.add(project);
                    continue;
                }
                found = true;
                break;
            }
        }
        boolean enable = false;
        if (!found && !this.fProjects.isEmpty()) {
            Iterator iter = this.fProjects.iterator();
            IProject first = (IProject)iter.next();
            IConfiguration[] firstConfigs = ManagedBuildManager.getBuildInfo((IResource)first).getManagedProject().getConfigurations();
            int i = 0;
            while (i < firstConfigs.length) {
                boolean common = true;
                iter = this.fProjects.iterator();
                while (iter.hasNext()) {
                    IProject current = (IProject)iter.next();
                    IConfiguration[] currentConfigs = ManagedBuildManager.getBuildInfo((IResource)current).getManagedProject().getConfigurations();
                    int j = 0;
                    while (j < currentConfigs.length) {
                        if (firstConfigs[i].getName().equals(currentConfigs[j].getName())) break;
                        ++j;
                    }
                    if (j != currentConfigs.length) continue;
                    common = false;
                    break;
                }
                if (common) {
                    enable = true;
                    break;
                }
                ++i;
            }
        }
        action.setEnabled(enable);
    }
}

