/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf;

import edu.uoregon.tau.perfdmf.Context;
import edu.uoregon.tau.perfdmf.CubeDataSource;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.FunctionProfile;
import edu.uoregon.tau.perfdmf.Group;
import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.Node;
import edu.uoregon.tau.perfdmf.Thread;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CubeXMLHandler
extends DefaultHandler {
    private StringBuffer accumulator;
    private String metricID;
    private Stack metricIDStack = new Stack();
    private String regionID;
    private String csiteID;
    private String cnodeID;
    private String callee;
    private String uom;
    private String rank;
    private Stack rankStack = new Stack();
    private Map metricMap = new HashMap();
    private Map regionMap = new HashMap();
    private Map csiteMap = new HashMap();
    private Map cnodeMap = new HashMap();
    private Map uomMap = new HashMap();
    private CubeDataSource cubeDataSource;
    private String name;
    private Stack nameStack = new Stack();
    private Stack cnodeStack = new Stack();
    private List threads = new ArrayList();
    private Metric metric;
    private int version = 2;
    private Metric calls = new Metric();
    private List cubeProcesses = new ArrayList();
    private CubeProcess cubeProcess;
    private Group defaultGroup;
    private Group callpathGroup;
    private volatile int numMetrics = 1;
    private volatile int currentMetric = 0;
    private Map parentMap = new HashMap();
    private Map flatMap = new HashMap();

    public CubeXMLHandler(CubeDataSource cubeDataSource) {
        this.cubeDataSource = cubeDataSource;
    }

    public void startDocument() throws SAXException {
        this.accumulator = new StringBuffer();
        this.calls.setName("Number of Calls");
        this.defaultGroup = this.cubeDataSource.addGroup("CUBE_DEFAULT");
        this.callpathGroup = this.cubeDataSource.addGroup("CUBE_CALLPATH");
    }

    public void endDocument() throws SAXException {
    }

    private String getFunctionName(Object object) {
        if (this.version == 3) {
            return (String)this.regionMap.get(object);
        }
        return (String)this.regionMap.get(this.csiteMap.get(object));
    }

    private String getInsensitiveValue(Attributes attributes, String string) {
        for (int i = 0; i < attributes.getLength(); ++i) {
            if (!attributes.getLocalName(i).equalsIgnoreCase(string)) continue;
            return attributes.getValue(i);
        }
        return null;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.accumulator.setLength(0);
        if (string2.equalsIgnoreCase("cube")) {
            String string4 = this.getInsensitiveValue(attributes, "version");
            if (string4.equals("3.0")) {
                this.version = 3;
            }
        } else if (string2.equalsIgnoreCase("metric")) {
            this.metricIDStack.push(this.metricID);
            this.metricID = this.getInsensitiveValue(attributes, "id");
        } else if (string2.equalsIgnoreCase("region")) {
            this.regionID = this.getInsensitiveValue(attributes, "id");
        } else if (string2.equalsIgnoreCase("csite")) {
            this.csiteID = this.getInsensitiveValue(attributes, "id");
        } else if (string2.equalsIgnoreCase("cnode")) {
            this.cnodeID = this.getInsensitiveValue(attributes, "id");
            this.csiteID = this.getInsensitiveValue(attributes, "csiteid");
            this.callee = this.getInsensitiveValue(attributes, "calleeid");
            String string5 = this.version == 3 ? this.getFunctionName(this.callee) : this.getFunctionName(this.csiteID);
            Stack stack = (Stack)this.cnodeStack.clone();
            while (stack.size() != 0) {
                string5 = this.getFunctionName(stack.pop()) + " => " + string5;
            }
            Function function = this.cubeDataSource.addFunction(string5);
            if (string5.indexOf("=>") != -1) {
                function.addGroup(this.callpathGroup);
            } else {
                function.addGroup(this.defaultGroup);
            }
            this.cnodeMap.put(this.cnodeID, function);
            if (this.version == 3) {
                this.cnodeStack.push(this.callee);
            } else {
                this.cnodeStack.push(this.csiteID);
            }
        } else if (string2.equalsIgnoreCase("matrix")) {
            this.metricID = this.getInsensitiveValue(attributes, "metricid");
            this.metric = (Metric)this.metricMap.get(this.metricID);
            ++this.currentMetric;
        } else if (string2.equalsIgnoreCase("row")) {
            this.cnodeID = this.getInsensitiveValue(attributes, "cnodeid");
        } else if (string2.equalsIgnoreCase("process")) {
            this.cubeProcess = new CubeProcess(-1);
            this.cubeProcesses.add(this.cubeProcess);
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.accumulator.append(cArray, n, n2);
    }

    private void popName() {
        this.name = (String)this.nameStack.pop();
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string2.equalsIgnoreCase("process")) {
            this.cubeProcess.rank = Integer.parseInt(this.rank);
            this.rank = (String)this.rankStack.pop();
        } else if (string2.equalsIgnoreCase("thread")) {
            CubeThread cubeThread = new CubeThread(Integer.parseInt(this.rank));
            this.cubeProcess.threads.add(cubeThread);
            this.rank = (String)this.rankStack.pop();
        } else if (string2.equalsIgnoreCase("locations") || string2.equalsIgnoreCase("system")) {
            for (int i = 0; i < this.cubeProcesses.size(); ++i) {
                CubeProcess cubeProcess = (CubeProcess)this.cubeProcesses.get(i);
                Node node = this.cubeDataSource.addNode(cubeProcess.rank);
                Context context = node.addContext(0);
                for (int j = 0; j < cubeProcess.threads.size(); ++j) {
                    CubeThread cubeThread = (CubeThread)cubeProcess.threads.get(j);
                    Thread thread = context.addThread(cubeThread.rank, this.cubeDataSource.getNumberOfMetrics());
                    this.threads.add(thread);
                }
            }
            this.numMetrics = this.cubeDataSource.getNumberOfMetrics();
        } else if (string2.equalsIgnoreCase("rank")) {
            this.rankStack.push(this.rank);
            this.rank = this.accumulator.toString();
        } else if (string2.equalsIgnoreCase("name")) {
            this.nameStack.push(this.name);
            this.name = this.accumulator.toString();
        } else if (string2.equalsIgnoreCase("disp_name")) {
            this.nameStack.push(this.name);
            this.name = this.accumulator.toString();
        } else if (string2.equalsIgnoreCase("uom")) {
            this.uom = this.accumulator.toString();
        } else if (string2.equalsIgnoreCase("metric")) {
            if (this.name.equalsIgnoreCase("Visits") || this.name.equalsIgnoreCase("Calls")) {
                this.metricMap.put(this.metricID, this.calls);
            } else {
                Object object;
                String string4 = this.name;
                Stack stack = (Stack)this.nameStack.clone();
                while (stack.size() > 0) {
                    object = (String)stack.pop();
                    if (object == null) continue;
                    string4 = (String)object + " => " + string4;
                }
                object = this.cubeDataSource.addMetric(string4);
                this.metricMap.put(this.metricID, object);
                this.uomMap.put(object, this.uom);
            }
            this.metricID = (String)this.metricIDStack.pop();
            this.popName();
        } else if (string2.equalsIgnoreCase("region")) {
            this.regionMap.put(this.regionID, this.name);
            this.popName();
        } else if (string2.equalsIgnoreCase("callee")) {
            this.callee = this.accumulator.toString();
        } else if (string2.equalsIgnoreCase("csite")) {
            this.csiteMap.put(this.csiteID, this.callee);
        } else if (string2.equalsIgnoreCase("cnode")) {
            this.cnodeStack.pop();
        } else if (string2.equalsIgnoreCase("row")) {
            Function function = (Function)this.cnodeMap.get(this.cnodeID);
            String string5 = this.accumulator.toString();
            StringTokenizer stringTokenizer = new StringTokenizer(string5, " \t\n\r");
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                Object object;
                String string6 = stringTokenizer.nextToken();
                Thread thread = (Thread)this.threads.get(n);
                FunctionProfile functionProfile = thread.getFunctionProfile(function);
                if (functionProfile == null) {
                    functionProfile = new FunctionProfile(function, this.cubeDataSource.getNumberOfMetrics());
                    thread.addFunctionProfile(functionProfile);
                }
                double d = Double.parseDouble(string6);
                if (this.metric == this.calls) {
                    functionProfile.setNumCalls(d);
                } else {
                    object = (String)this.uomMap.get(this.metric);
                    if (((String)object).equalsIgnoreCase("sec")) {
                        d = d * 1000.0 * 1000.0;
                    }
                    functionProfile.setExclusive(this.metric.getID(), d);
                }
                if (function.isCallPathFunction()) {
                    object = this.getFlatFunctionProfile(thread, function);
                    if (this.metric == this.calls) {
                        ((FunctionProfile)object).setNumCalls(((FunctionProfile)object).getNumCalls() + d);
                    } else {
                        ((FunctionProfile)object).setExclusive(this.metric.getID(), d + ((FunctionProfile)object).getExclusive(this.metric.getID()));
                    }
                }
                if (this.metric == this.calls) {
                    object = this.getParent(thread, function);
                    if (object != null) {
                        ((FunctionProfile)object).setNumSubr(((FunctionProfile)object).getNumSubr() + d);
                        FunctionProfile functionProfile2 = this.getFlatFunctionProfile(thread, ((FunctionProfile)object).getFunction());
                        if (functionProfile2 != null) {
                            functionProfile2.setNumSubr(functionProfile2.getNumSubr() + d);
                        }
                    }
                } else {
                    this.addToInclusive(thread, functionProfile, d);
                }
                ++n;
            }
        }
    }

    private FunctionProfile getFlatFunctionProfile(Thread thread, Function function) {
        Object object;
        if (!function.isCallPathFunction()) {
            return null;
        }
        Function function2 = (Function)this.flatMap.get(function);
        if (function2 == null) {
            object = function.getName().substring(function.getName().lastIndexOf("=>") + 2).trim();
            function2 = this.cubeDataSource.addFunction((String)object);
            function2.addGroup(this.defaultGroup);
            this.flatMap.put(function, function2);
        }
        if ((object = thread.getFunctionProfile(function2)) == null) {
            object = new FunctionProfile(function2, this.cubeDataSource.getNumberOfMetrics());
            thread.addFunctionProfile((FunctionProfile)object);
        }
        return object;
    }

    private FunctionProfile getParent(Thread thread, Function function) {
        Object object;
        if (!function.isCallPathFunction()) {
            return null;
        }
        Function function2 = (Function)this.parentMap.get(function);
        if (function2 == null) {
            object = function.getName();
            String string = ((String)object).substring(0, ((String)object).lastIndexOf("=>"));
            function2 = this.cubeDataSource.getFunction(string);
            this.parentMap.put(function, function2);
        }
        object = thread.getFunctionProfile(function2);
        return object;
    }

    private void addToInclusive(Thread thread, FunctionProfile functionProfile, double d) {
        FunctionProfile functionProfile2;
        functionProfile.setInclusive(this.metric.getID(), d + functionProfile.getInclusive(this.metric.getID()));
        FunctionProfile functionProfile3 = this.getFlatFunctionProfile(thread, functionProfile.getFunction());
        if (functionProfile3 != null) {
            functionProfile3.setInclusive(this.metric.getID(), d + functionProfile3.getInclusive(this.metric.getID()));
        }
        if ((functionProfile2 = this.getParent(thread, functionProfile.getFunction())) != null) {
            this.addToInclusive(thread, functionProfile2, d);
        }
    }

    public int getProgress() {
        int n = (int)((float)this.currentMetric / (float)this.numMetrics * 100.0f);
        return n;
    }

    private static class CubeThread {
        public int rank;

        public CubeThread(int n) {
            this.rank = n;
        }
    }

    private static class CubeProcess {
        public int rank;
        public List threads = new ArrayList();

        public CubeProcess(int n) {
            this.rank = n;
        }
    }
}

