/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf;

import edu.uoregon.tau.perfdmf.UserEvent;

public class UserEventProfile {
    private UserEvent userEvent;
    private double[] data;
    int numSnapshots;
    private static final int NUM_SAMPLES = 0;
    private static final int MAX = 1;
    private static final int MIN = 2;
    private static final int MEAN = 3;
    private static final int SUM_SQR = 4;
    private static final int STDDEV = 5;
    private static final int SNAPSHOT_SIZE = 6;

    public UserEventProfile(UserEvent userEvent) {
        this(userEvent, 1);
    }

    public UserEventProfile(UserEvent userEvent, int n) {
        this.userEvent = userEvent;
        this.data = new double[6 * n];
        this.numSnapshots = n;
    }

    public UserEvent getUserEvent() {
        return this.userEvent;
    }

    public void addSnapshot() {
        int n = 6 * (this.numSnapshots + 1);
        if (n > this.data.length) {
            double[] dArray = new double[(int)((double)n * 1.5)];
            System.arraycopy(this.data, 0, dArray, 0, this.data.length);
            this.data = dArray;
        }
        ++this.numSnapshots;
    }

    public String getName() {
        return this.userEvent.getName();
    }

    public void updateMax() {
    }

    public void setNumSamples(double d, int n) {
        if (n == -1) {
            n = this.numSnapshots - 1;
        }
        this.data[0 + n * 6] = d;
    }

    public void setNumSamples(double d) {
        this.setNumSamples(d, -1);
    }

    public double getNumSamples() {
        return this.getNumSamples(-1);
    }

    public double getNumSamples(int n) {
        if (n == -1) {
            n = this.numSnapshots - 1;
        }
        return this.data[0 + n * 6];
    }

    public void setMinValue(double d, int n) {
        if (n == -1) {
            n = this.numSnapshots - 1;
        }
        this.data[2 + n * 6] = d;
    }

    public void setMinValue(double d) {
        this.setMinValue(d, -1);
    }

    public double getMinValue() {
        return this.getMinValue(-1);
    }

    public double getMinValue(int n) {
        if (n == -1) {
            n = this.numSnapshots - 1;
        }
        return this.data[2 + n * 6];
    }

    public void setMaxValue(double d, int n) {
        if (n == -1) {
            n = this.numSnapshots - 1;
        }
        this.data[1 + n * 6] = d;
    }

    public void setMaxValue(double d) {
        this.setMaxValue(d, -1);
    }

    public double getMaxValue() {
        return this.getMaxValue(-1);
    }

    public double getMaxValue(int n) {
        if (n == -1) {
            n = this.numSnapshots - 1;
        }
        return this.data[1 + n * 6];
    }

    public void setMeanValue(double d, int n) {
        if (n == -1) {
            n = this.numSnapshots - 1;
        }
        this.data[3 + n * 6] = d;
    }

    public void setMeanValue(double d) {
        this.setMeanValue(d, -1);
    }

    public double getMeanValue() {
        return this.getMeanValue(-1);
    }

    public double getMeanValue(int n) {
        if (n == -1) {
            n = this.numSnapshots - 1;
        }
        return this.data[3 + n * 6];
    }

    public void setSumSquared(double d) {
        this.setSumSquared(d, -1);
    }

    public void setSumSquared(double d, int n) {
        if (n == -1) {
            n = this.numSnapshots - 1;
        }
        this.data[4 + n * 6] = d;
        this.data[5 + n * 6] = Math.sqrt(Math.abs(this.getSumSquared(n) / this.getNumSamples(n) - this.getMeanValue(n) * this.getMeanValue(n)));
    }

    public double getSumSquared() {
        return this.getSumSquared(-1);
    }

    public double getSumSquared(int n) {
        if (n == -1) {
            n = this.numSnapshots - 1;
        }
        return this.data[4 + n * 6];
    }

    public void setStdDev(double d, int n) {
        if (n == -1) {
            n = this.numSnapshots - 1;
        }
        this.data[5 + n * 6] = d;
        this.data[4 + n * 6] = d * d + this.getMeanValue(n) * this.getMeanValue(n) + this.getNumSamples(n);
    }

    public void setStdDev(double d) {
        this.setStdDev(d, -1);
    }

    public double getStdDev() {
        return this.getStdDev(-1);
    }

    public double getStdDev(int n) {
        if (n == -1) {
            n = this.numSnapshots - 1;
        }
        return this.data[5 + n * 6];
    }
}

