/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.launching.environments;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.launching.LaunchingPlugin;
import org.eclipse.jdt.internal.launching.environments.EnvironmentMessages;
import org.eclipse.jdt.internal.launching.environments.EnvironmentsManager;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;

class ExecutionEnvironment
implements IExecutionEnvironment {
    private IConfigurationElement fElement;
    private Set fStrictlyCompatible = new HashSet();
    private List fCompatibleVMs = new ArrayList();
    private IVMInstall fDefault = null;

    ExecutionEnvironment(IConfigurationElement element) {
        this.fElement = element;
    }

    private void init() {
        EnvironmentsManager manager = EnvironmentsManager.getDefault();
        manager.initializeCompatibilities();
    }

    public String getId() {
        return this.fElement.getAttribute("id");
    }

    public String getDescription() {
        return this.fElement.getAttribute("description");
    }

    public IVMInstall[] getCompatibleVMs() {
        this.init();
        return this.fCompatibleVMs.toArray(new IVMInstall[this.fCompatibleVMs.size()]);
    }

    public boolean isStrictlyCompatible(IVMInstall vm) {
        this.init();
        return this.fStrictlyCompatible.contains(vm);
    }

    public IVMInstall getDefaultVM() {
        this.init();
        return this.fDefault;
    }

    public void setDefaultVM(IVMInstall vm) {
        this.init();
        if (vm != null && !this.fCompatibleVMs.contains(vm)) {
            throw new IllegalArgumentException(MessageFormat.format((String)EnvironmentMessages.EnvironmentsManager_0, (Object[])new String[]{this.getId()}));
        }
        if (vm != null && vm.equals(this.fDefault)) {
            return;
        }
        this.fDefault = vm;
        EnvironmentsManager.getDefault().updateDefaultVMs();
        this.rebindClasspathContainers();
    }

    private void rebindClasspathContainers() {
        IJavaModel model = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
        if (model != null) {
            try {
                ArrayList<IJavaProject> updates = new ArrayList<IJavaProject>();
                IJavaProject[] javaProjects = model.getJavaProjects();
                IPath path = JavaRuntime.newJREContainerPath(this);
                int i = 0;
                while (i < javaProjects.length) {
                    IJavaProject project = javaProjects[i];
                    IClasspathEntry[] rawClasspath = project.getRawClasspath();
                    int j = 0;
                    while (j < rawClasspath.length) {
                        IClasspathEntry entry = rawClasspath[j];
                        if (entry.getEntryKind() == 5 && entry.getPath().equals((Object)path)) {
                            updates.add(project);
                        }
                        ++j;
                    }
                    ++i;
                }
                if (!updates.isEmpty()) {
                    JavaCore.setClasspathContainer((IPath)path, (IJavaProject[])updates.toArray(new IJavaProject[updates.size()]), (IClasspathContainer[])new IClasspathContainer[updates.size()], (IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (JavaModelException e) {
                LaunchingPlugin.log(e);
            }
        }
    }

    void add(IVMInstall vm, boolean strictlyCompatible) {
        if (this.fCompatibleVMs.contains(vm)) {
            return;
        }
        this.fCompatibleVMs.add(vm);
        if (strictlyCompatible) {
            this.fStrictlyCompatible.add(vm);
        }
    }

    void remove(IVMInstall vm) {
        this.fCompatibleVMs.remove(vm);
        this.fStrictlyCompatible.remove(vm);
    }

    void initDefaultVM(IVMInstall vm) {
        this.fDefault = vm;
    }
}

